import {serverLogger} from "./logger-impl";
export function reload15(session: ts.server.Session, ts_impl): any {
    serverLogger("Start reload");
    let service: ts.server.ProjectService = (<any>session).projectService;

    for (const project of service.configuredProjects) {
        updateConfiguredProject15(service, project, ts_impl);
        service.watchedProjectConfigFileChanged(project)
    }
    for (const project of service.inferredProjects) {
        updateConfiguredProject15(service, project, ts_impl);
        service.watchedProjectConfigFileChanged(project)
    }

    service.updateProjectStructure();
}

export function close15(session: ts.server.Session, request: any) {
    var closeArgs = <ts.server.protocol.FileRequestArgs>request.arguments;
    (<any>session).closeClientFile(closeArgs.file);
}

export function onMessage15(session: ts.server.Session, message: string) {
    try {
        var request = JSON.parse(message);
        let response = session.executeCommand(request);
        if (response && response.responseRequired) {
            session.output(response.response, request.command, request.seq);
        }

    } catch (e) {
        serverLogger(e, true);
        throw e;
    }
}

export function openClientFileConfig15(service: ts.server.ProjectService, fileName:string, fileContent:string, ts_impl) {
    var info = service.openClientFile(fileName);

    if (fileContent && info) {
        info.svc.reload(fileContent);
    }

    return info;
}

export function openProjectByConfig(service: ts.server.ProjectService, fileName: string, ts_impl) {
    var searchPath = ts_impl.normalizePath(ts_impl.getDirectoryPath(fileName));
    var configFileName = service.findConfigFile(searchPath);
    if (configFileName) {
        configFileName = getAbsolutePath(configFileName, searchPath, ts_impl);
    }
    if (configFileName) {
        const project = findConfiguredProjectByConfigFile15(service, configFileName);
        if (project) {
            updateConfiguredProject15(service, project, ts_impl);
        } else {

            var configResult: ts.server.ProjectOpenResult = service.openConfigFile(configFileName, fileName);
            if (!configResult.success) {
                serverLogger("Error opening config file " + configFileName + " " + configResult.errorMsg, true);
            }
            else {
                service.configuredProjects.push(configResult.project);
            }
        }
    }

    return findConfiguredProjectByConfigFile15(this.projectService, fileName);
}

export function setGetFileNames(Project: typeof ts.server.Project) {
    Project.prototype.getFileNames = function () {
        const sourceFiles = this.program.getSourceFiles();
        return sourceFiles.map(sourceFile => sourceFile.fileName);
    }
}

function getAbsolutePath(filename: string, directory: string, ts_impl) {
    var rootLength = ts_impl.getRootLength(filename);
    if (rootLength > 0) {
        return filename;
    }
    else {
        var splitFilename = filename.split('/');
        var splitDir = directory.split('/');
        var i = 0;
        var dirTail = 0;
        var sflen = splitFilename.length;
        while ((i < sflen) && (splitFilename[i].charAt(0) == '.')) {
            var dots = splitFilename[i];
            if (dots == '..') {
                dirTail++;
            }
            else if (dots != '.') {
                return undefined;
            }
            i++;
        }
        return splitDir.slice(0, splitDir.length - dirTail).concat(splitFilename.slice(i)).join('/');
    }
}

export function findConfiguredProjectByConfigFile15(service: ts.server.ProjectService, configFileName: string) {
    for (let i = 0, len = service.configuredProjects.length; i < len; i++) {
        if (service.configuredProjects[i].projectFilename == configFileName) {
            return service.configuredProjects[i];
        }
    }
    return undefined;
}

export function updateConfiguredProject15(service: ts.server.ProjectService, project:ts.server.Project, ts_impl) {
    serverLogger("Update project", true)
    if (!service.host.fileExists(project.projectFilename)) {
        service.removeProject(project);
    }
    else {
        const rawConfig: { config?: ts.server.ProjectOptions;
            error?: ts.server.protocol.Diagnostic; } = ts_impl.readConfigFile(project.projectFilename);

        let projectOptions = rawConfig.config;
        serverLogger("New options " + JSON.stringify(projectOptions), true)
        project.setProjectOptions(projectOptions);
        project.finishGraph();
    }
}

function copyListRemovingItem<T>(item: T, list: T[]) {
    const copiedList: T[] = [];
    for (let i = 0, len = list.length; i < len; i++) {
        if (list[i] != item) {
            copiedList.push(list[i]);
        }
    }
    return copiedList;
}
