/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.remotesdk;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.intellij.credentialStore.CredentialAttributes;
import com.intellij.credentialStore.CredentialAttributesKt;
import com.intellij.credentialStore.CredentialPromptDialog;
import com.intellij.credentialStore.Credentials;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.BaseRemoteProcessHandler;
import com.intellij.remote.RemoteCancelledException;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.RemoteFile;
import com.intellij.remote.RemoteSdkCredentials;
import com.intellij.remote.RemoteSdkException;
import com.intellij.util.EventDispatcher;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.ui.EdtInvocationManager;
import com.intellij.util.ui.UIUtil;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpATTRS;
import com.jetbrains.plugins.remotesdk.CapturingRemoteProcessHandler;
import com.jetbrains.plugins.remotesdk.ConnectionOwnerFactory;
import com.jetbrains.plugins.remotesdk.RemoteTransfer;
import com.jetbrains.plugins.remotesdk.SdkSessionManager;
import com.jetbrains.plugins.remotesdk.transport.JschExecProcess;
import com.jetbrains.plugins.remotesdk.transport.JschProcess;
import com.jetbrains.plugins.remotesdk.transport.SshConnectionManager;
import com.jetbrains.plugins.remotesdk.transport.SshRemoteSession;
import com.jetbrains.plugins.remotesdk.transport.SshUtil;
import com.jetbrains.plugins.webDeployment.ConnectionOwner;
import com.jetbrains.plugins.webDeployment.CustomFileSystemException;
import com.jetbrains.plugins.webDeployment.PublishUtils;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.config.AccessType;
import com.jetbrains.plugins.webDeployment.config.FileTransferConfig;
import com.jetbrains.plugins.webDeployment.config.RemoteCredentialsVerifiableHolder;
import com.jetbrains.plugins.webDeployment.config.WebDeploymentCredentialHelper;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.config.WebServersConfigManager;
import com.jetbrains.plugins.webDeployment.connections.RemoteConnectionManager;
import com.jetbrains.plugins.webDeployment.ui.ServerBrowserDialog;
import java.awt.Component;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.swing.JTextField;
import org.apache.commons.vfs2.FileSystemException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoteSdkUtil {
    private static final Logger LOG = Logger.getInstance(RemoteSdkUtil.class);
    @NonNls
    private static final String JETBRAINS_REMOTE_RUN = "JETBRAINS_REMOTE_RUN";
    public static final long TEST_CONNECTION_POLL_TIMEOUT = 100L;
    private static final int MAX_CREATE_DIR_ATTEMPTS = 5;
    public static final long TEST_CONNECTION_TIMEOUT = 10L;
    public static final String DEFAULT_PYCHARM_HELPERS_PATH_ON_DOCKER = "/opt/.pycharm_helpers";

    private RemoteSdkUtil() {
    }

    public static void copyData(@NotNull RemoteCredentials from, @NotNull RemoteCredentialsVerifiableHolder to) {
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/jetbrains/plugins/remotesdk/RemoteSdkUtil", "copyData"));
        }
        if (to == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "com/jetbrains/plugins/remotesdk/RemoteSdkUtil", "copyData"));
        }
        to.setHost(from.getHost());
        to.setLiteralPort(from.getLiteralPort());
        to.setAnonymous(from.isAnonymous());
        to.setUseKeyPair(from.isUseKeyPair());
        to.setKnownHostsFile(from.getKnownHostsFile());
        to.setPrivateKeyFile(from.getPrivateKeyFile());
    }

    public static void createFromRemoteCredentials(@NotNull WebServerConfig server, @NotNull RemoteCredentials data) {
        if (server == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "server", "com/jetbrains/plugins/remotesdk/RemoteSdkUtil", "createFromRemoteCredentials"));
        }
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/jetbrains/plugins/remotesdk/RemoteSdkUtil", "createFromRemoteCredentials"));
        }
        FileTransferConfig config = server.getFileTransferConfig();
        config.setAccessType(AccessType.SFTP);
        RemoteSdkUtil.copyData(data, config.getCredentials());
        WebDeploymentCredentialHelper.saveCredentials((WebServerConfig)server, (String)data.getUserName(), (String)(data.isUseKeyPair() ? data.getPassphrase() : data.getPassword()), (boolean)(data.isUseKeyPair() ? !data.isStorePassphrase() : !data.isStorePassword()));
    }

    public static void initRemoteSdkData(@NotNull RemoteSdkCredentials data, @NotNull WebServerConfig server) {
        String passwordOrPassphrase;
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/jetbrains/plugins/remotesdk/RemoteSdkUtil", "initRemoteSdkData"));
        }
        if (server == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "server", "com/jetbrains/plugins/remotesdk/RemoteSdkUtil", "initRemoteSdkData"));
        }
        FileTransferConfig config = server.getFileTransferConfig();
        data.setHost(config.getHost());
        data.setLiteralPort(config.getLiteralPort());
        data.setAnonymous(config.isAnonymous());
        Credentials credentials = WebDeploymentCredentialHelper.getCredentials((WebServerConfig)server);
        data.setUserName(credentials == null ? null : credentials.getUserName());
        String string = passwordOrPassphrase = credentials == null ? null : credentials.getPasswordAsString();
        if (config.isUseKeyPair()) {
            data.setPassphrase(passwordOrPassphrase);
        } else {
            data.setPassword(passwordOrPassphrase);
        }
        data.setPrivateKeyFile(config.getPrivateKeyFile());
        data.setKnownHostsFile(config.getKnownHostsFile());
        data.setUseKeyPair(config.isUseKeyPair());
    }

    @NotNull
    public static List<WebServerConfig> getSftpServerList() {
        List<WebServerConfig> list = RemoteSdkUtil.getSftpServerList(null);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/remotesdk/RemoteSdkUtil", "getSftpServerList"));
        }
        return list;
    }

    @NotNull
    public static List<WebServerConfig> getSftpServerList(@Nullable Project project) {
        List config = WebServersConfigManager.getInstance((Project)project).getServers(true);
        Predicate<WebServerConfig> filter = new Predicate<WebServerConfig>(){

            public boolean apply(WebServerConfig input) {
                return input.getFileTransferConfig().getAccessType() == AccessType.SFTP;
            }
        };
        ArrayList arrayList = Lists.newArrayList((Iterable)Iterables.filter((Iterable)config, (Predicate)filter));
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/remotesdk/RemoteSdkUtil", "getSftpServerList"));
        }
        return arrayList;
    }

    public static boolean testConnectionAndCreateHelpersPath(@Nullable Project project, @NotNull RemoteSdkCredentials data, String title) throws RemoteCancelledException, FileSystemException {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/jetbrains/plugins/remotesdk/RemoteSdkUtil", "testConnectionAndCreateHelpersPath"));
        }
        return RemoteSdkUtil.testConnectionAndCreateHelpersPath(project, data, title, null);
    }

    public static boolean testConnection(@Nullable Project project, @NotNull RemoteCredentials data) {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/jetbrains/plugins/remotesdk/RemoteSdkUtil", "testConnection"));
        }
        if (EdtInvocationManager.getInstance().isEventDispatchThread()) {
            return RemoteSdkUtil.testConnectionFromEDT(project, data);
        }
        return RemoteSdkUtil.testConnectionFromNonEDT(project, data);
    }

    private static boolean testConnectionFromEDT(@Nullable Project project, @NotNull RemoteCredentials data) {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/jetbrains/plugins/remotesdk/RemoteSdkUtil", "testConnectionFromEDT"));
        }
        try {
            return RemoteSdkUtil.doTestConnection(project, data, 10L, TimeUnit.SECONDS);
        }
        catch (RuntimeException e) {
            LOG.warn((Throwable)e);
            return false;
        }
    }

    private static boolean testConnectionFromNonEDT(@Nullable Project project, @NotNull RemoteCredentials data) {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/jetbrains/plugins/remotesdk/RemoteSdkUtil", "testConnectionFromNonEDT"));
        }
        Future result = ApplicationManager.getApplication().executeOnPooledThread(() -> {
            if (data == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/jetbrains/plugins/remotesdk/RemoteSdkUtil", "lambda$testConnectionFromNonEDT$0"));
            }
            return RemoteSdkUtil.doTestConnection(project, data, 10L, TimeUnit.SECONDS);
        });
        try {
            return (Boolean)result.get(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            LOG.warn((Throwable)e);
        }
        catch (ExecutionException e) {
            LOG.warn((Throwable)e);
        }
        catch (TimeoutException e) {
            LOG.warn((Throwable)e);
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean doTestConnection(@Nullable Project project, @NotNull RemoteCredentials data, long timeout, @NotNull TimeUnit timeUnit) {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/jetbrains/plugins/remotesdk/RemoteSdkUtil", "doTestConnection"));
        }
        if (timeUnit == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "timeUnit", "com/jetbrains/plugins/remotesdk/RemoteSdkUtil", "doTestConnection"));
        }
        try {
            void timeUnit2;
            SshRemoteSession session = SshConnectionManager.getInstance().getSession(project, data, timeout, (TimeUnit)timeUnit2);
            return session.isConnected();
        }
        catch (RemoteSdkException remoteSdkException) {
            return false;
        }
    }

    public static boolean testConnectionAndCreateHelpersPath(final @Nullable Project project, final @NotNull RemoteSdkCredentials data, String title, final @Nullable RemoteSdkUpdatedCallback updatedCallback) throws FileSystemException, RemoteCancelledException {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/jetbrains/plugins/remotesdk/RemoteSdkUtil", "testConnectionAndCreateHelpersPath"));
        }
        final Ref error = new Ref();
        final Ref result = new Ref();
        result.set((Object)false);
        Task.Modal task = new Task.Modal(project, title, true){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(@NotNull ProgressIndicator pi) {
                if (pi == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pi", "com/jetbrains/plugins/remotesdk/RemoteSdkUtil$2", "run"));
                }
                Semaphore done = new Semaphore();
                done.down();
                EventDispatcher forceDisconnectDispatcher = EventDispatcher.create(RemoteConnectionManager.ForceDisconnectListener.class);
                SshConnectionManager connectionManager = SshConnectionManager.getInstance();
                ApplicationManager.getApplication().executeOnPooledThread(() -> {
                    if (pi == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pi", "com/jetbrains/plugins/remotesdk/RemoteSdkUtil$2", "lambda$run$0"));
                    }
                    if (data == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/jetbrains/plugins/remotesdk/RemoteSdkUtil$2", "lambda$run$0"));
                    }
                    try {
                        pi.setText("Connecting to " + data.getHost() + "...");
                        SshRemoteSession session = connectionManager.getSession(project, (RemoteCredentials)data);
                        RemoteSdkUtil.checkInterpreterAndCreateHelpersFolder(data, (Ref<Exception>)error, (Ref<Boolean>)result, updatedCallback, session);
                    }
                    catch (RemoteSdkException e) {
                        error.set((Object)new CustomFileSystemException(e.getMessage(), (Throwable)e));
                    }
                    finally {
                        done.up();
                    }
                });
                try {
                    while (!done.waitFor(100L)) {
                        pi.checkCanceled();
                    }
                }
                finally {
                    ((RemoteConnectionManager.ForceDisconnectListener)forceDisconnectDispatcher.getMulticaster()).forceDisconnect();
                }
            }

            public void onCancel() {
                error.set((Object)new RemoteCancelledException("Connection was canceled."));
            }

            public void onError(@NotNull Exception err) {
                if (err == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "err", "com/jetbrains/plugins/remotesdk/RemoteSdkUtil$2", "onError"));
                }
                error.set((Object)err);
            }
        };
        if (!ProgressManager.getInstance().hasProgressIndicator()) {
            UIUtil.invokeAndWaitIfNeeded(() -> ProgressManager.getInstance().run((Task)task));
        } else {
            task.run(ProgressManager.getInstance().getProgressIndicator());
        }
        if (!error.isNull()) {
            Exception exception = (Exception)error.get();
            if (exception instanceof RemoteCancelledException) {
                throw (RemoteCancelledException)exception;
            }
            if (exception instanceof FileSystemException) {
                throw (FileSystemException)exception;
            }
            throw new FileSystemException("Exception:", (Throwable)exception);
        }
        return (Boolean)result.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean checkInterpreterAndCreateHelpersFolder(@NotNull RemoteSdkCredentials sdkCredentials, @NotNull Ref<Exception> error, @NotNull Ref<Boolean> result, @Nullable RemoteSdkUpdatedCallback updateCallback, SshRemoteSession session) {
        if (sdkCredentials == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdkCredentials", "com/jetbrains/plugins/remotesdk/RemoteSdkUtil", "checkInterpreterAndCreateHelpersFolder"));
        }
        if (error == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "error", "com/jetbrains/plugins/remotesdk/RemoteSdkUtil", "checkInterpreterAndCreateHelpersFolder"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/jetbrains/plugins/remotesdk/RemoteSdkUtil", "checkInterpreterAndCreateHelpersFolder"));
        }
        try {
            ChannelSftp channel = session.sftp();
            try {
                String interpreterPath = sdkCredentials.getInterpreterPath();
                String pathForHelpers = sdkCredentials.getHelpersPath();
                if (updateCallback != null) {
                    SftpATTRS attrs = SshUtil.getAttrs(channel, interpreterPath);
                    if (attrs == null || attrs.isDir()) {
                        error.set((Object)new CustomFileSystemException("Interpreter '" + interpreterPath + "' doesn't exist on remote server"));
                        boolean bl = false;
                        return bl;
                    }
                    if (!StringUtil.isEmpty((String)pathForHelpers)) {
                        attrs = SshUtil.getAttrs(channel, pathForHelpers);
                        if (attrs == null || !attrs.isDir()) {
                            error.set((Object)new CustomFileSystemException("Folder '" + pathForHelpers + "' doesn't exist on remote server"));
                            boolean bl = false;
                            return bl;
                        }
                    } else {
                        String path = new RemoteFile(channel.getHome(), sdkCredentials.getDefaultHelpersName()).getPath();
                        sdkCredentials.setHelpersPath(path);
                        attrs = SshUtil.getAttrs(channel, path);
                        int i = 0;
                        while (true) {
                            ProgressManager.checkCanceled();
                            if (attrs != null && attrs.isDir()) break;
                            try {
                                channel.mkdir(path);
                                sdkCredentials.setHelpersPath(path);
                            }
                            catch (Exception e) {
                                path = sdkCredentials.getHelpersPath() + "_" + ++i;
                                if (i <= 5) continue;
                                throw e;
                            }
                            break;
                        }
                        updateCallback.updated(sdkCredentials);
                    }
                }
                result.set((Object)true);
                boolean bl = true;
                return bl;
            }
            finally {
                channel.disconnect();
            }
        }
        catch (Exception e) {
            error.set((Object)new CustomFileSystemException(e.getMessage(), (Throwable)e));
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean ensureCanWriteFile(@NotNull ConnectionOwner connectionOwner, @NotNull RemoteSdkCredentials data, @NotNull String path) {
        Session session;
        if (connectionOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connectionOwner", "com/jetbrains/plugins/remotesdk/RemoteSdkUtil", "ensureCanWriteFile"));
        }
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/jetbrains/plugins/remotesdk/RemoteSdkUtil", "ensureCanWriteFile"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/jetbrains/plugins/remotesdk/RemoteSdkUtil", "ensureCanWriteFile"));
        }
        try {
            session = SshUtil.connectJSch((RemoteCredentials)data, connectionOwner, null, 60L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            return true;
        }
        try {
            ChannelSftp channel = SshUtil.createSftpChannel(session);
            SftpATTRS attrs = SshUtil.getAttrs(channel, path);
            boolean bl = attrs != null && (attrs.getPermissions() & 0x80) != 0 && attrs.getUId() != 0;
            return bl;
        }
        catch (Exception e) {
            boolean bl = true;
            return bl;
        }
        finally {
            session.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static JschProcess createRemoteProcess(@NotNull SshRemoteSession runProcessSession, @NotNull GeneralCommandLine commandLine, boolean allocatePty, boolean askForSudo, boolean changeDir) throws RemoteSdkException {
        JschExecProcess jschExecProcess;
        if (runProcessSession == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runProcessSession", "com/jetbrains/plugins/remotesdk/RemoteSdkUtil", "createRemoteProcess"));
        }
        if (commandLine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandLine", "com/jetbrains/plugins/remotesdk/RemoteSdkUtil", "createRemoteProcess"));
        }
        try {
            commandLine.getEnvironment().put(JETBRAINS_REMOTE_RUN, "1");
            String command = commandLine.getCommandLineString();
            if (!RemoteFile.isWindowsPath((String)commandLine.getExePath())) {
                command = RemoteSdkUtil.addEnvCommand(commandLine, command);
                if (askForSudo) {
                    command = "sudo -S -p '' " + command;
                }
            }
            if (changeDir && commandLine.getWorkDirectory() != null) {
                String workingDir = commandLine.getWorkDirectory().getPath();
                workingDir = RemoteFile.detectSystemByPath((String)commandLine.getExePath()).createRemoteFile(workingDir).getPath();
                command = "cd " + workingDir + "; " + command;
            }
            JschExecProcess process = runProcessSession.exec(command, 60, allocatePty);
            if (askForSudo) {
                String password = CredentialPromptDialog.askPassword(null, (String)"Enter Root Password", (String)("Sudo password for host \"" + runProcessSession.getHost() + "\":"), (CredentialAttributes)CredentialAttributesKt.CredentialAttributes(BaseRemoteProcessHandler.class, (String)runProcessSession.getCredentialsString()));
                if (password != null) {
                    try (PrintWriter pw = new PrintWriter(process.getOutputStream());){
                        pw.println(password);
                    }
                } else {
                    throw new RemoteCancelledException("Sudo password dialog cancelled.");
                }
            }
            jschExecProcess = process;
        }
        catch (Exception e) {
            throw new RemoteSdkException(e.getMessage(), (Throwable)e);
        }
        if (jschExecProcess == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/remotesdk/RemoteSdkUtil", "createRemoteProcess"));
        }
        return jschExecProcess;
    }

    private static String addEnvCommand(GeneralCommandLine commandLine, String command) {
        StringBuilder params = new StringBuilder();
        for (Map.Entry entry : commandLine.getEnvironment().entrySet()) {
            String value;
            if (params.length() > 0) {
                params.append(" ");
            }
            if ((value = (String)entry.getValue()) == null) continue;
            String key = RemoteSdkUtil.escapeEnvParameter((String)entry.getKey());
            value = RemoteSdkUtil.escapeEnvParameter(value);
            if (commandLine.isPassParentEnvironment() && "PATH".equalsIgnoreCase(key)) {
                value = value + ":$PATH";
            }
            params.append("\"").append(key).append("\"").append("=").append("\"").append(value).append("\"");
        }
        if (params.length() > 0) {
            String env = "env ";
            if (!commandLine.isPassParentEnvironment()) {
                env = env + "-i ";
            }
            command = env + params.toString() + " " + command;
        }
        return command;
    }

    private static String escapeEnvParameter(String value) {
        return value.replace("\"", "\\\"").replace("$", "\\$");
    }

    public static SshRemoteSession createRemoteSession(@Nullable Project project, @NotNull RemoteCredentials data) throws RemoteSdkException {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/jetbrains/plugins/remotesdk/RemoteSdkUtil", "createRemoteSession"));
        }
        try {
            return new SshRemoteSession(project, data);
        }
        catch (JSchException e) {
            throw new RemoteSdkException(e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static SshRemoteSession createRemoteSession(@Nullable Project project, @NotNull RemoteCredentials data, long timeout, @NotNull TimeUnit timeUnit) throws RemoteSdkException {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/jetbrains/plugins/remotesdk/RemoteSdkUtil", "createRemoteSession"));
        }
        if (timeUnit == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "timeUnit", "com/jetbrains/plugins/remotesdk/RemoteSdkUtil", "createRemoteSession"));
        }
        try {
            void timeUnit2;
            ConnectionOwner owner = ConnectionOwnerFactory.createConnectionOwner(project);
            return new SshRemoteSession(owner, data, null, timeout, (TimeUnit)timeUnit2);
        }
        catch (JSchException e) {
            throw new RemoteSdkException(e.getMessage(), (Throwable)e);
        }
    }

    public static WebServerConfig createWebServer(RemoteCredentials data) {
        WebServerConfig config = new WebServerConfig();
        config.setName("Remote host");
        RemoteSdkUtil.createFromRemoteCredentials(config, data);
        return config;
    }

    public static boolean testConnection(@NotNull Component component, RemoteSdkCredentials data, boolean reportOnSuccess) {
        String error;
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/jetbrains/plugins/remotesdk/RemoteSdkUtil", "testConnection"));
        }
        WebServerConfig config = RemoteSdkUtil.createWebServer((RemoteCredentials)data);
        String title = WDBundle.message((String)"test.connection", (Object[])new Object[]{config.getFileTransferConfig().getAccessType().getTitle()});
        String validationInfo = config.getFileTransferConfig().validateFast();
        if (validationInfo != null) {
            error = validationInfo;
        } else {
            try {
                error = RemoteSdkUtil.testConnectionAndCreateHelpersPath(null, data, title) ? null : "Connection failed";
            }
            catch (FileSystemException e) {
                error = StringUtil.capitalize((String)PublishUtils.getMessage((Throwable)e, (boolean)false));
            }
            catch (RemoteCancelledException e) {
                error = "Connection was cancelled";
            }
        }
        if (error == null) {
            if (reportOnSuccess) {
                Messages.showInfoMessage((Component)component, (String)WDBundle.message((String)"connection.to.successful", (Object[])new Object[]{data.getHost()}), (String)title);
            }
            return true;
        }
        Messages.showErrorDialog((Component)component, (String)WDBundle.message((String)"connection.to.failed", (Object[])new Object[]{data.getHost(), error}), (String)title);
        return false;
    }

    public static boolean testConnection(@NotNull Component component, RemoteCredentials data, boolean reportOnSuccess) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/jetbrains/plugins/remotesdk/RemoteSdkUtil", "testConnection"));
        }
        WebServerConfig config = RemoteSdkUtil.createWebServer(data);
        String title = WDBundle.message((String)"test.connection", (Object[])new Object[]{config.getFileTransferConfig().getAccessType().getTitle()});
        String validationInfo = config.getFileTransferConfig().validateFast();
        Object error = validationInfo != null ? validationInfo : (RemoteSdkUtil.testConnection(null, data) ? null : "Connection failed");
        if (error == null) {
            if (reportOnSuccess) {
                UIUtil.invokeLaterIfNeeded(() -> {
                    if (component == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/jetbrains/plugins/remotesdk/RemoteSdkUtil", "lambda$testConnection$2"));
                    }
                    Messages.showInfoMessage((Component)component, (String)WDBundle.message((String)"connection.to.successful", (Object[])new Object[]{data.getHost()}), (String)title);
                });
            }
            return true;
        }
        UIUtil.invokeLaterIfNeeded(() -> RemoteSdkUtil.lambda$testConnection$3(component, data, (String)error, title));
        return false;
    }

    public static ServerBrowserDialog showBrowseRemoteDialog(@NotNull String title, @NotNull JTextField field, boolean foldersOnly, @NotNull WebServerConfig serverConfig) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/jetbrains/plugins/remotesdk/RemoteSdkUtil", "showBrowseRemoteDialog"));
        }
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/jetbrains/plugins/remotesdk/RemoteSdkUtil", "showBrowseRemoteDialog"));
        }
        if (serverConfig == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serverConfig", "com/jetbrains/plugins/remotesdk/RemoteSdkUtil", "showBrowseRemoteDialog"));
        }
        WebServerConfig.RemotePath initialPath = new WebServerConfig.RemotePath(field.getText());
        Project project = (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext((Component)field));
        ServerBrowserDialog d = project != null ? new ServerBrowserDialog(project, serverConfig, title, foldersOnly, FileTransferConfig.Origin.ForceRoot, initialPath) : new ServerBrowserDialog((Component)field, serverConfig, title, foldersOnly, FileTransferConfig.Origin.ForceRoot, initialPath);
        d.show();
        return d;
    }

    @NotNull
    public static RemoteTransfer.HelpersTransferConfig newHelpersTransferConfigFromRemoteCredentials(final @NotNull RemoteSdkCredentials myRemoteSdkCredentials) {
        if (myRemoteSdkCredentials == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "myRemoteSdkCredentials", "com/jetbrains/plugins/remotesdk/RemoteSdkUtil", "newHelpersTransferConfigFromRemoteCredentials"));
        }
        RemoteTransfer.HelpersTransferConfig helpersTransferConfig = new RemoteTransfer.HelpersTransferConfig(){

            @Override
            @NotNull
            public String getHelpersPath() {
                String string = myRemoteSdkCredentials.getHelpersPath();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/remotesdk/RemoteSdkUtil$3", "getHelpersPath"));
                }
                return string;
            }

            @Override
            public final void createFileTransferConfig(@NotNull WebServerConfig server) {
                if (server == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "server", "com/jetbrains/plugins/remotesdk/RemoteSdkUtil$3", "createFileTransferConfig"));
                }
                RemoteSdkUtil.createFromRemoteCredentials(server, (RemoteCredentials)myRemoteSdkCredentials);
            }

            @Override
            public boolean isHelpersVersionChecked() {
                return myRemoteSdkCredentials.isHelpersVersionChecked();
            }

            @Override
            public void setHelpersVersionChecked(boolean checked) {
                myRemoteSdkCredentials.setHelpersVersionChecked(checked);
            }
        };
        if (helpersTransferConfig == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/remotesdk/RemoteSdkUtil", "newHelpersTransferConfigFromRemoteCredentials"));
        }
        return helpersTransferConfig;
    }

    @NotNull
    public static ProcessOutput getProcessOutput(@Nullable Project project, @NotNull RemoteSdkCredentials data, @NonNls GeneralCommandLine command) throws RemoteSdkException {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/jetbrains/plugins/remotesdk/RemoteSdkUtil", "getProcessOutput"));
        }
        SshRemoteSession runProcessSession = SdkSessionManager.checkConnectionAndGetSessionInBackground(project, data);
        JschProcess process = RemoteSdkUtil.createRemoteProcess(runProcessSession, command, false, false, false);
        CapturingRemoteProcessHandler processHandler = new CapturingRemoteProcessHandler(process, null, command.getCommandLineString());
        ProcessOutput processOutput = processHandler.runProcess();
        if (processOutput == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/remotesdk/RemoteSdkUtil", "getProcessOutput"));
        }
        return processOutput;
    }

    @Nullable
    public static String chooseRemoteFile(@NotNull Project project, @NotNull RemoteCredentials credentials, boolean foldersOnly) {
        WebServerConfig.RemotePath path;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/plugins/remotesdk/RemoteSdkUtil", "chooseRemoteFile"));
        }
        if (credentials == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "credentials", "com/jetbrains/plugins/remotesdk/RemoteSdkUtil", "chooseRemoteFile"));
        }
        WebServerConfig server = RemoteSdkUtil.createWebServer(credentials);
        ServerBrowserDialog d = new ServerBrowserDialog(project, server, "Choose Remote Path", foldersOnly, FileTransferConfig.Origin.ForceRoot, null);
        d.show();
        if (d.isOK() && (path = d.getPath()) != null) {
            return path.path;
        }
        return null;
    }

    private static /* synthetic */ void lambda$testConnection$3(@NotNull Component component, RemoteCredentials data, String error, String title) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/jetbrains/plugins/remotesdk/RemoteSdkUtil", "lambda$testConnection$3"));
        }
        Messages.showErrorDialog((Component)component, (String)WDBundle.message((String)"connection.to.failed", (Object[])new Object[]{data.getHost(), error}), (String)title);
    }

    public static interface RemoteSdkUpdatedCallback {
        public void updated(RemoteSdkCredentials var1);
    }
}

