/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cdi.jam;

import com.intellij.cdi.jam.CdiNamedBean;
import com.intellij.cdi.jam.CdiSemContributor;
import com.intellij.cdi.jam.events.CdiObserves;
import com.intellij.cdi.jam.inject.CdiInject;
import com.intellij.cdi.jam.lifecycle.CdiDispose;
import com.intellij.cdi.jam.producers.CdiProduces;
import com.intellij.cdi.jam.specialization.CdiSpecializes;
import com.intellij.cdi.utils.CdiCommonUtils;
import com.intellij.jam.JamService;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CdiJamModel {
    private final Module myModule;

    public static CdiJamModel getModel(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/cdi/jam/CdiJamModel", "getModel"));
        }
        return (CdiJamModel)ModuleServiceManager.getService((Module)module, CdiJamModel.class);
    }

    public CdiJamModel(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/cdi/jam/CdiJamModel", "<init>"));
        }
        this.myModule = module;
    }

    public List<CdiNamedBean> getNamedBeans() {
        return this.getNamedBeans(GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)this.myModule));
    }

    public List<CdiNamedBean> getNamedBeans(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/cdi/jam/CdiJamModel", "getNamedBeans"));
        }
        JamService service = JamService.getJamService((Project)this.myModule.getProject());
        ArrayList<CdiNamedBean> beanCdis = new ArrayList<CdiNamedBean>();
        beanCdis.addAll(service.getJamClassElements(CdiSemContributor.NAMED_JAM_KEY, "javax.inject.Named", scope));
        beanCdis.addAll(service.getJamMethodElements(CdiSemContributor.NAMED_JAM_KEY, "javax.inject.Named", scope));
        beanCdis.addAll(service.getJamFieldElements(CdiSemContributor.NAMED_JAM_KEY, "javax.inject.Named", scope));
        Collection<PsiClass> stereotypeAnnotationClasses = CdiCommonUtils.getStereotypeAnnotationClasses(this.myModule, "javax.inject.Named");
        for (String annoFQN : CdiCommonUtils.getQualifiedNames(stereotypeAnnotationClasses)) {
            beanCdis.addAll(service.getJamClassElements(CdiSemContributor.NAMED_JAM_KEY, annoFQN, scope));
            beanCdis.addAll(service.getJamMethodElements(CdiSemContributor.NAMED_JAM_KEY, annoFQN, scope));
            beanCdis.addAll(service.getJamFieldElements(CdiSemContributor.NAMED_JAM_KEY, annoFQN, scope));
        }
        return beanCdis;
    }

    public List<CdiObserves> getObserves() {
        return this.getObserves(GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)this.myModule));
    }

    public List<CdiObserves> getObserves(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/cdi/jam/CdiJamModel", "getObserves"));
        }
        JamService service = JamService.getJamService((Project)this.myModule.getProject());
        return service.getJamParameterElements(CdiObserves.META.getJamKey(), "javax.enterprise.event.Observes", scope);
    }

    public List<CdiDispose> getDisposes() {
        return this.getDisposes(GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)this.myModule));
    }

    public List<CdiDispose> getDisposes(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/cdi/jam/CdiJamModel", "getDisposes"));
        }
        JamService service = JamService.getJamService((Project)this.myModule.getProject());
        return service.getJamParameterElements(CdiDispose.META.getJamKey(), "javax.enterprise.inject.Disposes", scope);
    }

    @NotNull
    public List<CdiInject> getInjects() {
        List<CdiInject> list = this.getInjects(GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)this.myModule));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cdi/jam/CdiJamModel", "getInjects"));
        }
        return list;
    }

    @NotNull
    public List<CdiInject> getInjects(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/cdi/jam/CdiJamModel", "getInjects"));
        }
        JamService service = JamService.getJamService((Project)this.myModule.getProject());
        ArrayList<CdiInject> injects = new ArrayList<CdiInject>();
        injects.addAll(service.getJamFieldElements(CdiInject.FIELD_META, "javax.inject.Inject", scope));
        injects.addAll(service.getJamMethodElements(CdiInject.METHOD_META, "javax.inject.Inject", scope));
        ArrayList<CdiInject> arrayList = injects;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cdi/jam/CdiJamModel", "getInjects"));
        }
        return arrayList;
    }

    @NotNull
    public List<CdiProduces> getProduces() {
        List<CdiProduces> list = this.getProduces(GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)this.myModule));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cdi/jam/CdiJamModel", "getProduces"));
        }
        return list;
    }

    @NotNull
    public List<CdiProduces> getProduces(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/cdi/jam/CdiJamModel", "getProduces"));
        }
        List<CdiProduces> list = this.getProduces(scope, true, true);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cdi/jam/CdiJamModel", "getProduces"));
        }
        return list;
    }

    @NotNull
    public List<CdiProduces> getProduces(boolean methods, boolean fields) {
        List<CdiProduces> list = this.getProduces(GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)this.myModule), methods, fields);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cdi/jam/CdiJamModel", "getProduces"));
        }
        return list;
    }

    @NotNull
    public List<CdiProduces> getProduces(@NotNull GlobalSearchScope scope, boolean methods, boolean fields) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/cdi/jam/CdiJamModel", "getProduces"));
        }
        JamService service = JamService.getJamService((Project)this.myModule.getProject());
        ArrayList<CdiProduces> produces = new ArrayList<CdiProduces>();
        if (fields) {
            produces.addAll(service.getJamFieldElements(CdiProduces.FIELD_META, "javax.enterprise.inject.Produces", scope));
        }
        if (methods) {
            produces.addAll(service.getJamMethodElements(CdiProduces.METHOD_META, "javax.enterprise.inject.Produces", scope));
        }
        ArrayList<CdiProduces> arrayList = produces;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cdi/jam/CdiJamModel", "getProduces"));
        }
        return arrayList;
    }

    public List<CdiSpecializes> getSpecializeses() {
        JamService service = JamService.getJamService((Project)this.myModule.getProject());
        GlobalSearchScope scope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)this.myModule);
        ArrayList<CdiSpecializes> specializeses = new ArrayList<CdiSpecializes>();
        specializeses.addAll(service.getJamClassElements(CdiSpecializes.CLASS_META, "javax.enterprise.inject.Specializes", scope));
        specializeses.addAll(service.getJamMethodElements(CdiSpecializes.METHOD_META, "javax.enterprise.inject.Specializes", scope));
        return specializeses;
    }

    public List<CdiSpecializes> getSpecializes(PsiClass psiClass) {
        JamService service = JamService.getJamService((Project)this.myModule.getProject());
        return service.getAnnotatedMembersList(psiClass, CdiSpecializes.SEM_KEY, true, true, false, false);
    }
}

