/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.palette;

import com.intellij.CommonBundle;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.uiDesigner.UIDesignerBundle;
import com.intellij.uiDesigner.palette.GroupItem;
import com.intellij.uiDesigner.palette.Palette;
import java.util.List;
import javax.swing.Icon;

public class EditGroupAction
extends AnAction {
    public void actionPerformed(AnActionEvent e) {
        Project project = e.getProject();
        GroupItem groupToBeEdited = (GroupItem)GroupItem.DATA_KEY.getData(e.getDataContext());
        if (groupToBeEdited == null || project == null) {
            return;
        }
        String groupName = Messages.showInputDialog((Project)project, (String)UIDesignerBundle.message("edit.enter.group.name", new Object[0]), (String)UIDesignerBundle.message("title.edit.group", new Object[0]), (Icon)Messages.getQuestionIcon(), (String)groupToBeEdited.getName(), null);
        if (groupName == null || groupName.equals(groupToBeEdited.getName())) {
            return;
        }
        Palette palette = Palette.getInstance(project);
        List<GroupItem> groups = palette.getGroups();
        for (int i = groups.size() - 1; i >= 0; --i) {
            if (!groupName.equals(groups.get(i).getName())) continue;
            Messages.showErrorDialog((Project)project, (String)UIDesignerBundle.message("error.group.name.unique", new Object[0]), (String)CommonBundle.getErrorTitle());
            return;
        }
        groupToBeEdited.setName(groupName);
        palette.fireGroupsChanged();
    }

    public void update(AnActionEvent e) {
        Project project = e.getProject();
        GroupItem groupItem = (GroupItem)GroupItem.DATA_KEY.getData(e.getDataContext());
        e.getPresentation().setEnabled(project != null && groupItem != null && !groupItem.isReadOnly());
    }
}

