/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.thymeleaf.providers.contexts;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.thymeleaf.dialects.ThymeleafDialect;
import com.intellij.thymeleaf.dialects.ThymeleafDialects;
import com.intellij.thymeleaf.dialects.ThymeleafExpressionObject;
import com.intellij.thymeleaf.lang.support.ThymeleafContextVariablesProvider;
import com.intellij.thymeleaf.lang.support.beans.ThymeleafVariable;
import com.intellij.util.containers.HashSet;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class ThymeleafExpressionUtilityVariablesProvider
extends ThymeleafContextVariablesProvider {
    @Override
    @NotNull
    public Collection<? extends PsiVariable> getContextVariables(@NotNull PsiElement contextElement) {
        if (contextElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextElement", "com/intellij/thymeleaf/providers/contexts/ThymeleafExpressionUtilityVariablesProvider", "getContextVariables"));
        }
        HashSet variables = new HashSet();
        Project project = contextElement.getProject();
        for (ThymeleafDialect dialect : ThymeleafDialects.getDialects(contextElement.getProject())) {
            if (!dialect.isSupported(contextElement.getProject())) continue;
            for (ThymeleafExpressionObject thymeleafExpressionObject : dialect.getExpressionObjects()) {
                PsiClass aClass;
                String varName = "#" + thymeleafExpressionObject.getName();
                String className = thymeleafExpressionObject.getClassName();
                if (className == null || (aClass = JavaPsiFacade.getInstance((Project)project).findClass(className, GlobalSearchScope.allScope((Project)project))) == null) continue;
                variables.add(new ThymeleafVariable(varName, (PsiType)PsiTypesUtil.getClassType((PsiClass)aClass), (PsiElement)aClass));
            }
        }
        HashSet hashSet = variables;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/thymeleaf/providers/contexts/ThymeleafExpressionUtilityVariablesProvider", "getContextVariables"));
        }
        return hashSet;
    }
}

