/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.ui;

import com.intellij.util.EventDispatcher;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.ExtendedItem;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.LockLevel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.tfsIntegration.core.tfs.locks.LockItemModel;

public class LockItemsTableModel
extends AbstractTableModel {
    @NotNull
    private final List<LockItemModel> myContent;
    private final EventDispatcher<Listener> myEventDispatcher;

    public LockItemsTableModel(@NotNull List<LockItemModel> content) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "org/jetbrains/tfsIntegration/ui/LockItemsTableModel", "<init>"));
        }
        this.myEventDispatcher = EventDispatcher.create(Listener.class);
        this.myContent = content;
        Collections.sort(this.myContent, LockItemModel.LOCK_ITEM_PARENT_FIRST);
    }

    @Override
    public int getRowCount() {
        return this.myContent.size();
    }

    @Override
    public int getColumnCount() {
        return Column.values().length;
    }

    @Override
    public String getColumnName(int column) {
        return Column.values()[column].getName();
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return Column.values()[columnIndex] == Column.Selection && this.myContent.get(rowIndex).getSelectionStatus() != null;
    }

    @Override
    @Nullable
    public Object getValueAt(int rowIndex, int columnIndex) {
        return Column.values()[columnIndex].getValue(this.myContent.get(rowIndex));
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (Column.values()[columnIndex] == Column.Selection) {
            this.myContent.get(rowIndex).setSelectionStatus((Boolean)aValue);
            ((Listener)this.myEventDispatcher.getMulticaster()).selectionChanged();
        }
    }

    public List<LockItemModel> getSelectedItems() {
        ArrayList<LockItemModel> result = new ArrayList<LockItemModel>();
        for (LockItemModel item : this.myContent) {
            if (item.getSelectionStatus() != Boolean.TRUE) continue;
            result.add(item);
        }
        return result;
    }

    public void addListener(Listener listener) {
        this.myEventDispatcher.addListener((EventListener)listener);
    }

    public void removeListener(Listener listener) {
        this.myEventDispatcher.removeListener((EventListener)listener);
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (columnIndex == Column.Selection.ordinal()) {
            return Boolean.class;
        }
        if (columnIndex == Column.Item.ordinal()) {
            return ExtendedItem.class;
        }
        return super.getColumnClass(columnIndex);
    }

    static enum Column {
        Selection("", 5){

            @Override
            public Boolean getValue(LockItemModel item) {
                return item.getSelectionStatus();
            }
        }
        ,
        Item("Item", 550){

            public ExtendedItem getValue(LockItemModel item) {
                return item.getExtendedItem();
            }
        }
        ,
        Lock("Current Lock", 110){

            @Override
            public String getValue(LockItemModel item) {
                LockLevel lock = item.getExtendedItem().getLock();
                return lock == null ? "" : lock.getValue();
            }
        }
        ,
        LockOwner("Locked By", 130){

            @Override
            public String getValue(LockItemModel item) {
                String lockOwner = item.getLockOwner();
                return lockOwner == null ? "" : lockOwner;
            }
        };

        private final String myName;
        private final int myWidth;

        private Column(String name, int width) {
            this.myName = name;
            this.myWidth = width;
        }

        public String getName() {
            return this.myName;
        }

        public int getWidth() {
            return this.myWidth;
        }

        @Nullable
        public abstract Object getValue(LockItemModel var1);
    }

    public static interface Listener
    extends EventListener {
        public void selectionChanged();
    }
}

