/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tapestry.intellij;

import com.intellij.ProjectTopics;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootAdapter;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTreeChangeAdapter;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.psi.PsiTreeChangeListener;
import com.intellij.tapestry.core.TapestryProject;
import com.intellij.tapestry.intellij.TapestryModuleSupportLoader;
import com.intellij.tapestry.intellij.core.resource.IntellijResource;
import com.intellij.tapestry.intellij.util.IdeaUtils;
import com.intellij.tapestry.intellij.util.TapestryUtils;
import com.intellij.util.messages.MessageBusConnection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TapestryListenersSupportLoader
implements ProjectComponent {
    private final Project myProject;

    public TapestryListenersSupportLoader(Project project) {
        this.myProject = project;
    }

    public void initComponent() {
    }

    public void disposeComponent() {
    }

    @NotNull
    public String getComponentName() {
        String string = TapestryListenersSupportLoader.class.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tapestry/intellij/TapestryListenersSupportLoader", "getComponentName"));
        }
        return string;
    }

    public void projectOpened() {
        PsiManager.getInstance((Project)this.myProject).addPsiTreeChangeListener((PsiTreeChangeListener)new PsiTreeChangeAdapter(){

            public void childRemoved(@NotNull PsiTreeChangeEvent event) {
                PsiFile psiFile;
                PsiClass classDeleted;
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/tapestry/intellij/TapestryListenersSupportLoader$1", "childRemoved"));
                }
                Module module = TapestryListenersSupportLoader.getModuleFromEvent(event);
                if (module == null || module.isDisposed()) {
                    return;
                }
                TapestryProject tapestryProject = TapestryModuleSupportLoader.getTapestryProject(module);
                if (tapestryProject == null || !TapestryUtils.isTapestryModule(module)) {
                    return;
                }
                PsiElement child = event.getChild();
                if (child instanceof PsiClassOwner && (classDeleted = IdeaUtils.findPublicClass((PsiFile)((PsiClassOwner)child))) != null) {
                    tapestryProject.getEventsManager().classDeleted(classDeleted.getQualifiedName());
                }
                if (child instanceof PsiFile) {
                    tapestryProject.getEventsManager().fileDeleted(((PsiFile)child).getVirtualFile().getPath());
                }
                if (child instanceof PsiDirectory) {
                    tapestryProject.getEventsManager().fileDeleted(((PsiDirectory)child).getVirtualFile().getPath());
                }
                if ((psiFile = event.getFile()) != null) {
                    tapestryProject.getEventsManager().fileContentsChanged(new IntellijResource(psiFile));
                }
            }

            public void childAdded(@NotNull PsiTreeChangeEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/tapestry/intellij/TapestryListenersSupportLoader$1", "childAdded"));
                }
                Module module = TapestryListenersSupportLoader.getModuleFromEvent(event);
                if (module == null) {
                    return;
                }
                TapestryProject tapestryProject = TapestryModuleSupportLoader.getTapestryProject(module);
                if (tapestryProject == null || !TapestryUtils.isTapestryModule(module)) {
                    return;
                }
                PsiFile eventFile = event.getFile();
                if (eventFile != null) {
                    tapestryProject.getEventsManager().fileContentsChanged(new IntellijResource(eventFile));
                }
                if (!(event.getChild() instanceof PsiFile)) {
                    return;
                }
                PsiFile psiFile = (PsiFile)event.getChild();
                if (psiFile instanceof PsiClassOwner) {
                    tapestryProject.getEventsManager().classCreated(null);
                    return;
                }
                tapestryProject.getEventsManager().fileCreated(psiFile.getVirtualFile().getPath());
            }
        });
        MessageBusConnection connection = this.myProject.getMessageBus().connect((Disposable)this.myProject);
        connection.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootAdapter(){

            public void rootsChanged(ModuleRootEvent event) {
                for (Module module : ModuleManager.getInstance((Project)((Project)event.getSource())).getModules()) {
                    if (!TapestryUtils.isTapestryModule(module)) {
                        return;
                    }
                    TapestryProject tapestryProject = TapestryModuleSupportLoader.getTapestryProject(module);
                    tapestryProject.getEventsManager().modelChanged();
                }
            }
        });
    }

    public void projectClosed() {
    }

    @Nullable
    private static Module getModuleFromEvent(PsiTreeChangeEvent event) {
        PsiElement parent = event.getParent();
        return parent == null ? null : ModuleUtil.findModuleForPsiElement((PsiElement)parent);
    }
}

