/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tapestry.intellij.lang.descriptor;

import com.intellij.javaee.ExternalResourceManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbAware;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.tapestry.intellij.lang.descriptor.TapestryXmlExtension;
import com.intellij.tapestry.lang.TmlFileType;
import com.intellij.util.containers.HashSet;
import com.intellij.xml.XmlSchemaProvider;
import com.intellij.xml.util.XmlUtil;
import java.util.Arrays;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TapestrySchemaProvider
extends XmlSchemaProvider
implements DumbAware {
    public XmlFile getSchema(@NotNull @NonNls String url, @Nullable Module module, @NotNull PsiFile baseFile) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/tapestry/intellij/lang/descriptor/TapestrySchemaProvider", "getSchema"));
        }
        if (baseFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseFile", "com/intellij/tapestry/intellij/lang/descriptor/TapestrySchemaProvider", "getSchema"));
        }
        String location = ExternalResourceManager.getInstance().getResourceLocation(url, baseFile.getProject());
        return XmlUtil.findXmlFile((PsiFile)baseFile, (String)location);
    }

    public boolean isAvailable(@NotNull XmlFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/tapestry/intellij/lang/descriptor/TapestrySchemaProvider", "isAvailable"));
        }
        return file.getFileType() instanceof TmlFileType;
    }

    @NotNull
    public Set<String> getAvailableNamespaces(@NotNull XmlFile file, @Nullable String tagName) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/tapestry/intellij/lang/descriptor/TapestrySchemaProvider", "getAvailableNamespaces"));
        }
        HashSet set = new HashSet();
        set.addAll(Arrays.asList(TapestryXmlExtension.tapestryTemplateNamespaces()));
        set.add((Object)"tapestry:parameter");
        set.add((Object)"http://www.w3.org/1999/xhtml");
        HashSet hashSet = set;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tapestry/intellij/lang/descriptor/TapestrySchemaProvider", "getAvailableNamespaces"));
        }
        return hashSet;
    }

    @Nullable
    public String getDefaultPrefix(@NotNull @NonNls String namespace, @NotNull XmlFile context) {
        if (namespace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namespace", "com/intellij/tapestry/intellij/lang/descriptor/TapestrySchemaProvider", "getDefaultPrefix"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/tapestry/intellij/lang/descriptor/TapestrySchemaProvider", "getDefaultPrefix"));
        }
        if ("http://www.w3.org/1999/xhtml".equals(namespace)) {
            return "";
        }
        if (TapestryXmlExtension.isTapestryTemplateNamespace(namespace)) {
            return "t";
        }
        if ("tapestry:parameter".equals(namespace)) {
            return "p";
        }
        return null;
    }

    @Nullable
    public Set<String> getLocations(@NotNull @NonNls String namespace, @NotNull XmlFile context) {
        if (namespace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namespace", "com/intellij/tapestry/intellij/lang/descriptor/TapestrySchemaProvider", "getLocations"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/tapestry/intellij/lang/descriptor/TapestrySchemaProvider", "getLocations"));
        }
        return null;
    }
}

