/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tapestry.psi;

import com.intellij.lang.ASTNode;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiParser;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.tapestry.psi.TelCompositeElementType;
import com.intellij.tapestry.psi.TelTokenType;
import com.intellij.tapestry.psi.TelTokenTypes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TelParser
implements PsiParser {
    private static final Key<String> LAST_FOUND_IDENT = Key.create((String)"LAST_FOUND_IDENT");

    @NotNull
    public ASTNode parse(IElementType root, PsiBuilder builder) {
        PsiBuilder.Marker markerUnderFile;
        ASTNode contextNode = (ASTNode)builder.getUserData(TelTokenTypes.TAP5_CONTEXT_NODE_KEY);
        PsiBuilder.Marker rootMarker = builder.mark();
        boolean elUnderFile = contextNode != null && contextNode.getElementType() == TelTokenTypes.TEL_FILE;
        PsiBuilder.Marker marker = markerUnderFile = elUnderFile ? builder.mark() : null;
        while (!builder.eof()) {
            TelParser.parseExpression(builder);
        }
        if (markerUnderFile != null) {
            markerUnderFile.done(root);
            rootMarker.done((IElementType)TelTokenTypes.TEL_FILE);
        } else {
            rootMarker.done(root);
        }
        ASTNode aSTNode = builder.getTreeBuilt();
        if (aSTNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tapestry/psi/TelParser", "parse"));
        }
        return aSTNode;
    }

    public static void parseExpression(PsiBuilder builder) {
        if (TelParser.consumeToken(builder, TelTokenTypes.TAP5_EL_START)) {
            PsiBuilder.Marker referenceExpression = TelParser.tryToConsumeIdentifierAndMark(builder);
            if (referenceExpression != null) {
                if (TelParser.consumeOptionalToken(builder, TelTokenTypes.TAP5_EL_COLON)) {
                    try {
                        if ("prop".equalsIgnoreCase((String)builder.getUserData(LAST_FOUND_IDENT))) {
                            TelParser.parseExpressionInner(builder);
                        }
                        while (TelTokenTypes.TAP5_EL_END != builder.getTokenType()) {
                            builder.advanceLexer();
                        }
                    }
                    finally {
                        referenceExpression.done((IElementType)TelCompositeElementType.EXPLICIT_BINDING);
                        builder.putUserData(LAST_FOUND_IDENT, null);
                    }
                } else {
                    TelParser.parsePropertyChainTrailer(builder, referenceExpression);
                }
            } else {
                TelParser.parseExpressionInner(builder);
            }
            if (!TelParser.consumeToken(builder, TelTokenTypes.TAP5_EL_END)) {
                while (!builder.eof() && builder.getTokenType() != TelTokenTypes.TAP5_EL_END && builder.getTokenType() != TelTokenTypes.TAP5_EL_START) {
                    builder.advanceLexer();
                }
                TelParser.consumeOptionalToken(builder, TelTokenTypes.TAP5_EL_END);
            }
        } else {
            builder.advanceLexer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean parseExpressionInner(PsiBuilder builder) {
        PsiBuilder.Marker mark = builder.mark();
        TelCompositeElementType res = null;
        try {
            if (TelParser.consumeOptionalToken(builder, TelTokenTypes.TAP5_EL_LEFT_BRACKET)) {
                res = TelCompositeElementType.LIST_EXPRESSION;
                TelParser.parseExpressionList(builder);
                TelParser.consumeToken(builder, TelTokenTypes.TAP5_EL_RIGHT_BRACKET);
                boolean bl = true;
                return bl;
            }
            if (TelParser.consumeOptionalToken(builder, TelTokenTypes.TAP5_EL_EXCLAMATION)) {
                res = TelCompositeElementType.NOT_OP_EXPRESSION;
                TelParser.parseExpressionInner(builder);
                boolean bl = true;
                return bl;
            }
            res = TelParser.parseConstantExpr(builder);
            boolean propertyChainFound = false;
            if (res == null) {
                propertyChainFound = TelParser.parsePropertyChainExpression(builder);
            }
            if ((propertyChainFound || res == TelCompositeElementType.INTEGER_LITERAL) && builder.getTokenType() == TelTokenTypes.TAP5_EL_RANGE) {
                if (res != null) {
                    mark.done((IElementType)res);
                    mark = mark.precede();
                }
                TelParser.consumeToken(builder, TelTokenTypes.TAP5_EL_RANGE);
                res = TelCompositeElementType.RANGE_EXPRESSION;
                if (!TelParser.parseIntegerLiteral(builder) && !TelParser.parsePropertyChainExpression(builder)) {
                    builder.error("property chain or integer literal expected");
                }
            }
            boolean bl = propertyChainFound || res != null;
            return bl;
        }
        finally {
            if (res != null) {
                mark.done((IElementType)res);
            } else {
                mark.drop();
            }
        }
    }

    private static boolean parseIntegerLiteral(PsiBuilder builder) {
        PsiBuilder.Marker mark = builder.mark();
        boolean result = TelParser.consumeOptionalToken(builder, TelTokenTypes.TAP5_EL_INTEGER);
        if (result) {
            mark.done((IElementType)TelCompositeElementType.INTEGER_LITERAL);
        } else {
            mark.drop();
        }
        return result;
    }

    private static boolean consumeOptionalToken(PsiBuilder builder, TelTokenType tokenType) {
        if (tokenType != builder.getTokenType()) {
            return false;
        }
        builder.advanceLexer();
        return true;
    }

    private static boolean consumeToken(PsiBuilder builder, TelTokenType tokenType) {
        if (tokenType != builder.getTokenType()) {
            String s = tokenType.toString();
            s = StringUtil.trimStart((String)s, (String)"TAP5_EL_");
            builder.error(s + " expected");
            return false;
        }
        builder.advanceLexer();
        return true;
    }

    @Nullable
    private static TelCompositeElementType parseConstantExpr(PsiBuilder builder) {
        if (TelParser.consumeOptionalToken(builder, TelTokenTypes.TAP5_EL_BOOLEAN)) {
            return TelCompositeElementType.BOOLEAN_LITERAL;
        }
        if (TelParser.consumeOptionalToken(builder, TelTokenTypes.TAP5_EL_INTEGER)) {
            return TelCompositeElementType.INTEGER_LITERAL;
        }
        if (TelParser.consumeOptionalToken(builder, TelTokenTypes.TAP5_EL_DECIMAL)) {
            return TelCompositeElementType.DECIMAL_LITERAL;
        }
        if (TelParser.consumeOptionalToken(builder, TelTokenTypes.TAP5_EL_STRING)) {
            return TelCompositeElementType.STRING_LITERAL;
        }
        if (TelParser.consumeOptionalToken(builder, TelTokenTypes.TAP5_EL_NULL)) {
            return TelCompositeElementType.NULL_LITERAL;
        }
        return null;
    }

    private static boolean parsePropertyChainExpression(PsiBuilder builder) {
        PsiBuilder.Marker referenceExpression = TelParser.tryToConsumeIdentifierAndMark(builder);
        if (referenceExpression == null) {
            return false;
        }
        TelParser.parsePropertyChainTrailer(builder, referenceExpression);
        return true;
    }

    @Nullable
    private static PsiBuilder.Marker tryToConsumeIdentifierAndMark(PsiBuilder builder) {
        if (TelTokenTypes.TAP5_EL_IDENTIFIER != builder.getTokenType()) {
            return null;
        }
        PsiBuilder.Marker mark = builder.mark();
        builder.putUserData(LAST_FOUND_IDENT, (Object)builder.getTokenText());
        builder.advanceLexer();
        return mark;
    }

    private static void parsePropertyChainTrailer(PsiBuilder builder, PsiBuilder.Marker referenceExpression) {
        referenceExpression.done((IElementType)TelCompositeElementType.REFERENCE_EXPRESSION);
        referenceExpression = TelParser.parseMethodCallArgumentList(builder, referenceExpression).precede();
        while ((TelParser.consumeOptionalToken(builder, TelTokenTypes.TAP5_EL_DOT) || TelParser.consumeOptionalToken(builder, TelTokenTypes.TAP5_EL_QUESTION_DOT)) && TelParser.consumeToken(builder, TelTokenTypes.TAP5_EL_IDENTIFIER)) {
            referenceExpression.done((IElementType)TelCompositeElementType.REFERENCE_EXPRESSION);
            referenceExpression = TelParser.parseMethodCallArgumentList(builder, referenceExpression).precede();
        }
        referenceExpression.drop();
    }

    private static PsiBuilder.Marker parseMethodCallArgumentList(PsiBuilder builder, PsiBuilder.Marker referenceExpression) {
        if (!TelParser.consumeOptionalToken(builder, TelTokenTypes.TAP5_EL_LEFT_PARENTH)) {
            return referenceExpression;
        }
        referenceExpression = referenceExpression.precede();
        PsiBuilder.Marker mark = builder.mark();
        try {
            TelParser.parseExpressionList(builder);
        }
        finally {
            mark.done((IElementType)TelCompositeElementType.ARGUMENT_LIST);
        }
        TelParser.consumeToken(builder, TelTokenTypes.TAP5_EL_RIGHT_PARENTH);
        referenceExpression.done((IElementType)TelCompositeElementType.METHOD_CALL_EXPRESSION);
        return referenceExpression;
    }

    private static void parseExpressionList(PsiBuilder builder) {
        if (!TelParser.parseExpressionInner(builder)) {
            return;
        }
        while (TelParser.consumeOptionalToken(builder, TelTokenTypes.TAP5_EL_COMMA)) {
            if (TelParser.parseExpressionInner(builder)) continue;
            builder.error("expression expected");
        }
    }
}

