/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.j2ee.web.resin.ui;

import com.intellij.javaee.run.configuration.CommonModel;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.ui.PanelWithAnchor;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.intellij.j2ee.web.resin.ResinBundle;
import org.intellij.j2ee.web.resin.ResinModel;
import org.intellij.j2ee.web.resin.resin.common.ParseUtil;
import org.intellij.j2ee.web.resin.ui.ResinRunConfigurationEditorBase;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.PropertyKey;

public class RunConfigurationEditor
extends ResinRunConfigurationEditorBase
implements PanelWithAnchor {
    private JTextField myHttpPortTextField;
    private JPanel mainPanel;
    private JCheckBox debugConfiguration;
    private TextFieldWithBrowseButton resinConfSelector;
    private JTextField charset;
    private JCheckBox readOnlyConfiguration;
    private RawCommandLineEditor additionalParameters;
    private JCheckBox autoBuildClasspath;
    private JComboBox myDeployModeComboBox;
    private JTextField myJmxPortTextField;
    private JBLabel myAdditionalResinCommandLineLabel;
    private JLabel myJmxPortLabel;
    private JComponent anchor;

    public RunConfigurationEditor() {
        this.$$$setupUI$$$();
        RunConfigurationEditor.initChooser(this.resinConfSelector, ResinBundle.message("message.text.settings.resin.conf.file.title", new Object[0]), ResinBundle.message("message.text.settings.resin.conf.file.select", new Object[0]));
        this.myDeployModeComboBox.addItem("automatic");
        this.myDeployModeComboBox.addItem("lazy");
        this.myDeployModeComboBox.addItem("manual");
        this.setAnchor((JComponent)this.myAdditionalResinCommandLineLabel);
    }

    protected void resetEditorFrom(CommonModel commonModel) {
        ResinModel resinModel = (ResinModel)commonModel.getServerModel();
        this.myHttpPortTextField.setText(String.valueOf(resinModel.getLocalPort()));
        this.resinConfSelector.setText(resinModel.getResinConf());
        this.debugConfiguration.setSelected(resinModel.isDebugConfiguration());
        this.readOnlyConfiguration.setSelected(resinModel.isReadOnlyConfiguration());
        this.autoBuildClasspath.setSelected(resinModel.isAutoBuildClassPath());
        this.charset.setText(resinModel.getCharset());
        this.additionalParameters.setText(resinModel.getAdditionalParameters());
        this.myJmxPortTextField.setText(String.valueOf(resinModel.getJmxPort()));
        this.myDeployModeComboBox.setSelectedItem(resinModel.getDeployMode());
        this.updateJmxPortVisible(resinModel);
    }

    protected void applyEditorTo(CommonModel commonModel) throws ConfigurationException {
        ResinModel resinModel = (ResinModel)commonModel.getServerModel();
        resinModel.setPort(RunConfigurationEditor.parseInt(this.myHttpPortTextField, "run.config.dlg.http.port.error"));
        resinModel.setResinConf(this.resinConfSelector.getText());
        resinModel.setDebugConfiguration(this.debugConfiguration.isSelected());
        resinModel.setReadOnlyConfiguration(this.readOnlyConfiguration.isSelected());
        resinModel.setAutoBuildClassPath(this.autoBuildClasspath.isSelected());
        resinModel.setCharset(this.charset.getText());
        resinModel.setAdditionalParameters(this.additionalParameters.getText());
        resinModel.setJmxPort(RunConfigurationEditor.parseInt(this.myJmxPortTextField, "run.config.dlg.jmx.port.error"));
        resinModel.setDeployMode((String)this.myDeployModeComboBox.getSelectedItem());
    }

    @Override
    protected void setJmxPortVisible(boolean visible) {
        this.myJmxPortLabel.setVisible(visible);
        this.myJmxPortTextField.setVisible(visible);
    }

    @NotNull
    protected JComponent createEditor() {
        JPanel jPanel = this.mainPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/j2ee/web/resin/ui/RunConfigurationEditor", "createEditor"));
        }
        return jPanel;
    }

    public JComponent getAnchor() {
        return this.anchor;
    }

    public void setAnchor(JComponent anchor) {
        this.anchor = anchor;
        this.myAdditionalResinCommandLineLabel.setAnchor(anchor);
    }

    private static void initChooser(TextFieldWithBrowseButton field, String title, String description) {
        field.setText("");
        field.getTextField().setEditable(true);
        field.addBrowseFolderListener(title, description, null, FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor());
    }

    public static int parseInt(JTextField text, final @PropertyKey(resourceBundle="org.intellij.j2ee.web.resin.ResinBundle") String errorKey) throws ConfigurationException {
        return new ParseUtil(){

            @Override
            protected String getErrorMessage(String unparsableValue) {
                return ResinBundle.message(errorKey, unparsableValue);
            }
        }.parseInt(text);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextField jTextField;
        JTextField jTextField2;
        JTextField jTextField3;
        JLabel jLabel;
        JComboBox jComboBox;
        RawCommandLineEditor rawCommandLineEditor;
        JBLabel jBLabel;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        JPanel jPanel;
        this.mainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(6, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.readOnlyConfiguration = jCheckBox3 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox3, ResourceBundle.getBundle("org/intellij/j2ee/web/resin/ResinBundle").getString("run.config.dlg.notalter.resin.conf"));
        jPanel.add((Component)jCheckBox3, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.autoBuildClasspath = jCheckBox2 = new JCheckBox();
        jCheckBox2.setText("Include compiler output and libraries on classpath");
        jPanel.add((Component)jCheckBox2, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.debugConfiguration = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("org/intellij/j2ee/web/resin/ResinBundle").getString("run.config.dlg.debug.resin.conf"));
        jPanel.add((Component)jCheckBox, new GridConstraints(3, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("org/intellij/j2ee/web/resin/ResinBundle").getString("run.config.dlg.resin.conf"));
        jPanel2.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.resinConfSelector = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        textFieldWithBrowseButton.setEditable(true);
        textFieldWithBrowseButton.setEnabled(true);
        jPanel2.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 1, 1, 1, 1, 1, 3, 0, null, new Dimension(200, -1), null));
        this.myAdditionalResinCommandLineLabel = jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, ResourceBundle.getBundle("org/intellij/j2ee/web/resin/ResinBundle").getString("run.config.dlg.additional.params"));
        jPanel2.add((Component)jBLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.additionalParameters = rawCommandLineEditor = new RawCommandLineEditor();
        rawCommandLineEditor.setDialogCaption(ResourceBundle.getBundle("org/intellij/j2ee/web/resin/ResinBundle").getString("run.config.dlg.additional.params"));
        jPanel2.add((Component)rawCommandLineEditor, new GridConstraints(1, 1, 1, 1, 1, 1, 3, 0, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel3, new GridConstraints(4, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("org/intellij/j2ee/web/resin/ResinBundle").getString("run.config.dlg.deploy.mode"));
        jPanel3.add((Component)jLabel3, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myDeployModeComboBox = jComboBox = new JComboBox();
        jPanel3.add(jComboBox, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, null, null));
        this.myJmxPortLabel = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("org/intellij/j2ee/web/resin/ResinBundle").getString("run.config.dlg.jmx.port"));
        jPanel3.add((Component)jLabel, new GridConstraints(0, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myJmxPortTextField = jTextField3 = new JTextField();
        jPanel3.add((Component)jTextField3, new GridConstraints(0, 3, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, ResourceBundle.getBundle("org/intellij/j2ee/web/resin/ResinBundle").getString("run.config.dlg.charset"));
        jPanel3.add((Component)jLabel4, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.charset = jTextField2 = new JTextField();
        jPanel3.add((Component)jTextField2, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myHttpPortTextField = jTextField = new JTextField();
        jPanel3.add((Component)jTextField, new GridConstraints(1, 3, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel5 = new JLabel();
        this.$$$loadLabelText$$$(jLabel5, ResourceBundle.getBundle("org/intellij/j2ee/web/resin/ResinBundle").getString("run.config.dlg.http.port"));
        jPanel3.add((Component)jLabel5, new GridConstraints(1, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(5, 0, 1, 1, 0, 2, 1, 6, null, new Dimension(95, 14), null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.mainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

