/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vaadin.actions;

import com.intellij.gwt.facet.GwtFacet;
import com.intellij.gwt.module.GwtModulesManager;
import com.intellij.gwt.module.model.GwtModule;
import com.intellij.ide.actions.CreateElementActionBase;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.FileTemplateUtil;
import com.intellij.ide.util.PackageUtil;
import com.intellij.javaee.model.xml.web.InitParam;
import com.intellij.javaee.model.xml.web.Servlet;
import com.intellij.javaee.model.xml.web.WebApp;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vaadin.actions.CreateWidgetDialog;
import com.intellij.vaadin.actions.VaadinCreateElementActionBase;
import com.intellij.vaadin.framework.VaadinVersion;
import com.intellij.vaadin.framework.VaadinVersionUtil;
import com.intellij.vaadin.templates.VaadinTemplateNames;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateWidgetAction
extends VaadinCreateElementActionBase {
    public CreateWidgetAction() {
        super("Vaadin Widget", "Create new Vaadin widget");
    }

    @NotNull
    protected PsiElement[] invokeDialog(Project project, PsiDirectory directory) {
        CreateElementActionBase.MyInputValidator validator = new CreateElementActionBase.MyInputValidator((CreateElementActionBase)this, project, directory);
        Module module = ModuleUtilCore.findModuleForFile((VirtualFile)directory.getVirtualFile(), (Project)project);
        if (module == null) {
            if (PsiElement.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vaadin/actions/CreateWidgetAction", "invokeDialog"));
            }
            return PsiElement.EMPTY_ARRAY;
        }
        new CreateWidgetDialog(module, (InputValidator)validator).show();
        PsiElement[] psiElementArray = validator.getCreatedElements();
        if (psiElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vaadin/actions/CreateWidgetAction", "invokeDialog"));
        }
        return psiElementArray;
    }

    @NotNull
    protected PsiElement[] create(String newName, PsiDirectory directory) throws Exception {
        PsiPackage clientPackage;
        VirtualFile clientDir;
        Project project = directory.getProject();
        Module module = ModuleUtilCore.findModuleForFile((VirtualFile)directory.getVirtualFile(), (Project)project);
        if (module == null) {
            if (PsiElement.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vaadin/actions/CreateWidgetAction", "create"));
            }
            return PsiElement.EMPTY_ARRAY;
        }
        PsiUtil.checkIsIdentifier((PsiManager)directory.getManager(), (String)newName);
        JavaDirectoryService.getInstance().checkCreateClass(directory, newName);
        VaadinVersion version = VaadinVersionUtil.getVaadinVersion(module);
        VaadinTemplateNames templateNames = version.getTemplateNames();
        GwtModule widgetSetModule = CreateWidgetAction.findWidgetSetModule(module);
        PsiPackage basePackage = JavaDirectoryService.getInstance().getPackage(directory);
        String basePackageQualifiedName = basePackage != null ? basePackage.getQualifiedName() : null;
        PsiDirectory clientDirectory = null;
        PsiElement widgetSetFile = null;
        if (widgetSetModule != null && (clientDir = (VirtualFile)ContainerUtil.getFirstItem((Collection)widgetSetModule.getSourceRoots(false))) != null) {
            clientDirectory = PsiManager.getInstance((Project)project).findDirectory(clientDir);
        }
        if (clientDirectory == null) {
            clientDirectory = PackageUtil.findOrCreateSubdirectory((PsiDirectory)directory, (String)"client");
        }
        for (VirtualFile template : templateNames.getClientWidgetClasses()) {
            JavaDirectoryService.getInstance().checkCreateClass(clientDirectory, newName + template.getNameSuffix());
        }
        if (widgetSetModule == null) {
            FileTemplate template = FileTemplateManager.getInstance((Project)project).getJ2eeTemplate(templateNames.getWidgetSetModule());
            Properties properties = new Properties(FileTemplateManager.getInstance((Project)project).getDefaultProperties());
            properties.setProperty("GWT_MODULE_DOCTYPE", GwtFacet.getGwtVersion((Module)module).getGwtModuleDocTypeString());
            String widgetSetName = "WidgetSet";
            widgetSetFile = FileTemplateUtil.createFromTemplate((FileTemplate)template, (String)(widgetSetName + ".gwt.xml"), (Properties)properties, (PsiDirectory)directory);
            String widgetSetQualifiedName = StringUtil.getQualifiedName((String)basePackageQualifiedName, (String)widgetSetName);
            CreateWidgetAction.registerWidgetSetInServlet(module, version, widgetSetQualifiedName);
        }
        String clientPackageQualifiedName = (clientPackage = JavaDirectoryService.getInstance().getPackage(clientDirectory)) != null ? clientPackage.getQualifiedName() : null;
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("BASE_PACKAGE_NAME", basePackageQualifiedName);
        properties.put("CLIENT_PACKAGE_NAME", clientPackageQualifiedName);
        properties.put("WIDGET_NAME", newName);
        ArrayList<PsiClass> result = new ArrayList<PsiClass>();
        ContainerUtil.addIfNotNull(result, widgetSetFile);
        result.add(JavaDirectoryService.getInstance().createClass(directory, newName, templateNames.getWidget(), false, properties));
        for (VaadinTemplateNames.ClientWidgetClassTemplate template : templateNames.getClientWidgetClasses()) {
            result.add(JavaDirectoryService.getInstance().createClass(clientDirectory, newName + template.getNameSuffix(), template.getTemplateName(), false, properties));
        }
        PsiElement[] psiElementArray = result.toArray(new PsiElement[result.size()]);
        if (psiElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vaadin/actions/CreateWidgetAction", "create"));
        }
        return psiElementArray;
    }

    private static void registerWidgetSetInServlet(Module module, VaadinVersion version, String widgetSetQualifiedName) {
        WebApp webApp;
        WebFacet webFacet;
        GwtFacet facet = GwtFacet.getInstance((Module)module);
        if (facet != null && (webFacet = facet.getWebFacet()) != null && (webApp = webFacet.getRoot()) != null) {
            for (Servlet servlet : webApp.getServlets()) {
                if (!version.getServletClass().equals(servlet.getServletClass().getStringValue())) continue;
                InitParam param = servlet.addInitParam();
                param.getParamName().setValue((Object)"widgetset");
                param.getParamValue().setValue((Object)widgetSetQualifiedName);
            }
        }
    }

    @Nullable
    private static GwtModule findWidgetSetModule(Module module) {
        VaadinVersion version = VaadinVersionUtil.getVaadinVersion(module);
        GwtModulesManager modulesManager = GwtModulesManager.getInstance((Project)module.getProject());
        GlobalSearchScope scope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module);
        List widgetSetBaseModules = modulesManager.findGwtModulesByQualifiedName(version.getWidgetSetModuleName(), scope);
        for (GwtModule gwtModule : modulesManager.getGwtModules(module, false)) {
            if (!widgetSetBaseModules.isEmpty() && !modulesManager.isInheritedOrSelf(gwtModule, widgetSetBaseModules)) continue;
            return gwtModule;
        }
        return null;
    }

    protected String getErrorTitle() {
        return "Cannot Create Widget";
    }

    protected String getCommandName() {
        return "Create Widget";
    }

    protected String getActionName(PsiDirectory directory, String newName) {
        return "Creating Vaadin widget '" + newName + "'";
    }
}

