/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.model.autoconfigure.jam;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.jam.JamAttributeElement;
import com.intellij.jam.JamBooleanAttributeElement;
import com.intellij.jam.JamConverter;
import com.intellij.jam.JamService;
import com.intellij.jam.JamSimpleReferenceConverter;
import com.intellij.jam.JamStringAttributeElement;
import com.intellij.jam.annotations.JamPsiConnector;
import com.intellij.jam.reflect.JamAnnotationMeta;
import com.intellij.jam.reflect.JamAttributeMeta;
import com.intellij.jam.reflect.JamBooleanAttributeMeta;
import com.intellij.jam.reflect.JamClassMeta;
import com.intellij.jam.reflect.JamMethodMeta;
import com.intellij.jam.reflect.JamStringAttributeMeta;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.semantic.SemKey;
import com.intellij.spring.boot.application.config.SpringBootHintReferencesProvider;
import com.intellij.spring.boot.application.metadata.SpringBootApplicationMetaConfigKey;
import com.intellij.spring.boot.application.metadata.SpringBootApplicationMetaConfigKeyManager;
import com.intellij.spring.boot.model.autoconfigure.jam.ConditionalOnEvaluationContext;
import com.intellij.spring.boot.model.autoconfigure.jam.ConditionalOnJamElement;
import com.intellij.util.ProcessingContext;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import icons.SpringBootApiIcons;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ConditionalOnProperty
implements ConditionalOnJamElement {
    private static final JamStringAttributeMeta.Collection<SpringBootApplicationMetaConfigKey> VALUE_META = JamAttributeMeta.collectionString((String)"value", (JamConverter)new NameJamConverter());
    private static final JamStringAttributeMeta.Collection<SpringBootApplicationMetaConfigKey> NAME_META = JamAttributeMeta.collectionString((String)"name", (JamConverter)new NameJamConverter());
    private static final JamStringAttributeMeta.Single<String> PREFIX_META = JamAttributeMeta.singleString((String)"prefix", (JamConverter)new PrefixJamConverter());
    private static final JamStringAttributeMeta.Single<String> HAVING_VALUE_META = JamAttributeMeta.singleString((String)"havingValue", (JamConverter)new HavingValueJamConverter());
    private static final JamBooleanAttributeMeta MATCH_IF_MISSING_META = JamAttributeMeta.singleBoolean((String)"matchIfMissing", (boolean)false);
    private static final JamBooleanAttributeMeta RELAXED_NAMES_META = JamAttributeMeta.singleBoolean((String)"relaxedNames", (boolean)true);
    private static final JamAnnotationMeta ANNOTATION_META = new JamAnnotationMeta("org.springframework.boot.autoconfigure.condition.ConditionalOnProperty").addAttribute(VALUE_META).addAttribute(NAME_META).addAttribute(PREFIX_META).addAttribute(HAVING_VALUE_META).addAttribute((JamAttributeMeta)MATCH_IF_MISSING_META).addAttribute((JamAttributeMeta)RELAXED_NAMES_META);
    private static final SemKey<ConditionalOnProperty> SEM_KEY = CONDITIONAL_JAM_ELEMENT_KEY.subKey("ConditionalOnProperty", new SemKey[0]);
    public static final JamClassMeta<ConditionalOnProperty> CLASS_META = new JamClassMeta(null, ConditionalOnProperty.class, SEM_KEY).addAnnotation(ANNOTATION_META);
    public static final JamMethodMeta<ConditionalOnProperty> METHOD_META = new JamMethodMeta(null, ConditionalOnProperty.class, SEM_KEY).addAnnotation(ANNOTATION_META);

    @JamPsiConnector
    @NotNull
    public abstract PsiModifierListOwner getPsiElement();

    public boolean value(ConditionalOnEvaluationContext context) {
        return false;
    }

    private List<JamStringAttributeElement<SpringBootApplicationMetaConfigKey>> getNameOrValue() {
        List name = (List)ANNOTATION_META.getAttribute(this.getPsiElement(), NAME_META);
        if (!name.isEmpty()) {
            return name;
        }
        return (List)ANNOTATION_META.getAttribute(this.getPsiElement(), VALUE_META);
    }

    public List<SpringBootApplicationMetaConfigKey> getResolvedMetaConfigKeys() {
        return ContainerUtil.mapNotNull(this.getNameOrValue(), JamStringAttributeElement::getValue);
    }

    public String getHavingValue() {
        return (String)((JamStringAttributeElement)ANNOTATION_META.getAttribute(this.getPsiElement(), HAVING_VALUE_META)).getValue();
    }

    public boolean isMatchIfMissing() {
        return ((JamBooleanAttributeElement)ANNOTATION_META.getAttribute(this.getPsiElement(), (JamAttributeMeta)MATCH_IF_MISSING_META)).getValue();
    }

    public boolean isRelaxedNames() {
        return ((JamBooleanAttributeElement)ANNOTATION_META.getAttribute(this.getPsiElement(), (JamAttributeMeta)RELAXED_NAMES_META)).getValue();
    }

    @Nullable
    private static ConditionalOnProperty getCurrentConditionalOnProperty(JamAttributeElement<?> context) {
        PsiAnnotation annotation = (PsiAnnotation)context.getParentAnnotationElement().getPsiElement();
        if (annotation == null) {
            return null;
        }
        PsiElement jamOwner = PsiTreeUtil.getParentOfType((PsiElement)context.getPsiElement(), (Class[])new Class[]{PsiMethod.class, PsiClass.class});
        if (jamOwner == null) {
            return null;
        }
        ConditionalOnProperty conditionalOnProperty = (ConditionalOnProperty)JamService.getJamService((Project)annotation.getProject()).getJamElement(ConditionalOnProperty.class, jamOwner);
        assert (conditionalOnProperty != null);
        return conditionalOnProperty;
    }

    private static class HavingValueJamConverter
    extends JamConverter<String> {
        private HavingValueJamConverter() {
        }

        @Nullable
        public String fromString(@Nullable String s, JamStringAttributeElement<String> context) {
            return s;
        }

        @NotNull
        public PsiReference[] createReferences(JamStringAttributeElement<String> context) {
            PsiLiteral psiElement = context.getPsiLiteral();
            if (psiElement == null) {
                if (PsiReference.EMPTY_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/model/autoconfigure/jam/ConditionalOnProperty$HavingValueJamConverter", "createReferences"));
                }
                return PsiReference.EMPTY_ARRAY;
            }
            ConditionalOnProperty conditionalOnProperty = ConditionalOnProperty.getCurrentConditionalOnProperty(context);
            if (conditionalOnProperty == null) {
                if (PsiReference.EMPTY_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/model/autoconfigure/jam/ConditionalOnProperty$HavingValueJamConverter", "createReferences"));
                }
                return PsiReference.EMPTY_ARRAY;
            }
            List nameAttributes = conditionalOnProperty.getNameOrValue();
            if (nameAttributes.size() != 1) {
                if (PsiReference.EMPTY_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/model/autoconfigure/jam/ConditionalOnProperty$HavingValueJamConverter", "createReferences"));
                }
                return PsiReference.EMPTY_ARRAY;
            }
            JamStringAttributeElement firstNameElement = (JamStringAttributeElement)ContainerUtil.getFirstItem((List)nameAttributes);
            assert (firstNameElement != null);
            SpringBootApplicationMetaConfigKey configKey = (SpringBootApplicationMetaConfigKey)firstNameElement.getValue();
            if (configKey == null) {
                if (PsiReference.EMPTY_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/model/autoconfigure/jam/ConditionalOnProperty$HavingValueJamConverter", "createReferences"));
                }
                return PsiReference.EMPTY_ARRAY;
            }
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiElement);
            PsiReference[] psiReferenceArray = SpringBootHintReferencesProvider.getInstance().getReferences(module, configKey, SpringBootHintReferencesProvider.ItemHintType.VALUE, (PsiElement)psiElement, new ProcessingContext());
            if (psiReferenceArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/model/autoconfigure/jam/ConditionalOnProperty$HavingValueJamConverter", "createReferences"));
            }
            return psiReferenceArray;
        }
    }

    private static class PrefixJamConverter
    extends JamSimpleReferenceConverter<String> {
        private PrefixJamConverter() {
        }

        @Nullable
        public String fromString(@Nullable String s, JamStringAttributeElement<String> context) {
            return s;
        }

        public Collection<String> getVariants(JamStringAttributeElement<String> context) {
            List<SpringBootApplicationMetaConfigKey> keys = SpringBootApplicationMetaConfigKeyManager.getInstance().getAllMetaConfigKeys((PsiElement)context.getPsiElement());
            LinkedHashSet<String> prefixes = new LinkedHashSet<String>();
            for (SpringBootApplicationMetaConfigKey key : keys) {
                int lastDot = key.getName().lastIndexOf(46);
                if (lastDot == -1) continue;
                String keyPrefix = key.getName().substring(0, lastDot);
                prefixes.add(keyPrefix);
            }
            return prefixes;
        }

        @NotNull
        protected LookupElement createLookupElementFor(@NotNull String target) {
            if (target == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/intellij/spring/boot/model/autoconfigure/jam/ConditionalOnProperty$PrefixJamConverter", "createLookupElementFor"));
            }
            LookupElementBuilder lookupElementBuilder = LookupElementBuilder.create((String)target).withIcon(SpringBootApiIcons.SpringBoot);
            if (lookupElementBuilder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/model/autoconfigure/jam/ConditionalOnProperty$PrefixJamConverter", "createLookupElementFor"));
            }
            return lookupElementBuilder;
        }
    }

    private static class NameJamConverter
    extends JamSimpleReferenceConverter<SpringBootApplicationMetaConfigKey> {
        private NameJamConverter() {
        }

        @Nullable
        public SpringBootApplicationMetaConfigKey fromString(@Nullable String s, JamStringAttributeElement<SpringBootApplicationMetaConfigKey> context) {
            String prefix = NameJamConverter.getPrefixValueForName(context);
            if (prefix == null) {
                return null;
            }
            PsiAnnotationMemberValue psiElement = context.getPsiElement();
            assert (psiElement != null);
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiElement);
            return SpringBootApplicationMetaConfigKeyManager.getInstance().findApplicationMetaConfigKey(module, prefix + s);
        }

        @Nullable
        protected PsiElement getPsiElementFor(@NotNull SpringBootApplicationMetaConfigKey target) {
            if (target == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/intellij/spring/boot/model/autoconfigure/jam/ConditionalOnProperty$NameJamConverter", "getPsiElementFor"));
            }
            return target.getDeclaration();
        }

        public LookupElement[] getLookupVariants(JamStringAttributeElement<SpringBootApplicationMetaConfigKey> context) {
            String prefix = NameJamConverter.getPrefixValueForName(context);
            if (prefix == null) {
                return LookupElement.EMPTY_ARRAY;
            }
            SmartList variants = new SmartList();
            for (SpringBootApplicationMetaConfigKey key : this.getVariants(context)) {
                String actualKey = StringUtil.substringAfter((String)key.getName(), (String)prefix);
                LookupElement element = key.getPresentation().tuneLookupElement((LookupElement)key.getPresentation().getLookupElement(actualKey));
                variants.add(element);
            }
            return variants.toArray(new LookupElement[variants.size()]);
        }

        public Collection<SpringBootApplicationMetaConfigKey> getVariants(JamStringAttributeElement<SpringBootApplicationMetaConfigKey> context) {
            String prefix = StringUtil.notNullize((String)NameJamConverter.getPrefixValueForName(context));
            List<SpringBootApplicationMetaConfigKey> allKeys = SpringBootApplicationMetaConfigKeyManager.getInstance().getAllMetaConfigKeys((PsiElement)context.getPsiElement());
            SmartList variants = new SmartList();
            for (SpringBootApplicationMetaConfigKey key : allKeys) {
                if (!prefix.isEmpty() && (!key.matchesPrefix(prefix) || NameJamConverter.isKeyFromSubgroup(prefix, key))) continue;
                variants.add(key);
            }
            return variants;
        }

        private static boolean isKeyFromSubgroup(String prefix, SpringBootApplicationMetaConfigKey key) {
            return StringUtil.contains((CharSequence)key.getName(), (int)(prefix.length() + 1), (int)key.getName().length(), (char)'.');
        }

        @Nullable
        private static String getPrefixValueForName(JamStringAttributeElement<SpringBootApplicationMetaConfigKey> context) {
            ConditionalOnProperty conditionalOnProperty = ConditionalOnProperty.getCurrentConditionalOnProperty(context);
            if (conditionalOnProperty == null) {
                return null;
            }
            String prefix = (String)((JamStringAttributeElement)ANNOTATION_META.getAttribute(conditionalOnProperty.getPsiElement(), (JamAttributeMeta)PREFIX_META)).getValue();
            if (StringUtil.isEmpty((String)prefix)) {
                return "";
            }
            if (!StringUtil.endsWithChar((CharSequence)prefix, (char)'.')) {
                return prefix + '.';
            }
            return prefix;
        }
    }
}

