/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.inspections;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.cucumber.psi.GherkinElementFactory;
import org.jetbrains.plugins.cucumber.psi.GherkinExamplesBlock;
import org.jetbrains.plugins.cucumber.psi.GherkinKeywordTable;
import org.jetbrains.plugins.cucumber.psi.GherkinScenarioOutline;
import org.jetbrains.plugins.cucumber.psi.GherkinStep;
import org.jetbrains.plugins.cucumber.psi.GherkinTable;
import org.jetbrains.plugins.cucumber.psi.GherkinTableCell;
import org.jetbrains.plugins.cucumber.psi.GherkinTableRow;
import org.jetbrains.plugins.cucumber.psi.impl.GherkinExamplesBlockImpl;
import org.jetbrains.plugins.cucumber.psi.impl.GherkinScenarioOutlineImpl;

public class CucumberCreateExamplesSectionFix
implements LocalQuickFix {
    private static final Logger LOG = Logger.getInstance((String)CucumberCreateExamplesSectionFix.class.getName());

    @NotNull
    public String getFamilyName() {
        if ("Create Examples Section" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/cucumber/inspections/CucumberCreateExamplesSectionFix", "getFamilyName"));
        }
        return "Create Examples Section";
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/cucumber/inspections/CucumberCreateExamplesSectionFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/plugins/cucumber/inspections/CucumberCreateExamplesSectionFix", "applyFix"));
        }
        GherkinScenarioOutlineImpl outline = (GherkinScenarioOutlineImpl)descriptor.getPsiElement();
        PsiFile featureFile = outline.getContainingFile();
        if (!FileModificationService.getInstance().prepareFileForWrite(featureFile)) {
            return;
        }
        String language = GherkinKeywordTable.getFeatureLanguage(featureFile);
        GherkinKeywordTable keywordsTable = GherkinKeywordTable.getKeywordsTable(featureFile, project);
        StringBuilder buff = new StringBuilder();
        buff.append(keywordsTable.getScenarioOutlineKeyword()).append(": boo\n");
        buff.append(keywordsTable.getExampleSectionKeyword()).append(":\n|");
        ArrayList<String> params = new ArrayList<String>();
        PsiElement[] elements = outline.getChildren();
        for (PsiElement element : elements) {
            if (!(element instanceof GherkinStep)) continue;
            GherkinStep step = (GherkinStep)element;
            List<String> substitutions = step.getParamsSubstitutions();
            for (String substitution : substitutions) {
                if (params.contains(substitution)) continue;
                params.add(substitution);
            }
        }
        if (params.isEmpty()) {
            buff.append(" |");
        } else {
            for (String substitution : params) {
                buff.append(' ').append(substitution).append(" |");
            }
        }
        String text = buff.toString();
        GherkinScenarioOutline fakeScenario = (GherkinScenarioOutline)GherkinElementFactory.createScenarioFromText(project, language, text);
        GherkinExamplesBlock fakeExampleSection = fakeScenario.getExamplesBlocks().get(0);
        assert (fakeExampleSection != null);
        GherkinExamplesBlockImpl addedSection = (GherkinExamplesBlockImpl)outline.add(fakeExampleSection);
        addedSection = (GherkinExamplesBlockImpl)CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement((PsiElement)addedSection);
        GherkinTable table = addedSection.getTable();
        assert (table != null);
        GherkinTableRow headerRow = table.getHeaderRow();
        assert (headerRow != null);
        List<GherkinTableCell> cells = headerRow.getPsiCells();
        int firstCellOffset = cells.size() > 0 && cells.get(0).getTextLength() > 0 ? cells.get(0).getTextOffset() : headerRow.getTextOffset() + 1;
        Editor editor = FileEditorManager.getInstance((Project)project).getSelectedTextEditor();
        assert (editor != null);
        Document document = editor.getDocument();
        PsiDocumentManager.getInstance((Project)project).commitDocument(document);
        editor.getCaretModel().moveToOffset(firstCellOffset);
    }
}

