/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jboss.jbpm.ui;

import com.intellij.diagram.DiagramPresentationModel;
import com.intellij.diagram.Utils;
import com.intellij.jboss.jbpm.layout.ChartLayoutCoordinator;
import com.intellij.jboss.jbpm.model.ChartDataModel;
import com.intellij.jboss.jbpm.settings.ChartProvider;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.project.Project;
import com.intellij.uml.UmlGraphBuilder;
import org.jetbrains.annotations.NotNull;

public abstract class ChartBuilder<T>
extends UmlGraphBuilder {
    private ChartLayoutCoordinator chartLayoutCoordinator;
    @NotNull
    private final ChartProvider<T> chartProvider;

    protected ChartBuilder(Project project, @NotNull ChartProvider<T> chartProvider, Graph2D graph, Graph2DView view, ChartDataModel<T> dataModel, DiagramPresentationModel presentationModel) {
        if (chartProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chartProvider", "com/intellij/jboss/jbpm/ui/ChartBuilder", "<init>"));
        }
        super(project, graph, view, dataModel, presentationModel);
        this.chartProvider = chartProvider;
        this.chartLayoutCoordinator = chartProvider.createLayoutCoordinator(project, dataModel);
        this.putUserData(Utils.UML_PROVIDER, chartProvider);
    }

    @NotNull
    public ChartProvider<T> getProvider() {
        ChartProvider<T> chartProvider = this.chartProvider;
        if (chartProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jboss/jbpm/ui/ChartBuilder", "getProvider"));
        }
        return chartProvider;
    }

    public ChartDataModel<T> getDataModel() {
        return (ChartDataModel)super.getDataModel();
    }

    public ChartLayoutCoordinator getChartLayoutCoordinator() {
        return this.chartLayoutCoordinator;
    }
}

