/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.appServers.supportProvider;

import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.j2ee.openapi.ex.DeploymentManagerEx;
import com.intellij.javaee.deployment.DeploymentProvider;
import com.intellij.javaee.deployment.DeploymentSettings;
import com.intellij.javaee.run.configuration.CommonModel;
import com.intellij.javaee.supportProvider.JavaeeFrameworkSupportContributionModel;
import com.intellij.javaee.supportProvider.JavaeeFrameworkSupportContributorBase;
import com.intellij.javaee.ui.packaging.ExplodedEarArtifactType;
import com.intellij.javaee.ui.packaging.ExplodedEjbArtifactType;
import com.intellij.javaee.ui.packaging.ExplodedWarArtifactType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.impl.run.BuildArtifactsBeforeRunTaskProvider;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class AppServerSupportContributor
extends JavaeeFrameworkSupportContributorBase {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.javaee.appServers.supportProvider.AppServerSupportContributor");

    @Override
    protected void setupServerRunConfiguration(@NotNull CommonModel commonModel, JavaeeFrameworkSupportContributionModel model) {
        Artifact warArtifact;
        Artifact ejbArtifact;
        Artifact earArtifact;
        if (commonModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commonModel", "com/intellij/javaee/appServers/supportProvider/AppServerSupportContributor", "setupServerRunConfiguration"));
        }
        DeploymentProvider deploymentProvider = DeploymentManagerEx.getProvider(commonModel);
        if (deploymentProvider == null) {
            return;
        }
        Collection supportedArtifactTypes = deploymentProvider.getSupportedArtifactTypes();
        if (supportedArtifactTypes.contains((Object)ExplodedEarArtifactType.getInstance()) && (earArtifact = model.getExplodedEarArtifact()) != null) {
            AppServerSupportContributor.setArtifactToDeploy(earArtifact, commonModel, model);
            return;
        }
        if (supportedArtifactTypes.contains((Object)ExplodedEjbArtifactType.getInstance()) && (ejbArtifact = model.getExplodedEjbArtifact()) != null) {
            AppServerSupportContributor.setArtifactToDeploy(ejbArtifact, commonModel, model);
        }
        if (supportedArtifactTypes.contains((Object)ExplodedWarArtifactType.getInstance()) && (warArtifact = model.getExplodedWarArtifact()) != null) {
            AppServerSupportContributor.setArtifactToDeploy(warArtifact, commonModel, model);
        }
    }

    private static void setArtifactToDeploy(Artifact artifact, CommonModel commonModel, JavaeeFrameworkSupportContributionModel model) {
        DeploymentSettings settings = commonModel.getDeploymentSettings();
        LOG.assertTrue(settings != null, (Object)commonModel.getIntegration());
        settings.getOrCreateModel(artifact);
        BuildArtifactsBeforeRunTaskProvider.setBuildArtifactBeforeRun((Project)model.getProject(), (RunConfiguration)commonModel, (Artifact)artifact);
    }
}

