/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.deployment;

import com.intellij.javaee.deployment.ExternalFileDeploymentProvider;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import gnu.trove.THashSet;
import java.io.File;
import java.io.FileFilter;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class ExternalFileDeploymentProviderImpl
extends ExternalFileDeploymentProvider {
    private FileFilter myFileFilter;
    private boolean myDirectoriesAllowed;

    public ExternalFileDeploymentProviderImpl(boolean directoriesAllowed, Collection<String> allowedExtensions) {
        this.myDirectoriesAllowed = directoriesAllowed;
        this.myFileFilter = new DeployableFileFilter(allowedExtensions);
    }

    public boolean isDirectoriesAllowed() {
        return this.myDirectoriesAllowed;
    }

    @NotNull
    public FileFilter getDeployableFileFilter() {
        FileFilter fileFilter = this.myFileFilter;
        if (fileFilter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/deployment/ExternalFileDeploymentProviderImpl", "getDeployableFileFilter"));
        }
        return fileFilter;
    }

    private static class DeployableFileFilter
    implements FileFilter {
        private final Set<String> myAllowedExtensions;

        public DeployableFileFilter(Collection<String> allowedExtensions) {
            this.myAllowedExtensions = new THashSet(allowedExtensions, FileUtil.PATH_HASHING_STRATEGY);
        }

        @Override
        public boolean accept(File file) {
            return this.myAllowedExtensions.contains(FileUtilRt.getExtension((String)file.getName()));
        }
    }
}

