/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.ejb;

import com.intellij.jam.model.common.CommonModelElement;
import com.intellij.jam.model.common.CommonModelRefactoringSupport;
import com.intellij.javaee.EjbType;
import com.intellij.javaee.J2EEBundle;
import com.intellij.javaee.model.common.ejb.EjbCommonModelUtil;
import com.intellij.javaee.model.common.ejb.EnterpriseBean;
import com.intellij.javaee.model.common.ejb.EntityBean;
import com.intellij.javaee.module.view.ejb.ejbLevel.EjbPrefixNameSuffixPanel;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.xml.XmlTag;
import com.intellij.refactoring.rename.RenameProcessor;
import com.intellij.refactoring.ui.RefactoringDialog;
import com.intellij.ui.EditorTextField;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.ElementPresentationManager;
import com.intellij.util.xml.GenericValue;
import com.intellij.util.xml.ModelMergerUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nullable;

public class EjbRenameDialog
extends RefactoringDialog {
    private final EjbPrefixNameSuffixPanel myPrefixNameSuffixPanel;
    private EditorTextField myAbstractSchemaName;
    private JPanel myPanel;
    private JLabel myASNLabel;
    private JPanel myNamePanel;
    private final EnterpriseBean myEjb;

    public EjbRenameDialog(EnterpriseBean ejb) {
        super(ejb.getPsiManager().getProject(), true);
        this.myEjb = ejb;
        this.$$$setupUI$$$();
        String ejbName = (String)ejb.getEjbName().getValue();
        EjbType ejbType = EjbType.getEjbType(ejb);
        this.myPrefixNameSuffixPanel = new EjbPrefixNameSuffixPanel(ejb.getModule(), ejbType, ejbName){

            @Override
            public void beforeNameChange() {
                if (EjbRenameDialog.this.myAbstractSchemaName.getText().equals(this.getFullName())) {
                    ApplicationManager.getApplication().invokeLater(() -> EjbRenameDialog.this.myAbstractSchemaName.setText(this.getFullName()));
                }
            }

            @Override
            public void nameChanged() {
            }

            @Override
            public void codeStyleChanged() {
            }
        };
        this.myNamePanel.add(this.myPrefixNameSuffixPanel.getComponent());
        if (ejbType == EjbType.Entity && ((EntityBean)ejb).getAbstractSchemaName().getStringValue() != null) {
            String abstractSchemaName = (String)((EntityBean)ejb).getAbstractSchemaName().getValue();
            this.myAbstractSchemaName.setText(StringUtil.isEmpty((String)abstractSchemaName) ? ejbName : abstractSchemaName);
        } else {
            this.myASNLabel.setVisible(false);
            this.myAbstractSchemaName.setVisible(false);
        }
        this.setTitle(J2EEBundle.message((String)"dialog.title.rename.0", (Object[])new Object[]{ElementPresentationManager.getTypeNameForObject((Object)this.myEjb)}));
        this.init();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myPrefixNameSuffixPanel.getPreferredFocusedComponent();
    }

    public boolean isOKActionEnabled() {
        return PsiNameHelper.getInstance((Project)this.myEjb.getPsiManager().getProject()).isIdentifier(this.myPrefixNameSuffixPanel.getFullName()) && this.myPrefixNameSuffixPanel.isUnique();
    }

    protected void doAction() {
        this.close(0);
        String newName = this.myPrefixNameSuffixPanel.getFullName();
        if (newName == null) {
            return;
        }
        RenameProcessor processor = new RenameProcessor(this.getProject(), this.myEjb.getIdentifyingPsiElement(), newName, true, false);
        processor.setPreviewUsages(this.isPreviewUsages());
        if (!CommonModelRefactoringSupport.addPsiClasses((CommonModelElement)this.myEjb, (List)EjbCommonModelUtil.getEjbClasses((EnterpriseBean)this.myEjb, (boolean)true, (boolean)true, (boolean)true), (String)this.myPrefixNameSuffixPanel.getOldRawName(), (String)this.myPrefixNameSuffixPanel.getRawName(), (RenameProcessor)processor)) {
            return;
        }
        XmlTag tag = EjbRenameDialog.getAbstractSchemaNameTag(this.myEjb);
        if (tag != null) {
            processor.addElement((PsiElement)tag, this.myAbstractSchemaName.getText());
        }
        processor.run();
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    protected void doHelpAction() {
        if (this.myEjb instanceof EntityBean) {
            HelpManager.getInstance().invokeHelp("reference.javaee.rename.entity.bean");
        } else {
            super.doHelpAction();
        }
    }

    @Nullable
    public static XmlTag getAbstractSchemaNameTag(EnterpriseBean ejb) {
        if (!(ejb instanceof EntityBean)) {
            return null;
        }
        GenericValue value = ((EntityBean)ejb).getAbstractSchemaName();
        return ((DomElement)ModelMergerUtil.getImplementation((Object)value, DomElement.class)).getXmlTag();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        EditorTextField editorTextField;
        JLabel jLabel;
        JPanel jPanel2;
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myASNLabel = jLabel = new JLabel();
        jLabel.setHorizontalAlignment(10);
        jLabel.setAlignmentX(0.0f);
        jLabel.setText("Abstract Schema Name:");
        jLabel.setAlignmentY(0.5f);
        jPanel2.add((Component)jLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myAbstractSchemaName = editorTextField = new EditorTextField();
        jPanel2.add((Component)editorTextField, new GridConstraints(1, 1, 1, 1, 0, 1, 7, 3, new Dimension(100, -1), null, null));
        this.myNamePanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(0, 0, 1, 2, 0, 3, 3, 3, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

