/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.web.validation;

import com.intellij.compiler.CompilerConfigurationImpl;
import com.intellij.compiler.impl.CompilerUtil;
import com.intellij.compiler.impl.javaCompiler.javac.JavacConfiguration;
import com.intellij.compiler.impl.packagingCompiler.IgnoredFileFilter;
import com.intellij.execution.configurations.CommandLineBuilder;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.SimpleJavaParameters;
import com.intellij.javaee.model.enums.WebAppVersion;
import com.intellij.javaee.model.xml.web.WebApp;
import com.intellij.javaee.ui.packaging.ExplodedEarArtifactType;
import com.intellij.javaee.ui.packaging.LibrariesAndModulesCollector;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.javaee.web.validation.JasperValidatorItem;
import com.intellij.lang.jsp.JspVersion;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.impl.MockJdkWrapper;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ExportableOrderEntry;
import com.intellij.openapi.roots.LanguageLevelProjectExtension;
import com.intellij.openapi.roots.ModuleSourceOrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileFilters;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactManager;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.impl.artifacts.ArtifactUtil;
import com.intellij.packaging.impl.artifacts.PackagingElementPath;
import com.intellij.packaging.impl.artifacts.PackagingElementProcessor;
import com.intellij.packaging.impl.artifacts.ParentElementProcessor;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.rt.jasper2.Jasper2Runner;
import com.intellij.rt.jasper2.LineReader;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import com.intellij.util.PathsList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.download.DownloadableFileService;
import com.intellij.util.download.DownloadableFileSetDescription;
import com.intellij.util.download.DownloadableFileSetVersions;
import gnu.trove.THashSet;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JasperValidationForArtifactRunner {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.javaee.web.validation.JasperValidationForArtifactRunner");
    @NonNls
    private static final String DEBUG_JASPER_PROPERTY = "idea.jasper.validator.debug";
    @NonNls
    private static final String JASPER_TARGET_PACKAGE = "jsp";
    @NonNls
    private static final String[] LIBRARIES = new String[]{"xercesImpl.jar", "xml-apis.jar", "ant/lib/ant.jar", "log4j.jar"};
    private final Project myProject;
    private Artifact myArtifact;

    public JasperValidationForArtifactRunner(Project project, Artifact artifact) {
        this.myProject = project;
        this.myArtifact = artifact;
    }

    @Nullable
    public List<VirtualFile> validate(CompileContext context, List<JasperValidatorItem> items, File explodedDir) {
        ArrayList<File> files = new ArrayList<File>();
        for (JasperValidatorItem item : items) {
            files.add(new File(explodedDir, FileUtil.toSystemDependentName((String)item.getPathFromRoot())));
        }
        return this.doValidate(context, files, explodedDir);
    }

    private static File getJasperDownloadDir(JasperVersion version) {
        return new File(PathManager.getSystemPath(), "download-cache/jasper/" + version.myVersionString);
    }

    private static File[] getDownloadedJasperJars(JasperVersion version) {
        return (File[])ObjectUtils.notNull((Object)JasperValidationForArtifactRunner.getJasperDownloadDir(version).listFiles(FileFilters.filesWithExtension((String)"jar")), (Object)ArrayUtilRt.EMPTY_FILE_ARRAY);
    }

    @Nullable
    private JavaParameters computeJasperParameters(Collection<File> filesToValidate, File explodedDirFile, CompileContext context, List<String> jspFileNames) {
        String[] classpathUrls;
        String outputDirName = "jasper_" + PathUtil.suggestFileName((String)(this.myArtifact.getName() + "_" + this.myProject.getLocationHash()));
        outputDirName = outputDirName.replaceAll("\\s", "_");
        String outputDir = FileUtil.toSystemDependentName((String)(PathManager.getSystemPath() + "/jasper2output/" + outputDirName));
        Sdk jdk = ProjectRootManager.getInstance((Project)this.myProject).getProjectSdk();
        if (jdk == null) {
            context.addMessage(CompilerMessageCategory.ERROR, "Project JDK isn't specified", null, -1, -1);
            return null;
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            jdk = new MockJdkWrapper(CompilerConfigurationImpl.getTestsExternalCompilerHome(), jdk);
        }
        String webModuleCanonicalExplodedPath = FileUtil.toSystemDependentName((String)explodedDirFile.getPath());
        for (File file2 : filesToValidate) {
            String path = FileUtil.toSystemDependentName((String)file2.getPath());
            try {
                path = file2.getCanonicalPath();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            jspFileNames.add(path);
        }
        if (jspFileNames.size() == 0) {
            return null;
        }
        Set modules = ArtifactUtil.getModulesIncludedInArtifacts(Collections.singletonList(this.myArtifact), (Project)this.myProject);
        File outputDirFile = new File(outputDir);
        outputDirFile.mkdirs();
        JavaSdkVersion projectJdkVersion = JavaSdk.getInstance().getVersion(jdk);
        JasperVersion jasperVersion = JasperValidationForArtifactRunner.getJasperVersion(modules, projectJdkVersion);
        JavaParameters javaParameters = new JavaParameters();
        javaParameters.setJdk(jdk);
        ParametersList vmParameters = javaParameters.getVMParametersList();
        vmParameters.add("-Xmx" + JavacConfiguration.getOptions((Project)this.myProject, JavacConfiguration.class).MAXIMUM_HEAP_SIZE + "m");
        if (Boolean.parseBoolean(System.getProperty(DEBUG_JASPER_PROPERTY))) {
            vmParameters.add("-Xdebug");
            vmParameters.add("-Xnoagent");
            vmParameters.add("-Djava.compiler=NONE");
            vmParameters.add("-Xrunjdwp:transport=dt_socket,address=2222,suspend=y,server=y");
        }
        ArrayList prependClasspathJars = new ArrayList();
        ArrayList classpathJars = new ArrayList();
        if (jasperVersion == JasperVersion.V23) {
            if (!this.downloadJasperJars(context, jasperVersion)) {
                return null;
            }
            Object[] jars = JasperValidationForArtifactRunner.getDownloadedJasperJars(jasperVersion);
            Condition prependFilter = file -> file.getName().matches(".*-patch\\.jar");
            prependClasspathJars.addAll(ContainerUtil.filter((Object[])jars, (Condition)prependFilter));
            classpathJars.addAll(ContainerUtil.filter((Object[])jars, (Condition)Conditions.not((Condition)prependFilter)));
        }
        PathsList classPath = javaParameters.getClassPath();
        classPath.addAllFiles(prependClasspathJars);
        for (File[] path : LIBRARIES) {
            classPath.add(PathManager.findFileInLibDirectory((String)path).getAbsolutePath());
        }
        if (jasperVersion == JasperVersion.V21) {
            File classesRoot = new File(PathUtil.getJarPathForClass(JasperValidationForArtifactRunner.class));
            File jasperJar = classesRoot.isFile() ? PathManager.findFileInLibDirectory((String)"jasper21_rt.jar") : new File(classesRoot.getParentFile(), "jasper21");
            LOG.assertTrue(jasperJar.exists(), (Object)("Jasper JAR file not found: " + jasperJar.getAbsolutePath()));
            classPath.add(jasperJar.getAbsolutePath());
        }
        classPath.add(PathUtil.getJarPathForClass(Jasper2Runner.class));
        if (jasperVersion == JasperVersion.V20 || jasperVersion == JasperVersion.V21) {
            File[] jasper2Jars;
            File[] path;
            String[] libDirName = jasperVersion == JasperVersion.V21 ? "jasper2.1" : "jasper2";
            File jasper2LibPath = PathManager.findFileInLibDirectory((String)("rt/" + (String)libDirName));
            path = jasper2Jars = jasper2LibPath.listFiles((FileFilter)new IgnoredFileFilter());
            int n = path.length;
            for (int i = 0; i < n; ++i) {
                File jar = path[i];
                classPath.add(FileUtil.toSystemDependentName((String)jar.getPath()));
            }
        }
        classPath.addAllFiles(classpathJars);
        for (String url : jdk.getRootProvider().getUrls(OrderRootType.CLASSES)) {
            classPath.add(PathUtil.getLocalPath((String)VfsUtil.urlToPath((String)url)));
        }
        this.addDependenciesFromLibFolderOfParentEarArtifactToClasspath(classPath);
        Condition condition = orderEntry -> orderEntry instanceof ExportableOrderEntry && ((ExportableOrderEntry)orderEntry).getScope() == DependencyScope.PROVIDED || orderEntry instanceof ModuleSourceOrderEntry && !modules.contains(((ModuleSourceOrderEntry)orderEntry).getRootModel().getModule());
        for (String url : classpathUrls = ProjectRootManager.getInstance((Project)this.myProject).orderEntries((Collection)modules).withoutSdk().recursively().exportedOnly().satisfying(condition).classes().getUrls()) {
            classPath.add(PathUtil.getLocalPath((String)VfsUtil.urlToPath((String)url)));
        }
        javaParameters.setMainClass("com.intellij.rt.jasper2.Jasper2Runner");
        LanguageLevel languageLevel = LanguageLevelProjectExtension.getInstance((Project)this.myProject).getLanguageLevel();
        if (languageLevel == LanguageLevel.JDK_1_6) {
            languageLevel = LanguageLevel.JDK_1_5;
        }
        ParametersList programParameters = javaParameters.getProgramParametersList();
        programParameters.add("-source");
        programParameters.add(languageLevel.getCompilerComplianceDefaultOption());
        programParameters.add("-d");
        programParameters.add(CompilerUtil.quotePath((String)outputDir));
        programParameters.add("-mapped");
        programParameters.add("-compile");
        programParameters.add("-uriroot");
        programParameters.add(CompilerUtil.quotePath((String)webModuleCanonicalExplodedPath));
        programParameters.add("-p");
        programParameters.add(JASPER_TARGET_PACKAGE);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Validating " + jspFileNames.size() + " files using jasper " + jasperVersion.myVersionString);
            LOG.debug("Classpath:");
            for (String path : classPath.getPathList()) {
                LOG.debug(" " + path);
            }
            LOG.debug("Exploded path:" + webModuleCanonicalExplodedPath);
        }
        return javaParameters;
    }

    private boolean downloadJasperJars(CompileContext context, JasperVersion version) {
        File[] files = JasperValidationForArtifactRunner.getDownloadedJasperJars(version);
        if (files.length != 0) {
            return true;
        }
        DownloadableFileService service = DownloadableFileService.getInstance();
        DownloadableFileSetVersions versions = service.createFileSetVersions(null, new URL[]{this.getClass().getResource("/library/jasper.xml")});
        DownloadableFileSetDescription description = JasperValidationForArtifactRunner.findJasperJarsFileSet((DownloadableFileSetVersions<DownloadableFileSetDescription>)versions, version);
        if (description == null) {
            context.addMessage(CompilerMessageCategory.ERROR, "Cannot find Jasper validator for " + version.myVersionString, null, -1, -1);
            return false;
        }
        try {
            List pairs = service.createDownloader(description).download(JasperValidationForArtifactRunner.getJasperDownloadDir(version));
            if (pairs.isEmpty() || JasperValidationForArtifactRunner.getDownloadedJasperJars(version).length == 0) {
                context.addMessage(CompilerMessageCategory.ERROR, "Jasper validator JARs weren't downloaded", null, -1, -1);
                return false;
            }
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
            context.addMessage(CompilerMessageCategory.ERROR, "Failed to download Jasper validator JARs: " + e.getMessage(), null, -1, -1);
            return false;
        }
        return true;
    }

    private static DownloadableFileSetDescription findJasperJarsFileSet(DownloadableFileSetVersions<DownloadableFileSetDescription> versions, JasperVersion version) {
        List descriptions = versions.fetchVersions();
        for (DownloadableFileSetDescription description : descriptions) {
            if (!description.getVersionString().equals(version.myVersionString)) continue;
            return description;
        }
        return null;
    }

    @NotNull
    private static JasperVersion getJasperVersion(@NotNull Set<Module> modules, @NotNull JavaSdkVersion projectSdkVersion) {
        if (modules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modules", "com/intellij/javaee/web/validation/JasperValidationForArtifactRunner", "getJasperVersion"));
        }
        if (projectSdkVersion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectSdkVersion", "com/intellij/javaee/web/validation/JasperValidationForArtifactRunner", "getJasperVersion"));
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            JasperVersion jasperVersion = JasperVersion.V21;
            if (jasperVersion == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/web/validation/JasperValidationForArtifactRunner", "getJasperVersion"));
            }
            return jasperVersion;
        }
        JspVersion jspVersion = JasperValidationForArtifactRunner.getJspVersion(modules);
        if (jspVersion == JspVersion.JSP_2_0 || !projectSdkVersion.isAtLeast(JavaSdkVersion.JDK_1_5)) {
            JasperVersion jasperVersion = JasperVersion.V20;
            if (jasperVersion == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/web/validation/JasperValidationForArtifactRunner", "getJasperVersion"));
            }
            return jasperVersion;
        }
        if ((jspVersion.betterThan(JspVersion.JSP_2_1) || projectSdkVersion.isAtLeast(JavaSdkVersion.JDK_1_8)) && projectSdkVersion.isAtLeast(JavaSdkVersion.JDK_1_7)) {
            JasperVersion jasperVersion = JasperVersion.V23;
            if (jasperVersion == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/web/validation/JasperValidationForArtifactRunner", "getJasperVersion"));
            }
            return jasperVersion;
        }
        JasperVersion jasperVersion = JasperVersion.V21;
        if (jasperVersion == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/web/validation/JasperValidationForArtifactRunner", "getJasperVersion"));
        }
        return jasperVersion;
    }

    private void addDependenciesFromLibFolderOfParentEarArtifactToClasspath(final PathsList classPath) {
        final PackagingElementResolvingContext resolvingContext = ArtifactManager.getInstance((Project)this.myProject).getResolvingContext();
        ArtifactUtil.processParents((Artifact)this.myArtifact, (PackagingElementResolvingContext)resolvingContext, (ParentElementProcessor)new ParentElementProcessor(){

            public boolean process(@NotNull CompositePackagingElement<?> element, @NotNull List<Pair<Artifact, CompositePackagingElement<?>>> parents, @NotNull Artifact artifact) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/javaee/web/validation/JasperValidationForArtifactRunner$1", "process"));
                }
                if (parents == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parents", "com/intellij/javaee/web/validation/JasperValidationForArtifactRunner$1", "process"));
                }
                if (artifact == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifact", "com/intellij/javaee/web/validation/JasperValidationForArtifactRunner$1", "process"));
                }
                ArtifactType artifactType = artifact.getArtifactType();
                if (artifactType.equals((Object)ExplodedEarArtifactType.getInstance())) {
                    LibrariesAndModulesCollector collector = new LibrariesAndModulesCollector(resolvingContext, artifactType, true);
                    ArtifactUtil.processDirectoryChildren((CompositePackagingElement)artifact.getRootElement(), (PackagingElementPath)PackagingElementPath.EMPTY, (String)"lib", (PackagingElementResolvingContext)resolvingContext, (ArtifactType)artifactType, (PackagingElementProcessor)collector);
                    classPath.addVirtualFiles(collector.getIncludedLibraryFiles());
                    for (Library library : collector.getIncludedLibraries()) {
                        classPath.addVirtualFiles(library.getFiles(OrderRootType.CLASSES));
                    }
                    for (Pair pair : collector.getUsedModules()) {
                        CompilerModuleExtension compilerModuleExtension = CompilerModuleExtension.getInstance((Module)((Module)pair.getFirst()));
                        if (compilerModuleExtension == null) continue;
                        classPath.add(compilerModuleExtension.getCompilerOutputPath());
                    }
                }
                return true;
            }
        }, (int)2);
    }

    @NotNull
    private static JspVersion getJspVersion(Set<Module> modules) {
        JspVersion maxVersion = null;
        for (Module module : modules) {
            for (WebFacet webFacet : WebFacet.getInstances((Module)module)) {
                WebAppVersion version;
                WebApp root = webFacet.getRoot();
                if (root == null || (version = (WebAppVersion)root.getVersion().getValue()) == null) continue;
                JspVersion jspVersion = version.getJspVersion();
                if (maxVersion != null && !jspVersion.betterThan(maxVersion)) continue;
                maxVersion = jspVersion;
            }
        }
        JspVersion jspVersion = maxVersion != null ? maxVersion : JspVersion.MAX_VERSION;
        if (jspVersion == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/web/validation/JasperValidationForArtifactRunner", "getJspVersion"));
        }
        return jspVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Nullable
    public List<VirtualFile> doValidate(final CompileContext context, final Collection<File> filesToValidate, final File explodedDir) {
        MyCallback callback;
        block47: {
            final ArrayList jspFileNames = new ArrayList();
            PathsList projectClassPath = new PathsList();
            JavaParameters javaParameters = (JavaParameters)ApplicationManager.getApplication().runReadAction((Computable)new Computable<JavaParameters>(){

                @Nullable
                public JavaParameters compute() {
                    return JasperValidationForArtifactRunner.this.computeJasperParameters(filesToValidate, explodedDir, context, jspFileNames);
                }
            });
            if (javaParameters == null) {
                return null;
            }
            Future parsingThreadFuture = null;
            Future parsingErrorThreadFuture = null;
            callback = new MyCallback(context, 1.0 / (double)jspFileNames.size(), explodedDir);
            javaParameters.setPassParentEnvs(true);
            try {
                GeneralCommandLine commandLine = CommandLineBuilder.createFromJavaParameters((SimpleJavaParameters)javaParameters);
                Process process = commandLine.createProcess();
                try (OutputStream outputStream = process.getOutputStream();){
                    outputStream.write(projectClassPath.getPathsString().getBytes());
                    outputStream.write(10);
                    for (String jspFileName : jspFileNames) {
                        outputStream.write(jspFileName.getBytes());
                        outputStream.write(10);
                    }
                }
                parsingThreadFuture = ApplicationManager.getApplication().executeOnPooledThread((Runnable)new ParsingThread(process, callback, explodedDir));
                parsingErrorThreadFuture = ApplicationManager.getApplication().executeOnPooledThread((Runnable)new ParsingErrorThread(process));
                process.waitFor();
            }
            catch (IOException e) {
                LOG.info((Throwable)e);
                context.addMessage(CompilerMessageCategory.ERROR, e.getMessage(), null, -1, -1);
                List<VirtualFile> process = null;
                return process;
            }
            catch (InterruptedException e) {
                List<VirtualFile> process = null;
                return process;
            }
            catch (com.intellij.execution.ExecutionException e2) {
                LOG.error((Throwable)e2);
                break block47;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                if (parsingThreadFuture != null) {
                    try {
                        parsingThreadFuture.get();
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    catch (ExecutionException executionException) {}
                }
                if (parsingErrorThreadFuture != null) {
                    try {
                        parsingErrorThreadFuture.get();
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    catch (ExecutionException executionException) {}
                }
            }
        }
        List validatedUrls = callback.mySuccessfullyValidatedUrls;
        ArrayList<VirtualFile> files = new ArrayList<VirtualFile>(validatedUrls.size());
        ApplicationManager.getApplication().runReadAction(() -> {
            for (String url : validatedUrls) {
                VirtualFile file = VirtualFileManager.getInstance().findFileByUrl(url);
                if (file == null) continue;
                files.add(file);
            }
        });
        return files;
    }

    @Nullable
    private File translateExplodedFileToWebRootFile(@Nullable File file, File exploded) {
        PackagingElementResolvingContext context;
        String filePath;
        VirtualFile sourceFile;
        String relativePath;
        if (file == null) {
            return null;
        }
        if (FileUtil.isAncestor((File)exploded, (File)file, (boolean)false) && (relativePath = FileUtil.getRelativePath((File)exploded, (File)file)) != null && (sourceFile = ArtifactUtil.findSourceFileByOutputPath((Artifact)this.myArtifact, (String)(filePath = FileUtil.toSystemIndependentName((String)relativePath)), (PackagingElementResolvingContext)(context = ArtifactManager.getInstance((Project)this.myProject).getResolvingContext()))) != null) {
            return VfsUtilCore.virtualToIoFile((VirtualFile)sourceFile);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Source file not found for " + file + ", exploded root: " + exploded);
        }
        return file;
    }

    private class MyCallback {
        private final CompileContext myContext;
        private final File myExplodedDir;
        private final double myProgressDelta;
        private double myProgressFraction;
        private final List<String> mySuccessfullyValidatedUrls = new ArrayList<String>();
        private final Set<File> myProcessedFiles = new THashSet();

        private MyCallback(CompileContext context, double progressDelta, File explodedDir) {
            this.myContext = context;
            this.myExplodedDir = explodedDir;
            this.myContext.getProgressIndicator().setFraction(this.myProgressFraction);
            this.myProgressDelta = progressDelta;
        }

        public boolean isCanceled() {
            return this.myContext.getProgressIndicator().isCanceled() || JasperValidationForArtifactRunner.this.myProject.isDisposed();
        }

        public void beforeFileProcessing(File file) {
            this.myContext.getProgressIndicator().setText("Validating JSP files...");
            this.myContext.getProgressIndicator().setText2(file.getPath());
        }

        private void fileProcessed(File processedFile, String errorMessage, int errorLine, int errorColumn) {
            String url;
            File originalFile = JasperValidationForArtifactRunner.this.translateExplodedFileToWebRootFile(processedFile, this.myExplodedDir);
            String string = url = originalFile == null ? null : VirtualFileManager.constructUrl((String)LocalFileSystem.getInstance().getProtocol(), (String)FileUtil.toSystemIndependentName((String)originalFile.getPath()));
            if (errorMessage == null) {
                this.mySuccessfullyValidatedUrls.add(url);
            } else {
                this.myContext.addMessage(CompilerMessageCategory.ERROR, errorMessage, url, errorLine, errorColumn);
            }
            if (originalFile != null && this.myProcessedFiles.add(originalFile)) {
                this.myProgressFraction += this.myProgressDelta;
                this.myContext.getProgressIndicator().setFraction(this.myProgressFraction);
            }
        }
    }

    private static class ParsingThread
    implements Runnable {
        private final Process myProcess;
        private final MyCallback myCallback;
        private final File myExplodedDir;
        private File myLastProcessedFile;
        private final LineReader myLineReader;
        @NonNls
        protected static final String NULL_STRING = "null";

        private ParsingThread(Process process, MyCallback callback, File explodedDir) {
            this.myProcess = process;
            this.myCallback = callback;
            this.myExplodedDir = explodedDir;
            this.myLineReader = new LineReader(process.getInputStream());
        }

        private void processLine(String line) {
            ApplicationManager.getApplication().runReadAction(() -> {
                if (line.startsWith("VALIDATING")) {
                    File file = this.findFile(this.myLineReader.getNextLine());
                    if (file == null) {
                        return;
                    }
                    this.myLastProcessedFile = file;
                    this.myCallback.beforeFileProcessing(file);
                } else if (line.startsWith("VALIDATE-SUCCESS")) {
                    String filePath = this.myLineReader.getNextLine();
                    File file = this.findFile(filePath);
                    if (file == null) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug(filePath + " file not found");
                        }
                        return;
                    }
                    this.myCallback.fileProcessed(file, null, -1, -1);
                    this.myLastProcessedFile = null;
                } else if (line.startsWith("VALIDATE-ERROR")) {
                    File file = this.findFile(this.myLineReader.getNextLine());
                    int line1 = Integer.parseInt(this.myLineReader.getNextLine());
                    int column = Integer.parseInt(this.myLineReader.getNextLine());
                    String errorMessage = this.parseMessageRemainder();
                    if (file != null || errorMessage != null) {
                        this.myCallback.fileProcessed(file, errorMessage, line1, column);
                        this.myLastProcessedFile = null;
                    }
                }
            });
        }

        @Nullable
        private String parseMessageRemainder() {
            String errorLine;
            StringBuilder buffer = new StringBuilder();
            while ((errorLine = this.myLineReader.getNextLine()) != null && !errorLine.startsWith("END-MESSAGE")) {
                if (buffer.length() > 0) {
                    buffer.append("\n");
                }
                buffer.append(errorLine);
            }
            String msg = buffer.toString();
            msg = msg.equals(NULL_STRING) ? null : StringUtil.unescapeXml((String)msg);
            return msg;
        }

        @Nullable
        private File findFile(String path) {
            if (Comparing.strEqual((String)path, null)) {
                return this.myLastProcessedFile;
            }
            File file = new File(this.myExplodedDir, FileUtil.toSystemDependentName((String)path));
            if (file.exists()) {
                return file;
            }
            file = new File(path);
            if (file.exists()) {
                return file;
            }
            try {
                file = new File(new URL(path).getFile());
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            if (file.exists()) {
                return file;
            }
            return null;
        }

        @Override
        public void run() {
            while (true) {
                if (this.myCallback.isCanceled()) {
                    this.myProcess.destroy();
                    break;
                }
                String line = this.myLineReader.getNextLine();
                if (line == null) break;
                this.processLine(line);
            }
        }
    }

    private static class ParsingErrorThread
    implements Runnable {
        private final InputStream myInputStream;

        private ParsingErrorThread(Process process) {
            this.myInputStream = process.getErrorStream();
        }

        @Override
        public void run() {
            try {
                char[] chars = FileUtil.adaptiveLoadText((Reader)new InputStreamReader(this.myInputStream));
                LOG.debug(new String(chars));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static enum JasperVersion {
        V20("2.0"),
        V21("2.1"),
        V23("2.3");

        private final String myVersionString;

        private JasperVersion(String versionString) {
            this.myVersionString = versionString;
        }
    }
}

