/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.engine;

import com.intellij.credentialStore.Credentials;
import com.intellij.database.DataBus;
import com.intellij.database.access.DatabaseCredentials;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.model.RawConnectionConfig;
import com.intellij.database.run.ConsoleRunConfiguration;
import com.intellij.javaee.JavaeePersistenceDescriptorsConstants;
import com.intellij.javaee.model.common.persistence.mapping.Entity;
import com.intellij.javaee.model.xml.persistence.Persistence;
import com.intellij.javaee.model.xml.persistence.PersistenceUnit;
import com.intellij.javaee.model.xml.persistence.PersistenceUnitTransactionType;
import com.intellij.javaee.model.xml.persistence.Property;
import com.intellij.jpa.JpaImplementationProvider;
import com.intellij.jpa.engine.JpaConnectionManager;
import com.intellij.jpa.engine.JpaEngineBase;
import com.intellij.jpa.model.annotations.mapping.JamEntityMappings;
import com.intellij.jpa.model.manipulators.JpaUnitManipulator;
import com.intellij.jpa.remote.JpaFacade;
import com.intellij.jpa.remote.RemoteEntityManager;
import com.intellij.jpa.remote.RemoteEntityManagerFactory;
import com.intellij.jpa.remote.RemoteQuery;
import com.intellij.jpa.util.JpaUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.persistence.PersistenceHelper;
import com.intellij.persistence.facet.PersistenceFacet;
import com.intellij.persistence.model.PersistenceMappings;
import com.intellij.persistence.model.PersistencePackage;
import com.intellij.persistence.model.PersistencePackagePointer;
import com.intellij.persistence.model.manipulators.PersistenceUnitManipulator;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.GenericValue;
import com.intellij.util.xml.ModelMergerUtil;
import gnu.trove.THashSet;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JpaEngine
extends JpaEngineBase {
    private File myTemporaryJpaConfig;
    private JpaFacade myFacade;
    private RemoteEntityManager myEntityManager;

    public static boolean isAvailable(Module module) {
        return JpaEngine.isClassAvailable(module, "javax.persistence.EntityManager");
    }

    public JpaEngine(DataBus.Producing messageBus, PersistencePackagePointer unitFile, ConsoleRunConfiguration configuration) {
        super(messageBus, unitFile, configuration);
    }

    @Override
    protected void releaseConnection() {
        this.myFacade = null;
        JpaConnectionManager.getInstance(this.getProject()).releaseConnection(this.myUnitFile, this.myConfiguration);
        this.removeTemporaryFiles();
    }

    private void ensureInitialized() throws Exception {
        try {
            if (!this.myEntityManager.isOpen()) {
                throw new IllegalStateException();
            }
        }
        catch (Exception e) {
            this.myFacade = JpaConnectionManager.getInstance(this.getProject()).getConnection(this.myUnitFile, this.myConfiguration);
            this.removeTemporaryFiles();
            this.createTemporaryConfig(this.myFacade.getPersistenceRoot());
            RemoteEntityManagerFactory entityManagerFactory = this.myFacade.createEntityManagerFactory(this.myUnitFile.getElementName());
            this.myEntityManager = entityManagerFactory.createEntityManager();
        }
    }

    @Override
    protected RemoteQuery createQuery(String query) throws Exception {
        this.ensureInitialized();
        return this.myEntityManager.createQuery(query);
    }

    @Override
    protected String getGenerateSqlInner(String hqlQuery) throws Exception {
        this.ensureInitialized();
        return this.myEntityManager.generateSql(hqlQuery);
    }

    @Override
    protected String getGeneratedDdlInner() throws Exception {
        this.ensureInitialized();
        return this.myEntityManager.generateSchemaScript();
    }

    private void removeTemporaryFiles() {
        if (this.myTemporaryJpaConfig != null) {
            File generatedDataDirectory = JpaEngine.getTempDirectory(this.getProject());
            for (File tmp = this.myTemporaryJpaConfig; tmp != null && !FileUtil.filesEqual((File)tmp, (File)generatedDataDirectory); tmp = tmp.getParentFile()) {
                File[] files;
                File[] fileArray = files = tmp.isFile() ? null : tmp.listFiles();
                if (files != null && files.length > 0 || !tmp.delete()) break;
            }
            this.myTemporaryJpaConfig = null;
        }
    }

    private void createTemporaryConfig(String unitRoot) {
        LocalDataSource dataSource = JpaEngine.findDataSource(this.getProject(), this.myUnitFile);
        Credentials credentials = dataSource == null ? null : DatabaseCredentials.getInstance().getCredentials((DatabaseSystem)dataSource);
        this.myTemporaryJpaConfig = (File)DumbService.getInstance((Project)this.getProject()).runReadActionInSmartMode(() -> {
            PersistencePackage unit = this.myUnitFile.findElement();
            PersistenceFacet facet = this.myUnitFile.getPersistenceFacet();
            if (unit == null || facet == null || facet.getModule().isDisposed()) {
                return null;
            }
            return this.createTemporaryJpaConfig(new JpaEngineBase.GenerationInfo(this.getProject(), facet, unit, dataSource, credentials), unitRoot);
        });
    }

    private static String createPersistenceXmlText(@NotNull JpaEngineBase.GenerationInfo info) {
        PersistenceUnitManipulator manipulator;
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/jpa/engine/JpaEngine", "createPersistenceXmlText"));
        }
        Project project = info.project;
        String versionString = JpaEngine.getVersion(info);
        Pair<String, Set<String>> template = JpaEngine.loadJpaTemplate(versionString);
        XmlFile xmlFile = (XmlFile)PsiFileFactory.getInstance((Project)project).createFileFromText(JavaeePersistenceDescriptorsConstants.PERSISTENCE_XML_META_DATA.getFileName(), (FileType)StdFileTypes.XML, (CharSequence)template.first);
        DomFileElement fileElement = DomManager.getDomManager((Project)project).getFileElement(xmlFile, Persistence.class);
        assert (fileElement != null);
        if (StringUtil.isNotEmpty((String)versionString)) {
            ((Persistence)fileElement.getRootElement()).getVersion().setStringValue(versionString);
        }
        PersistenceUnit pu = ((Persistence)fileElement.getRootElement()).addPersistenceUnit();
        pu.getName().setStringValue((String)info.unit.getName().getValue());
        pu.getExcludeUnlistedClasses().setStringValue(info.unit.getModelHelper().getExcludeUnlistedClasses().getStringValue());
        PersistenceFacet facet = info.facet;
        JpaImplementationProvider provider = JpaUtil.findJpaProvider(facet, info.unit, true);
        if (provider != null) {
            pu.getProvider().setStringValue(provider.getProviderClassName(facet != null ? facet.getModule() : null));
        }
        pu.getTransactionType().setValue((Object)PersistenceUnitTransactionType.RESOURCE_LOCAL);
        for (GenericValue value : info.unit.getModelHelper().getJarFiles()) {
            pu.addJarFile().setStringValue(value.getStringValue());
        }
        for (GenericValue value : info.unit.getModelHelper().getMappingFiles(PersistenceMappings.class)) {
            pu.addMappingFile().setStringValue(value.getStringValue());
        }
        for (String name : JpaEngine.getMappedClasses(info.unit.getModelHelper().getClasses(), info.unit, facet)) {
            pu.addClass().setStringValue(name);
        }
        for (GenericValue value : info.unit.getModelHelper().getClasses()) {
            pu.addClass().setStringValue(value.getStringValue());
        }
        Set filteredProperties = (Set)template.second;
        if (info.dataSource != null && (manipulator = (PersistenceUnitManipulator)PersistenceHelper.getHelper().getManipulatorsRegistry().getManipulator((Object)pu, PersistenceUnitManipulator.class)) != null) {
            if (manipulator instanceof JpaUnitManipulator) {
                ((JpaUnitManipulator)manipulator).setConnectionProperties(provider, project, (RawConnectionConfig)info.dataSource, info.credentials);
            } else {
                manipulator.setConnectionProperties(project, (RawConnectionConfig)info.dataSource, info.credentials);
            }
            for (Property property : pu.getProperties().getProperties()) {
                filteredProperties.add(property.getName().getStringValue());
            }
        }
        Properties properties = info.unit.getModelHelper().getPersistenceUnitProperties();
        for (Object key : properties.keySet()) {
            String name = (String)key;
            if (filteredProperties.contains(name)) continue;
            Property property = pu.getProperties().addProperty();
            property.getName().setValue((Object)name);
            property.getValue().setStringValue(properties.getProperty(name));
        }
        return xmlFile.getText();
    }

    private File createTemporaryJpaConfig(@NotNull JpaEngineBase.GenerationInfo info, @NotNull String unitRoot) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/jpa/engine/JpaEngine", "createTemporaryJpaConfig"));
        }
        if (unitRoot == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unitRoot", "com/intellij/jpa/engine/JpaEngine", "createTemporaryJpaConfig"));
        }
        String fileName = JavaeePersistenceDescriptorsConstants.PERSISTENCE_XML_META_DATA.getFileName();
        String text = JpaEngine.createPersistenceXmlText(info);
        File metaInf = new File(unitRoot, "META-INF");
        File file = new File(metaInf, fileName);
        this.writeTemporaryConfigText(file, text, info);
        return file;
    }

    public static Set<String> getMappedClasses(List<? extends GenericValue<PsiClass>> classes, PersistencePackage unit, PersistenceFacet facet) {
        JamEntityMappings jamMappings;
        THashSet classNames = new THashSet();
        for (GenericValue<PsiClass> genericValue : classes) {
            ContainerUtil.addIfNotNull((Collection)classNames, (Object)genericValue.getStringValue());
        }
        if (classes.isEmpty() && (jamMappings = (JamEntityMappings)ModelMergerUtil.getImplementation((Object)facet.getEntityMappings(unit), JamEntityMappings.class)) != null) {
            for (Entity entity : jamMappings.getEntities()) {
                ContainerUtil.addIfNotNull((Collection)classNames, (Object)entity.getClazz().getStringValue());
            }
        }
        return classNames;
    }

    @NotNull
    public static Pair<String, Set<String>> loadJpaTemplate(@Nullable String versionString) {
        String template;
        String name = "console-persistence" + (StringUtil.isNotEmpty((String)versionString) ? versionString : "") + ".xml";
        try {
            InputStream stream = JpaEngine.class.getResourceAsStream(name);
            template = stream != null ? FileUtil.loadTextAndClose((InputStream)stream) : JpaEngine.getDefaultTemplate();
        }
        catch (IOException e) {
            template = JpaEngine.getDefaultTemplate();
        }
        Matcher matcher = Pattern.compile("<!-- ignore: (.*) -->").matcher(template);
        THashSet strings = new THashSet();
        while (matcher.find()) {
            strings.add(matcher.group(1).trim());
        }
        Pair pair = Pair.create((Object)template, (Object)strings);
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/engine/JpaEngine", "loadJpaTemplate"));
        }
        return pair;
    }

    @NotNull
    private static String getDefaultTemplate() {
        if ("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<persistence xmlns=\"http://xmlns.jcp.org/xml/ns/persistence\"/>" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/engine/JpaEngine", "getDefaultTemplate"));
        }
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<persistence xmlns=\"http://xmlns.jcp.org/xml/ns/persistence\"/>";
    }

    @Nullable
    public static String getVersion(@NotNull JpaEngineBase.GenerationInfo info) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/jpa/engine/JpaEngine", "getVersion"));
        }
        DomElement parent = info.unit instanceof PersistenceUnit ? ((PersistenceUnit)info.unit).getParent() : null;
        return parent instanceof Persistence ? ((Persistence)parent).getVersion().getStringValue() : "2.0";
    }
}

