/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dsm.ui;

import com.intellij.dsm.model.DsmTreeStructure;
import com.intellij.dsm.ui.AbstractNodeVisitor;
import com.intellij.dsm.ui.DsmTableConstants;
import com.intellij.dsm.ui.DsmTableImpl;
import com.intellij.dsm.ui.DsmTableUtil;
import com.intellij.openapi.util.Couple;
import java.awt.Graphics2D;
import java.awt.Rectangle;

class PaintCyclesVisitor<N>
extends AbstractNodeVisitor<N> {
    private final Graphics2D g;
    private final DsmTableImpl<N> myDsmTable;

    public PaintCyclesVisitor(DsmTableImpl<N> dsmTable, Graphics2D g) {
        this.myDsmTable = dsmTable;
        this.g = g;
    }

    @Override
    public void visitExpanded(DsmTreeStructure.TreeNode<N> node, int x, int y, int height, boolean isLast) {
        super.visitExpanded(node, x, y, height, isLast);
        boolean small = this.myDsmTable.myCache.isSmall;
        Couple<Integer>[] cycles = node.getCycles();
        if (cycles.length > 0) {
            DsmTreeStructure.TreeNode<N>[] children = node.getChildren();
            Rectangle clipBounds = this.g.getClipBounds();
            for (Couple<Integer> cycle : cycles) {
                DsmTreeStructure.TreeNode<N> n1 = children[(Integer)cycle.first];
                DsmTreeStructure.TreeNode<N> n2 = children[(Integer)cycle.second];
                Rectangle r1 = this.myDsmTable.myCache.rowHeaderBounds.get(n1);
                Rectangle r2 = this.myDsmTable.myCache.rowHeaderBounds.get(n2);
                int y1 = r1.y;
                int y2 = r2.y + r2.height + 1;
                Rectangle r = new Rectangle(y1, y1, y2 - y1, y2 - y1);
                if (!clipBounds.intersects(r)) continue;
                this.g.setPaint(DsmTableConstants.COLOR_CYCLE);
                if (!small) {
                    DsmTableUtil.drawBoldRectangle(this.g, r);
                    continue;
                }
                DsmTableUtil.drawRectangle(this.g, r);
            }
        }
    }
}

