/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.weblogic.appServerIntegration;

import com.intellij.jam.model.common.CommonModelElement;
import com.intellij.jam.model.common.CommonModelManager;
import com.intellij.javaee.ejb.EjbModuleUtil;
import com.intellij.javaee.ejb.facet.EjbFacet;
import com.intellij.javaee.facet.JavaeeFacet;
import com.intellij.javaee.model.common.JavaeeModelElement;
import com.intellij.javaee.model.xml.ejb.EjbBase;
import com.intellij.javaee.module.view.ejb.editor.EjbAsVirtualFile;
import com.intellij.javaee.ui.MockJavaeeDomElementsEditor;
import com.intellij.javaee.weblogic.WeblogicBundle;
import com.intellij.javaee.weblogic.beaInstallation.WeblogicUtil;
import com.intellij.javaee.weblogic.editors.EjbWebLogicEditor;
import com.intellij.javaee.weblogic.model.WeblogicEnterpriseBean;
import com.intellij.javaee.weblogic.model.persistence.WeblogicRdbmsBean;
import com.intellij.javaee.weblogic.module.WeblogicEjbFacetUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.descriptors.ConfigFile;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.ui.CaptionComponent;
import com.intellij.util.xml.ui.CommittablePanel;
import com.intellij.util.xml.ui.DomFileEditor;
import com.intellij.util.xml.ui.DomUIFactory;
import com.intellij.util.xml.ui.EditedElementDescription;
import com.intellij.util.xml.ui.PerspectiveFileEditor;
import com.intellij.util.xml.ui.PerspectiveFileEditorProvider;
import org.jetbrains.annotations.NotNull;

public class WeblogicEjbEditorProvider
extends PerspectiveFileEditorProvider {
    public boolean accept(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javaee/weblogic/appServerIntegration/WeblogicEjbEditorProvider", "accept"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/javaee/weblogic/appServerIntegration/WeblogicEjbEditorProvider", "accept"));
        }
        if (!(file instanceof EjbAsVirtualFile)) {
            return false;
        }
        EjbBase ejb = (EjbBase)CommonModelManager.getInstance().getDomElement((CommonModelElement)((EjbAsVirtualFile)file).findElement(project));
        if (ejb == null) {
            return false;
        }
        EjbFacet ejbFacet = EjbModuleUtil.getEjbFacet((JavaeeModelElement)ejb);
        return ejbFacet != null && WeblogicEjbFacetUtil.getEjbRoot(ejbFacet) != null && WeblogicEjbFacetUtil.getRdbmsRoot(ejbFacet) != null;
    }

    @NotNull
    public PerspectiveFileEditor createEditor(final @NotNull Project project, final @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javaee/weblogic/appServerIntegration/WeblogicEjbEditorProvider", "createEditor"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/javaee/weblogic/appServerIntegration/WeblogicEjbEditorProvider", "createEditor"));
        }
        EjbBase ejb = (EjbBase)DomManager.getDomManager((Project)project).createStableValue((Factory)new Factory<EjbBase>(){

            public EjbBase create() {
                return (EjbBase)CommonModelManager.getInstance().getDomElement((CommonModelElement)((EjbAsVirtualFile)file).findElement(project));
            }
        });
        EjbFacet ejbFacet = EjbModuleUtil.getEjbFacet((JavaeeModelElement)ejb);
        DomFileEditor domFileEditor = new WeblogicEjbEditor(ejb, ejbFacet).getFileEditor();
        if (domFileEditor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/weblogic/appServerIntegration/WeblogicEjbEditorProvider", "createEditor"));
        }
        return domFileEditor;
    }

    public double getWeight() {
        return 239.0;
    }

    private static class WeblogicEjbEditor
    extends MockJavaeeDomElementsEditor {
        private final EjbBase myEjb;

        public WeblogicEjbEditor(EjbBase ejb, final EjbFacet ejbFacet) {
            super((JavaeeFacet)ejbFacet);
            this.myEjb = ejb;
            WeblogicEnterpriseBean weblogicEnterpriseBean = (WeblogicEnterpriseBean)this.addEditedElement(WeblogicEnterpriseBean.class, (EditedElementDescription)new EditedElementDescription<WeblogicEnterpriseBean>(){

                public XmlFile getEditedFile() {
                    ConfigFile descriptor = WeblogicEjbFacetUtil.getEjbJarDeploymentDescriptor(ejbFacet);
                    return descriptor != null ? descriptor.getXmlFile() : null;
                }

                public WeblogicEnterpriseBean find() {
                    return WeblogicUtil.findEnterpriseBean(WeblogicEjbFacetUtil.getEjbRoot(ejbFacet), this.getEjbName());
                }

                public void initialize(WeblogicEnterpriseBean element) {
                    element.getEjbName().setStringValue(this.getEjbName());
                }

                public WeblogicEnterpriseBean addElement() {
                    return WeblogicEjbFacetUtil.getEjbRoot(ejbFacet).addWeblogicEnterpriseBean();
                }
            });
            WeblogicRdbmsBean weblogicRdbmsBean = (WeblogicRdbmsBean)this.addEditedElement(WeblogicRdbmsBean.class, (EditedElementDescription)new EditedElementDescription<WeblogicRdbmsBean>(){

                public XmlFile getEditedFile() {
                    ConfigFile rdbmsDescriptor = WeblogicEjbFacetUtil.getCmpRdbmsDescriptor(ejbFacet);
                    return rdbmsDescriptor != null ? rdbmsDescriptor.getXmlFile() : null;
                }

                public WeblogicRdbmsBean find() {
                    return WeblogicUtil.findRdbmsBean(WeblogicEjbFacetUtil.getRdbmsRoot(ejbFacet), this.getEjbName());
                }

                public void initialize(WeblogicRdbmsBean element) {
                    element.getEjbName().setStringValue(this.getEjbName());
                }

                public WeblogicRdbmsBean addElement() {
                    return WeblogicEjbFacetUtil.getRdbmsRoot(ejbFacet).addWeblogicRdbmsBean();
                }
            });
            String name = WeblogicBundle.message("weblogic.integration.presentable.name", new Object[0]);
            DomFileEditor editor = this.initFileEditor(this.myEjb.getManager().getProject(), DomUtil.getFile((DomElement)this.myEjb).getVirtualFile(), name, () -> {
                EjbWebLogicEditor webLogicEditor = new EjbWebLogicEditor(this.myEjb, weblogicEnterpriseBean, weblogicRdbmsBean);
                CaptionComponent captionComponent = DomUIFactory.getDomUIFactory().addErrorPanel(new CaptionComponent(name), new DomElement[]{weblogicEnterpriseBean, weblogicRdbmsBean});
                return DomFileEditor.createComponentWithCaption((CommittablePanel)webLogicEditor, (CaptionComponent)captionComponent, (DomElement)ejb);
            });
            editor.addWatchedElement((DomElement)WeblogicEjbFacetUtil.getEjbRoot(ejbFacet));
            editor.addWatchedElement((DomElement)WeblogicEjbFacetUtil.getRdbmsRoot(ejbFacet));
        }

        private String getEjbName() {
            return (String)this.myEjb.getEjbName().getValue();
        }
    }
}

