/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.clientBundle.jam;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.gwt.clientBundle.jam.SourceFileJamConverter;
import com.intellij.jam.JamConverter;
import com.intellij.jam.JamElement;
import com.intellij.jam.JamService;
import com.intellij.jam.JamStringAttributeElement;
import com.intellij.jam.annotations.JamPsiConnector;
import com.intellij.jam.reflect.JamAnnotationMeta;
import com.intellij.jam.reflect.JamAttributeMeta;
import com.intellij.jam.reflect.JamMethodMeta;
import com.intellij.jam.reflect.JamStringAttributeMeta;
import com.intellij.javaee.model.annotations.AnnotationGenericValue;
import com.intellij.javaee.model.annotations.AnnotationModelUtil;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.util.SmartList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ClientBundleMethodJamElement
implements JamElement {
    private static final Set<String> DEFAULT_EXTENSIONS_ANNOTATION_SET = Collections.singleton("com.google.gwt.resources.ext.DefaultExtensions");
    private static final JamStringAttributeMeta.Collection<PsiFile> SOURCE_PATH_META = JamAttributeMeta.collectionString((String)"value", (JamConverter)new SourceFileJamConverter((Condition<PsiFileSystemItem>)Conditions.alwaysTrue()));
    private static final JamAnnotationMeta SOURCE_META = new JamAnnotationMeta("com.google.gwt.resources.client.ClientBundle.Source").addAttribute(SOURCE_PATH_META);
    public static final JamMethodMeta<ClientBundleMethodJamElement> META = new JamMethodMeta(ClientBundleMethodJamElement.class).addAnnotation(SOURCE_META);

    @JamPsiConnector
    @NotNull
    public abstract PsiMethod getPsiMethod();

    @NotNull
    public List<PsiFile> getSourceFiles(boolean addLocalized) {
        PsiModifierList modifierList;
        PsiClass resourceType;
        PsiType type;
        SmartList result = new SmartList();
        PsiMethod method = this.getPsiMethod();
        List sourceAnnotation = (List)SOURCE_META.getAttribute((PsiModifierListOwner)method, SOURCE_PATH_META);
        for (JamStringAttributeElement element : sourceAnnotation) {
            PsiFile mainFile = (PsiFile)element.getValue();
            if (mainFile == null) continue;
            result.add(mainFile);
            if (!addLocalized) continue;
            ClientBundleMethodJamElement.addLocalizedFiles(mainFile, (List<PsiFile>)result);
        }
        if (sourceAnnotation.isEmpty() && (type = method.getReturnType()) instanceof PsiClassType && (resourceType = ((PsiClassType)type).resolve()) != null && (modifierList = resourceType.getModifierList()) != null) {
            PsiAnnotation annotation = AnnotationUtil.findAnnotationInHierarchy((PsiModifierListOwner)resourceType, DEFAULT_EXTENSIONS_ANNOTATION_SET);
            PsiDirectory directory = method.getContainingFile().getContainingDirectory();
            if (annotation != null && directory != null) {
                for (AnnotationGenericValue value : AnnotationModelUtil.getStringArrayValue((PsiAnnotation)annotation, (String)"value")) {
                    PsiFile file;
                    String extension = (String)value.getValue();
                    if (extension == null || (file = directory.findFile(method.getName() + extension)) == null) continue;
                    result.add(file);
                    if (!addLocalized) break;
                    ClientBundleMethodJamElement.addLocalizedFiles(file, (List<PsiFile>)result);
                    break;
                }
            }
        }
        SmartList smartList = result;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/clientBundle/jam/ClientBundleMethodJamElement", "getSourceFiles"));
        }
        return smartList;
    }

    private static void addLocalizedFiles(@NotNull PsiFile mainFile, @NotNull List<PsiFile> result) {
        if (mainFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mainFile", "com/intellij/gwt/clientBundle/jam/ClientBundleMethodJamElement", "addLocalizedFiles"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/gwt/clientBundle/jam/ClientBundleMethodJamElement", "addLocalizedFiles"));
        }
        PsiDirectory parent = mainFile.getParent();
        if (parent == null) {
            return;
        }
        String baseName = FileUtil.getNameWithoutExtension((String)mainFile.getName()) + "_";
        String extension = FileUtilRt.getExtension((String)mainFile.getName());
        for (PsiFile file : parent.getFiles()) {
            String name = file.getName();
            if (!name.startsWith(baseName) || !FileUtilRt.extensionEquals((String)name, (String)extension)) continue;
            result.add(file);
        }
    }

    @Nullable
    public static ClientBundleMethodJamElement getElement(PsiMethod method) {
        AccessToken token = ReadAction.start();
        try {
            ClientBundleMethodJamElement clientBundleMethodJamElement = (ClientBundleMethodJamElement)JamService.getJamService((Project)method.getProject()).getJamElement(META.getJamKey(), (PsiElement)method);
            return clientBundleMethodJamElement;
        }
        finally {
            token.finish();
        }
    }
}

