/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.rpc;

import com.intellij.gwt.rpc.GwtSearcherBase;
import com.intellij.gwt.rpc.RemoteServiceUtil;
import com.intellij.openapi.util.Couple;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.searches.AllOverridingMethodsSearch;
import com.intellij.util.Processor;

public class GwtAllOverridingServiceMethodsSearcher
extends GwtSearcherBase<Couple<PsiMethod>, AllOverridingMethodsSearch.SearchParameters> {
    @Override
    protected PsiFile getContainingFile(AllOverridingMethodsSearch.SearchParameters parameters) {
        return parameters.getPsiClass().getContainingFile();
    }

    @Override
    public boolean doExecute(AllOverridingMethodsSearch.SearchParameters queryParameters, Processor<Couple<PsiMethod>> consumer) {
        PsiClass async = queryParameters.getPsiClass();
        PsiClass sync = RemoteServiceUtil.findSynchronousInterface(async);
        if (sync != null) {
            for (PsiMethod method : async.getMethods()) {
                PsiMethod syncMethod = RemoteServiceUtil.findMethodInSync(method, sync);
                if (syncMethod == null || consumer.process((Object)Couple.of((Object)method, (Object)syncMethod))) continue;
                return false;
            }
        }
        return true;
    }
}

