/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.run.remoteUi.responses;

import com.intellij.gwt.run.remoteUi.UnknownRemoteUiResponse;
import com.intellij.gwt.run.remoteUi.responses.AddLogBranchResponse;
import com.intellij.gwt.run.remoteUi.responses.AddLogEntryResponse;
import com.intellij.gwt.run.remoteUi.responses.AddMainLogResponse;
import com.intellij.gwt.run.remoteUi.responses.AddModuleLogResponse;
import com.intellij.gwt.run.remoteUi.responses.AddWebServerLogResponse;
import com.intellij.gwt.run.remoteUi.responses.CapabilityExchangeResponse;
import com.intellij.gwt.run.remoteUi.responses.DisconnectLogResponse;
import com.intellij.gwt.run.remoteUi.responses.FailureResponse;
import com.intellij.gwt.run.remoteUi.responses.InitializeResponse;
import com.intellij.gwt.run.remoteUi.responses.RemoteUiResponse;
import com.intellij.gwt.shell.remoteUi.generated.RemoteMessageProto;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.io.socketConnection.ResponseReader;
import java.io.IOException;
import java.io.InputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoteUiResponseReader
implements ResponseReader<RemoteUiResponse> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.gwt.run.remoteUi.responses.RemoteUiResponseReader");
    private final InputStream myInput;

    public RemoteUiResponseReader(InputStream input) {
        this.myInput = input;
    }

    public RemoteUiResponse readResponse() throws IOException, InterruptedException {
        RemoteMessageProto.Message message = RemoteMessageProto.Message.parseDelimitedFrom(this.myInput);
        if (message == null) {
            LOG.debug("Null message received, stopping");
            return null;
        }
        RemoteUiResponse response = RemoteUiResponseReader.fromMessage(message);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Received: " + response);
        }
        return response != null ? response : new UnknownRemoteUiResponse(message.getMessageId());
    }

    private static RemoteUiResponse fromMessage(@NotNull RemoteMessageProto.Message message) throws InterruptedException {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/gwt/run/remoteUi/responses/RemoteUiResponseReader", "fromMessage"));
        }
        switch (message.getMessageType()) {
            case REQUEST: {
                return RemoteUiResponseReader.fromRequest(message.getRequest(), message.getMessageId());
            }
            case RESPONSE: {
                return null;
            }
            case FAILURE: {
                RemoteMessageProto.Message.Failure failure = message.getFailure();
                return new FailureResponse(message.getMessageId(), failure.getMessage(), failure.getStackTrace());
            }
        }
        return null;
    }

    @Nullable
    private static RemoteUiResponse fromRequest(RemoteMessageProto.Message.Request request, int messageId) {
        if (request.getServiceType() == RemoteMessageProto.Message.Request.ServiceType.DEV_MODE) {
            LOG.info("Dev mode requests aren't processed");
            return null;
        }
        RemoteMessageProto.Message.Request.ViewerRequest viewerRequest = request.getViewerRequest();
        switch (viewerRequest.getRequestType()) {
            case CAPABILITY_EXCHANGE: {
                return new CapabilityExchangeResponse(messageId);
            }
            case ADD_LOG: {
                return RemoteUiResponseReader.fromAddLog(viewerRequest.getAddLog(), messageId);
            }
            case ADD_LOG_BRANCH: {
                return new AddLogBranchResponse(messageId, viewerRequest.getAddLogBranch());
            }
            case ADD_LOG_ENTRY: {
                return new AddLogEntryResponse(messageId, viewerRequest.getAddLogEntry());
            }
            case DISCONNECT_LOG: {
                return new DisconnectLogResponse(messageId, viewerRequest.getDisconnectLog().getLogHandle());
            }
            case INITIALIZE: {
                return new InitializeResponse(messageId, viewerRequest.getInitialize().getStartupURLsList());
            }
        }
        return null;
    }

    private static RemoteUiResponse fromAddLog(RemoteMessageProto.Message.Request.ViewerRequest.AddLog addLog, int messageId) {
        switch (addLog.getType()) {
            case MAIN: {
                return new AddMainLogResponse(messageId);
            }
            case MODULE: {
                return new AddModuleLogResponse(messageId, addLog.getModuleLog());
            }
            case WEB_SERVER: {
                return new AddWebServerLogResponse(messageId);
            }
        }
        return null;
    }
}

