/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.patterns;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.patterns.PsiNamePatternCondition;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class PsiNameValuePairPattern
extends PsiElementPattern<PsiNameValuePair, PsiNameValuePairPattern> {
    static final PsiNameValuePairPattern NAME_VALUE_PAIR_PATTERN = new PsiNameValuePairPattern();

    private PsiNameValuePairPattern() {
        super(PsiNameValuePair.class);
    }

    @Override
    public PsiNameValuePairPattern withName(final @NotNull @NonNls String requiredName) {
        if (requiredName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requiredName", "com/intellij/patterns/PsiNameValuePairPattern", "withName"));
        }
        return (PsiNameValuePairPattern)this.with(new PatternCondition<PsiNameValuePair>("withName"){

            @Override
            public boolean accepts(@NotNull PsiNameValuePair psiNameValuePair, ProcessingContext context) {
                if (psiNameValuePair == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiNameValuePair", "com/intellij/patterns/PsiNameValuePairPattern$1", "accepts"));
                }
                String actualName = psiNameValuePair.getName();
                return requiredName.equals(actualName) || actualName == null && "value".equals(requiredName);
            }
        });
    }

    @Override
    public PsiNameValuePairPattern withName(@NotNull ElementPattern<String> name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/patterns/PsiNameValuePairPattern", "withName"));
        }
        return (PsiNameValuePairPattern)this.with(new PsiNamePatternCondition<PsiNameValuePair>("withName", name){

            @Override
            public String getPropertyValue(@NotNull Object o) {
                if (o == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/patterns/PsiNameValuePairPattern$2", "getPropertyValue"));
                }
                if (o instanceof PsiNameValuePair) {
                    String nameValue = ((PsiNameValuePair)o).getName();
                    return StringUtil.notNullize((String)nameValue, (String)"value");
                }
                return null;
            }
        });
    }
}

