/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import javax.swing.JFormattedTextField;
import javax.swing.JSpinner;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public class PortField
extends JSpinner {
    public PortField() {
        this(0);
    }

    public PortField(int value) {
        this(value, 0);
    }

    public void setMin(int value) {
        ((SpinnerNumberModel)this.getModel()).setMinimum(Integer.valueOf(value));
    }

    public PortField(int value, int min) {
        this.setModel(new SpinnerNumberModel(value, min, 65535, 1));
        JSpinner.NumberEditor editor = new JSpinner.NumberEditor((JSpinner)this, "#");
        this.setEditor(editor);
        MyListener listener = new MyListener();
        this.addMouseWheelListener(listener);
        JFormattedTextField field = editor.getTextField();
        field.addFocusListener(listener);
        field.addMouseListener(listener);
    }

    public void setEditable(boolean value) {
        ((JSpinner.NumberEditor)this.getEditor()).getTextField().setEditable(value);
    }

    public void setNumber(int value) {
        this.setValue(value);
    }

    public int getNumber() {
        return ((SpinnerNumberModel)this.getModel()).getNumber().intValue();
    }

    public boolean isSpecified() {
        return this.getNumber() != 0;
    }

    private static class MyListener
    extends MouseAdapter
    implements FocusListener {
        private boolean select = true;

        private MyListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.select = false;
        }

        @Override
        public void focusGained(FocusEvent e) {
            if (!this.select) {
                this.select = true;
                return;
            }
            SwingUtilities.invokeLater(() -> {
                Object source = e.getSource();
                if (source instanceof JFormattedTextField) {
                    JFormattedTextField textField = (JFormattedTextField)source;
                    textField.selectAll();
                }
            });
        }

        @Override
        public void focusLost(FocusEvent e) {
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            Comparable<?> maximum;
            Comparable<?> minimum;
            Number stepSize;
            SpinnerNumberModel numberModel;
            Number value;
            Number newValue;
            JSpinner spinner;
            SpinnerModel model;
            int units = e.getUnitsToScroll();
            if (units == 0) {
                return;
            }
            Object source = e.getSource();
            if (source instanceof JSpinner && (model = (spinner = (JSpinner)source).getModel()) instanceof SpinnerNumberModel && (newValue = MyListener.calculateNewValue(value = (Number)(numberModel = (SpinnerNumberModel)model).getValue(), stepSize = numberModel.getStepSize(), minimum = numberModel.getMinimum(), maximum = numberModel.getMaximum(), units)) != null) {
                numberModel.setValue(newValue);
            }
        }

        private static Number calculateNewValue(@NotNull Number value, @NotNull Number stepSize, Comparable minimum, Comparable maximum, int steps) {
            Number newValue;
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/ui/PortField$MyListener", "calculateNewValue"));
            }
            if (stepSize == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stepSize", "com/intellij/ui/PortField$MyListener", "calculateNewValue"));
            }
            if (value instanceof Float || value instanceof Double) {
                double v = value.doubleValue() + stepSize.doubleValue() * (double)steps;
                newValue = value instanceof Double ? new Double(v) : (double)new Float(v).floatValue();
            } else {
                long v = value.longValue() + stepSize.longValue() * (long)steps;
                newValue = value instanceof Long ? (Number)v : (Number)(value instanceof Integer ? (Number)((int)v) : (Number)(value instanceof Short ? (Number)((short)v) : (Number)((byte)v)));
            }
            if (maximum != null && maximum.compareTo(newValue) < 0 || minimum != null && minimum.compareTo(newValue) > 0) {
                return null;
            }
            return newValue;
        }
    }
}

