/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.velocity.psi.formatter;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.formatting.templateLanguages.DataLanguageBlockWrapper;
import com.intellij.formatting.templateLanguages.TemplateLanguageBlock;
import com.intellij.formatting.templateLanguages.TemplateLanguageBlockFactory;
import com.intellij.formatting.templateLanguages.TemplateLanguageFormattingModelBuilder;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.formatter.common.AbstractBlock;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.velocity.editorActions.VtlCommenter;
import com.intellij.velocity.psi.formatter.VtlBlock;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VtlFormattingModelBuilder
extends TemplateLanguageFormattingModelBuilder {
    public TemplateLanguageBlock createTemplateLanguageBlock(@NotNull ASTNode node, @Nullable Wrap wrap, @Nullable Alignment alignment, @Nullable List<DataLanguageBlockWrapper> foreignChildren, @NotNull CodeStyleSettings codeStyleSettings) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/velocity/psi/formatter/VtlFormattingModelBuilder", "createTemplateLanguageBlock"));
        }
        if (codeStyleSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codeStyleSettings", "com/intellij/velocity/psi/formatter/VtlFormattingModelBuilder", "createTemplateLanguageBlock"));
        }
        PsiElement psi = node.getPsi();
        if (psi instanceof PsiComment && new VtlCommenter().isDocumentationComment((PsiComment)psi)) {
            return new VtlDocCommentBlock(codeStyleSettings, node, foreignChildren, this);
        }
        return new VtlBlock((TemplateLanguageBlockFactory)this, codeStyleSettings, node, foreignChildren, wrap);
    }

    private static class VtlDocCommentBlock
    extends VtlBlock {
        private final ASTNode myNode;

        public VtlDocCommentBlock(CodeStyleSettings codeStyleSettings, ASTNode node, List<DataLanguageBlockWrapper> foreignChildren, VtlFormattingModelBuilder factory) {
            super((TemplateLanguageBlockFactory)factory, codeStyleSettings, node, foreignChildren, null);
            this.myNode = node;
        }

        protected List<Block> buildChildren() {
            ArrayList<Block> blocks = new ArrayList<Block>();
            int lineStart = 0;
            String text = this.myNode.getText();
            while (true) {
                int end;
                int nextEol;
                String line = text.substring(lineStart, (nextEol = text.indexOf(10, lineStart)) < 0 ? text.length() : nextEol);
                int start = CharArrayUtil.shiftForward((CharSequence)text, (int)lineStart, (String)" \t");
                if (start < (end = CharArrayUtil.shiftBackward((CharSequence)text, (int)(lineStart + line.length() - 1), (String)" \t") + 1)) {
                    blocks.add((Block)new VtlDocLineBlock(this.myNode, start, end));
                }
                if (nextEol < 0) break;
                lineStart = nextEol + 1;
            }
            return blocks;
        }

        public Spacing getSpacing(@Nullable Block child1, @NotNull Block child2) {
            if (child2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child2", "com/intellij/velocity/psi/formatter/VtlFormattingModelBuilder$VtlDocCommentBlock", "getSpacing"));
            }
            return child1 == null ? null : Spacing.createSpacing((int)0, (int)0, (int)1, (boolean)true, (int)10);
        }

        public boolean isLeaf() {
            return false;
        }
    }

    private static class VtlDocLineBlock
    extends AbstractBlock {
        private final ASTNode myNode;
        private final int myStart;
        private final int myEnd;
        private final int myCommentStart;

        public VtlDocLineBlock(ASTNode node, int start, int end) {
            super(node, null, null);
            this.myNode = node;
            this.myStart = start;
            this.myEnd = end;
            this.myCommentStart = this.myNode.getTextRange().getStartOffset();
        }

        boolean isFirstDocLine() {
            return this.myStart == 0;
        }

        @NotNull
        public TextRange getTextRange() {
            TextRange textRange = new TextRange(this.myStart, this.myEnd).shiftRight(this.myCommentStart);
            if (textRange == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/velocity/psi/formatter/VtlFormattingModelBuilder$VtlDocLineBlock", "getTextRange"));
            }
            return textRange;
        }

        protected List<Block> buildChildren() {
            return Collections.emptyList();
        }

        public Spacing getSpacing(Block child1, @NotNull Block child2) {
            if (child2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child2", "com/intellij/velocity/psi/formatter/VtlFormattingModelBuilder$VtlDocLineBlock", "getSpacing"));
            }
            return null;
        }

        public Indent getIndent() {
            return this.isFirstDocLine() ? null : Indent.getSpaceIndent((int)1);
        }

        public boolean isLeaf() {
            return true;
        }
    }
}

