/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.renderer;

import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.ImageObserver;
import java.io.IOException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.logging.Level;
import org.lobobrowser.html.HttpRequest;
import org.lobobrowser.html.ReadyStateChangeListener;
import org.lobobrowser.html.UserAgentContext;
import org.lobobrowser.html.dombl.ModelNode;
import org.lobobrowser.html.domimpl.HTMLDocumentImpl;
import org.lobobrowser.html.domimpl.HTMLElementImpl;
import org.lobobrowser.html.renderer.BaseBoundableRenderable;
import org.lobobrowser.html.renderer.BaseRCollection;
import org.lobobrowser.html.renderer.DelayedPair;
import org.lobobrowser.html.renderer.RBlockViewport;
import org.lobobrowser.html.renderer.RCollection;
import org.lobobrowser.html.renderer.RElement;
import org.lobobrowser.html.renderer.RenderableContainer;
import org.lobobrowser.html.renderstate.RenderState;
import org.lobobrowser.html.style.AbstractCSS2Properties;
import org.lobobrowser.html.style.BackgroundInfo;
import org.lobobrowser.html.style.BorderInfo;
import org.lobobrowser.html.style.HtmlInsets;
import org.lobobrowser.html.style.HtmlValues;
import org.lobobrowser.util.Strings;
import org.lobobrowser.util.gui.GUITasks;

public abstract class BaseElementRenderable
extends BaseRCollection
implements RElement,
RenderableContainer,
ImageObserver {
    protected static final Integer INVALID_SIZE = new Integer(Integer.MIN_VALUE);
    private Collection<Component> guiComponents = null;
    protected Collection<DelayedPair> delayedPairs = null;
    protected Color backgroundColor;
    protected volatile Image backgroundImage;
    protected int zIndex;
    protected Color borderTopColor;
    protected Color borderLeftColor;
    protected Color borderBottomColor;
    protected Color borderRightColor;
    protected Insets borderInsets;
    protected Insets marginInsets;
    protected Insets paddingInsets;
    protected BorderInfo borderInfo;
    protected URL lastBackgroundImageUri;
    protected Insets defaultMarginInsets = null;
    protected Insets defaultPaddingInsets = null;
    protected int overflowX;
    protected int overflowY;
    protected final UserAgentContext userAgentContext;
    protected boolean layoutDeepCanBeInvalidated = false;
    private Integer declaredWidth = INVALID_SIZE;
    private Integer declaredHeight = INVALID_SIZE;
    private int lastAvailWidthForDeclared = -1;
    private int lastAvailHeightForDeclared = -1;
    protected static final int SCROLL_BAR_THICKNESS = 16;

    public BaseElementRenderable(RenderableContainer container, ModelNode modelNode, UserAgentContext ucontext) {
        super(container, modelNode);
        this.userAgentContext = ucontext;
    }

    public void setDefaultPaddingInsets(Insets insets) {
        this.defaultPaddingInsets = insets;
    }

    public void setDefaultMarginInsets(Insets insets) {
        this.defaultMarginInsets = insets;
    }

    public float getAlignmentX() {
        return 0.0f;
    }

    public float getAlignmentY() {
        return 0.0f;
    }

    @Override
    public final void invalidateLayoutDeep() {
        if (this.layoutDeepCanBeInvalidated) {
            this.layoutDeepCanBeInvalidated = false;
            this.invalidateLayoutLocal();
            Iterator i = this.getRenderables();
            if (i != null) {
                while (i.hasNext()) {
                    Object r = i.next();
                    if (!(r instanceof RCollection)) continue;
                    ((RCollection)r).invalidateLayoutDeep();
                }
            }
        }
    }

    @Override
    protected void invalidateLayoutLocal() {
        RenderState rs = this.modelNode.getRenderState();
        if (rs != null) {
            rs.invalidate();
        }
        this.overflowX = 0;
        this.overflowY = 0;
        this.declaredWidth = INVALID_SIZE;
        this.declaredHeight = INVALID_SIZE;
        this.lastAvailHeightForDeclared = -1;
        this.lastAvailWidthForDeclared = -1;
    }

    protected Integer getDeclaredWidth(RenderState renderState, int actualAvailWidth) {
        Integer dw = this.declaredWidth;
        if (dw == INVALID_SIZE || actualAvailWidth != this.lastAvailWidthForDeclared) {
            this.lastAvailWidthForDeclared = actualAvailWidth;
            int dwInt = this.getDeclaredWidthImpl(renderState, actualAvailWidth);
            this.declaredWidth = dw = dwInt == -1 ? null : new Integer(dwInt);
        }
        return dw;
    }

    public final boolean hasDeclaredWidth() {
        Integer dw = this.declaredWidth;
        if (dw == INVALID_SIZE) {
            ModelNode rootNode = this.modelNode;
            if (rootNode instanceof HTMLElementImpl) {
                HTMLElementImpl element = (HTMLElementImpl)rootNode;
                AbstractCSS2Properties props = element.getCurrentStyle();
                if (props == null) {
                    return false;
                }
                return !Strings.isBlank(props.getWidth());
            }
            return false;
        }
        return dw != null;
    }

    private final int getDeclaredWidthImpl(RenderState renderState, int availWidth) {
        ModelNode rootNode = this.modelNode;
        if (rootNode instanceof HTMLElementImpl) {
            HTMLElementImpl element = (HTMLElementImpl)rootNode;
            AbstractCSS2Properties props = element.getCurrentStyle();
            if (props == null) {
                return -1;
            }
            String widthText = props.getWidth();
            if (widthText == null || "".equals(widthText)) {
                return -1;
            }
            return HtmlValues.getPixelSize(widthText, renderState, -1, availWidth);
        }
        return -1;
    }

    protected Integer getDeclaredHeight(RenderState renderState, int actualAvailHeight) {
        Integer dh = this.declaredHeight;
        if (dh == INVALID_SIZE || actualAvailHeight != this.lastAvailHeightForDeclared) {
            this.lastAvailHeightForDeclared = actualAvailHeight;
            int dhInt = this.getDeclaredHeightImpl(renderState, actualAvailHeight);
            this.declaredHeight = dh = dhInt == -1 ? null : new Integer(dhInt);
        }
        return dh;
    }

    protected int getDeclaredHeightImpl(RenderState renderState, int availHeight) {
        ModelNode rootNode = this.modelNode;
        if (rootNode instanceof HTMLElementImpl) {
            HTMLElementImpl element = (HTMLElementImpl)rootNode;
            AbstractCSS2Properties props = element.getCurrentStyle();
            if (props == null) {
                return -1;
            }
            String heightText = props.getHeight();
            if (heightText == null || "".equals(heightText)) {
                return -1;
            }
            return HtmlValues.getPixelSize(heightText, renderState, -1, availHeight);
        }
        return -1;
    }

    @Override
    public void paint(Graphics g) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void layout(int availWidth, int availHeight, boolean sizeOnly) {
        try {
            this.doLayout(availWidth, availHeight, sizeOnly);
        }
        finally {
            this.layoutUpTreeCanBeInvalidated = true;
            this.layoutDeepCanBeInvalidated = true;
        }
    }

    protected abstract void doLayout(int var1, int var2, boolean var3);

    protected final void sendGUIComponentsToParent() {
        Collection<Component> gc = this.guiComponents;
        if (gc != null) {
            RenderableContainer rc = this.container;
            Iterator<Component> i = gc.iterator();
            while (i.hasNext()) {
                rc.addComponent(i.next());
            }
        }
    }

    protected final void clearGUIComponents() {
        Collection<Component> gc = this.guiComponents;
        if (gc != null) {
            gc.clear();
        }
    }

    @Override
    public Component addComponent(Component component) {
        Collection<Component> gc = this.guiComponents;
        if (gc == null) {
            this.guiComponents = gc = new HashSet<Component>(1);
        }
        gc.add(component);
        return component;
    }

    @Override
    public void updateAllWidgetBounds() {
        this.container.updateAllWidgetBounds();
    }

    public void updateWidgetBounds() {
        Point guiPoint = this.getGUIPoint(0, 0);
        this.updateWidgetBounds(guiPoint.x, guiPoint.y);
    }

    @Override
    public Rectangle getBoundsRelativeToBlock() {
        RCollection parent = this;
        int x = 0;
        int y = 0;
        while (parent != null) {
            x += parent.getX();
            y += parent.getY();
            if (!((parent = parent.getParent()) instanceof RElement)) continue;
        }
        return new Rectangle(x, y, this.getWidth(), this.getHeight());
    }

    protected void clearStyle(boolean isRootBlock) {
        this.borderInfo = null;
        this.borderInsets = null;
        this.borderTopColor = null;
        this.borderLeftColor = null;
        this.borderBottomColor = null;
        this.borderRightColor = null;
        this.zIndex = 0;
        this.backgroundColor = null;
        this.backgroundImage = null;
        this.lastBackgroundImageUri = null;
        this.overflowX = 4;
        this.overflowY = 4;
        if (isRootBlock) {
            Insets finalInsets;
            Insets insets1 = this.defaultMarginInsets;
            Insets insets2 = this.defaultPaddingInsets;
            Insets insets = finalInsets = insets1 == null ? null : new Insets(insets1.top, insets1.left, insets1.bottom, insets1.right);
            if (insets2 != null) {
                if (finalInsets == null) {
                    finalInsets = new Insets(insets2.top, insets2.left, insets2.bottom, insets2.right);
                } else {
                    finalInsets.top += insets2.top;
                    finalInsets.bottom += insets2.bottom;
                    finalInsets.left += insets2.left;
                    finalInsets.right += insets2.right;
                }
            }
            this.marginInsets = null;
            this.paddingInsets = finalInsets;
        } else {
            this.marginInsets = this.defaultMarginInsets;
            this.paddingInsets = this.defaultPaddingInsets;
        }
    }

    protected void applyStyle(int availWidth, int availHeight) {
        URL backgroundImageUri;
        HTMLElementImpl rootElement;
        boolean isRootBlock;
        ModelNode rootNode = this.modelNode;
        if (rootNode instanceof HTMLDocumentImpl) {
            isRootBlock = true;
            HTMLDocumentImpl doc = (HTMLDocumentImpl)rootNode;
            rootElement = (HTMLElementImpl)doc.getBody();
        } else {
            isRootBlock = false;
            rootElement = (HTMLElementImpl)rootNode;
        }
        if (rootElement == null) {
            this.clearStyle(isRootBlock);
            return;
        }
        RenderState rs = rootElement.getRenderState();
        if (rs == null) {
            throw new IllegalStateException("Element without render state: " + rootElement + "; parent=" + rootElement.getParentNode());
        }
        BackgroundInfo binfo = rs.getBackgroundInfo();
        this.backgroundColor = binfo == null ? null : binfo.backgroundColor;
        URL uRL = backgroundImageUri = binfo == null ? null : binfo.backgroundImage;
        if (backgroundImageUri == null) {
            this.backgroundImage = null;
            this.lastBackgroundImageUri = null;
        } else if (!backgroundImageUri.equals(this.lastBackgroundImageUri)) {
            this.lastBackgroundImageUri = backgroundImageUri;
            this.loadBackgroundImage(backgroundImageUri);
        }
        AbstractCSS2Properties props = rootElement.getCurrentStyle();
        if (props == null) {
            this.clearStyle(isRootBlock);
        } else {
            Insets tentativeMarginInsets;
            Insets paddingInsets;
            Insets borderInsets;
            BorderInfo borderInfo;
            this.borderInfo = borderInfo = rs.getBorderInfo();
            HtmlInsets binsets = borderInfo == null ? null : borderInfo.getInsets();
            HtmlInsets minsets = rs.getMarginInsets();
            HtmlInsets pinsets = rs.getPaddingInsets();
            Insets defaultMarginInsets = this.defaultMarginInsets;
            int dmleft = 0;
            int dmright = 0;
            int dmtop = 0;
            int dmbottom = 0;
            if (defaultMarginInsets != null) {
                dmleft = defaultMarginInsets.left;
                dmright = defaultMarginInsets.right;
                dmtop = defaultMarginInsets.top;
                dmbottom = defaultMarginInsets.bottom;
            }
            Insets defaultPaddingInsets = this.defaultPaddingInsets;
            int dpleft = 0;
            int dpright = 0;
            int dptop = 0;
            int dpbottom = 0;
            if (defaultPaddingInsets != null) {
                dpleft = defaultPaddingInsets.left;
                dpright = defaultPaddingInsets.right;
                dptop = defaultPaddingInsets.top;
                dpbottom = defaultPaddingInsets.bottom;
            }
            Insets insets = borderInsets = binsets == null ? null : binsets.getAWTInsets(0, 0, 0, 0, availWidth, availHeight, 0, 0);
            if (borderInsets == null) {
                borderInsets = RBlockViewport.ZERO_INSETS;
            }
            Insets insets2 = paddingInsets = pinsets == null ? defaultPaddingInsets : pinsets.getAWTInsets(dptop, dpleft, dpbottom, dpright, availWidth, availHeight, 0, 0);
            if (paddingInsets == null) {
                paddingInsets = RBlockViewport.ZERO_INSETS;
            }
            Insets insets3 = tentativeMarginInsets = minsets == null ? defaultMarginInsets : minsets.getAWTInsets(dmtop, dmleft, dmbottom, dmright, availWidth, availHeight, 0, 0);
            if (tentativeMarginInsets == null) {
                tentativeMarginInsets = RBlockViewport.ZERO_INSETS;
            }
            int actualAvailWidth = availWidth - paddingInsets.left - paddingInsets.right - borderInsets.left - borderInsets.right - tentativeMarginInsets.left - tentativeMarginInsets.right;
            int actualAvailHeight = availHeight - paddingInsets.top - paddingInsets.bottom - borderInsets.top - borderInsets.bottom - tentativeMarginInsets.top - tentativeMarginInsets.bottom;
            Integer declaredWidth = this.getDeclaredWidth(rs, actualAvailWidth);
            Integer declaredHeight = this.getDeclaredHeight(rs, actualAvailHeight);
            int autoMarginX = 0;
            int autoMarginY = 0;
            if (declaredWidth != null) {
                autoMarginX = (availWidth - declaredWidth - (borderInsets == null ? 0 : borderInsets.left - borderInsets.right) - (paddingInsets == null ? 0 : paddingInsets.left - paddingInsets.right)) / 2;
            }
            if (declaredHeight != null) {
                autoMarginY = (availHeight - declaredHeight - (borderInsets == null ? 0 : borderInsets.top - borderInsets.bottom) - (paddingInsets == null ? 0 : paddingInsets.top - paddingInsets.bottom)) / 2;
            }
            this.borderInsets = borderInsets;
            if (isRootBlock) {
                Insets regularMarginInsets;
                Insets insets4 = autoMarginX == 0 && autoMarginY == 0 ? tentativeMarginInsets : (regularMarginInsets = minsets == null ? defaultMarginInsets : minsets.getAWTInsets(dmtop, dmleft, dmbottom, dmright, availWidth, availHeight, autoMarginX, autoMarginY));
                if (regularMarginInsets == null) {
                    regularMarginInsets = RBlockViewport.ZERO_INSETS;
                }
                this.marginInsets = null;
                this.paddingInsets = new Insets(paddingInsets.top + regularMarginInsets.top, paddingInsets.left + regularMarginInsets.left, paddingInsets.bottom + regularMarginInsets.bottom, paddingInsets.right + regularMarginInsets.right);
            } else {
                this.paddingInsets = paddingInsets;
                Insets insets5 = autoMarginX == 0 && autoMarginY == 0 ? tentativeMarginInsets : (this.marginInsets = minsets == null ? defaultMarginInsets : minsets.getAWTInsets(dmtop, dmleft, dmbottom, dmright, availWidth, availHeight, autoMarginX, autoMarginY));
            }
            if (borderInfo != null) {
                this.borderTopColor = borderInfo.getTopColor();
                this.borderLeftColor = borderInfo.getLeftColor();
                this.borderBottomColor = borderInfo.getBottomColor();
                this.borderRightColor = borderInfo.getRightColor();
            } else {
                this.borderTopColor = null;
                this.borderLeftColor = null;
                this.borderBottomColor = null;
                this.borderRightColor = null;
            }
            String zIndex = props.getZIndex();
            if (zIndex != null) {
                try {
                    this.zIndex = Integer.parseInt(zIndex);
                }
                catch (NumberFormatException err) {
                    logger.log(Level.WARNING, "Unable to parse z-index [" + zIndex + "] in element " + this.modelNode + ".", err);
                    this.zIndex = 0;
                }
            } else {
                this.zIndex = 0;
            }
            this.overflowX = rs.getOverflowX();
            this.overflowY = rs.getOverflowY();
        }
    }

    protected void loadBackgroundImage(final URL imageURL) {
        UserAgentContext ctx = this.userAgentContext;
        if (ctx != null) {
            final HttpRequest request = ctx.createHttpRequest();
            request.addReadyStateChangeListener(new ReadyStateChangeListener(){

                @Override
                public void readyStateChanged() {
                    int status;
                    int readyState = request.getReadyState();
                    if (readyState == 4 && ((status = request.getStatus()) == 200 || status == 0)) {
                        Image img;
                        BaseElementRenderable.this.backgroundImage = img = request.getResponseImage();
                        int w = img.getWidth(BaseElementRenderable.this);
                        int h = img.getHeight(BaseElementRenderable.this);
                        if (w != -1 && h != -1) {
                            BaseElementRenderable.this.repaint();
                        }
                    }
                }
            });
            SecurityManager sm = System.getSecurityManager();
            if (sm == null) {
                try {
                    request.open("GET", imageURL);
                    request.send(null);
                }
                catch (IOException thrown) {
                    logger.log(Level.WARNING, "loadBackgroundImage()", thrown);
                }
            } else {
                AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        try {
                            request.open("GET", imageURL);
                            request.send(null);
                        }
                        catch (IOException thrown) {
                            BaseBoundableRenderable.logger.log(Level.WARNING, "loadBackgroundImage()", thrown);
                        }
                        return null;
                    }
                });
            }
        }
    }

    @Override
    public int getZIndex() {
        return this.zIndex;
    }

    private Color getBorderTopColor() {
        Color c = this.borderTopColor;
        return c == null ? Color.black : c;
    }

    private Color getBorderLeftColor() {
        Color c = this.borderLeftColor;
        return c == null ? Color.black : c;
    }

    private Color getBorderBottomColor() {
        Color c = this.borderBottomColor;
        return c == null ? Color.black : c;
    }

    private Color getBorderRightColor() {
        Color c = this.borderRightColor;
        return c == null ? Color.black : c;
    }

    protected int getWidthElement() {
        return this.width;
    }

    protected int getHeightElement() {
        return this.height;
    }

    protected int getStartX() {
        return 0;
    }

    protected int getStartY() {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void prePaint(Graphics g) {
        Insets borderInsets;
        int startWidth = this.getWidthElement();
        int startHeight = this.getHeightElement();
        int totalWidth = startWidth;
        int totalHeight = startHeight;
        int startX = this.getStartX();
        int startY = this.getStartY();
        ModelNode node = this.modelNode;
        RenderState rs = node.getRenderState();
        Insets marginInsets = this.marginInsets;
        if (marginInsets != null) {
            totalWidth -= marginInsets.left + marginInsets.right;
            totalHeight -= marginInsets.top + marginInsets.bottom;
            startX += marginInsets.left;
            startY += marginInsets.top;
        }
        if ((borderInsets = this.borderInsets) != null) {
            int bleft = borderInsets.left;
            int newStartX = startX + bleft;
            int btop = borderInsets.top;
            int newStartY = startY + btop;
            int bright = borderInsets.right;
            int newTotalWidth = totalWidth - (bleft + bright);
            int bbottom = borderInsets.bottom;
            int newTotalHeight = totalHeight - (btop + bbottom);
            Rectangle clientRegion = new Rectangle(newStartX, newStartY, newTotalWidth, newTotalHeight);
            Rectangle clipBounds = g.getClipBounds();
            if (!clientRegion.contains(clipBounds)) {
                int i;
                int i2;
                int borderStyle;
                BorderInfo borderInfo = this.borderInfo;
                if (btop > 0) {
                    g.setColor(this.getBorderTopColor());
                    borderStyle = borderInfo == null ? 4 : borderInfo.getTopStyle();
                    for (i2 = 0; i2 < btop; ++i2) {
                        int leftOffset = i2 * bleft / btop;
                        int rightOffset = i2 * bright / btop;
                        if (borderStyle == 3) {
                            GUITasks.drawDashed(g, startX + leftOffset, startY + i2, startX + totalWidth - rightOffset - 1, startY + i2, 10 + btop, 6);
                            continue;
                        }
                        g.drawLine(startX + leftOffset, startY + i2, startX + totalWidth - rightOffset - 1, startY + i2);
                    }
                }
                if (bright > 0) {
                    borderStyle = borderInfo == null ? 4 : borderInfo.getRightStyle();
                    g.setColor(this.getBorderRightColor());
                    int lastX = startX + totalWidth - 1;
                    for (i = 0; i < bright; ++i) {
                        int topOffset = i * btop / bright;
                        int bottomOffset = i * bbottom / bright;
                        if (borderStyle == 3) {
                            GUITasks.drawDashed(g, lastX - i, startY + topOffset, lastX - i, startY + totalHeight - bottomOffset - 1, 10 + bright, 6);
                            continue;
                        }
                        g.drawLine(lastX - i, startY + topOffset, lastX - i, startY + totalHeight - bottomOffset - 1);
                    }
                }
                if (bbottom > 0) {
                    borderStyle = borderInfo == null ? 4 : borderInfo.getBottomStyle();
                    g.setColor(this.getBorderBottomColor());
                    int lastY = startY + totalHeight - 1;
                    for (i = 0; i < bbottom; ++i) {
                        int leftOffset = i * bleft / bbottom;
                        int rightOffset = i * bright / bbottom;
                        if (borderStyle == 3) {
                            GUITasks.drawDashed(g, startX + leftOffset, lastY - i, startX + totalWidth - rightOffset - 1, lastY - i, 10 + bbottom, 6);
                            continue;
                        }
                        g.drawLine(startX + leftOffset, lastY - i, startX + totalWidth - rightOffset - 1, lastY - i);
                    }
                }
                if (bleft > 0) {
                    borderStyle = borderInfo == null ? 4 : borderInfo.getLeftStyle();
                    g.setColor(this.getBorderLeftColor());
                    for (i2 = 0; i2 < bleft; ++i2) {
                        int topOffset = i2 * btop / bleft;
                        int bottomOffset = i2 * bbottom / bleft;
                        if (borderStyle == 3) {
                            GUITasks.drawDashed(g, startX + i2, startY + topOffset, startX + i2, startY + totalHeight - bottomOffset - 1, 10 + bleft, 6);
                            continue;
                        }
                        g.drawLine(startX + i2, startY + topOffset, startX + i2, startY + totalHeight - bottomOffset - 1);
                    }
                }
            }
            totalWidth = newTotalWidth;
            totalHeight = newTotalHeight;
            startX = newStartX;
            startY = newStartY;
        }
        Graphics clientG = g.create(startX, startY, totalWidth, totalHeight);
        try {
            Rectangle bkgBounds = null;
            if (node == null) return;
            Color bkg = this.backgroundColor;
            if (bkg != null && bkg.getAlpha() > 0) {
                clientG.setColor(bkg);
                bkgBounds = clientG.getClipBounds();
                clientG.fillRect(bkgBounds.x, bkgBounds.y, bkgBounds.width, bkgBounds.height);
            }
            BackgroundInfo binfo = rs == null ? null : rs.getBackgroundInfo();
            Image image = this.backgroundImage;
            if (image == null) return;
            if (bkgBounds == null) {
                bkgBounds = clientG.getClipBounds();
            }
            int w = image.getWidth(this);
            int h = image.getHeight(this);
            if (w == -1 || h == -1) return;
            switch (binfo == null ? 0 : binfo.backgroundRepeat) {
                case 1: {
                    int imageX = binfo.backgroundXPositionAbsolute ? binfo.backgroundXPosition : binfo.backgroundXPosition * (totalWidth - w) / 100;
                    int imageY = binfo.backgroundYPositionAbsolute ? binfo.backgroundYPosition : binfo.backgroundYPosition * (totalHeight - h) / 100;
                    clientG.drawImage(image, imageX, imageY, w, h, this);
                    return;
                }
                case 2: {
                    int imageY = binfo.backgroundYPositionAbsolute ? binfo.backgroundYPosition : binfo.backgroundYPosition * (totalHeight - h) / 100;
                    int topX = bkgBounds.x + bkgBounds.width;
                    for (int x = bkgBounds.x / w * w; x < topX; x += w) {
                        clientG.drawImage(image, x, imageY, w, h, this);
                    }
                    return;
                }
                case 3: {
                    int imageX = binfo.backgroundXPositionAbsolute ? binfo.backgroundXPosition : binfo.backgroundXPosition * (totalWidth - w) / 100;
                    int topY = bkgBounds.y + bkgBounds.height;
                    for (int y = bkgBounds.y / h * h; y < topY; y += h) {
                        clientG.drawImage(image, imageX, y, w, h, this);
                    }
                    return;
                }
                default: {
                    int baseX = bkgBounds.x / w * w;
                    int baseY = bkgBounds.y / h * h;
                    int topX = bkgBounds.x + bkgBounds.width;
                    int topY = bkgBounds.y + bkgBounds.height;
                    for (int x = baseX; x < topX; x += w) {
                        for (int y = baseY; y < topY; y += h) {
                            clientG.drawImage(image, x, y, w, h, this);
                        }
                    }
                    return;
                }
            }
        }
        finally {
            clientG.dispose();
        }
    }

    @Override
    public boolean imageUpdate(Image img, int infoflags, int x, int y, int w, int h) {
        if ((infoflags & 0x20) != 0 || (infoflags & 0x10) != 0) {
            this.repaint();
        }
        return true;
    }

    public Insets getInsets(boolean hscroll, boolean vscroll) {
        Insets mi = this.marginInsets;
        Insets bi = this.borderInsets;
        int top = 0;
        int bottom = 0;
        int left = 0;
        int right = 0;
        if (mi != null) {
            top += mi.top;
            left += mi.left;
            bottom += mi.bottom;
            right += mi.right;
        }
        if (bi != null) {
            top += bi.top;
            left += bi.left;
            bottom += bi.bottom;
            right += bi.right;
        }
        if (hscroll) {
            bottom += 16;
        }
        if (vscroll) {
            right += 16;
        }
        return new Insets(top, left, bottom, right);
    }

    protected final void sendDelayedPairsToParent() {
        Collection<DelayedPair> gc = this.delayedPairs;
        if (gc != null) {
            RenderableContainer rc = this.container;
            for (DelayedPair pair : gc) {
                if (pair.targetParent == this) continue;
                rc.addDelayedPair(pair);
            }
        }
    }

    @Override
    public final void clearDelayedPairs() {
        Collection<DelayedPair> gc = this.delayedPairs;
        if (gc != null) {
            gc.clear();
        }
    }

    @Override
    public final Collection<DelayedPair> getDelayedPairs() {
        return this.delayedPairs;
    }

    @Override
    public void addDelayedPair(DelayedPair pair) {
        Collection<DelayedPair> gc = this.delayedPairs;
        if (gc == null) {
            this.delayedPairs = gc = new LinkedList<DelayedPair>();
        }
        gc.add(pair);
    }

    @Override
    public RenderableContainer getParentContainer() {
        return this.container;
    }

    @Override
    public boolean isContainedByNode() {
        return true;
    }

    @Override
    public int getCollapsibleMarginBottom() {
        FontMetrics fm;
        int fontHeight;
        RenderState rs;
        Insets borderInsets;
        Insets paddingInsets = this.paddingInsets;
        int cm = paddingInsets != null && paddingInsets.bottom > 0 ? 0 : ((borderInsets = this.borderInsets) != null && borderInsets.bottom > 0 ? 0 : this.getMarginBottom());
        if (this.isMarginBoundary() && (rs = this.modelNode.getRenderState()) != null && (fontHeight = (fm = rs.getFontMetrics()).getHeight()) > cm) {
            cm = fontHeight;
        }
        return cm;
    }

    protected boolean isMarginBoundary() {
        return this.overflowY != 4 && this.overflowX != 0 || this.modelNode instanceof HTMLDocumentImpl;
    }

    @Override
    public int getCollapsibleMarginTop() {
        FontMetrics fm;
        int fontHeight;
        RenderState rs;
        Insets borderInsets;
        Insets paddingInsets = this.paddingInsets;
        int cm = paddingInsets != null && paddingInsets.top > 0 ? 0 : ((borderInsets = this.borderInsets) != null && borderInsets.top > 0 ? 0 : this.getMarginTop());
        if (this.isMarginBoundary() && (rs = this.modelNode.getRenderState()) != null && (fontHeight = (fm = rs.getFontMetrics()).getHeight()) > cm) {
            cm = fontHeight;
        }
        return cm;
    }

    @Override
    public int getMarginBottom() {
        Insets marginInsets = this.marginInsets;
        return marginInsets == null ? 0 : marginInsets.bottom;
    }

    @Override
    public int getMarginLeft() {
        Insets marginInsets = this.marginInsets;
        return marginInsets == null ? 0 : marginInsets.left;
    }

    @Override
    public int getMarginRight() {
        Insets marginInsets = this.marginInsets;
        return marginInsets == null ? 0 : marginInsets.right;
    }

    @Override
    public int getMarginTop() {
        Insets marginInsets = this.marginInsets;
        return marginInsets == null ? 0 : marginInsets.top;
    }
}

