/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.request;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import javax.net.ssl.HostnameVerifier;
import org.lobobrowser.clientlet.ClientletException;
import org.lobobrowser.clientlet.ClientletRequest;
import org.lobobrowser.clientlet.ClientletResponse;
import org.lobobrowser.request.RequestHandler;
import org.lobobrowser.ua.ProgressType;
import org.lobobrowser.ua.RequestType;
import org.lobobrowser.util.Urls;

public class RedirectRequestHandler
implements RequestHandler {
    private final RequestHandler origHandler;
    private final URL latestRequestURL;
    private volatile boolean cancelled;

    public RedirectRequestHandler(RequestHandler origHandler, HttpURLConnection origConnection) throws MalformedURLException, UnsupportedEncodingException {
        String finalPath;
        String origPath;
        String finalHost;
        this.origHandler = origHandler;
        String location = origConnection.getHeaderField("Location");
        URL origURL = origConnection.getURL();
        if (location == null) {
            throw new IllegalArgumentException("No Location header in redirect response for " + origConnection.getURL());
        }
        URL finalURL = Urls.createURL(origURL, location);
        String origHost = origURL.getHost();
        if (origHost.equals(finalHost = finalURL.getHost()) && origURL.getProtocol().equalsIgnoreCase(finalURL.getProtocol()) && origURL.getPort() == finalURL.getPort() && (origPath = origURL.getFile()).equals(finalPath = finalURL.getFile())) {
            throw new IllegalArgumentException("Redirecting URL '" + origURL + "' and target URL '" + finalURL + "' are equal!");
        }
        this.latestRequestURL = finalURL;
    }

    @Override
    public HostnameVerifier getHostnameVerifier() {
        return this.origHandler.getHostnameVerifier();
    }

    @Override
    public String getLatestRequestMethod() {
        return "GET";
    }

    @Override
    public URL getLatestRequestURL() {
        return this.latestRequestURL;
    }

    @Override
    public ClientletRequest getRequest() {
        return this.origHandler.getRequest();
    }

    @Override
    public boolean handleException(ClientletResponse response, Throwable exception) throws ClientletException {
        return this.origHandler.handleException(response, exception);
    }

    @Override
    public void handleProgress(ProgressType progressType, URL url, String method, int value, int max) {
        this.origHandler.handleProgress(progressType, url, method, value, max);
    }

    @Override
    public void processResponse(ClientletResponse response) throws ClientletException, IOException {
        this.origHandler.processResponse(response);
    }

    @Override
    public void cancel() {
        this.cancelled = true;
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public RequestType getRequestType() {
        return this.origHandler.getRequestType();
    }
}

