/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.resources.ResourceType;
import com.android.sdklib.AndroidVersion;
import com.android.tools.lint.checks.PermissionFinder;
import com.android.tools.lint.checks.PermissionHolder;
import com.android.tools.lint.checks.PermissionRequirement;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ConstantEvaluator;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.ResourceEvaluator;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.TextFormat;
import com.android.utils.XmlUtils;
import com.google.common.base.Joiner;
import com.google.common.collect.Sets;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SupportAnnotationDetector
extends Detector
implements Detector.JavaPsiScanner {
    public static final Implementation IMPLEMENTATION = new Implementation(SupportAnnotationDetector.class, Scope.JAVA_FILE_SCOPE);
    public static final Issue RANGE = Issue.create("Range", "Outside Range", "Some parameters are required to in a particular numerical range; this check makes sure that arguments passed fall within the range. For arrays, Strings and collections this refers to the size or length.", Category.CORRECTNESS, 6, Severity.ERROR, IMPLEMENTATION);
    public static final Issue RESOURCE_TYPE = Issue.create("ResourceType", "Wrong Resource Type", "Ensures that resource id's passed to APIs are of the right type; for example, calling `Resources.getColor(R.string.name)` is wrong.", Category.CORRECTNESS, 7, Severity.FATAL, IMPLEMENTATION);
    public static final Issue COLOR_USAGE = Issue.create("ResourceAsColor", "Should pass resolved color instead of resource id", "Methods that take a color in the form of an integer should be passed an RGB triple, not the actual color resource id. You must call `getResources().getColor(resource)` to resolve the actual color value first.", Category.CORRECTNESS, 7, Severity.ERROR, IMPLEMENTATION);
    public static final Issue TYPE_DEF = Issue.create("WrongConstant", "Incorrect constant", "Ensures that when parameter in a method only allows a specific set of constants, calls obey those rules.", Category.SECURITY, 6, Severity.ERROR, IMPLEMENTATION);
    public static final Issue CHECK_RESULT = Issue.create("CheckResult", "Ignoring results", "Some methods have no side effects, an calling them without doing something without the result is suspicious. ", Category.CORRECTNESS, 6, Severity.WARNING, IMPLEMENTATION);
    public static final Issue CHECK_PERMISSION = Issue.create("UseCheckPermission", "Using the result of check permission calls", "You normally want to use the result of checking a permission; these methods return whether the permission is held; they do not throw an error if the permission is not granted. Code which does not do anything with the return value probably meant to be calling the enforce methods instead, e.g. rather than `Context#checkCallingPermission` it should call `Context#enforceCallingPermission`.", Category.SECURITY, 6, Severity.WARNING, IMPLEMENTATION);
    public static final Issue MISSING_PERMISSION = Issue.create("MissingPermission", "Missing Permissions", "This check scans through your code and libraries and looks at the APIs being used, and checks this against the set of permissions required to access those APIs. If the code using those APIs is called at runtime, then the program will crash.\n\nFurthermore, for permissions that are revocable (with targetSdkVersion 23), client code must also be prepared to handle the calls throwing an exception if the user rejects the request for permission at runtime.", Category.CORRECTNESS, 9, Severity.ERROR, IMPLEMENTATION);
    public static final Issue THREAD = Issue.create("WrongThread", "Wrong Thread", "Ensures that a method which expects to be called on a specific thread, is actually called from that thread. For example, calls on methods in widgets should always be made on the UI thread.", Category.CORRECTNESS, 6, Severity.ERROR, IMPLEMENTATION).addMoreInfo("http://developer.android.com/guide/components/processes-and-threads.html#Threads");
    public static final String CHECK_RESULT_ANNOTATION = "android.support.annotation.CheckResult";
    public static final String INT_RANGE_ANNOTATION = "android.support.annotation.IntRange";
    public static final String FLOAT_RANGE_ANNOTATION = "android.support.annotation.FloatRange";
    public static final String SIZE_ANNOTATION = "android.support.annotation.Size";
    public static final String PERMISSION_ANNOTATION = "android.support.annotation.RequiresPermission";
    public static final String UI_THREAD_ANNOTATION = "android.support.annotation.UiThread";
    public static final String MAIN_THREAD_ANNOTATION = "android.support.annotation.MainThread";
    public static final String WORKER_THREAD_ANNOTATION = "android.support.annotation.WorkerThread";
    public static final String BINDER_THREAD_ANNOTATION = "android.support.annotation.BinderThread";
    public static final String ANY_THREAD_ANNOTATION = "android.support.annotation.AnyThread";
    public static final String PERMISSION_ANNOTATION_READ = "android.support.annotation.RequiresPermission.Read";
    public static final String PERMISSION_ANNOTATION_WRITE = "android.support.annotation.RequiresPermission.Write";
    public static final String THREAD_SUFFIX = "Thread";
    public static final String ATTR_SUGGEST = "suggest";
    public static final String ATTR_TO = "to";
    public static final String ATTR_FROM = "from";
    public static final String ATTR_FROM_INCLUSIVE = "fromInclusive";
    public static final String ATTR_TO_INCLUSIVE = "toInclusive";
    public static final String ATTR_MULTIPLE = "multiple";
    public static final String ATTR_MIN = "min";
    public static final String ATTR_MAX = "max";
    public static final String ATTR_ALL_OF = "allOf";
    public static final String ATTR_ANY_OF = "anyOf";
    public static final String ATTR_CONDITIONAL = "conditional";
    private PermissionHolder mPermissions;

    private void checkMethodAnnotation(JavaContext context, PsiMethod method, PsiElement call, PsiAnnotation annotation, PsiAnnotation[] allMethodAnnotations, PsiAnnotation[] allClassAnnotations) {
        String signature = annotation.getQualifiedName();
        if (signature == null) {
            return;
        }
        if (CHECK_RESULT_ANNOTATION.equals(signature) || signature.endsWith(".CheckReturnValue")) {
            SupportAnnotationDetector.checkResult(context, call, method, annotation);
        } else if (signature.equals(PERMISSION_ANNOTATION)) {
            PermissionRequirement requirement = PermissionRequirement.create(context, annotation);
            this.checkPermission(context, call, method, null, requirement);
        } else if (signature.endsWith(THREAD_SUFFIX) && signature.startsWith("android.support.annotation.")) {
            SupportAnnotationDetector.checkThreading(context, call, method, signature, annotation, allMethodAnnotations, allClassAnnotations);
        }
    }

    private void checkParameterAnnotations(JavaContext context, PsiExpression argument, PsiCall call, PsiMethod method, PsiAnnotation[] annotations) {
        boolean handledResourceTypes = false;
        for (PsiAnnotation annotation : annotations) {
            String signature = annotation.getQualifiedName();
            if (signature == null) continue;
            if ("android.support.annotation.ColorInt".equals(signature)) {
                SupportAnnotationDetector.checkColor(context, (PsiElement)argument);
                continue;
            }
            if (signature.equals("android.support.annotation.Px")) {
                SupportAnnotationDetector.checkPx(context, (PsiElement)argument);
                continue;
            }
            if (signature.equals(INT_RANGE_ANNOTATION)) {
                SupportAnnotationDetector.checkIntRange(context, annotation, (PsiElement)argument, annotations);
                continue;
            }
            if (signature.equals(FLOAT_RANGE_ANNOTATION)) {
                SupportAnnotationDetector.checkFloatRange(context, annotation, (PsiElement)argument);
                continue;
            }
            if (signature.equals(SIZE_ANNOTATION)) {
                SupportAnnotationDetector.checkSize(context, annotation, (PsiElement)argument);
                continue;
            }
            if (signature.startsWith(PERMISSION_ANNOTATION)) {
                this.checkParameterPermission(context, signature, (PsiElement)call, method, argument);
                continue;
            }
            if (signature.equals("android.support.annotation.IntDef")) {
                boolean flag = PermissionRequirement.getAnnotationBooleanValue(annotation, "flag") == Boolean.TRUE;
                SupportAnnotationDetector.checkTypeDefConstant(context, annotation, (PsiElement)argument, null, flag, annotations);
                continue;
            }
            if (signature.equals("android.support.annotation.StringDef")) {
                SupportAnnotationDetector.checkTypeDefConstant(context, annotation, (PsiElement)argument, null, false, annotations);
                continue;
            }
            if (!signature.endsWith("Res") || handledResourceTypes) continue;
            handledResourceTypes = true;
            EnumSet<ResourceType> types = null;
            for (PsiAnnotation a : annotations) {
                String s = a.getQualifiedName();
                if (s == null || !s.endsWith("Res")) continue;
                String typeString = s.substring("android.support.annotation.".length(), s.length() - "Res".length()).toLowerCase(Locale.US);
                ResourceType type = ResourceType.getEnum((String)typeString);
                if (type != null) {
                    if (types == null) {
                        types = EnumSet.of(type);
                        continue;
                    }
                    types.add(type);
                    continue;
                }
                if (!typeString.equals("any")) continue;
                types = SupportAnnotationDetector.getAnyRes();
                break;
            }
            if (types == null) continue;
            SupportAnnotationDetector.checkResourceType(context, (PsiElement)argument, types, call, method);
        }
    }

    private static EnumSet<ResourceType> getAnyRes() {
        EnumSet<ResourceType> types = EnumSet.allOf(ResourceType.class);
        types.remove(ResourceEvaluator.COLOR_INT_MARKER_TYPE);
        types.remove(ResourceEvaluator.PX_MARKER_TYPE);
        return types;
    }

    private void checkParameterPermission(JavaContext context, String signature, PsiElement call, PsiMethod method, PsiExpression argument) {
        PermissionFinder.Operation operation = null;
        if (signature.equals(PERMISSION_ANNOTATION_READ)) {
            operation = PermissionFinder.Operation.READ;
        } else if (signature.equals(PERMISSION_ANNOTATION_WRITE)) {
            operation = PermissionFinder.Operation.WRITE;
        } else {
            PsiType type = argument.getType();
            if (type != null && "android.content.Intent".equals(type.getCanonicalText())) {
                operation = PermissionFinder.Operation.ACTION;
            }
        }
        if (operation == null) {
            return;
        }
        PermissionFinder.Result result = PermissionFinder.findRequiredPermissions(operation, context, (PsiElement)argument);
        if (result != null) {
            this.checkPermission(context, call, method, result, result.requirement);
        }
    }

    private static void checkColor(JavaContext context, PsiElement argument) {
        if (argument instanceof PsiConditionalExpression) {
            PsiConditionalExpression expression = (PsiConditionalExpression)argument;
            if (expression.getThenExpression() != null) {
                SupportAnnotationDetector.checkColor(context, (PsiElement)expression.getThenExpression());
            }
            if (expression.getElseExpression() != null) {
                SupportAnnotationDetector.checkColor(context, (PsiElement)expression.getElseExpression());
            }
            return;
        }
        EnumSet<ResourceType> types = ResourceEvaluator.getResourceTypes(context.getEvaluator(), argument);
        if (types != null && types.contains(ResourceType.COLOR) && !SupportAnnotationDetector.isIgnoredInIde(COLOR_USAGE, context, argument)) {
            String message = String.format("Should pass resolved color instead of resource id here: `getResources().getColor(%1$s)`", argument.getText());
            context.report(COLOR_USAGE, argument, context.getLocation(argument), message);
        }
    }

    private static void checkPx(JavaContext context, PsiElement argument) {
        if (argument instanceof PsiConditionalExpression) {
            PsiConditionalExpression expression = (PsiConditionalExpression)argument;
            if (expression.getThenExpression() != null) {
                SupportAnnotationDetector.checkPx(context, (PsiElement)expression.getThenExpression());
            }
            if (expression.getElseExpression() != null) {
                SupportAnnotationDetector.checkPx(context, (PsiElement)expression.getElseExpression());
            }
            return;
        }
        EnumSet<ResourceType> types = ResourceEvaluator.getResourceTypes(context.getEvaluator(), argument);
        if (types != null && types.contains(ResourceType.DIMEN)) {
            String message = String.format("Should pass resolved pixel dimension instead of resource id here: `getResources().getDimension*(%1$s)`", argument.getText());
            context.report(COLOR_USAGE, argument, context.getLocation(argument), message);
        }
    }

    private static boolean isIgnoredInIde(Issue issue, JavaContext context, PsiElement node) {
        Issue synonym = Issue.create("ResourceType", issue.getBriefDescription(TextFormat.RAW), issue.getExplanation(TextFormat.RAW), issue.getCategory(), issue.getPriority(), issue.getDefaultSeverity(), issue.getImplementation());
        return context.getDriver().isSuppressed(context, synonym, node);
    }

    private void checkPermission(JavaContext context, PsiElement node, PsiMethod method, PermissionFinder.Result result, PermissionRequirement requirement) {
        if (requirement.isConditional()) {
            return;
        }
        PermissionHolder permissions = this.getPermissions(context);
        if (!requirement.isSatisfied(permissions)) {
            if (!requirement.isSatisfied(permissions = SupportAnnotationDetector.addLocalPermissions(context, permissions, node))) {
                PermissionFinder.Operation operation;
                String name;
                if (SupportAnnotationDetector.isIgnoredInIde(MISSING_PERMISSION, context, node)) {
                    return;
                }
                if (result != null) {
                    name = result.name;
                    operation = result.operation;
                } else {
                    assert (method != null);
                    PsiClass containingClass = method.getContainingClass();
                    name = containingClass != null ? containingClass.getName() + "." + method.getName() : method.getName();
                    operation = PermissionFinder.Operation.CALL;
                }
                String message = SupportAnnotationDetector.getMissingPermissionMessage(requirement, name, permissions, operation);
                context.report(MISSING_PERMISSION, node, context.getLocation(node), message);
            }
        } else if (requirement.isRevocable(permissions) && context.getMainProject().getTargetSdkVersion().getFeatureLevel() >= 23) {
            PsiMethod methodNode;
            boolean handlesMissingPermission = SupportAnnotationDetector.handlesSecurityException(node);
            if (!handlesMissingPermission && (methodNode = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)node, PsiMethod.class, (boolean)true)) != null) {
                CheckPermissionVisitor visitor = new CheckPermissionVisitor(node);
                methodNode.accept((PsiElementVisitor)visitor);
                handlesMissingPermission = visitor.checksPermission();
            }
            if (!handlesMissingPermission && !SupportAnnotationDetector.isIgnoredInIde(MISSING_PERMISSION, context, node)) {
                String message = SupportAnnotationDetector.getUnhandledPermissionMessage();
                context.report(MISSING_PERMISSION, node, context.getLocation(node), message);
            }
        }
    }

    private static boolean handlesSecurityException(PsiElement node) {
        PsiTryStatement tryCatch;
        PsiElement parent = node;
        while ((tryCatch = (PsiTryStatement)PsiTreeUtil.getParentOfType((PsiElement)parent, PsiTryStatement.class, (boolean)true)) != null) {
            for (PsiCatchSection psiCatchSection : tryCatch.getCatchSections()) {
                PsiType type = psiCatchSection.getCatchType();
                if (!SupportAnnotationDetector.isSecurityException(type)) continue;
                return true;
            }
            parent = tryCatch;
        }
        PsiMethod declaration = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)parent, PsiMethod.class, (boolean)false);
        if (declaration != null) {
            for (PsiCatchSection psiCatchSection : declaration.getThrowsList().getReferencedTypes()) {
                if (!SupportAnnotationDetector.isSecurityException((PsiType)psiCatchSection)) continue;
                return true;
            }
        }
        return false;
    }

    private static PermissionHolder addLocalPermissions(JavaContext context, PermissionHolder permissions, PsiElement node) {
        PsiModifierList modifierList;
        PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)node, PsiMethod.class, (boolean)true);
        if (method == null) {
            return permissions;
        }
        PsiAnnotation annotation = method.getModifierList().findAnnotation(PERMISSION_ANNOTATION);
        permissions = SupportAnnotationDetector.mergeAnnotationPermissions(context, permissions, annotation);
        PsiClass containingClass = method.getContainingClass();
        if (containingClass != null && (modifierList = containingClass.getModifierList()) != null) {
            annotation = modifierList.findAnnotation(PERMISSION_ANNOTATION);
            permissions = SupportAnnotationDetector.mergeAnnotationPermissions(context, permissions, annotation);
        }
        return permissions;
    }

    private static PermissionHolder mergeAnnotationPermissions(JavaContext context, PermissionHolder permissions, PsiAnnotation annotation) {
        if (annotation != null) {
            PermissionRequirement requirement = PermissionRequirement.create(context, annotation);
            permissions = PermissionHolder.SetPermissionLookup.join(permissions, requirement);
        }
        return permissions;
    }

    public static String getMissingPermissionMessage(PermissionRequirement requirement, String callName, PermissionHolder permissions, PermissionFinder.Operation operation) {
        return String.format("Missing permissions required %1$s %2$s: %3$s", operation.prefix(), callName, requirement.describeMissingPermissions(permissions));
    }

    public static String getUnhandledPermissionMessage() {
        return "Call requires permission which may be rejected by user: code should explicitly check to see if permission is available (with `checkPermission`) or explicitly handle a potential `SecurityException`";
    }

    private static boolean isSecurityException(PsiType type) {
        if (type instanceof PsiClassType) {
            PsiClass cls = ((PsiClassType)type).resolve();
            return cls != null && "java.lang.SecurityException".equals(cls.getQualifiedName());
        }
        if (type instanceof PsiDisjunctionType) {
            for (PsiType disjunction : ((PsiDisjunctionType)type).getDisjunctions()) {
                if (!SupportAnnotationDetector.isSecurityException(disjunction)) continue;
                return true;
            }
        }
        return false;
    }

    private PermissionHolder getPermissions(JavaContext context) {
        if (this.mPermissions == null) {
            HashSet permissions = Sets.newHashSetWithExpectedSize((int)30);
            HashSet revocable = Sets.newHashSetWithExpectedSize((int)4);
            LintClient client = context.getClient();
            Project mainProject = context.getMainProject();
            for (File manifest : mainProject.getManifestFiles()) {
                SupportAnnotationDetector.addPermissions(client, permissions, revocable, manifest);
            }
            for (Project library : mainProject.getAllLibraries()) {
                for (File manifest : library.getManifestFiles()) {
                    SupportAnnotationDetector.addPermissions(client, permissions, revocable, manifest);
                }
            }
            AndroidVersion minSdkVersion = mainProject.getMinSdkVersion();
            AndroidVersion targetSdkVersion = mainProject.getTargetSdkVersion();
            this.mPermissions = new PermissionHolder.SetPermissionLookup(permissions, revocable, minSdkVersion, targetSdkVersion);
        }
        return this.mPermissions;
    }

    private static void addPermissions(LintClient client, Set<String> permissions, Set<String> revocable, File manifest) {
        Document document = XmlUtils.parseDocumentSilently((String)client.readFile(manifest), (boolean)true);
        if (document == null) {
            return;
        }
        Element root = document.getDocumentElement();
        if (root == null) {
            return;
        }
        NodeList children = root.getChildNodes();
        int n = children.getLength();
        for (int i = 0; i < n; ++i) {
            String name;
            String protectionLevel;
            Element element;
            Node item = children.item(i);
            if (item.getNodeType() != 1) continue;
            String nodeName = item.getNodeName();
            if (nodeName.equals("uses-permission") || nodeName.equals("uses-permission-sdk-23") || nodeName.equals("uses-permission-sdk-m")) {
                element = (Element)item;
                String name2 = element.getAttributeNS("http://schemas.android.com/apk/res/android", "name");
                if (name2.isEmpty()) continue;
                permissions.add(name2);
                continue;
            }
            if (!nodeName.equals("permission") || !"dangerous".equals(protectionLevel = (element = (Element)item).getAttributeNS("http://schemas.android.com/apk/res/android", "protectionLevel")) || (name = element.getAttributeNS("http://schemas.android.com/apk/res/android", "name")).isEmpty()) continue;
            revocable.add(name);
        }
    }

    private static void checkResult(JavaContext context, PsiElement node, PsiMethod method, PsiAnnotation annotation) {
        if (LintUtils.skipParentheses(node.getParent()) instanceof PsiExpressionStatement) {
            String methodName = JavaContext.getMethodName(node);
            String suggested = PermissionRequirement.getAnnotationStringValue(annotation, ATTR_SUGGEST);
            Issue issue = CHECK_RESULT;
            if (methodName != null && methodName.startsWith("check") && methodName.contains("Permission")) {
                issue = CHECK_PERMISSION;
            }
            if (SupportAnnotationDetector.isIgnoredInIde(issue, context, node)) {
                return;
            }
            String message = String.format("The result of `%1$s` is not used", methodName);
            if (suggested != null) {
                message = String.format("The result of `%1$s` is not used; did you mean to call `%2$s`?", methodName, suggested);
            } else if ("intersect".equals(methodName) && context.getEvaluator().isMemberInClass((PsiMember)method, "android.graphics.Rect")) {
                message = message + ". If the rectangles do not intersect, no change is made and the original rectangle is not modified. These methods return false to indicate that this has happened.";
            }
            context.report(issue, node, context.getLocation(node), message);
        }
    }

    private static void checkThreading(JavaContext context, PsiElement node, PsiMethod method, String signature, PsiAnnotation annotation, PsiAnnotation[] allMethodAnnotations, PsiAnnotation[] allClassAnnotations) {
        List<String> threadContext = SupportAnnotationDetector.getThreadContext(context, node);
        if (threadContext != null && !SupportAnnotationDetector.isCompatibleThread(threadContext, signature) && !SupportAnnotationDetector.isIgnoredInIde(THREAD, context, node)) {
            String name;
            if (SupportAnnotationDetector.containsAnnotation(allClassAnnotations, annotation)) {
                if (SupportAnnotationDetector.containsThreadingAnnotation(allMethodAnnotations)) {
                    return;
                }
            } else {
                assert (SupportAnnotationDetector.containsAnnotation(allMethodAnnotations, annotation));
                Boolean isFirst = null;
                for (PsiAnnotation other : allMethodAnnotations) {
                    if (other == annotation) {
                        if (isFirst != null) continue;
                        isFirst = true;
                        continue;
                    }
                    if (!SupportAnnotationDetector.isThreadingAnnotation(other)) continue;
                    if (isFirst == null) {
                        return;
                    }
                    String s = other.getQualifiedName();
                    if (s == null || !SupportAnnotationDetector.isCompatibleThread(threadContext, s)) continue;
                    return;
                }
            }
            if ((name = method.getName()).startsWith("post") && context.getEvaluator().isMemberInClass((PsiMember)method, "android.view.View")) {
                return;
            }
            List<String> targetThreads = SupportAnnotationDetector.getThreads(context, method);
            if (targetThreads == null) {
                targetThreads = Collections.singletonList(signature);
            }
            String message = String.format("%1$s %2$s must be called from the `%3$s` thread, currently inferred thread is `%4$s` thread", method.isConstructor() ? "Constructor" : "Method", method.getName(), SupportAnnotationDetector.describeThreads(targetThreads, true), SupportAnnotationDetector.describeThreads(threadContext, false));
            context.report(THREAD, node, context.getLocation(node), message);
        }
    }

    public static boolean containsAnnotation(PsiAnnotation[] array, PsiAnnotation annotation) {
        for (PsiAnnotation a : array) {
            if (a != annotation) continue;
            return true;
        }
        return false;
    }

    public static boolean containsThreadingAnnotation(PsiAnnotation[] array) {
        for (PsiAnnotation annotation : array) {
            if (!SupportAnnotationDetector.isThreadingAnnotation(annotation)) continue;
            return true;
        }
        return false;
    }

    public static boolean isThreadingAnnotation(PsiAnnotation annotation) {
        String signature = annotation.getQualifiedName();
        return signature != null && signature.endsWith(THREAD_SUFFIX) && signature.startsWith("android.support.annotation.");
    }

    public static String describeThreads(List<String> annotations, boolean any) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < annotations.size(); ++i) {
            if (i > 0) {
                if (i == annotations.size() - 1) {
                    if (any) {
                        sb.append(" or ");
                    } else {
                        sb.append(" and ");
                    }
                } else {
                    sb.append(", ");
                }
            }
            sb.append(SupportAnnotationDetector.describeThread(annotations.get(i)));
        }
        return sb.toString();
    }

    public static String describeThread(String annotation) {
        switch (annotation) {
            case "android.support.annotation.UiThread": {
                return "UI";
            }
            case "android.support.annotation.MainThread": {
                return "main";
            }
            case "android.support.annotation.BinderThread": {
                return "binder";
            }
            case "android.support.annotation.WorkerThread": {
                return "worker";
            }
            case "android.support.annotation.AnyThread": {
                return "any";
            }
        }
        return "other";
    }

    public static boolean isCompatibleThread(List<String> callers, String callee) {
        assert (!callers.isEmpty());
        for (String caller : callers) {
            if (SupportAnnotationDetector.isCompatibleThread(caller, callee)) continue;
            return false;
        }
        return true;
    }

    public static boolean isCompatibleThread(String caller, String callee) {
        if (callee.equals(caller)) {
            return true;
        }
        if (callee.equals(ANY_THREAD_ANNOTATION)) {
            return true;
        }
        return callee.equals(UI_THREAD_ANNOTATION) ? caller.equals(MAIN_THREAD_ANNOTATION) : callee.equals(MAIN_THREAD_ANNOTATION) && caller.equals(UI_THREAD_ANNOTATION);
    }

    private static List<String> getThreadContext(JavaContext context, PsiElement methodCall) {
        PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)methodCall, PsiMethod.class, (boolean)true, (Class[])new Class[]{PsiAnonymousClass.class});
        return SupportAnnotationDetector.getThreads(context, method);
    }

    private static List<String> getThreads(JavaContext context, PsiMethod method) {
        if (method != null) {
            ArrayList<String> result = null;
            PsiClass cls = method.getContainingClass();
            while (method != null) {
                for (PsiAnnotation annotation : method.getModifierList().getAnnotations()) {
                    String name = annotation.getQualifiedName();
                    if (name == null || !name.startsWith("android.support.annotation.") || !name.endsWith(THREAD_SUFFIX)) continue;
                    if (result == null) {
                        result = new ArrayList<String>(4);
                    }
                    result.add(name);
                }
                if (result != null) {
                    return result;
                }
                method = context.getEvaluator().getSuperMethod(method);
            }
            while (cls != null) {
                PsiModifierList modifierList = cls.getModifierList();
                if (modifierList != null) {
                    for (PsiAnnotation annotation : modifierList.getAnnotations()) {
                        String name = annotation.getQualifiedName();
                        if (name == null || !name.startsWith("android.support.annotation.") || !name.endsWith(THREAD_SUFFIX)) continue;
                        if (result == null) {
                            result = new ArrayList(4);
                        }
                        result.add(name);
                    }
                    if (result != null) {
                        return result;
                    }
                }
                cls = cls.getSuperClass();
            }
        }
        return null;
    }

    private static boolean isNumber(PsiElement argument) {
        if (argument instanceof PsiLiteral) {
            Object value = ((PsiLiteral)argument).getValue();
            return value instanceof Number;
        }
        if (argument instanceof PsiPrefixExpression) {
            PsiPrefixExpression expression = (PsiPrefixExpression)argument;
            PsiExpression operand = expression.getOperand();
            return operand != null && SupportAnnotationDetector.isNumber((PsiElement)operand);
        }
        return false;
    }

    private static boolean isZero(PsiElement argument) {
        if (argument instanceof PsiLiteral) {
            Object value = ((PsiLiteral)argument).getValue();
            return value instanceof Number && ((Number)value).intValue() == 0;
        }
        return false;
    }

    private static boolean isMinusOne(PsiElement argument) {
        if (argument instanceof PsiPrefixExpression) {
            PsiPrefixExpression expression = (PsiPrefixExpression)argument;
            PsiExpression operand = expression.getOperand();
            if (operand instanceof PsiLiteral && expression.getOperationTokenType() == JavaTokenType.MINUS) {
                Object value = ((PsiLiteral)operand).getValue();
                return value instanceof Number && ((Number)value).intValue() == 1;
            }
            return false;
        }
        return false;
    }

    private static void checkResourceType(JavaContext context, PsiElement argument, EnumSet<ResourceType> expectedType, PsiCall call, PsiMethod calledMethod) {
        EnumSet<ResourceType> actual = ResourceEvaluator.getResourceTypes(context.getEvaluator(), argument);
        if (actual == null && (!SupportAnnotationDetector.isNumber(argument) || SupportAnnotationDetector.isZero(argument) || SupportAnnotationDetector.isMinusOne(argument))) {
            return;
        }
        if (actual != null && (!Sets.intersection(actual, expectedType).isEmpty() || expectedType.contains(ResourceType.DRAWABLE) && (actual.contains(ResourceType.COLOR) || actual.contains(ResourceType.MIPMAP)))) {
            return;
        }
        if (SupportAnnotationDetector.isIgnoredInIde(RESOURCE_TYPE, context, argument)) {
            return;
        }
        if (expectedType.contains(ResourceType.STYLEABLE) && expectedType.size() == 1 && context.getEvaluator().isMemberInClass((PsiMember)calledMethod, "android.content.res.TypedArray") && call instanceof PsiMethodCallExpression && SupportAnnotationDetector.typeArrayFromArrayLiteral((PsiElement)((PsiMethodCallExpression)call).getMethodExpression().getQualifierExpression())) {
            return;
        }
        String message = actual != null && actual.size() == 1 && actual.contains(ResourceEvaluator.COLOR_INT_MARKER_TYPE) ? "Expected a color resource id (`R.color.`) but received an RGB integer" : (expectedType.contains(ResourceEvaluator.COLOR_INT_MARKER_TYPE) ? String.format("Should pass resolved color instead of resource id here: `getResources().getColor(%1$s)`", argument.getText()) : (actual != null && actual.size() == 1 && actual.contains(ResourceEvaluator.PX_MARKER_TYPE) ? "Expected a dimension resource id (`R.color.`) but received a pixel integer" : (expectedType.contains(ResourceEvaluator.PX_MARKER_TYPE) ? String.format("Should pass resolved pixel size instead of resource id here: `getResources().getDimension*(%1$s)`", argument.getText()) : (expectedType.size() < ResourceType.getNames().length - 2 ? String.format("Expected resource of type %1$s", Joiner.on((String)" or ").join(expectedType)) : "Expected resource identifier (`R`.type.`name`)"))));
        context.report(RESOURCE_TYPE, argument, context.getLocation(argument), message);
    }

    public static boolean typeArrayFromArrayLiteral(PsiElement node) {
        PsiTypeCastExpression castExpression;
        PsiExpression operand;
        if (node instanceof PsiMethodCallExpression) {
            PsiExpressionList argumentList;
            PsiExpression[] expressions;
            PsiMethodCallExpression expression = (PsiMethodCallExpression)node;
            String name = expression.getMethodExpression().getReferenceName();
            if (name != null && "obtainStyledAttributes".equals(name) && (expressions = (argumentList = expression.getArgumentList()).getExpressions()).length > 0) {
                int arg;
                if (expressions.length == 1) {
                    arg = 0;
                } else if (expressions.length == 2) {
                    PsiType type;
                    for (arg = 0; arg < expressions.length && !((type = expressions[arg].getType()) instanceof PsiArrayType); ++arg) {
                    }
                    if (arg == expressions.length) {
                        return false;
                    }
                } else if (expressions.length == 4) {
                    arg = 1;
                } else {
                    return false;
                }
                return ConstantEvaluator.isArrayLiteral((PsiElement)expressions[arg]);
            }
            return false;
        }
        if (node instanceof PsiReference) {
            PsiElement resolved = ((PsiReference)node).resolve();
            if (resolved instanceof PsiField) {
                PsiField field = (PsiField)resolved;
                if (field.getInitializer() != null) {
                    return SupportAnnotationDetector.typeArrayFromArrayLiteral((PsiElement)field.getInitializer());
                }
            } else if (resolved instanceof PsiLocalVariable) {
                PsiLocalVariable variable = (PsiLocalVariable)resolved;
                PsiStatement statement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)node, PsiStatement.class, (boolean)false);
                if (statement != null) {
                    PsiStatement prev = (PsiStatement)PsiTreeUtil.getPrevSiblingOfType((PsiElement)statement, PsiStatement.class);
                    String targetName = variable.getName();
                    if (targetName == null) {
                        return false;
                    }
                    while (prev != null) {
                        PsiReferenceExpression reference;
                        PsiAssignmentExpression assign;
                        PsiExpression lhs;
                        PsiExpression expression;
                        if (prev instanceof PsiDeclarationStatement) {
                            for (PsiElement element : ((PsiDeclarationStatement)prev).getDeclaredElements()) {
                                if (!variable.equals(element)) continue;
                                return SupportAnnotationDetector.typeArrayFromArrayLiteral((PsiElement)variable.getInitializer());
                            }
                        } else if (prev instanceof PsiExpressionStatement && (expression = ((PsiExpressionStatement)prev).getExpression()) instanceof PsiAssignmentExpression && (lhs = (assign = (PsiAssignmentExpression)expression).getLExpression()) instanceof PsiReferenceExpression && targetName.equals((reference = (PsiReferenceExpression)lhs).getReferenceName()) && reference.getQualifier() == null) {
                            return SupportAnnotationDetector.typeArrayFromArrayLiteral((PsiElement)assign.getRExpression());
                        }
                        prev = (PsiStatement)PsiTreeUtil.getPrevSiblingOfType((PsiElement)prev, PsiStatement.class);
                    }
                }
            }
        } else if (node instanceof PsiNewExpression) {
            PsiNewExpression creation = (PsiNewExpression)node;
            if (creation.getArrayInitializer() != null) {
                return true;
            }
            PsiType type = creation.getType();
            if (type instanceof PsiArrayType) {
                return true;
            }
        } else if (node instanceof PsiParenthesizedExpression) {
            PsiParenthesizedExpression parenthesizedExpression = (PsiParenthesizedExpression)node;
            PsiExpression expression = parenthesizedExpression.getExpression();
            if (expression != null) {
                return SupportAnnotationDetector.typeArrayFromArrayLiteral((PsiElement)expression);
            }
        } else if (node instanceof PsiTypeCastExpression && (operand = (castExpression = (PsiTypeCastExpression)node).getOperand()) != null) {
            return SupportAnnotationDetector.typeArrayFromArrayLiteral((PsiElement)operand);
        }
        return false;
    }

    private static void checkIntRange(JavaContext context, PsiAnnotation annotation, PsiElement argument, PsiAnnotation[] allAnnotations) {
        String message = SupportAnnotationDetector.getIntRangeError(context, annotation, argument);
        if (message != null) {
            if (SupportAnnotationDetector.findIntDef(allAnnotations) != null) {
                return;
            }
            if (SupportAnnotationDetector.isIgnoredInIde(RANGE, context, argument)) {
                return;
            }
            context.report(RANGE, argument, context.getLocation(argument), message);
        }
    }

    private static String getIntRangeError(JavaContext context, PsiAnnotation annotation, PsiElement argument) {
        Object object;
        PsiNewExpression newExpression;
        PsiArrayInitializerExpression initializer;
        if (argument instanceof PsiNewExpression && (initializer = (newExpression = (PsiNewExpression)argument).getArrayInitializer()) != null) {
            for (PsiExpression expression : initializer.getInitializers()) {
                String error = SupportAnnotationDetector.getIntRangeError(context, annotation, (PsiElement)expression);
                if (error == null) continue;
                return error;
            }
        }
        if (!((object = ConstantEvaluator.evaluate(context, argument)) instanceof Number)) {
            return null;
        }
        long value = ((Number)object).longValue();
        long from = SupportAnnotationDetector.getLongAttribute(annotation, ATTR_FROM, Long.MIN_VALUE);
        long to = SupportAnnotationDetector.getLongAttribute(annotation, ATTR_TO, Long.MAX_VALUE);
        return SupportAnnotationDetector.getIntRangeError(value, from, to);
    }

    private static String getIntRangeError(long value, long from, long to) {
        String message = null;
        if (value < from || value > to) {
            StringBuilder sb = new StringBuilder(20);
            if (value < from) {
                sb.append("Value must be \u2265 ");
                sb.append(Long.toString(from));
            } else {
                assert (value > to);
                sb.append("Value must be \u2264 ");
                sb.append(Long.toString(to));
            }
            sb.append(" (was ").append(value).append(')');
            message = sb.toString();
        }
        return message;
    }

    private static void checkFloatRange(JavaContext context, PsiAnnotation annotation, PsiElement argument) {
        boolean toInclusive;
        boolean fromInclusive;
        double to;
        double from;
        Object object = ConstantEvaluator.evaluate(context, argument);
        if (!(object instanceof Number)) {
            return;
        }
        double value = ((Number)object).doubleValue();
        String message = SupportAnnotationDetector.getFloatRangeError(value, from = SupportAnnotationDetector.getDoubleAttribute(annotation, ATTR_FROM, Double.NEGATIVE_INFINITY), to = SupportAnnotationDetector.getDoubleAttribute(annotation, ATTR_TO, Double.POSITIVE_INFINITY), fromInclusive = SupportAnnotationDetector.getBoolean(annotation, ATTR_FROM_INCLUSIVE, true), toInclusive = SupportAnnotationDetector.getBoolean(annotation, ATTR_TO_INCLUSIVE, true), argument);
        if (message != null && !SupportAnnotationDetector.isIgnoredInIde(RANGE, context, argument)) {
            context.report(RANGE, argument, context.getLocation(argument), message);
        }
    }

    private static String getFloatRangeError(double value, double from, double to, boolean fromInclusive, boolean toInclusive, PsiElement node) {
        if (!((fromInclusive && value >= from || !fromInclusive && value > from) && (toInclusive && value <= to || !toInclusive && value < to))) {
            StringBuilder sb = new StringBuilder(20);
            if (from != Double.NEGATIVE_INFINITY) {
                if (to != Double.POSITIVE_INFINITY) {
                    if (fromInclusive && value < from || !fromInclusive && value <= from) {
                        sb.append("Value must be ");
                        if (fromInclusive) {
                            sb.append('\u2265');
                        } else {
                            sb.append('>');
                        }
                        sb.append(' ');
                        sb.append(Double.toString(from));
                    } else {
                        assert (toInclusive && value > to || !toInclusive && value >= to);
                        sb.append("Value must be ");
                        if (toInclusive) {
                            sb.append('\u2264');
                        } else {
                            sb.append('<');
                        }
                        sb.append(' ');
                        sb.append(Double.toString(to));
                    }
                } else {
                    sb.append("Value must be ");
                    if (fromInclusive) {
                        sb.append('\u2265');
                    } else {
                        sb.append('>');
                    }
                    sb.append(' ');
                    sb.append(Double.toString(from));
                }
            } else if (to != Double.POSITIVE_INFINITY) {
                sb.append("Value must be ");
                if (toInclusive) {
                    sb.append('\u2264');
                } else {
                    sb.append('<');
                }
                sb.append(' ');
                sb.append(Double.toString(to));
            }
            sb.append(" (was ");
            if (node instanceof PsiLiteral) {
                String str = node.getText();
                if (str.endsWith("f") || str.endsWith("F")) {
                    str = str.substring(0, str.length() - 1);
                }
                sb.append(str);
            } else {
                sb.append(value);
            }
            sb.append(')');
            return sb.toString();
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void checkSize(JavaContext context, PsiAnnotation annotation, PsiElement argument) {
        int actual;
        boolean isString = false;
        if (argument instanceof PsiNewExpression) {
            PsiNewExpression newExpression = (PsiNewExpression)argument;
            PsiArrayInitializerExpression initializer = newExpression.getArrayInitializer();
            if (initializer == null) return;
            PsiExpression[] initializers = initializer.getInitializers();
            actual = initializers.length;
        } else {
            Object object = ConstantEvaluator.evaluate(context, argument);
            if (!(object instanceof String)) return;
            actual = ((String)object).length();
            isString = true;
        }
        long exact = SupportAnnotationDetector.getLongAttribute(annotation, "value", -1L);
        long min = SupportAnnotationDetector.getLongAttribute(annotation, ATTR_MIN, Long.MIN_VALUE);
        long max = SupportAnnotationDetector.getLongAttribute(annotation, ATTR_MAX, Long.MAX_VALUE);
        long multiple = SupportAnnotationDetector.getLongAttribute(annotation, ATTR_MULTIPLE, 1L);
        String unit = isString ? "length" : "size";
        String message = SupportAnnotationDetector.getSizeError(actual, exact, min, max, multiple, unit);
        if (message == null || SupportAnnotationDetector.isIgnoredInIde(RANGE, context, argument)) return;
        context.report(RANGE, argument, context.getLocation(argument), message);
    }

    private static String getSizeError(long actual, long exact, long min, long max, long multiple, String unit) {
        String message = null;
        if (exact != -1L) {
            if (exact != actual) {
                message = String.format("Expected %1$s %2$d (was %3$d)", unit, exact, actual);
            }
        } else if (actual < min || actual > max) {
            StringBuilder sb = new StringBuilder(20);
            if (actual < min) {
                sb.append("Expected ").append(unit).append(" \u2265 ");
                sb.append(Long.toString(min));
            } else {
                assert (actual > max);
                sb.append("Expected ").append(unit).append(" \u2264 ");
                sb.append(Long.toString(max));
            }
            sb.append(" (was ").append(actual).append(')');
            message = sb.toString();
        } else if (actual % multiple != 0L) {
            message = String.format("Expected %1$s to be a multiple of %2$d (was %3$d and should be either %4$d or %5$d)", unit, multiple, actual, actual / multiple * multiple, (actual / multiple + 1L) * multiple);
        }
        return message;
    }

    private static PsiAnnotation findIntRange(PsiAnnotation[] annotations) {
        for (PsiAnnotation annotation : annotations) {
            if (!INT_RANGE_ANNOTATION.equals(annotation.getQualifiedName())) continue;
            return annotation;
        }
        return null;
    }

    static PsiAnnotation findIntDef(PsiAnnotation[] annotations) {
        for (PsiAnnotation annotation : annotations) {
            if (!"android.support.annotation.IntDef".equals(annotation.getQualifiedName())) continue;
            return annotation;
        }
        return null;
    }

    private static void checkTypeDefConstant(JavaContext context, PsiAnnotation annotation, PsiElement argument, PsiElement errorNode, boolean flag, PsiAnnotation[] allAnnotations) {
        block20: {
            PsiNewExpression newExpression;
            PsiArrayInitializerExpression initializer;
            block29: {
                PsiElement resolved;
                block30: {
                    block27: {
                        PsiBinaryExpression expression;
                        block28: {
                            block26: {
                                block25: {
                                    block22: {
                                        IElementType operator;
                                        block24: {
                                            PsiPrefixExpression expression2;
                                            block23: {
                                                block21: {
                                                    block18: {
                                                        long v;
                                                        Object value;
                                                        block19: {
                                                            if (argument == null) {
                                                                return;
                                                            }
                                                            if (!(argument instanceof PsiLiteral)) break block18;
                                                            value = ((PsiLiteral)argument).getValue();
                                                            if (value == null) {
                                                                return;
                                                            }
                                                            if (!(value instanceof String)) break block19;
                                                            String string = (String)value;
                                                            SupportAnnotationDetector.checkTypeDefConstant(context, annotation, argument, errorNode, false, string, allAnnotations);
                                                            break block20;
                                                        }
                                                        if (!(value instanceof Integer) && !(value instanceof Long)) break block20;
                                                        long l = v = value instanceof Long ? ((Long)value).longValue() : ((Integer)value).longValue();
                                                        if (flag && v == 0L) {
                                                            return;
                                                        }
                                                        SupportAnnotationDetector.checkTypeDefConstant(context, annotation, argument, errorNode, flag, value, allAnnotations);
                                                        break block20;
                                                    }
                                                    if (!SupportAnnotationDetector.isMinusOne(argument)) break block21;
                                                    if (flag) break block20;
                                                    SupportAnnotationDetector.reportTypeDef(context, annotation, argument, errorNode, allAnnotations);
                                                    break block20;
                                                }
                                                if (!(argument instanceof PsiPrefixExpression)) break block22;
                                                expression2 = (PsiPrefixExpression)argument;
                                                if (!flag) break block23;
                                                SupportAnnotationDetector.checkTypeDefConstant(context, annotation, (PsiElement)expression2.getOperand(), errorNode, true, allAnnotations);
                                                break block20;
                                            }
                                            operator = expression2.getOperationTokenType();
                                            if (operator != JavaTokenType.TILDE) break block24;
                                            if (SupportAnnotationDetector.isIgnoredInIde(TYPE_DEF, context, (PsiElement)expression2)) {
                                                return;
                                            }
                                            context.report(TYPE_DEF, (PsiElement)expression2, context.getLocation((PsiElement)expression2), "Flag not allowed here");
                                            break block20;
                                        }
                                        if (operator != JavaTokenType.MINUS) break block20;
                                        SupportAnnotationDetector.reportTypeDef(context, annotation, argument, errorNode, allAnnotations);
                                        break block20;
                                    }
                                    if (!(argument instanceof PsiParenthesizedExpression)) break block25;
                                    PsiExpression expression3 = ((PsiParenthesizedExpression)argument).getExpression();
                                    if (expression3 == null) break block20;
                                    SupportAnnotationDetector.checkTypeDefConstant(context, annotation, (PsiElement)expression3, errorNode, flag, allAnnotations);
                                    break block20;
                                }
                                if (!(argument instanceof PsiConditionalExpression)) break block26;
                                PsiConditionalExpression expression4 = (PsiConditionalExpression)argument;
                                if (expression4.getThenExpression() != null) {
                                    SupportAnnotationDetector.checkTypeDefConstant(context, annotation, (PsiElement)expression4.getThenExpression(), errorNode, flag, allAnnotations);
                                }
                                if (expression4.getElseExpression() == null) break block20;
                                SupportAnnotationDetector.checkTypeDefConstant(context, annotation, (PsiElement)expression4.getElseExpression(), errorNode, flag, allAnnotations);
                                break block20;
                            }
                            if (!(argument instanceof PsiBinaryExpression)) break block27;
                            expression = (PsiBinaryExpression)argument;
                            if (!flag) break block28;
                            SupportAnnotationDetector.checkTypeDefConstant(context, annotation, (PsiElement)expression.getLOperand(), errorNode, true, allAnnotations);
                            SupportAnnotationDetector.checkTypeDefConstant(context, annotation, (PsiElement)expression.getROperand(), errorNode, true, allAnnotations);
                            break block20;
                        }
                        IElementType operator = expression.getOperationTokenType();
                        if (operator != JavaTokenType.AND && operator != JavaTokenType.OR && operator != JavaTokenType.XOR) break block20;
                        if (SupportAnnotationDetector.isIgnoredInIde(TYPE_DEF, context, (PsiElement)expression)) {
                            return;
                        }
                        context.report(TYPE_DEF, (PsiElement)expression, context.getLocation((PsiElement)expression), "Flag not allowed here");
                        break block20;
                    }
                    if (!(argument instanceof PsiReference)) break block29;
                    resolved = ((PsiReference)argument).resolve();
                    if (!(resolved instanceof PsiField)) break block30;
                    PsiField field = (PsiField)resolved;
                    if (field.getType() instanceof PsiArrayType) {
                        return;
                    }
                    if (!context.getEvaluator().isStatic((PsiModifierListOwner)field) || !context.getEvaluator().isFinal((PsiModifierListOwner)field)) break block20;
                    SupportAnnotationDetector.checkTypeDefConstant(context, annotation, argument, errorNode != null ? errorNode : argument, flag, resolved, allAnnotations);
                    break block20;
                }
                if (!(resolved instanceof PsiLocalVariable)) break block20;
                PsiLocalVariable variable = (PsiLocalVariable)resolved;
                PsiStatement statement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)argument, PsiStatement.class, (boolean)false);
                if (statement != null) {
                    PsiStatement prev = (PsiStatement)PsiTreeUtil.getPrevSiblingOfType((PsiElement)statement, PsiStatement.class);
                    String targetName = variable.getName();
                    if (targetName == null) {
                        return;
                    }
                    while (prev != null) {
                        PsiReferenceExpression reference;
                        PsiAssignmentExpression assign;
                        PsiExpression lhs;
                        PsiExpression expression;
                        if (prev instanceof PsiDeclarationStatement) {
                            for (PsiElement element : ((PsiDeclarationStatement)prev).getDeclaredElements()) {
                                if (!variable.equals(element)) continue;
                                SupportAnnotationDetector.checkTypeDefConstant(context, annotation, (PsiElement)variable.getInitializer(), errorNode != null ? errorNode : argument, flag, allAnnotations);
                                return;
                            }
                        } else if (prev instanceof PsiExpressionStatement && (expression = ((PsiExpressionStatement)prev).getExpression()) instanceof PsiAssignmentExpression && (lhs = (assign = (PsiAssignmentExpression)expression).getLExpression()) instanceof PsiReferenceExpression && targetName.equals((reference = (PsiReferenceExpression)lhs).getReferenceName()) && reference.getQualifier() == null) {
                            SupportAnnotationDetector.checkTypeDefConstant(context, annotation, (PsiElement)assign.getRExpression(), errorNode != null ? errorNode : argument, flag, allAnnotations);
                            return;
                        }
                        prev = (PsiStatement)PsiTreeUtil.getPrevSiblingOfType((PsiElement)prev, PsiStatement.class);
                    }
                }
                break block20;
            }
            if (argument instanceof PsiNewExpression && (initializer = (newExpression = (PsiNewExpression)argument).getArrayInitializer()) != null) {
                PsiType type = initializer.getType();
                if (type != null) {
                    type = type.getDeepComponentType();
                }
                if (PsiType.INT.equals((Object)type) || PsiType.LONG.equals((Object)type)) {
                    for (PsiExpression expression : initializer.getInitializers()) {
                        SupportAnnotationDetector.checkTypeDefConstant(context, annotation, (PsiElement)expression, errorNode, flag, allAnnotations);
                    }
                }
            }
        }
    }

    private static void checkTypeDefConstant(JavaContext context, PsiAnnotation annotation, PsiElement argument, PsiElement errorNode, boolean flag, Object value, PsiAnnotation[] allAnnotations) {
        PsiAnnotation rangeAnnotation = SupportAnnotationDetector.findIntRange(allAnnotations);
        if (rangeAnnotation != null && SupportAnnotationDetector.getIntRangeError(context, rangeAnnotation, argument) == null) {
            return;
        }
        PsiAnnotationMemberValue allowed = SupportAnnotationDetector.getAnnotationValue(annotation);
        if (allowed == null) {
            return;
        }
        if (allowed instanceof PsiArrayInitializerMemberValue) {
            PsiField astNode;
            PsiExpression initializer;
            PsiAnnotationMemberValue[] initializers;
            PsiArrayInitializerMemberValue initializerExpression = (PsiArrayInitializerMemberValue)allowed;
            for (PsiAnnotationMemberValue expression : initializers = initializerExpression.getInitializers()) {
                PsiElement resolved;
                if (!(expression instanceof PsiLiteral ? value.equals(((PsiLiteral)expression).getValue()) : expression instanceof PsiReference && (resolved = ((PsiReference)expression).resolve()) != null && resolved.equals(value))) continue;
                return;
            }
            if (value instanceof PsiField && (initializer = (astNode = (PsiField)value).getInitializer()) != null) {
                SupportAnnotationDetector.checkTypeDefConstant(context, annotation, (PsiElement)initializer, errorNode, flag, allAnnotations);
                return;
            }
            SupportAnnotationDetector.reportTypeDef(context, argument, errorNode, flag, initializers, allAnnotations);
        }
    }

    private static void reportTypeDef(JavaContext context, PsiAnnotation annotation, PsiElement argument, PsiElement errorNode, PsiAnnotation[] allAnnotations) {
        PsiAnnotationMemberValue allowed = SupportAnnotationDetector.getAnnotationValue(annotation);
        if (allowed instanceof PsiArrayInitializerMemberValue) {
            PsiArrayInitializerMemberValue initializerExpression = (PsiArrayInitializerMemberValue)allowed;
            PsiAnnotationMemberValue[] initializers = initializerExpression.getInitializers();
            SupportAnnotationDetector.reportTypeDef(context, argument, errorNode, false, initializers, allAnnotations);
        }
    }

    private static void reportTypeDef(JavaContext context, PsiElement node, PsiElement errorNode, boolean flag, PsiAnnotationMemberValue[] allowedValues, PsiAnnotation[] allAnnotations) {
        String rangeError;
        if (errorNode == null) {
            errorNode = node;
        }
        if (SupportAnnotationDetector.isIgnoredInIde(TYPE_DEF, context, errorNode)) {
            return;
        }
        String values = SupportAnnotationDetector.listAllowedValues(allowedValues);
        String message = flag ? "Must be one or more of: " + values : "Must be one of: " + values;
        PsiAnnotation rangeAnnotation = SupportAnnotationDetector.findIntRange(allAnnotations);
        if (rangeAnnotation != null && (rangeError = SupportAnnotationDetector.getIntRangeError(context, rangeAnnotation, node)) != null && !rangeError.isEmpty()) {
            message = message + " or " + Character.toLowerCase(rangeError.charAt(0)) + rangeError.substring(1);
        }
        context.report(TYPE_DEF, errorNode, context.getLocation(errorNode), message);
    }

    private static PsiAnnotationMemberValue getAnnotationValue(PsiAnnotation annotation) {
        PsiNameValuePair[] attributes;
        for (PsiNameValuePair pair : attributes = annotation.getParameterList().getAttributes()) {
            if (pair.getName() != null && !pair.getName().equals("value")) continue;
            return pair.getValue();
        }
        return null;
    }

    private static String listAllowedValues(PsiAnnotationMemberValue[] allowedValues) {
        StringBuilder sb = new StringBuilder();
        for (PsiAnnotationMemberValue allowedValue : allowedValues) {
            PsiElement resolved;
            String s = null;
            if (allowedValue instanceof PsiReference && (resolved = ((PsiReference)allowedValue).resolve()) instanceof PsiField) {
                String containingClassName;
                PsiField field = (PsiField)resolved;
                String string = containingClassName = field.getContainingClass() != null ? field.getContainingClass().getName() : null;
                if (containingClassName == null) continue;
                s = containingClassName + "." + field.getName();
            }
            if (s == null) {
                s = allowedValue.getText();
            }
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(s);
        }
        return sb.toString();
    }

    static double getDoubleAttribute(PsiAnnotation annotation, String name, double defaultValue) {
        Double value = PermissionRequirement.getAnnotationDoubleValue(annotation, name);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    static long getLongAttribute(PsiAnnotation annotation, String name, long defaultValue) {
        Long value = PermissionRequirement.getAnnotationLongValue(annotation, name);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    static boolean getBoolean(PsiAnnotation annotation, String name, boolean defaultValue) {
        Boolean value = PermissionRequirement.getAnnotationBooleanValue(annotation, name);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    static PsiAnnotation[] filterRelevantAnnotations(JavaEvaluator evaluator, PsiAnnotation[] annotations) {
        ArrayList<PsiAnnotation> result = null;
        int length = annotations.length;
        if (length == 0) {
            return annotations;
        }
        for (PsiAnnotation annotation : annotations) {
            PsiElement resolved;
            PsiJavaCodeReferenceElement ref;
            String signature = annotation.getQualifiedName();
            if (signature == null || signature.startsWith("java.")) continue;
            if (signature.startsWith("android.support.annotation.")) {
                if (signature.endsWith(".Nullable") || signature.endsWith(".NonNull")) continue;
                if (length == 1) {
                    return annotations;
                }
                if (result == null) {
                    result = new ArrayList<PsiAnnotation>(2);
                }
                result.add(annotation);
            }
            if ((ref = annotation.getNameReferenceElement()) == null || !((resolved = ref.resolve()) instanceof PsiClass) || !((PsiClass)resolved).isAnnotationType()) continue;
            PsiClass cls = (PsiClass)resolved;
            PsiAnnotation[] innerAnnotations = evaluator.getAllAnnotations((PsiModifierListOwner)cls, false);
            for (int j = 0; j < innerAnnotations.length; ++j) {
                PsiAnnotation inner = innerAnnotations[j];
                String a = inner.getQualifiedName();
                if (a == null || a.startsWith("java.") || !a.equals("android.support.annotation.IntDef") && !a.equals(PERMISSION_ANNOTATION) && !a.equals(INT_RANGE_ANNOTATION) && !a.equals("android.support.annotation.StringDef")) continue;
                if (length == 1 && j == innerAnnotations.length - 1 && result == null) {
                    return innerAnnotations;
                }
                if (result == null) {
                    result = new ArrayList(2);
                }
                result.add(inner);
            }
        }
        return result != null ? result.toArray(PsiAnnotation.EMPTY_ARRAY) : PsiAnnotation.EMPTY_ARRAY;
    }

    @Override
    public List<Class<? extends PsiElement>> getApplicablePsiTypes() {
        ArrayList<Class<? extends PsiElement>> types = new ArrayList<Class<? extends PsiElement>>(2);
        types.add(PsiCallExpression.class);
        types.add(PsiEnumConstant.class);
        return types;
    }

    @Override
    public JavaElementVisitor createPsiVisitor(JavaContext context) {
        return new CallVisitor(context);
    }

    private class CallVisitor
    extends JavaElementVisitor {
        private final JavaContext mContext;

        public CallVisitor(JavaContext context) {
            this.mContext = context;
        }

        public void visitCallExpression(PsiCallExpression call) {
            PsiMethod method = call.resolveMethod();
            if (method != null) {
                this.checkCall(method, (PsiCall)call);
            }
        }

        public void visitEnumConstant(PsiEnumConstant call) {
            PsiMethod method = call.resolveMethod();
            if (method != null) {
                this.checkCall(method, (PsiCall)call);
            }
        }

        public void checkCall(PsiMethod method, PsiCall call) {
            PsiExpressionList argumentList;
            PsiAnnotation[] classAnnotations;
            JavaEvaluator evaluator = this.mContext.getEvaluator();
            PsiAnnotation[] methodAnnotations = evaluator.getAllAnnotations((PsiModifierListOwner)method, true);
            methodAnnotations = SupportAnnotationDetector.filterRelevantAnnotations(evaluator, methodAnnotations);
            PsiClass containingClass = method.getContainingClass();
            if (containingClass != null) {
                classAnnotations = evaluator.getAllAnnotations((PsiModifierListOwner)containingClass, true);
                classAnnotations = SupportAnnotationDetector.filterRelevantAnnotations(evaluator, classAnnotations);
            } else {
                classAnnotations = PsiAnnotation.EMPTY_ARRAY;
            }
            for (PsiAnnotation annotation : methodAnnotations) {
                SupportAnnotationDetector.this.checkMethodAnnotation(this.mContext, method, (PsiElement)call, annotation, methodAnnotations, classAnnotations);
            }
            if (classAnnotations.length > 0) {
                for (PsiAnnotation annotation : classAnnotations) {
                    SupportAnnotationDetector.this.checkMethodAnnotation(this.mContext, method, (PsiElement)call, annotation, methodAnnotations, classAnnotations);
                }
            }
            if ((argumentList = call.getArgumentList()) != null) {
                int i;
                PsiExpression[] arguments = argumentList.getExpressions();
                PsiParameterList parameterList = method.getParameterList();
                PsiParameter[] parameters = parameterList.getParameters();
                PsiAnnotation[] annotations = null;
                int n = Math.min(parameters.length, arguments.length);
                for (i = 0; i < n; ++i) {
                    PsiExpression argument = arguments[i];
                    PsiParameter parameter = parameters[i];
                    annotations = evaluator.getAllAnnotations((PsiModifierListOwner)parameter, true);
                    annotations = SupportAnnotationDetector.filterRelevantAnnotations(evaluator, annotations);
                    SupportAnnotationDetector.this.checkParameterAnnotations(this.mContext, argument, call, method, annotations);
                }
                if (annotations != null) {
                    for (i = parameters.length; i < arguments.length; ++i) {
                        PsiExpression argument = arguments[i];
                        SupportAnnotationDetector.this.checkParameterAnnotations(this.mContext, argument, call, method, annotations);
                    }
                }
            }
        }
    }

    private static class CheckPermissionVisitor
    extends JavaRecursiveElementVisitor {
        private boolean mChecksPermission;
        private boolean mDone;
        private final PsiElement mTarget;

        public CheckPermissionVisitor(PsiElement target) {
            this.mTarget = target;
        }

        public void visitElement(PsiElement element) {
            if (!this.mDone) {
                super.visitElement(element);
            }
        }

        public void visitMethodCallExpression(PsiMethodCallExpression node) {
            String name;
            if (node == this.mTarget) {
                this.mDone = true;
            }
            if ((name = node.getMethodExpression().getReferenceName()) != null && (name.startsWith("check") || name.startsWith("enforce")) && name.endsWith("Permission")) {
                this.mChecksPermission = true;
                this.mDone = true;
            }
        }

        public boolean checksPermission() {
            return this.mChecksPermission;
        }
    }
}

