/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coldFusion.UI.editorActions.completionProviders;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.coldFusion.model.info.CfmlLangInfo;
import com.intellij.coldFusion.model.psi.CfmlReference;
import com.intellij.coldFusion.model.psi.CfmlReferenceExpression;
import com.intellij.coldFusion.model.psi.impl.CfmlTagImpl;
import com.intellij.psi.PsiElement;
import com.intellij.util.ProcessingContext;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CfmlPredefinedVariablesCompletion
extends CompletionProvider<CompletionParameters> {
    protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/coldFusion/UI/editorActions/completionProviders/CfmlPredefinedVariablesCompletion", "addCompletions"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/coldFusion/UI/editorActions/completionProviders/CfmlPredefinedVariablesCompletion", "addCompletions"));
        }
        Map<String, Integer> myPredefinedVariables = CfmlLangInfo.getInstance(parameters.getPosition().getProject()).getPredefinedVariables();
        String tagName = CfmlPredefinedVariablesCompletion.getNameForCfmlTag(parameters);
        for (String s : myPredefinedVariables.keySet()) {
            if (s.contains("[x]")) continue;
            if (tagName != null && s.startsWith(tagName)) {
                result.addElement((LookupElement)LookupElementBuilder.create((String)s.substring(s.indexOf(".") + 1)).withCaseSensitivity(false));
                continue;
            }
            if (tagName != null || result.getPrefixMatcher().getPrefix().isEmpty() || !(parameters.getPosition().getParent() instanceof CfmlReference)) continue;
            result.addElement((LookupElement)LookupElementBuilder.create((String)s).withCaseSensitivity(false));
        }
    }

    @Nullable
    private static String getNameForCfmlTag(@NotNull CompletionParameters pars) {
        PsiElement resElem;
        if (pars == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pars", "com/intellij/coldFusion/UI/editorActions/completionProviders/CfmlPredefinedVariablesCompletion", "getNameForCfmlTag"));
        }
        PsiElement elem = pars.getPosition().getParent().getFirstChild();
        if (elem instanceof CfmlReferenceExpression && (resElem = ((CfmlReferenceExpression)elem).resolve()) != null) {
            PsiElement parent = resElem.getParent();
            if (!(parent instanceof CfmlTagImpl)) {
                return null;
            }
            String name = ((CfmlTagImpl)parent).getTagName();
            return name.startsWith("cf") ? name.substring(2) : name;
        }
        return null;
    }
}

