/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coldFusion.model.psi;

import com.intellij.coldFusion.model.CfmlLanguage;
import com.intellij.coldFusion.model.files.CfmlFile;
import com.intellij.coldFusion.model.files.CfmlFileType;
import com.intellij.coldFusion.model.parsers.CfmlElementTypes;
import com.intellij.coldFusion.model.psi.CfmlAttribute;
import com.intellij.coldFusion.model.psi.CfmlFileReferenceSet;
import com.intellij.coldFusion.model.psi.CfmlPsiElement;
import com.intellij.coldFusion.model.psi.CfmlPsiUtil;
import com.intellij.coldFusion.model.psi.CfmlScopeProvider;
import com.intellij.coldFusion.model.psi.CfmlTag;
import com.intellij.extapi.psi.StubBasedPsiElementBase;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.NamedStub;
import com.intellij.psi.stubs.StubElement;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class CfmlCompositeElement
extends StubBasedPsiElementBase<NamedStub>
implements CfmlPsiElement,
CfmlScopeProvider {
    @NonNls
    private static final String TEMPLATE_ATTR_NAME = "template";
    private static final FileType[] CFML_FILE_TYPES = new FileType[]{CfmlFileType.INSTANCE};

    public CfmlCompositeElement(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/coldFusion/model/psi/CfmlCompositeElement", "<init>"));
        }
        super(node);
    }

    public CfmlCompositeElement(@NotNull NamedStub stub, @NotNull IStubElementType nodeType) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "com/intellij/coldFusion/model/psi/CfmlCompositeElement", "<init>"));
        }
        if (nodeType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeType", "com/intellij/coldFusion/model/psi/CfmlCompositeElement", "<init>"));
        }
        super((StubElement)stub, nodeType);
    }

    @NotNull
    public CfmlFile getContainingFile() {
        CfmlFile cfmlFile = (CfmlFile)super.getContainingFile();
        if (cfmlFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coldFusion/model/psi/CfmlCompositeElement", "getContainingFile"));
        }
        return cfmlFile;
    }

    @NotNull
    public Language getLanguage() {
        CfmlLanguage cfmlLanguage = CfmlLanguage.INSTANCE;
        if (cfmlLanguage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coldFusion/model/psi/CfmlCompositeElement", "getLanguage"));
        }
        return cfmlLanguage;
    }

    public String toString() {
        return this.getNode().getElementType().toString();
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/coldFusion/model/psi/CfmlCompositeElement", "processDeclarations"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/coldFusion/model/psi/CfmlCompositeElement", "processDeclarations"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/coldFusion/model/psi/CfmlCompositeElement", "processDeclarations"));
        }
        return CfmlPsiUtil.processDeclarations(processor, state, lastParent, place);
    }

    @Override
    public int getProvidedScope() {
        return 17;
    }

    @NotNull
    public PsiReference[] getReferences() {
        PsiElement parent = this.getParent();
        if (parent.getNode().getElementType() == CfmlElementTypes.ATTRIBUTE) {
            String localName = ((CfmlAttribute)parent).getAttributeName();
            PsiElement parentTag = parent.getParent();
            if (TEMPLATE_ATTR_NAME.equalsIgnoreCase(localName) && parentTag.getNode().getElementType() == CfmlElementTypes.TAG && (((CfmlTag)parentTag).getTagName().equals("cfinclude") || ((CfmlTag)parentTag).getTagName().equalsIgnoreCase("cfmodule"))) {
                FileReference[] refs = new CfmlFileReferenceSet(this, 0).getAllReferences();
                if (refs == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coldFusion/model/psi/CfmlCompositeElement", "getReferences"));
                }
                return refs;
            }
        }
        if (parent.getNode().getElementType() == CfmlElementTypes.INCLUDEEXPRESSION) {
            FileReference[] fileReferenceArray = new CfmlFileReferenceSet(this, 1).getAllReferences();
            if (fileReferenceArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coldFusion/model/psi/CfmlCompositeElement", "getReferences"));
            }
            return fileReferenceArray;
        }
        PsiReference[] psiReferenceArray = super.getReferences();
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coldFusion/model/psi/CfmlCompositeElement", "getReferences"));
        }
        return psiReferenceArray;
    }
}

