/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.stylus.parser;

import com.intellij.lang.ASTNode;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiParser;
import com.intellij.lang.css.CSSParserDefinition;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.project.Project;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiFile;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.stylus.lexer.StylusLexer;
import org.jetbrains.plugins.stylus.parser.StylusParser;
import org.jetbrains.plugins.stylus.psi.StylusElementTypes;
import org.jetbrains.plugins.stylus.psi.StylusTokenTypes;
import org.jetbrains.plugins.stylus.psi.impl.StylusFileImpl;

public class StylusParserDefinition
extends CSSParserDefinition {
    @NotNull
    public Lexer createLexer(Project project) {
        StylusLexer stylusLexer = new StylusLexer();
        if (stylusLexer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/stylus/parser/StylusParserDefinition", "createLexer"));
        }
        return stylusLexer;
    }

    public IFileElementType getFileNodeType() {
        return StylusElementTypes.STYLUS_FILE;
    }

    @NotNull
    public TokenSet getCommentTokens() {
        TokenSet tokenSet = StylusTokenTypes.COMMENTS;
        if (tokenSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/stylus/parser/StylusParserDefinition", "getCommentTokens"));
        }
        return tokenSet;
    }

    @NotNull
    public TokenSet getWhitespaceTokens() {
        TokenSet tokenSet = TokenSet.orSet((TokenSet[])new TokenSet[]{TokenSet.create((IElementType[])new IElementType[]{StylusTokenTypes.INDENT, StylusTokenTypes.EOL}), CssElementTypes.WHITESPACES});
        if (tokenSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/stylus/parser/StylusParserDefinition", "getWhitespaceTokens"));
        }
        return tokenSet;
    }

    public PsiFile createFile(FileViewProvider viewProvider) {
        return new StylusFileImpl(viewProvider);
    }

    @NotNull
    public PsiParser createParser(Project project) {
        PsiParser psiParser = new PsiParser(){

            @NotNull
            public ASTNode parse(IElementType root, PsiBuilder builder) {
                ASTNode aSTNode = new StylusParser().parse(root, builder);
                if (aSTNode == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/stylus/parser/StylusParserDefinition$1", "parse"));
                }
                return aSTNode;
            }
        };
        if (psiParser == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/stylus/parser/StylusParserDefinition", "createParser"));
        }
        return psiParser;
    }
}

