/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.analysis;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.BitSet;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jf.dexlib2.AccessFlags;
import org.jf.dexlib2.Opcode;
import org.jf.dexlib2.analysis.AnalysisException;
import org.jf.dexlib2.analysis.AnalyzedInstruction;
import org.jf.dexlib2.analysis.ArrayProto;
import org.jf.dexlib2.analysis.ClassPath;
import org.jf.dexlib2.analysis.InlineMethodResolver;
import org.jf.dexlib2.analysis.OdexedFieldInstructionMapper;
import org.jf.dexlib2.analysis.RegisterType;
import org.jf.dexlib2.analysis.TypeProto;
import org.jf.dexlib2.analysis.UnresolvedOdexInstruction;
import org.jf.dexlib2.iface.ClassDef;
import org.jf.dexlib2.iface.ExceptionHandler;
import org.jf.dexlib2.iface.Method;
import org.jf.dexlib2.iface.MethodImplementation;
import org.jf.dexlib2.iface.MethodParameter;
import org.jf.dexlib2.iface.TryBlock;
import org.jf.dexlib2.iface.instruction.FiveRegisterInstruction;
import org.jf.dexlib2.iface.instruction.Instruction;
import org.jf.dexlib2.iface.instruction.NarrowLiteralInstruction;
import org.jf.dexlib2.iface.instruction.OffsetInstruction;
import org.jf.dexlib2.iface.instruction.OneRegisterInstruction;
import org.jf.dexlib2.iface.instruction.ReferenceInstruction;
import org.jf.dexlib2.iface.instruction.RegisterRangeInstruction;
import org.jf.dexlib2.iface.instruction.SwitchElement;
import org.jf.dexlib2.iface.instruction.SwitchPayload;
import org.jf.dexlib2.iface.instruction.ThreeRegisterInstruction;
import org.jf.dexlib2.iface.instruction.TwoRegisterInstruction;
import org.jf.dexlib2.iface.instruction.VtableIndexInstruction;
import org.jf.dexlib2.iface.instruction.formats.Instruction22cs;
import org.jf.dexlib2.iface.instruction.formats.Instruction35c;
import org.jf.dexlib2.iface.instruction.formats.Instruction35mi;
import org.jf.dexlib2.iface.instruction.formats.Instruction35ms;
import org.jf.dexlib2.iface.instruction.formats.Instruction3rc;
import org.jf.dexlib2.iface.instruction.formats.Instruction3rmi;
import org.jf.dexlib2.iface.instruction.formats.Instruction3rms;
import org.jf.dexlib2.iface.reference.FieldReference;
import org.jf.dexlib2.iface.reference.MethodReference;
import org.jf.dexlib2.iface.reference.Reference;
import org.jf.dexlib2.iface.reference.TypeReference;
import org.jf.dexlib2.immutable.instruction.ImmutableInstruction;
import org.jf.dexlib2.immutable.instruction.ImmutableInstruction10x;
import org.jf.dexlib2.immutable.instruction.ImmutableInstruction21c;
import org.jf.dexlib2.immutable.instruction.ImmutableInstruction22c;
import org.jf.dexlib2.immutable.instruction.ImmutableInstruction35c;
import org.jf.dexlib2.immutable.instruction.ImmutableInstruction3rc;
import org.jf.dexlib2.immutable.reference.ImmutableFieldReference;
import org.jf.dexlib2.immutable.reference.ImmutableMethodReference;
import org.jf.dexlib2.util.MethodUtil;
import org.jf.dexlib2.util.ReferenceUtil;
import org.jf.dexlib2.util.TypeUtils;
import org.jf.util.BitSetUtils;
import org.jf.util.ExceptionWithContext;
import org.jf.util.SparseArray;

public class MethodAnalyzer {
    @Nonnull
    private final Method method;
    @Nonnull
    private final MethodImplementation methodImpl;
    private final int paramRegisterCount;
    @Nonnull
    private final ClassPath classPath;
    @Nullable
    private final InlineMethodResolver inlineResolver;
    @Nonnull
    private final SparseArray<AnalyzedInstruction> analyzedInstructions = new SparseArray(0);
    @Nonnull
    private final BitSet analyzedState;
    @Nullable
    private AnalysisException analysisException = null;
    private final AnalyzedInstruction startOfMethod;
    private static final BitSet Primitive32BitCategories = BitSetUtils.bitSetOfIndexes((int[])new int[]{2, 3, 4, 5, 6, 7, 8, 9, 10, 11});
    private static final BitSet WideLowCategories = BitSetUtils.bitSetOfIndexes((int[])new int[]{12, 14});
    private static final BitSet WideHighCategories = BitSetUtils.bitSetOfIndexes((int[])new int[]{13, 15});
    private static final BitSet ReferenceOrUninitCategories = BitSetUtils.bitSetOfIndexes((int[])new int[]{2, 16, 17, 18});
    private static final BitSet BooleanCategories = BitSetUtils.bitSetOfIndexes((int[])new int[]{2, 3, 4});

    public MethodAnalyzer(@Nonnull ClassPath classPath, @Nonnull Method method, @Nullable InlineMethodResolver inlineResolver) {
        this.classPath = classPath;
        this.inlineResolver = inlineResolver;
        this.method = method;
        MethodImplementation methodImpl = method.getImplementation();
        if (methodImpl == null) {
            throw new IllegalArgumentException("The method has no implementation");
        }
        this.methodImpl = methodImpl;
        this.startOfMethod = new AnalyzedInstruction(null, -1, methodImpl.getRegisterCount()){

            @Override
            public boolean setsRegister() {
                return false;
            }

            @Override
            public boolean setsWideRegister() {
                return false;
            }

            @Override
            public boolean setsRegister(int registerNumber) {
                return false;
            }

            @Override
            public int getDestinationRegister() {
                assert (false);
                return -1;
            }
        };
        this.buildInstructionList();
        this.analyzedState = new BitSet(this.analyzedInstructions.size());
        this.paramRegisterCount = MethodUtil.getParameterRegisterCount(method);
        this.analyze();
    }

    /*
     * Unable to fully structure code
     */
    private void analyze() {
        method = this.method;
        methodImpl = this.methodImpl;
        totalRegisters = methodImpl.getRegisterCount();
        parameterRegisters = this.paramRegisterCount;
        nonParameterRegisters = totalRegisters - parameterRegisters;
        if (!MethodUtil.isStatic(method)) {
            thisRegister = totalRegisters - parameterRegisters;
            if (MethodUtil.isConstructor(method)) {
                this.setPostRegisterTypeAndPropagateChanges(this.startOfMethod, thisRegister, RegisterType.getRegisterType((byte)17, this.classPath.getClass(method.getDefiningClass())));
            } else {
                this.setPostRegisterTypeAndPropagateChanges(this.startOfMethod, thisRegister, RegisterType.getRegisterType((byte)18, this.classPath.getClass(method.getDefiningClass())));
            }
            this.propagateParameterTypes(totalRegisters - parameterRegisters + 1);
        } else {
            this.propagateParameterTypes(totalRegisters - parameterRegisters);
        }
        uninit = RegisterType.getRegisterType((byte)1, null);
        for (i = 0; i < nonParameterRegisters; ++i) {
            this.setPostRegisterTypeAndPropagateChanges(this.startOfMethod, i, uninit);
        }
        instructionsToAnalyze = new BitSet(this.analyzedInstructions.size());
        for (AnalyzedInstruction successor : this.startOfMethod.successors) {
            instructionsToAnalyze.set(successor.instructionIndex);
        }
        undeodexedInstructions = new BitSet(this.analyzedInstructions.size());
        block13: while (true) {
            didSomething = false;
            while (!instructionsToAnalyze.isEmpty()) {
                i = instructionsToAnalyze.nextSetBit(0);
                while (i >= 0) {
                    block26: {
                        instructionsToAnalyze.clear(i);
                        if (!this.analyzedState.get(i)) {
                            instructionToAnalyze = (AnalyzedInstruction)this.analyzedInstructions.valueAt(i);
                            try {
                                if (instructionToAnalyze.originalInstruction.getOpcode().odexOnly()) {
                                    instructionToAnalyze.restoreOdexedInstruction();
                                }
                                if (!this.analyzeInstruction(instructionToAnalyze)) {
                                    undeodexedInstructions.set(i);
                                    break block26;
                                }
                                didSomething = true;
                                undeodexedInstructions.clear(i);
                            }
                            catch (AnalysisException ex) {
                                this.analysisException = ex;
                                ex.codeAddress = codeAddress = this.getInstructionAddress(instructionToAnalyze);
                                ex.addContext(String.format("opcode: %s", new Object[]{instructionToAnalyze.instruction.getOpcode().name}));
                                ex.addContext(String.format("code address: %d", new Object[]{codeAddress}));
                                ex.addContext(String.format("method: %s", new Object[]{ReferenceUtil.getReferenceString(method)}));
                                break;
                            }
                            this.analyzedState.set(instructionToAnalyze.getInstructionIndex());
                            for (AnalyzedInstruction successor : instructionToAnalyze.successors) {
                                instructionsToAnalyze.set(successor.getInstructionIndex());
                            }
                        }
                    }
                    i = instructionsToAnalyze.nextSetBit(i + 1);
                }
                if (this.analysisException == null) continue;
            }
            if (!didSomething) break;
            if (undeodexedInstructions.isEmpty()) continue;
            i = undeodexedInstructions.nextSetBit(0);
            while (true) {
                if (i >= 0) ** break;
                continue block13;
                instructionsToAnalyze.set(i);
                i = undeodexedInstructions.nextSetBit(i + 1);
            }
            break;
        }
        block18: for (i = 0; i < this.analyzedInstructions.size(); ++i) {
            analyzedInstruction = (AnalyzedInstruction)this.analyzedInstructions.valueAt(i);
            instruction = analyzedInstruction.getInstruction();
            if (!instruction.getOpcode().odexOnly()) continue;
            switch (3.$SwitchMap$org$jf$dexlib2$Format[instruction.getOpcode().format.ordinal()]) {
                case 1: {
                    this.analyzeReturnVoidBarrier(analyzedInstruction, false);
                    continue block18;
                }
                case 2: 
                case 3: {
                    this.analyzePutGetVolatile(analyzedInstruction, false);
                    continue block18;
                }
                case 4: {
                    this.analyzeInvokeDirectEmpty(analyzedInstruction, false);
                    continue block18;
                }
                case 5: {
                    this.analyzeInvokeObjectInitRange(analyzedInstruction, false);
                    continue block18;
                }
                case 6: {
                    objectRegisterNumber = ((Instruction22cs)instruction).getRegisterB();
                    break;
                }
                case 7: 
                case 8: {
                    objectRegisterNumber = ((FiveRegisterInstruction)instruction).getRegisterC();
                    break;
                }
                case 9: 
                case 10: {
                    objectRegisterNumber = ((RegisterRangeInstruction)instruction).getStartRegister();
                    break;
                }
                default: {
                    continue block18;
                }
            }
            analyzedInstruction.setDeodexedInstruction(new UnresolvedOdexInstruction(instruction, objectRegisterNumber));
        }
    }

    private void propagateParameterTypes(int parameterStartRegister) {
        int i = 0;
        for (MethodParameter methodParameter : this.method.getParameters()) {
            if (TypeUtils.isWideType(methodParameter)) {
                this.setPostRegisterTypeAndPropagateChanges(this.startOfMethod, parameterStartRegister + i++, RegisterType.getWideRegisterType(methodParameter, true));
                this.setPostRegisterTypeAndPropagateChanges(this.startOfMethod, parameterStartRegister + i++, RegisterType.getWideRegisterType(methodParameter, false));
                continue;
            }
            this.setPostRegisterTypeAndPropagateChanges(this.startOfMethod, parameterStartRegister + i++, RegisterType.getRegisterType(this.classPath, methodParameter));
        }
    }

    public List<AnalyzedInstruction> getAnalyzedInstructions() {
        return this.analyzedInstructions.getValues();
    }

    public List<Instruction> getInstructions() {
        return Lists.transform((List)this.analyzedInstructions.getValues(), (Function)new Function<AnalyzedInstruction, Instruction>(){

            @Nullable
            public Instruction apply(@Nullable AnalyzedInstruction input) {
                if (input == null) {
                    return null;
                }
                return input.instruction;
            }
        });
    }

    @Nullable
    public AnalysisException getAnalysisException() {
        return this.analysisException;
    }

    public int getParamRegisterCount() {
        return this.paramRegisterCount;
    }

    public int getInstructionAddress(@Nonnull AnalyzedInstruction instruction) {
        return this.analyzedInstructions.keyAt(instruction.instructionIndex);
    }

    private void setDestinationRegisterTypeAndPropagateChanges(@Nonnull AnalyzedInstruction analyzedInstruction, @Nonnull RegisterType registerType) {
        this.setPostRegisterTypeAndPropagateChanges(analyzedInstruction, analyzedInstruction.getDestinationRegister(), registerType);
    }

    private void setPostRegisterTypeAndPropagateChanges(@Nonnull AnalyzedInstruction analyzedInstruction, int registerNumber, @Nonnull RegisterType registerType) {
        BitSet changedInstructions = new BitSet(this.analyzedInstructions.size());
        if (!analyzedInstruction.setPostRegisterType(registerNumber, registerType)) {
            return;
        }
        this.propagateRegisterToSuccessors(analyzedInstruction, registerNumber, changedInstructions);
        while (!changedInstructions.isEmpty()) {
            int instructionIndex = changedInstructions.nextSetBit(0);
            while (instructionIndex >= 0) {
                changedInstructions.clear(instructionIndex);
                this.propagateRegisterToSuccessors((AnalyzedInstruction)this.analyzedInstructions.valueAt(instructionIndex), registerNumber, changedInstructions);
                instructionIndex = changedInstructions.nextSetBit(instructionIndex + 1);
            }
        }
        if (registerType.category == 12) {
            MethodAnalyzer.checkWidePair(registerNumber, analyzedInstruction);
            this.setPostRegisterTypeAndPropagateChanges(analyzedInstruction, registerNumber + 1, RegisterType.LONG_HI_TYPE);
        } else if (registerType.category == 14) {
            MethodAnalyzer.checkWidePair(registerNumber, analyzedInstruction);
            this.setPostRegisterTypeAndPropagateChanges(analyzedInstruction, registerNumber + 1, RegisterType.DOUBLE_HI_TYPE);
        }
    }

    private void propagateRegisterToSuccessors(@Nonnull AnalyzedInstruction instruction, int registerNumber, @Nonnull BitSet changedInstructions) {
        RegisterType postRegisterType = instruction.getPostInstructionRegisterType(registerNumber);
        for (AnalyzedInstruction successor : instruction.successors) {
            if (!successor.mergeRegister(registerNumber, postRegisterType, this.analyzedState)) continue;
            changedInstructions.set(successor.instructionIndex);
        }
    }

    private void buildInstructionList() {
        int registerCount = this.methodImpl.getRegisterCount();
        ImmutableList instructions = ImmutableList.copyOf(this.methodImpl.getInstructions());
        this.analyzedInstructions.ensureCapacity(instructions.size());
        int currentCodeAddress = 0;
        for (int i = 0; i < instructions.size(); ++i) {
            Instruction instruction = (Instruction)instructions.get(i);
            this.analyzedInstructions.append(currentCodeAddress, (Object)new AnalyzedInstruction(instruction, i, registerCount));
            assert (this.analyzedInstructions.indexOfKey(currentCodeAddress) == i);
            currentCodeAddress += instruction.getCodeUnits();
        }
        List<? extends TryBlock<? extends ExceptionHandler>> tries = this.methodImpl.getTryBlocks();
        int triesIndex = 0;
        TryBlock<? extends ExceptionHandler> currentTry = null;
        AnalyzedInstruction[] currentExceptionHandlers = null;
        AnalyzedInstruction[][] exceptionHandlers = new AnalyzedInstruction[instructions.size()][];
        if (tries != null) {
            for (int i = 0; i < this.analyzedInstructions.size(); ++i) {
                TryBlock<? extends ExceptionHandler> tryBlock;
                AnalyzedInstruction instruction = (AnalyzedInstruction)this.analyzedInstructions.valueAt(i);
                Opcode instructionOpcode = instruction.instruction.getOpcode();
                currentCodeAddress = this.getInstructionAddress(instruction);
                if (currentTry != null && currentTry.getStartCodeAddress() + currentTry.getCodeUnitCount() <= currentCodeAddress) {
                    currentTry = null;
                    ++triesIndex;
                }
                if (currentTry == null && triesIndex < tries.size() && (tryBlock = tries.get(triesIndex)).getStartCodeAddress() <= currentCodeAddress) {
                    assert (tryBlock.getStartCodeAddress() + tryBlock.getCodeUnitCount() > currentCodeAddress);
                    currentTry = tryBlock;
                    currentExceptionHandlers = this.buildExceptionHandlerArray(tryBlock);
                }
                if (currentTry == null || !instructionOpcode.canThrow()) continue;
                exceptionHandlers[i] = currentExceptionHandlers;
            }
        }
        assert (this.analyzedInstructions.size() > 0);
        BitSet instructionsToProcess = new BitSet(instructions.size());
        this.addPredecessorSuccessor(this.startOfMethod, (AnalyzedInstruction)this.analyzedInstructions.valueAt(0), exceptionHandlers, instructionsToProcess);
        while (!instructionsToProcess.isEmpty()) {
            int currentInstructionIndex = instructionsToProcess.nextSetBit(0);
            instructionsToProcess.clear(currentInstructionIndex);
            AnalyzedInstruction instruction = (AnalyzedInstruction)this.analyzedInstructions.valueAt(currentInstructionIndex);
            Opcode instructionOpcode = instruction.instruction.getOpcode();
            int instructionCodeAddress = this.getInstructionAddress(instruction);
            if (instruction.instruction.getOpcode().canContinue()) {
                if (currentInstructionIndex == this.analyzedInstructions.size() - 1) {
                    throw new AnalysisException("Execution can continue past the last instruction", new Object[0]);
                }
                AnalyzedInstruction nextInstruction = (AnalyzedInstruction)this.analyzedInstructions.valueAt(currentInstructionIndex + 1);
                this.addPredecessorSuccessor(instruction, nextInstruction, exceptionHandlers, instructionsToProcess);
            }
            if (!(instruction.instruction instanceof OffsetInstruction)) continue;
            OffsetInstruction offsetInstruction = (OffsetInstruction)instruction.instruction;
            if (instructionOpcode == Opcode.PACKED_SWITCH || instructionOpcode == Opcode.SPARSE_SWITCH) {
                SwitchPayload switchPayload = (SwitchPayload)((AnalyzedInstruction)this.analyzedInstructions.get((int)(instructionCodeAddress + offsetInstruction.getCodeOffset()))).instruction;
                for (SwitchElement switchElement : switchPayload.getSwitchElements()) {
                    AnalyzedInstruction targetInstruction = (AnalyzedInstruction)this.analyzedInstructions.get(instructionCodeAddress + switchElement.getOffset());
                    this.addPredecessorSuccessor(instruction, targetInstruction, exceptionHandlers, instructionsToProcess);
                }
                continue;
            }
            if (instructionOpcode == Opcode.FILL_ARRAY_DATA) continue;
            int targetAddressOffset = offsetInstruction.getCodeOffset();
            AnalyzedInstruction targetInstruction = (AnalyzedInstruction)this.analyzedInstructions.get(instructionCodeAddress + targetAddressOffset);
            this.addPredecessorSuccessor(instruction, targetInstruction, exceptionHandlers, instructionsToProcess);
        }
    }

    private void addPredecessorSuccessor(@Nonnull AnalyzedInstruction predecessor, @Nonnull AnalyzedInstruction successor, @Nonnull AnalyzedInstruction[][] exceptionHandlers, @Nonnull BitSet instructionsToProcess) {
        this.addPredecessorSuccessor(predecessor, successor, exceptionHandlers, instructionsToProcess, false);
    }

    private void addPredecessorSuccessor(@Nonnull AnalyzedInstruction predecessor, @Nonnull AnalyzedInstruction successor, @Nonnull AnalyzedInstruction[][] exceptionHandlers, @Nonnull BitSet instructionsToProcess, boolean allowMoveException) {
        if (!allowMoveException && successor.instruction.getOpcode() == Opcode.MOVE_EXCEPTION) {
            throw new AnalysisException("Execution can pass from the " + predecessor.instruction.getOpcode().name + " instruction at code address 0x" + Integer.toHexString(this.getInstructionAddress(predecessor)) + " to the move-exception instruction at address 0x" + Integer.toHexString(this.getInstructionAddress(successor)), new Object[0]);
        }
        if (!successor.addPredecessor(predecessor)) {
            return;
        }
        predecessor.addSuccessor(successor);
        instructionsToProcess.set(successor.getInstructionIndex());
        AnalyzedInstruction[] exceptionHandlersForSuccessor = exceptionHandlers[successor.instructionIndex];
        if (exceptionHandlersForSuccessor != null) {
            assert (successor.instruction.getOpcode().canThrow());
            for (AnalyzedInstruction exceptionHandler : exceptionHandlersForSuccessor) {
                this.addPredecessorSuccessor(predecessor, exceptionHandler, exceptionHandlers, instructionsToProcess, true);
            }
        }
    }

    @Nonnull
    private AnalyzedInstruction[] buildExceptionHandlerArray(@Nonnull TryBlock<? extends ExceptionHandler> tryBlock) {
        List<? extends ExceptionHandler> exceptionHandlers = tryBlock.getExceptionHandlers();
        AnalyzedInstruction[] handlerInstructions = new AnalyzedInstruction[exceptionHandlers.size()];
        for (int i = 0; i < exceptionHandlers.size(); ++i) {
            handlerInstructions[i] = (AnalyzedInstruction)this.analyzedInstructions.get(exceptionHandlers.get(i).getHandlerCodeAddress());
        }
        return handlerInstructions;
    }

    private boolean analyzeInstruction(@Nonnull AnalyzedInstruction analyzedInstruction) {
        Instruction instruction = analyzedInstruction.instruction;
        switch (instruction.getOpcode()) {
            case NOP: {
                return true;
            }
            case MOVE: 
            case MOVE_FROM16: 
            case MOVE_16: 
            case MOVE_WIDE: 
            case MOVE_WIDE_FROM16: 
            case MOVE_WIDE_16: 
            case MOVE_OBJECT: 
            case MOVE_OBJECT_FROM16: 
            case MOVE_OBJECT_16: {
                this.analyzeMove(analyzedInstruction);
                return true;
            }
            case MOVE_RESULT: 
            case MOVE_RESULT_WIDE: 
            case MOVE_RESULT_OBJECT: {
                this.analyzeMoveResult(analyzedInstruction);
                return true;
            }
            case MOVE_EXCEPTION: {
                this.analyzeMoveException(analyzedInstruction);
                return true;
            }
            case RETURN_VOID: 
            case RETURN: 
            case RETURN_WIDE: 
            case RETURN_OBJECT: {
                return true;
            }
            case RETURN_VOID_BARRIER: {
                this.analyzeReturnVoidBarrier(analyzedInstruction);
                return true;
            }
            case CONST_4: 
            case CONST_16: 
            case CONST: 
            case CONST_HIGH16: {
                this.analyzeConst(analyzedInstruction);
                return true;
            }
            case CONST_WIDE_16: 
            case CONST_WIDE_32: 
            case CONST_WIDE: 
            case CONST_WIDE_HIGH16: {
                this.analyzeWideConst(analyzedInstruction);
                return true;
            }
            case CONST_STRING: 
            case CONST_STRING_JUMBO: {
                this.analyzeConstString(analyzedInstruction);
                return true;
            }
            case CONST_CLASS: {
                this.analyzeConstClass(analyzedInstruction);
                return true;
            }
            case MONITOR_ENTER: 
            case MONITOR_EXIT: {
                return true;
            }
            case CHECK_CAST: {
                this.analyzeCheckCast(analyzedInstruction);
                return true;
            }
            case INSTANCE_OF: {
                this.analyzeInstanceOf(analyzedInstruction);
                return true;
            }
            case ARRAY_LENGTH: {
                this.analyzeArrayLength(analyzedInstruction);
                return true;
            }
            case NEW_INSTANCE: {
                this.analyzeNewInstance(analyzedInstruction);
                return true;
            }
            case NEW_ARRAY: {
                this.analyzeNewArray(analyzedInstruction);
                return true;
            }
            case FILLED_NEW_ARRAY: 
            case FILLED_NEW_ARRAY_RANGE: {
                return true;
            }
            case FILL_ARRAY_DATA: {
                return true;
            }
            case THROW: 
            case GOTO: 
            case GOTO_16: 
            case GOTO_32: {
                return true;
            }
            case PACKED_SWITCH: 
            case SPARSE_SWITCH: {
                return true;
            }
            case CMPL_FLOAT: 
            case CMPG_FLOAT: 
            case CMPL_DOUBLE: 
            case CMPG_DOUBLE: 
            case CMP_LONG: {
                this.analyzeFloatWideCmp(analyzedInstruction);
                return true;
            }
            case IF_EQ: 
            case IF_NE: 
            case IF_LT: 
            case IF_GE: 
            case IF_GT: 
            case IF_LE: 
            case IF_EQZ: 
            case IF_NEZ: 
            case IF_LTZ: 
            case IF_GEZ: 
            case IF_GTZ: 
            case IF_LEZ: {
                return true;
            }
            case AGET: {
                this.analyze32BitPrimitiveAget(analyzedInstruction, RegisterType.INTEGER_TYPE);
                return true;
            }
            case AGET_BOOLEAN: {
                this.analyze32BitPrimitiveAget(analyzedInstruction, RegisterType.BOOLEAN_TYPE);
                return true;
            }
            case AGET_BYTE: {
                this.analyze32BitPrimitiveAget(analyzedInstruction, RegisterType.BYTE_TYPE);
                return true;
            }
            case AGET_CHAR: {
                this.analyze32BitPrimitiveAget(analyzedInstruction, RegisterType.CHAR_TYPE);
                return true;
            }
            case AGET_SHORT: {
                this.analyze32BitPrimitiveAget(analyzedInstruction, RegisterType.SHORT_TYPE);
                return true;
            }
            case AGET_WIDE: {
                this.analyzeAgetWide(analyzedInstruction);
                return true;
            }
            case AGET_OBJECT: {
                this.analyzeAgetObject(analyzedInstruction);
                return true;
            }
            case APUT: 
            case APUT_BOOLEAN: 
            case APUT_BYTE: 
            case APUT_CHAR: 
            case APUT_SHORT: 
            case APUT_WIDE: 
            case APUT_OBJECT: {
                return true;
            }
            case IGET: {
                this.analyze32BitPrimitiveIgetSget(analyzedInstruction, RegisterType.INTEGER_TYPE);
                return true;
            }
            case IGET_BOOLEAN: {
                this.analyze32BitPrimitiveIgetSget(analyzedInstruction, RegisterType.BOOLEAN_TYPE);
                return true;
            }
            case IGET_BYTE: {
                this.analyze32BitPrimitiveIgetSget(analyzedInstruction, RegisterType.BYTE_TYPE);
                return true;
            }
            case IGET_CHAR: {
                this.analyze32BitPrimitiveIgetSget(analyzedInstruction, RegisterType.CHAR_TYPE);
                return true;
            }
            case IGET_SHORT: {
                this.analyze32BitPrimitiveIgetSget(analyzedInstruction, RegisterType.SHORT_TYPE);
                return true;
            }
            case IGET_WIDE: 
            case IGET_OBJECT: {
                this.analyzeIgetSgetWideObject(analyzedInstruction);
                return true;
            }
            case IPUT: 
            case IPUT_BOOLEAN: 
            case IPUT_BYTE: 
            case IPUT_CHAR: 
            case IPUT_SHORT: 
            case IPUT_WIDE: 
            case IPUT_OBJECT: {
                return true;
            }
            case SGET: {
                this.analyze32BitPrimitiveIgetSget(analyzedInstruction, RegisterType.INTEGER_TYPE);
                return true;
            }
            case SGET_BOOLEAN: {
                this.analyze32BitPrimitiveIgetSget(analyzedInstruction, RegisterType.BOOLEAN_TYPE);
                return true;
            }
            case SGET_BYTE: {
                this.analyze32BitPrimitiveIgetSget(analyzedInstruction, RegisterType.BYTE_TYPE);
                return true;
            }
            case SGET_CHAR: {
                this.analyze32BitPrimitiveIgetSget(analyzedInstruction, RegisterType.CHAR_TYPE);
                return true;
            }
            case SGET_SHORT: {
                this.analyze32BitPrimitiveIgetSget(analyzedInstruction, RegisterType.SHORT_TYPE);
                return true;
            }
            case SGET_WIDE: 
            case SGET_OBJECT: {
                this.analyzeIgetSgetWideObject(analyzedInstruction);
                return true;
            }
            case SPUT: 
            case SPUT_BOOLEAN: 
            case SPUT_BYTE: 
            case SPUT_CHAR: 
            case SPUT_SHORT: 
            case SPUT_WIDE: 
            case SPUT_OBJECT: {
                return true;
            }
            case INVOKE_VIRTUAL: 
            case INVOKE_SUPER: {
                return true;
            }
            case INVOKE_DIRECT: {
                this.analyzeInvokeDirect(analyzedInstruction);
                return true;
            }
            case INVOKE_STATIC: 
            case INVOKE_INTERFACE: 
            case INVOKE_VIRTUAL_RANGE: 
            case INVOKE_SUPER_RANGE: {
                return true;
            }
            case INVOKE_DIRECT_RANGE: {
                this.analyzeInvokeDirectRange(analyzedInstruction);
                return true;
            }
            case INVOKE_STATIC_RANGE: 
            case INVOKE_INTERFACE_RANGE: {
                return true;
            }
            case NEG_INT: 
            case NOT_INT: {
                this.analyzeUnaryOp(analyzedInstruction, RegisterType.INTEGER_TYPE);
                return true;
            }
            case NEG_LONG: 
            case NOT_LONG: {
                this.analyzeUnaryOp(analyzedInstruction, RegisterType.LONG_LO_TYPE);
                return true;
            }
            case NEG_FLOAT: {
                this.analyzeUnaryOp(analyzedInstruction, RegisterType.FLOAT_TYPE);
                return true;
            }
            case NEG_DOUBLE: {
                this.analyzeUnaryOp(analyzedInstruction, RegisterType.DOUBLE_LO_TYPE);
                return true;
            }
            case INT_TO_LONG: {
                this.analyzeUnaryOp(analyzedInstruction, RegisterType.LONG_LO_TYPE);
                return true;
            }
            case INT_TO_FLOAT: {
                this.analyzeUnaryOp(analyzedInstruction, RegisterType.FLOAT_TYPE);
                return true;
            }
            case INT_TO_DOUBLE: {
                this.analyzeUnaryOp(analyzedInstruction, RegisterType.DOUBLE_LO_TYPE);
                return true;
            }
            case LONG_TO_INT: 
            case DOUBLE_TO_INT: {
                this.analyzeUnaryOp(analyzedInstruction, RegisterType.INTEGER_TYPE);
                return true;
            }
            case LONG_TO_FLOAT: 
            case DOUBLE_TO_FLOAT: {
                this.analyzeUnaryOp(analyzedInstruction, RegisterType.FLOAT_TYPE);
                return true;
            }
            case LONG_TO_DOUBLE: {
                this.analyzeUnaryOp(analyzedInstruction, RegisterType.DOUBLE_LO_TYPE);
                return true;
            }
            case FLOAT_TO_INT: {
                this.analyzeUnaryOp(analyzedInstruction, RegisterType.INTEGER_TYPE);
                return true;
            }
            case FLOAT_TO_LONG: {
                this.analyzeUnaryOp(analyzedInstruction, RegisterType.LONG_LO_TYPE);
                return true;
            }
            case FLOAT_TO_DOUBLE: {
                this.analyzeUnaryOp(analyzedInstruction, RegisterType.DOUBLE_LO_TYPE);
                return true;
            }
            case DOUBLE_TO_LONG: {
                this.analyzeUnaryOp(analyzedInstruction, RegisterType.LONG_LO_TYPE);
                return true;
            }
            case INT_TO_BYTE: {
                this.analyzeUnaryOp(analyzedInstruction, RegisterType.BYTE_TYPE);
                return true;
            }
            case INT_TO_CHAR: {
                this.analyzeUnaryOp(analyzedInstruction, RegisterType.CHAR_TYPE);
                return true;
            }
            case INT_TO_SHORT: {
                this.analyzeUnaryOp(analyzedInstruction, RegisterType.SHORT_TYPE);
                return true;
            }
            case ADD_INT: 
            case SUB_INT: 
            case MUL_INT: 
            case DIV_INT: 
            case REM_INT: 
            case SHL_INT: 
            case SHR_INT: 
            case USHR_INT: {
                this.analyzeBinaryOp(analyzedInstruction, RegisterType.INTEGER_TYPE, false);
                return true;
            }
            case AND_INT: 
            case OR_INT: 
            case XOR_INT: {
                this.analyzeBinaryOp(analyzedInstruction, RegisterType.INTEGER_TYPE, true);
                return true;
            }
            case ADD_LONG: 
            case SUB_LONG: 
            case MUL_LONG: 
            case DIV_LONG: 
            case REM_LONG: 
            case AND_LONG: 
            case OR_LONG: 
            case XOR_LONG: 
            case SHL_LONG: 
            case SHR_LONG: 
            case USHR_LONG: {
                this.analyzeBinaryOp(analyzedInstruction, RegisterType.LONG_LO_TYPE, false);
                return true;
            }
            case ADD_FLOAT: 
            case SUB_FLOAT: 
            case MUL_FLOAT: 
            case DIV_FLOAT: 
            case REM_FLOAT: {
                this.analyzeBinaryOp(analyzedInstruction, RegisterType.FLOAT_TYPE, false);
                return true;
            }
            case ADD_DOUBLE: 
            case SUB_DOUBLE: 
            case MUL_DOUBLE: 
            case DIV_DOUBLE: 
            case REM_DOUBLE: {
                this.analyzeBinaryOp(analyzedInstruction, RegisterType.DOUBLE_LO_TYPE, false);
                return true;
            }
            case ADD_INT_2ADDR: 
            case SUB_INT_2ADDR: 
            case MUL_INT_2ADDR: 
            case DIV_INT_2ADDR: 
            case REM_INT_2ADDR: 
            case SHL_INT_2ADDR: 
            case SHR_INT_2ADDR: 
            case USHR_INT_2ADDR: {
                this.analyzeBinary2AddrOp(analyzedInstruction, RegisterType.INTEGER_TYPE, false);
                return true;
            }
            case AND_INT_2ADDR: 
            case OR_INT_2ADDR: 
            case XOR_INT_2ADDR: {
                this.analyzeBinary2AddrOp(analyzedInstruction, RegisterType.INTEGER_TYPE, true);
                return true;
            }
            case ADD_LONG_2ADDR: 
            case SUB_LONG_2ADDR: 
            case MUL_LONG_2ADDR: 
            case DIV_LONG_2ADDR: 
            case REM_LONG_2ADDR: 
            case AND_LONG_2ADDR: 
            case OR_LONG_2ADDR: 
            case XOR_LONG_2ADDR: 
            case SHL_LONG_2ADDR: 
            case SHR_LONG_2ADDR: 
            case USHR_LONG_2ADDR: {
                this.analyzeBinary2AddrOp(analyzedInstruction, RegisterType.LONG_LO_TYPE, false);
                return true;
            }
            case ADD_FLOAT_2ADDR: 
            case SUB_FLOAT_2ADDR: 
            case MUL_FLOAT_2ADDR: 
            case DIV_FLOAT_2ADDR: 
            case REM_FLOAT_2ADDR: {
                this.analyzeBinary2AddrOp(analyzedInstruction, RegisterType.FLOAT_TYPE, false);
                return true;
            }
            case ADD_DOUBLE_2ADDR: 
            case SUB_DOUBLE_2ADDR: 
            case MUL_DOUBLE_2ADDR: 
            case DIV_DOUBLE_2ADDR: 
            case REM_DOUBLE_2ADDR: {
                this.analyzeBinary2AddrOp(analyzedInstruction, RegisterType.DOUBLE_LO_TYPE, false);
                return true;
            }
            case ADD_INT_LIT16: 
            case RSUB_INT: 
            case MUL_INT_LIT16: 
            case DIV_INT_LIT16: 
            case REM_INT_LIT16: {
                this.analyzeLiteralBinaryOp(analyzedInstruction, RegisterType.INTEGER_TYPE, false);
                return true;
            }
            case AND_INT_LIT16: 
            case OR_INT_LIT16: 
            case XOR_INT_LIT16: {
                this.analyzeLiteralBinaryOp(analyzedInstruction, RegisterType.INTEGER_TYPE, true);
                return true;
            }
            case ADD_INT_LIT8: 
            case RSUB_INT_LIT8: 
            case MUL_INT_LIT8: 
            case DIV_INT_LIT8: 
            case REM_INT_LIT8: 
            case SHL_INT_LIT8: {
                this.analyzeLiteralBinaryOp(analyzedInstruction, RegisterType.INTEGER_TYPE, false);
                return true;
            }
            case AND_INT_LIT8: 
            case OR_INT_LIT8: 
            case XOR_INT_LIT8: {
                this.analyzeLiteralBinaryOp(analyzedInstruction, RegisterType.INTEGER_TYPE, true);
                return true;
            }
            case SHR_INT_LIT8: {
                this.analyzeLiteralBinaryOp(analyzedInstruction, this.getDestTypeForLiteralShiftRight(analyzedInstruction, true), false);
                return true;
            }
            case USHR_INT_LIT8: {
                this.analyzeLiteralBinaryOp(analyzedInstruction, this.getDestTypeForLiteralShiftRight(analyzedInstruction, false), false);
                return true;
            }
            case IGET_VOLATILE: 
            case IPUT_VOLATILE: 
            case SGET_VOLATILE: 
            case SPUT_VOLATILE: 
            case IGET_OBJECT_VOLATILE: 
            case IGET_WIDE_VOLATILE: 
            case IPUT_WIDE_VOLATILE: 
            case SGET_WIDE_VOLATILE: 
            case SPUT_WIDE_VOLATILE: {
                this.analyzePutGetVolatile(analyzedInstruction);
                return true;
            }
            case THROW_VERIFICATION_ERROR: {
                return true;
            }
            case EXECUTE_INLINE: {
                this.analyzeExecuteInline(analyzedInstruction);
                return true;
            }
            case EXECUTE_INLINE_RANGE: {
                this.analyzeExecuteInlineRange(analyzedInstruction);
                return true;
            }
            case INVOKE_DIRECT_EMPTY: {
                this.analyzeInvokeDirectEmpty(analyzedInstruction);
                return true;
            }
            case INVOKE_OBJECT_INIT_RANGE: {
                this.analyzeInvokeObjectInitRange(analyzedInstruction);
                return true;
            }
            case IGET_QUICK: 
            case IGET_WIDE_QUICK: 
            case IGET_OBJECT_QUICK: 
            case IPUT_QUICK: 
            case IPUT_WIDE_QUICK: 
            case IPUT_OBJECT_QUICK: {
                return this.analyzeIputIgetQuick(analyzedInstruction);
            }
            case INVOKE_VIRTUAL_QUICK: {
                return this.analyzeInvokeVirtualQuick(analyzedInstruction, false, false);
            }
            case INVOKE_SUPER_QUICK: {
                return this.analyzeInvokeVirtualQuick(analyzedInstruction, true, false);
            }
            case INVOKE_VIRTUAL_QUICK_RANGE: {
                return this.analyzeInvokeVirtualQuick(analyzedInstruction, false, true);
            }
            case INVOKE_SUPER_QUICK_RANGE: {
                return this.analyzeInvokeVirtualQuick(analyzedInstruction, true, true);
            }
            case IPUT_OBJECT_VOLATILE: 
            case SGET_OBJECT_VOLATILE: 
            case SPUT_OBJECT_VOLATILE: {
                this.analyzePutGetVolatile(analyzedInstruction);
                return true;
            }
        }
        assert (false);
        return true;
    }

    private void analyzeMove(@Nonnull AnalyzedInstruction analyzedInstruction) {
        TwoRegisterInstruction instruction = (TwoRegisterInstruction)analyzedInstruction.instruction;
        RegisterType sourceRegisterType = analyzedInstruction.getPreInstructionRegisterType(instruction.getRegisterB());
        this.setDestinationRegisterTypeAndPropagateChanges(analyzedInstruction, sourceRegisterType);
    }

    private void analyzeMoveResult(@Nonnull AnalyzedInstruction analyzedInstruction) {
        AnalyzedInstruction previousInstruction = (AnalyzedInstruction)this.analyzedInstructions.valueAt(analyzedInstruction.instructionIndex - 1);
        if (!previousInstruction.instruction.getOpcode().setsResult()) {
            throw new AnalysisException(analyzedInstruction.instruction.getOpcode().name + " must occur after an " + "invoke-*/fill-new-array instruction", new Object[0]);
        }
        ReferenceInstruction invokeInstruction = (ReferenceInstruction)previousInstruction.instruction;
        Reference reference = invokeInstruction.getReference();
        RegisterType resultRegisterType = reference instanceof MethodReference ? RegisterType.getRegisterType(this.classPath, ((MethodReference)reference).getReturnType()) : RegisterType.getRegisterType(this.classPath, (TypeReference)reference);
        this.setDestinationRegisterTypeAndPropagateChanges(analyzedInstruction, resultRegisterType);
    }

    private void analyzeMoveException(@Nonnull AnalyzedInstruction analyzedInstruction) {
        int instructionAddress = this.getInstructionAddress(analyzedInstruction);
        RegisterType exceptionType = RegisterType.UNKNOWN_TYPE;
        for (TryBlock<? extends ExceptionHandler> tryBlock : this.methodImpl.getTryBlocks()) {
            for (ExceptionHandler exceptionHandler : tryBlock.getExceptionHandlers()) {
                if (exceptionHandler.getHandlerCodeAddress() != instructionAddress) continue;
                String type = exceptionHandler.getExceptionType();
                if (type == null) {
                    exceptionType = RegisterType.getRegisterType((byte)18, this.classPath.getClass("Ljava/lang/Throwable;"));
                    continue;
                }
                exceptionType = RegisterType.getRegisterType((byte)18, this.classPath.getClass(type)).merge(exceptionType);
            }
        }
        if (exceptionType.category == 0) {
            throw new AnalysisException("move-exception must be the first instruction in an exception handler block", new Object[0]);
        }
        this.setDestinationRegisterTypeAndPropagateChanges(analyzedInstruction, exceptionType);
    }

    private void analyzeReturnVoidBarrier(AnalyzedInstruction analyzedInstruction) {
        this.analyzeReturnVoidBarrier(analyzedInstruction, true);
    }

    private void analyzeReturnVoidBarrier(@Nonnull AnalyzedInstruction analyzedInstruction, boolean analyzeResult) {
        ImmutableInstruction10x deodexedInstruction = new ImmutableInstruction10x(Opcode.RETURN_VOID);
        analyzedInstruction.setDeodexedInstruction(deodexedInstruction);
        if (analyzeResult) {
            this.analyzeInstruction(analyzedInstruction);
        }
    }

    private void analyzeConst(@Nonnull AnalyzedInstruction analyzedInstruction) {
        NarrowLiteralInstruction instruction = (NarrowLiteralInstruction)analyzedInstruction.instruction;
        this.setDestinationRegisterTypeAndPropagateChanges(analyzedInstruction, RegisterType.getRegisterTypeForLiteral(instruction.getNarrowLiteral()));
    }

    private void analyzeWideConst(@Nonnull AnalyzedInstruction analyzedInstruction) {
        this.setDestinationRegisterTypeAndPropagateChanges(analyzedInstruction, RegisterType.LONG_LO_TYPE);
    }

    private void analyzeConstString(@Nonnull AnalyzedInstruction analyzedInstruction) {
        TypeProto stringClass = this.classPath.getClass("Ljava/lang/String;");
        RegisterType stringType = RegisterType.getRegisterType((byte)18, stringClass);
        this.setDestinationRegisterTypeAndPropagateChanges(analyzedInstruction, stringType);
    }

    private void analyzeConstClass(@Nonnull AnalyzedInstruction analyzedInstruction) {
        TypeProto classClass = this.classPath.getClass("Ljava/lang/Class;");
        RegisterType classType = RegisterType.getRegisterType((byte)18, classClass);
        this.setDestinationRegisterTypeAndPropagateChanges(analyzedInstruction, classType);
    }

    private void analyzeCheckCast(@Nonnull AnalyzedInstruction analyzedInstruction) {
        ReferenceInstruction instruction = (ReferenceInstruction)analyzedInstruction.instruction;
        TypeReference reference = (TypeReference)instruction.getReference();
        RegisterType castRegisterType = RegisterType.getRegisterType(this.classPath, reference);
        this.setDestinationRegisterTypeAndPropagateChanges(analyzedInstruction, castRegisterType);
    }

    private void analyzeInstanceOf(@Nonnull AnalyzedInstruction analyzedInstruction) {
        this.setDestinationRegisterTypeAndPropagateChanges(analyzedInstruction, RegisterType.BOOLEAN_TYPE);
    }

    private void analyzeArrayLength(@Nonnull AnalyzedInstruction analyzedInstruction) {
        this.setDestinationRegisterTypeAndPropagateChanges(analyzedInstruction, RegisterType.INTEGER_TYPE);
    }

    private void analyzeNewInstance(@Nonnull AnalyzedInstruction analyzedInstruction) {
        ReferenceInstruction instruction = (ReferenceInstruction)analyzedInstruction.instruction;
        int register = ((OneRegisterInstruction)analyzedInstruction.instruction).getRegisterA();
        RegisterType destRegisterType = analyzedInstruction.getPostInstructionRegisterType(register);
        if (destRegisterType.category != 0) {
            assert (destRegisterType.category == 16);
            return;
        }
        TypeReference typeReference = (TypeReference)instruction.getReference();
        RegisterType classType = RegisterType.getRegisterType(this.classPath, typeReference);
        this.setDestinationRegisterTypeAndPropagateChanges(analyzedInstruction, RegisterType.getRegisterType((byte)16, classType.type));
    }

    private void analyzeNewArray(@Nonnull AnalyzedInstruction analyzedInstruction) {
        ReferenceInstruction instruction = (ReferenceInstruction)analyzedInstruction.instruction;
        TypeReference type = (TypeReference)instruction.getReference();
        if (type.getType().charAt(0) != '[') {
            throw new AnalysisException("new-array used with non-array type", new Object[0]);
        }
        RegisterType arrayType = RegisterType.getRegisterType(this.classPath, type);
        this.setDestinationRegisterTypeAndPropagateChanges(analyzedInstruction, arrayType);
    }

    private void analyzeFloatWideCmp(@Nonnull AnalyzedInstruction analyzedInstruction) {
        this.setDestinationRegisterTypeAndPropagateChanges(analyzedInstruction, RegisterType.BYTE_TYPE);
    }

    private void analyze32BitPrimitiveAget(@Nonnull AnalyzedInstruction analyzedInstruction, @Nonnull RegisterType registerType) {
        this.setDestinationRegisterTypeAndPropagateChanges(analyzedInstruction, registerType);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void analyzeAgetWide(@Nonnull AnalyzedInstruction analyzedInstruction) {
        ThreeRegisterInstruction instruction = (ThreeRegisterInstruction)analyzedInstruction.instruction;
        RegisterType arrayRegisterType = analyzedInstruction.getPreInstructionRegisterType(instruction.getRegisterB());
        if (arrayRegisterType.category != 2) {
            if (arrayRegisterType.category != 18 || !(arrayRegisterType.type instanceof ArrayProto)) {
                throw new AnalysisException("aget-wide used with non-array register: %s", arrayRegisterType.toString());
            }
            ArrayProto arrayProto = (ArrayProto)arrayRegisterType.type;
            if (arrayProto.dimensions != 1) {
                throw new AnalysisException("aget-wide used with multi-dimensional array: %s", arrayRegisterType.toString());
            }
            char arrayBaseType = arrayProto.getElementType().charAt(0);
            if (arrayBaseType == 'J') {
                this.setDestinationRegisterTypeAndPropagateChanges(analyzedInstruction, RegisterType.LONG_LO_TYPE);
                return;
            } else {
                if (arrayBaseType != 'D') throw new AnalysisException("aget-wide used with narrow array: %s", arrayRegisterType);
                this.setDestinationRegisterTypeAndPropagateChanges(analyzedInstruction, RegisterType.DOUBLE_LO_TYPE);
            }
            return;
        } else {
            this.setDestinationRegisterTypeAndPropagateChanges(analyzedInstruction, RegisterType.LONG_LO_TYPE);
        }
    }

    private void analyzeAgetObject(@Nonnull AnalyzedInstruction analyzedInstruction) {
        ThreeRegisterInstruction instruction = (ThreeRegisterInstruction)analyzedInstruction.instruction;
        RegisterType arrayRegisterType = analyzedInstruction.getPreInstructionRegisterType(instruction.getRegisterB());
        if (arrayRegisterType.category != 2) {
            if (arrayRegisterType.category != 18 || !(arrayRegisterType.type instanceof ArrayProto)) {
                throw new AnalysisException("aget-object used with non-array register: %s", arrayRegisterType.toString());
            }
            ArrayProto arrayProto = (ArrayProto)arrayRegisterType.type;
            String elementType = arrayProto.getImmediateElementType();
            this.setDestinationRegisterTypeAndPropagateChanges(analyzedInstruction, RegisterType.getRegisterType((byte)18, this.classPath.getClass(elementType)));
        } else {
            this.setDestinationRegisterTypeAndPropagateChanges(analyzedInstruction, RegisterType.NULL_TYPE);
        }
    }

    private void analyze32BitPrimitiveIgetSget(@Nonnull AnalyzedInstruction analyzedInstruction, @Nonnull RegisterType registerType) {
        this.setDestinationRegisterTypeAndPropagateChanges(analyzedInstruction, registerType);
    }

    private void analyzeIgetSgetWideObject(@Nonnull AnalyzedInstruction analyzedInstruction) {
        ReferenceInstruction referenceInstruction = (ReferenceInstruction)analyzedInstruction.instruction;
        FieldReference fieldReference = (FieldReference)referenceInstruction.getReference();
        RegisterType fieldType = RegisterType.getRegisterType(this.classPath, fieldReference.getType());
        this.setDestinationRegisterTypeAndPropagateChanges(analyzedInstruction, fieldType);
    }

    private void analyzeInvokeDirect(@Nonnull AnalyzedInstruction analyzedInstruction) {
        FiveRegisterInstruction instruction = (FiveRegisterInstruction)analyzedInstruction.instruction;
        this.analyzeInvokeDirectCommon(analyzedInstruction, instruction.getRegisterC());
    }

    private void analyzeInvokeDirectRange(@Nonnull AnalyzedInstruction analyzedInstruction) {
        RegisterRangeInstruction instruction = (RegisterRangeInstruction)analyzedInstruction.instruction;
        this.analyzeInvokeDirectCommon(analyzedInstruction, instruction.getStartRegister());
    }

    private void analyzeInvokeDirectCommon(@Nonnull AnalyzedInstruction analyzedInstruction, int objectRegister) {
        ReferenceInstruction instruction = (ReferenceInstruction)analyzedInstruction.instruction;
        MethodReference methodReference = (MethodReference)instruction.getReference();
        if (!methodReference.getName().equals("<init>")) {
            return;
        }
        RegisterType objectRegisterType = analyzedInstruction.getPreInstructionRegisterType(objectRegister);
        if (objectRegisterType.category != 16 && objectRegisterType.category != 17) {
            return;
        }
        this.setPostRegisterTypeAndPropagateChanges(analyzedInstruction, objectRegister, RegisterType.getRegisterType((byte)18, objectRegisterType.type));
        for (int i = 0; i < analyzedInstruction.postRegisterMap.length; ++i) {
            RegisterType postInstructionRegisterType = analyzedInstruction.postRegisterMap[i];
            if (postInstructionRegisterType.category != 0) continue;
            RegisterType preInstructionRegisterType = analyzedInstruction.getPreInstructionRegisterType(i);
            if (preInstructionRegisterType.category != 16 && preInstructionRegisterType.category != 17) continue;
            RegisterType registerType = preInstructionRegisterType.equals(objectRegisterType) ? analyzedInstruction.postRegisterMap[objectRegister] : preInstructionRegisterType;
            this.setPostRegisterTypeAndPropagateChanges(analyzedInstruction, i, registerType);
        }
    }

    private void analyzeUnaryOp(@Nonnull AnalyzedInstruction analyzedInstruction, @Nonnull RegisterType destRegisterType) {
        this.setDestinationRegisterTypeAndPropagateChanges(analyzedInstruction, destRegisterType);
    }

    private void analyzeBinaryOp(@Nonnull AnalyzedInstruction analyzedInstruction, @Nonnull RegisterType destRegisterType, boolean checkForBoolean) {
        if (checkForBoolean) {
            ThreeRegisterInstruction instruction = (ThreeRegisterInstruction)analyzedInstruction.instruction;
            RegisterType source1RegisterType = analyzedInstruction.getPreInstructionRegisterType(instruction.getRegisterB());
            RegisterType source2RegisterType = analyzedInstruction.getPreInstructionRegisterType(instruction.getRegisterC());
            if (BooleanCategories.get(source1RegisterType.category) && BooleanCategories.get(source2RegisterType.category)) {
                destRegisterType = RegisterType.BOOLEAN_TYPE;
            }
        }
        this.setDestinationRegisterTypeAndPropagateChanges(analyzedInstruction, destRegisterType);
    }

    private void analyzeBinary2AddrOp(@Nonnull AnalyzedInstruction analyzedInstruction, @Nonnull RegisterType destRegisterType, boolean checkForBoolean) {
        if (checkForBoolean) {
            TwoRegisterInstruction instruction = (TwoRegisterInstruction)analyzedInstruction.instruction;
            RegisterType source1RegisterType = analyzedInstruction.getPreInstructionRegisterType(instruction.getRegisterA());
            RegisterType source2RegisterType = analyzedInstruction.getPreInstructionRegisterType(instruction.getRegisterB());
            if (BooleanCategories.get(source1RegisterType.category) && BooleanCategories.get(source2RegisterType.category)) {
                destRegisterType = RegisterType.BOOLEAN_TYPE;
            }
        }
        this.setDestinationRegisterTypeAndPropagateChanges(analyzedInstruction, destRegisterType);
    }

    private void analyzeLiteralBinaryOp(@Nonnull AnalyzedInstruction analyzedInstruction, @Nonnull RegisterType destRegisterType, boolean checkForBoolean) {
        if (checkForBoolean) {
            int literal;
            TwoRegisterInstruction instruction = (TwoRegisterInstruction)analyzedInstruction.instruction;
            RegisterType sourceRegisterType = analyzedInstruction.getPreInstructionRegisterType(instruction.getRegisterB());
            if (BooleanCategories.get(sourceRegisterType.category) && ((literal = ((NarrowLiteralInstruction)analyzedInstruction.instruction).getNarrowLiteral()) == 0 || literal == 1)) {
                destRegisterType = RegisterType.BOOLEAN_TYPE;
            }
        }
        this.setDestinationRegisterTypeAndPropagateChanges(analyzedInstruction, destRegisterType);
    }

    private RegisterType getDestTypeForLiteralShiftRight(@Nonnull AnalyzedInstruction analyzedInstruction, boolean signedShift) {
        TwoRegisterInstruction instruction = (TwoRegisterInstruction)analyzedInstruction.instruction;
        RegisterType sourceRegisterType = MethodAnalyzer.getAndCheckSourceRegister(analyzedInstruction, instruction.getRegisterB(), Primitive32BitCategories);
        long literalShift = ((NarrowLiteralInstruction)analyzedInstruction.instruction).getNarrowLiteral();
        if (literalShift == 0L) {
            return sourceRegisterType;
        }
        RegisterType destRegisterType = !signedShift ? RegisterType.INTEGER_TYPE : sourceRegisterType;
        literalShift &= 0x1FL;
        switch (sourceRegisterType.category) {
            case 10: 
            case 11: {
                if (!signedShift) {
                    if (literalShift > 24L) {
                        return RegisterType.POS_BYTE_TYPE;
                    }
                    if (literalShift < 16L) break;
                    return RegisterType.CHAR_TYPE;
                }
                if (literalShift >= 24L) {
                    return RegisterType.BYTE_TYPE;
                }
                if (literalShift < 16L) break;
                return RegisterType.SHORT_TYPE;
            }
            case 7: {
                if (!signedShift || literalShift < 8L) break;
                return RegisterType.BYTE_TYPE;
            }
            case 8: {
                if (literalShift < 8L) break;
                return RegisterType.POS_BYTE_TYPE;
            }
            case 9: {
                if (literalShift <= 8L) break;
                return RegisterType.POS_BYTE_TYPE;
            }
            case 5: {
                break;
            }
            case 6: {
                return RegisterType.POS_BYTE_TYPE;
            }
            case 2: 
            case 3: 
            case 4: {
                return RegisterType.NULL_TYPE;
            }
            default: {
                assert (false);
                break;
            }
        }
        return destRegisterType;
    }

    private void analyzeExecuteInline(@Nonnull AnalyzedInstruction analyzedInstruction) {
        if (this.inlineResolver == null) {
            throw new AnalysisException("Cannot analyze an odexed instruction unless we are deodexing", new Object[0]);
        }
        Instruction35mi instruction = (Instruction35mi)analyzedInstruction.instruction;
        Method resolvedMethod = this.inlineResolver.resolveExecuteInline(analyzedInstruction);
        int acccessFlags = resolvedMethod.getAccessFlags();
        Opcode deodexedOpcode = AccessFlags.STATIC.isSet(acccessFlags) ? Opcode.INVOKE_STATIC : (AccessFlags.PRIVATE.isSet(acccessFlags) ? Opcode.INVOKE_DIRECT : Opcode.INVOKE_VIRTUAL);
        ImmutableInstruction35c deodexedInstruction = new ImmutableInstruction35c(deodexedOpcode, instruction.getRegisterCount(), instruction.getRegisterC(), instruction.getRegisterD(), instruction.getRegisterE(), instruction.getRegisterF(), instruction.getRegisterG(), resolvedMethod);
        analyzedInstruction.setDeodexedInstruction(deodexedInstruction);
        this.analyzeInstruction(analyzedInstruction);
    }

    private void analyzeExecuteInlineRange(@Nonnull AnalyzedInstruction analyzedInstruction) {
        if (this.inlineResolver == null) {
            throw new AnalysisException("Cannot analyze an odexed instruction unless we are deodexing", new Object[0]);
        }
        Instruction3rmi instruction = (Instruction3rmi)analyzedInstruction.instruction;
        Method resolvedMethod = this.inlineResolver.resolveExecuteInline(analyzedInstruction);
        int acccessFlags = resolvedMethod.getAccessFlags();
        Opcode deodexedOpcode = AccessFlags.STATIC.isSet(acccessFlags) ? Opcode.INVOKE_STATIC_RANGE : (AccessFlags.PRIVATE.isSet(acccessFlags) ? Opcode.INVOKE_DIRECT_RANGE : Opcode.INVOKE_VIRTUAL_RANGE);
        ImmutableInstruction3rc deodexedInstruction = new ImmutableInstruction3rc(deodexedOpcode, instruction.getStartRegister(), instruction.getRegisterCount(), resolvedMethod);
        analyzedInstruction.setDeodexedInstruction(deodexedInstruction);
        this.analyzeInstruction(analyzedInstruction);
    }

    private void analyzeInvokeDirectEmpty(@Nonnull AnalyzedInstruction analyzedInstruction) {
        this.analyzeInvokeDirectEmpty(analyzedInstruction, true);
    }

    private void analyzeInvokeDirectEmpty(@Nonnull AnalyzedInstruction analyzedInstruction, boolean analyzeResult) {
        Instruction35c instruction = (Instruction35c)analyzedInstruction.instruction;
        ImmutableInstruction35c deodexedInstruction = new ImmutableInstruction35c(Opcode.INVOKE_DIRECT, instruction.getRegisterCount(), instruction.getRegisterC(), instruction.getRegisterD(), instruction.getRegisterE(), instruction.getRegisterF(), instruction.getRegisterG(), instruction.getReference());
        analyzedInstruction.setDeodexedInstruction(deodexedInstruction);
        if (analyzeResult) {
            this.analyzeInstruction(analyzedInstruction);
        }
    }

    private void analyzeInvokeObjectInitRange(@Nonnull AnalyzedInstruction analyzedInstruction) {
        this.analyzeInvokeObjectInitRange(analyzedInstruction, true);
    }

    private void analyzeInvokeObjectInitRange(@Nonnull AnalyzedInstruction analyzedInstruction, boolean analyzeResult) {
        Instruction3rc instruction = (Instruction3rc)analyzedInstruction.instruction;
        int startRegister = instruction.getStartRegister();
        int registerCount = 1;
        ImmutableInstruction deodexedInstruction = startRegister < 16 ? new ImmutableInstruction35c(Opcode.INVOKE_DIRECT, registerCount, startRegister, 0, 0, 0, 0, instruction.getReference()) : new ImmutableInstruction3rc(Opcode.INVOKE_DIRECT_RANGE, startRegister, registerCount, instruction.getReference());
        analyzedInstruction.setDeodexedInstruction(deodexedInstruction);
        if (analyzeResult) {
            this.analyzeInstruction(analyzedInstruction);
        }
    }

    private boolean analyzeIputIgetQuick(@Nonnull AnalyzedInstruction analyzedInstruction) {
        Instruction22cs instruction = (Instruction22cs)analyzedInstruction.instruction;
        int fieldOffset = instruction.getFieldOffset();
        RegisterType objectRegisterType = MethodAnalyzer.getAndCheckSourceRegister(analyzedInstruction, instruction.getRegisterB(), ReferenceOrUninitCategories);
        if (objectRegisterType.category == 2) {
            return false;
        }
        TypeProto objectRegisterTypeProto = objectRegisterType.type;
        assert (objectRegisterTypeProto != null);
        TypeProto classTypeProto = this.classPath.getClass(objectRegisterTypeProto.getType());
        FieldReference resolvedField = classTypeProto.getFieldByOffset(fieldOffset);
        if (resolvedField == null) {
            throw new AnalysisException("Could not resolve the field in class %s at offset %d", objectRegisterType.type.getType(), fieldOffset);
        }
        ClassDef thisClass = this.classPath.getClassDef(this.method.getDefiningClass());
        if (!this.canAccessClass(thisClass, this.classPath.getClassDef(resolvedField.getDefiningClass()))) {
            ClassDef fieldClass = this.classPath.getClassDef(objectRegisterTypeProto.getType());
            while (!this.canAccessClass(thisClass, fieldClass)) {
                String superclass = fieldClass.getSuperclass();
                if (superclass == null) {
                    throw new ExceptionWithContext("Couldn't find accessible class while resolving field %s", new Object[]{ReferenceUtil.getShortFieldDescriptor(resolvedField)});
                }
                fieldClass = this.classPath.getClassDef(superclass);
            }
            resolvedField = this.classPath.getClass(fieldClass.getType()).getFieldByOffset(fieldOffset);
            if (resolvedField == null) {
                throw new ExceptionWithContext("Couldn't find accessible class while resolving field %s", new Object[]{ReferenceUtil.getShortFieldDescriptor(resolvedField)});
            }
            resolvedField = new ImmutableFieldReference(fieldClass.getType(), resolvedField.getName(), resolvedField.getType());
        }
        String fieldType = resolvedField.getType();
        Opcode opcode = OdexedFieldInstructionMapper.getAndCheckDeodexedOpcodeForOdexedOpcode(fieldType, instruction.getOpcode());
        ImmutableInstruction22c deodexedInstruction = new ImmutableInstruction22c(opcode, (byte)instruction.getRegisterA(), (byte)instruction.getRegisterB(), resolvedField);
        analyzedInstruction.setDeodexedInstruction(deodexedInstruction);
        this.analyzeInstruction(analyzedInstruction);
        return true;
    }

    private boolean analyzeInvokeVirtualQuick(@Nonnull AnalyzedInstruction analyzedInstruction, boolean isSuper, boolean isRange) {
        ImmutableInstruction deodexedInstruction;
        VtableIndexInstruction instruction;
        MethodReference resolvedMethod;
        int objectRegister;
        int methodIndex;
        VtableIndexInstruction instruction2;
        if (isRange) {
            instruction2 = (Instruction3rms)analyzedInstruction.instruction;
            methodIndex = instruction2.getVtableIndex();
            objectRegister = instruction2.getStartRegister();
        } else {
            instruction2 = (Instruction35ms)analyzedInstruction.instruction;
            methodIndex = instruction2.getVtableIndex();
            objectRegister = instruction2.getRegisterC();
        }
        RegisterType objectRegisterType = MethodAnalyzer.getAndCheckSourceRegister(analyzedInstruction, objectRegister, ReferenceOrUninitCategories);
        TypeProto objectRegisterTypeProto = objectRegisterType.type;
        if (objectRegisterType.category == 2) {
            return false;
        }
        assert (objectRegisterTypeProto != null);
        if (isSuper) {
            TypeProto typeProto = this.classPath.getClass(this.method.getDefiningClass());
            String superclassType = typeProto.getSuperclass();
            TypeProto superType = superclassType != null ? this.classPath.getClass(superclassType) : typeProto;
            resolvedMethod = superType.getMethodByVtableIndex(methodIndex);
        } else {
            resolvedMethod = objectRegisterTypeProto.getMethodByVtableIndex(methodIndex);
        }
        if (resolvedMethod == null) {
            throw new AnalysisException("Could not resolve the method in class %s at index %d", objectRegisterType.type.getType(), methodIndex);
        }
        ClassDef thisClass = this.classPath.getClassDef(this.method.getDefiningClass());
        if (!isSuper && !this.canAccessClass(thisClass, this.classPath.getClassDef(resolvedMethod.getDefiningClass()))) {
            ClassDef methodClass = this.classPath.getClassDef(objectRegisterTypeProto.getType());
            while (!this.canAccessClass(thisClass, methodClass)) {
                String superclass = methodClass.getSuperclass();
                if (superclass == null) {
                    throw new ExceptionWithContext("Couldn't find accessible class while resolving method %s", new Object[]{ReferenceUtil.getMethodDescriptor(resolvedMethod, true)});
                }
                methodClass = this.classPath.getClassDef(superclass);
            }
            MethodReference newResolvedMethod = this.classPath.getClass(methodClass.getType()).getMethodByVtableIndex(methodIndex);
            if (newResolvedMethod == null) {
                throw new ExceptionWithContext("Couldn't find accessible class while resolving method %s", new Object[]{ReferenceUtil.getMethodDescriptor(resolvedMethod, true)});
            }
            resolvedMethod = newResolvedMethod;
            resolvedMethod = new ImmutableMethodReference(methodClass.getType(), resolvedMethod.getName(), resolvedMethod.getParameterTypes(), resolvedMethod.getReturnType());
        }
        if (isRange) {
            instruction = (Instruction3rms)analyzedInstruction.instruction;
            Opcode opcode = isSuper ? Opcode.INVOKE_SUPER_RANGE : Opcode.INVOKE_VIRTUAL_RANGE;
            deodexedInstruction = new ImmutableInstruction3rc(opcode, instruction.getStartRegister(), instruction.getRegisterCount(), resolvedMethod);
        } else {
            instruction = (Instruction35ms)analyzedInstruction.instruction;
            Opcode opcode = isSuper ? Opcode.INVOKE_SUPER : Opcode.INVOKE_VIRTUAL;
            deodexedInstruction = new ImmutableInstruction35c(opcode, instruction.getRegisterCount(), instruction.getRegisterC(), instruction.getRegisterD(), instruction.getRegisterE(), instruction.getRegisterF(), instruction.getRegisterG(), resolvedMethod);
        }
        analyzedInstruction.setDeodexedInstruction(deodexedInstruction);
        this.analyzeInstruction(analyzedInstruction);
        return true;
    }

    private boolean canAccessClass(@Nonnull ClassDef accessorClassDef, @Nonnull ClassDef accesseeClassDef) {
        if (AccessFlags.PUBLIC.isSet(accesseeClassDef.getAccessFlags())) {
            return true;
        }
        return MethodAnalyzer.getPackage(accesseeClassDef.getType()).equals(MethodAnalyzer.getPackage(accessorClassDef.getType()));
    }

    private static String getPackage(String className) {
        int lastSlash = className.lastIndexOf(47);
        if (lastSlash < 0) {
            return "";
        }
        return className.substring(1, lastSlash);
    }

    private boolean analyzePutGetVolatile(@Nonnull AnalyzedInstruction analyzedInstruction) {
        return this.analyzePutGetVolatile(analyzedInstruction, true);
    }

    private boolean analyzePutGetVolatile(@Nonnull AnalyzedInstruction analyzedInstruction, boolean analyzeResult) {
        ImmutableInstruction deodexedInstruction;
        FieldReference field = (FieldReference)((ReferenceInstruction)analyzedInstruction.instruction).getReference();
        String fieldType = field.getType();
        Opcode originalOpcode = analyzedInstruction.instruction.getOpcode();
        Opcode opcode = OdexedFieldInstructionMapper.getAndCheckDeodexedOpcodeForOdexedOpcode(fieldType, originalOpcode);
        if (originalOpcode.isOdexedStaticVolatile()) {
            OneRegisterInstruction instruction = (OneRegisterInstruction)analyzedInstruction.instruction;
            deodexedInstruction = new ImmutableInstruction21c(opcode, instruction.getRegisterA(), field);
        } else {
            TwoRegisterInstruction instruction = (TwoRegisterInstruction)analyzedInstruction.instruction;
            deodexedInstruction = new ImmutableInstruction22c(opcode, instruction.getRegisterA(), instruction.getRegisterB(), field);
        }
        analyzedInstruction.setDeodexedInstruction(deodexedInstruction);
        if (analyzeResult) {
            this.analyzeInstruction(analyzedInstruction);
        }
        return true;
    }

    @Nonnull
    private static RegisterType getAndCheckSourceRegister(@Nonnull AnalyzedInstruction analyzedInstruction, int registerNumber, BitSet validCategories) {
        assert (registerNumber >= 0 && registerNumber < analyzedInstruction.postRegisterMap.length);
        RegisterType registerType = analyzedInstruction.getPreInstructionRegisterType(registerNumber);
        MethodAnalyzer.checkRegister(registerType, registerNumber, validCategories);
        if (validCategories == WideLowCategories) {
            MethodAnalyzer.checkRegister(registerType, registerNumber, WideLowCategories);
            MethodAnalyzer.checkWidePair(registerNumber, analyzedInstruction);
            RegisterType secondRegisterType = analyzedInstruction.getPreInstructionRegisterType(registerNumber + 1);
            MethodAnalyzer.checkRegister(secondRegisterType, registerNumber + 1, WideHighCategories);
        }
        return registerType;
    }

    private static void checkRegister(RegisterType registerType, int registerNumber, BitSet validCategories) {
        if (!validCategories.get(registerType.category)) {
            throw new AnalysisException(String.format("Invalid register type %s for register v%d.", registerType.toString(), registerNumber), new Object[0]);
        }
    }

    private static void checkWidePair(int registerNumber, AnalyzedInstruction analyzedInstruction) {
        if (registerNumber + 1 >= analyzedInstruction.postRegisterMap.length) {
            throw new AnalysisException(String.format("v%d cannot be used as the first register in a wide registerpair because it is the last register.", registerNumber), new Object[0]);
        }
    }
}

