/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.freemarker.psi.files;

import com.intellij.freemarker.psi.FtlXmlRootTag;
import com.intellij.freemarker.psi.FtlXmlTag;
import com.intellij.freemarker.psi.directives.FtlSignatureDirective;
import com.intellij.freemarker.psi.files.FtlFile;
import com.intellij.lang.ASTNode;
import com.intellij.lang.folding.FoldingBuilder;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class FtlFoldingBuilder
implements FoldingBuilder,
DumbAware {
    @NotNull
    public FoldingDescriptor[] buildFoldRegions(@NotNull ASTNode node, @NotNull Document document) {
        FtlFile file;
        FtlXmlRootTag tag;
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/freemarker/psi/files/FtlFoldingBuilder", "buildFoldRegions"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/freemarker/psi/files/FtlFoldingBuilder", "buildFoldRegions"));
        }
        PsiElement element = node.getPsi();
        if (element instanceof FtlFile && (tag = (file = (FtlFile)element).getRootTag()) != null) {
            ArrayList<FoldingDescriptor> descriptors = new ArrayList<FoldingDescriptor>();
            for (FtlXmlTag subTag : tag.getSubTags()) {
                FtlFoldingBuilder.addFoldingDescriptors(descriptors, subTag);
            }
            FoldingDescriptor[] foldingDescriptorArray = descriptors.toArray(new FoldingDescriptor[descriptors.size()]);
            if (foldingDescriptorArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/psi/files/FtlFoldingBuilder", "buildFoldRegions"));
            }
            return foldingDescriptorArray;
        }
        if (FoldingDescriptor.EMPTY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/psi/files/FtlFoldingBuilder", "buildFoldRegions"));
        }
        return FoldingDescriptor.EMPTY;
    }

    private static void addFoldingDescriptors(List<FoldingDescriptor> descriptors, FtlXmlTag tag) {
        int end;
        int start;
        if (!tag.textContains('\n')) {
            return;
        }
        PsiElement nameElement = null;
        if (tag instanceof FtlSignatureDirective) {
            nameElement = ((FtlSignatureDirective)tag).getNameElement();
        }
        if (nameElement == null) {
            nameElement = tag.getStartTagNameElement();
        }
        if (nameElement != null && (start = nameElement.getTextRange().getEndOffset()) + 1 < (end = tag.getTextRange().getEndOffset() - 1)) {
            descriptors.add(new FoldingDescriptor(tag.getNode(), new TextRange(start, end)));
            for (FtlXmlTag child : tag.getSubTags()) {
                FtlFoldingBuilder.addFoldingDescriptors(descriptors, child);
            }
        }
    }

    public String getPlaceholderText(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/freemarker/psi/files/FtlFoldingBuilder", "getPlaceholderText"));
        }
        return "...";
    }

    public boolean isCollapsedByDefault(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/freemarker/psi/files/FtlFoldingBuilder", "isCollapsedByDefault"));
        }
        return false;
    }
}

