/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.data.util.nodes;

import com.intellij.spring.data.util.nodes.QueryNode;
import com.intellij.spring.data.util.nodes.SortNode;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class OrderByNode
extends QueryNode {
    private static final String BLOCK_SPLIT = "(?<=Asc|Desc)(?=[A-Z])";
    private final Set<SortNode> myOrderNodes;

    public OrderByNode(@NotNull String expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/spring/data/util/nodes/OrderByNode", "<init>"));
        }
        super(expression);
        this.myOrderNodes = new LinkedHashSet<SortNode>();
        for (String orderExpression : expression.split(BLOCK_SPLIT)) {
            this.myOrderNodes.add(new SortNode(orderExpression));
        }
    }

    @Override
    @NotNull
    public Set<? extends QueryNode> getChildren() {
        Set<SortNode> set = this.myOrderNodes;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/data/util/nodes/OrderByNode", "getChildren"));
        }
        return set;
    }
}

