/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.guice.model;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.daemon.RelatedItemLineMarkerInfo;
import com.intellij.codeInsight.daemon.RelatedItemLineMarkerProvider;
import com.intellij.codeInsight.navigation.NavigationGutterIconBuilder;
import com.intellij.guice.GuiceBundle;
import com.intellij.guice.model.GuiceInjectionUtil;
import com.intellij.guice.model.GuiceInjectorManager;
import com.intellij.guice.model.InjectionPointDescriptor;
import com.intellij.guice.model.beans.BindDescriptor;
import com.intellij.guice.model.jam.GuiceProvides;
import com.intellij.guice.model.renderers.GuiceBindingClassPsiElementListCellRenderer;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.jam.JamService;
import com.intellij.jam.reflect.JamMemberMeta;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.NotNullFunction;
import com.intellij.util.containers.ContainerUtil;
import icons.GuiceIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class GuiceInjectionsClassAnnotator
extends RelatedItemLineMarkerProvider {
    private final PsiElementListCellRenderer BINDING_CLASS_CELL_RENDERER = new GuiceBindingClassPsiElementListCellRenderer();
    public static final NotNullFunction<BindDescriptor, Collection<? extends PsiElement>> DEFAULT_CONVERTOR = o -> ContainerUtil.createMaybeSingletonList((Object)o.getBindExpression());

    protected void collectNavigationMarkers(@NotNull PsiElement psiElement, Collection<? super RelatedItemLineMarkerInfo> result) {
        Module module;
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/guice/model/GuiceInjectionsClassAnnotator", "collectNavigationMarkers"));
        }
        if (psiElement instanceof PsiClass) {
            module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiElement);
            if (module == null) {
                return;
            }
            PsiClass psiClass = (PsiClass)psiElement;
            this.annotateClassBindings(result, module, psiClass);
        }
        if (psiElement instanceof PsiMethod) {
            module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiElement);
            if (module == null) {
                return;
            }
            if ("configure".equals(((PsiMethod)psiElement).getName())) {
                GuiceInjectionsClassAnnotator.annotateInjectionPoints(result, module, psiElement);
            }
            if (AnnotationUtil.isAnnotated((PsiModifierListOwner)((PsiMethod)psiElement), (String)"com.google.inject.Provides", (boolean)false)) {
                GuiceInjectionsClassAnnotator.annotateProvidesInjectionPoints(result, module, (PsiMethod)psiElement);
            }
        }
    }

    private void annotateClassBindings(Collection<? super RelatedItemLineMarkerInfo> result, Module module, PsiClass psiClass) {
        Set<InjectionPointDescriptor> points = GuiceInjectionUtil.getInjectionPoints(psiClass, false);
        PsiFile containingFile = psiClass.getContainingFile();
        if (points.size() > 0) {
            Set<BindDescriptor> allDescriptors = GuiceInjectorManager.getBindingDescriptors(module);
            List<GuiceProvides> allProvides = GuiceInjectionUtil.getProvides(module.getProject(), GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module));
            for (InjectionPointDescriptor ip : points) {
                PsiModifierListOwner owner = ip.getOwner();
                if (!containingFile.equals(owner.getContainingFile())) continue;
                Set<BindDescriptor> descriptors = GuiceInjectorManager.getInjectBindingDescriptors(ip, allDescriptors);
                Set<GuiceProvides> providesSet = GuiceInjectorManager.getInjectProvidesDescriptors(ip, allProvides);
                this.addInjectedGutterIcon(result, descriptors, providesSet, owner);
            }
        }
    }

    private static void annotateInjectionPoints(Collection<? super RelatedItemLineMarkerInfo> result, @NotNull Module module, @NotNull PsiElement scope) {
        Set<InjectionPointDescriptor> allInjectionPoints;
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/guice/model/GuiceInjectionsClassAnnotator", "annotateInjectionPoints"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/guice/model/GuiceInjectionsClassAnnotator", "annotateInjectionPoints"));
        }
        Set<BindDescriptor> descriptors = GuiceInjectorManager.getBindingDescriptors(scope);
        if (descriptors.size() > 0 && (allInjectionPoints = GuiceInjectionUtil.getInjectionPoints(module.getProject(), GlobalSearchScope.moduleWithDependenciesScope((Module)module))).size() > 0) {
            for (BindDescriptor descriptor : descriptors) {
                GuiceInjectionsClassAnnotator.addInjectionPointsGutterIcon(result, GuiceInjectionUtil.getInjectionPoints(descriptor, allInjectionPoints), (PsiElement)descriptor.getBindExpression());
            }
        }
    }

    private static void annotateProvidesInjectionPoints(Collection<? super RelatedItemLineMarkerInfo> result, @NotNull Module module, @NotNull PsiMethod psiMethod) {
        Set<InjectionPointDescriptor> allInjectionPoints;
        Set<InjectionPointDescriptor> injectionPoints;
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/guice/model/GuiceInjectionsClassAnnotator", "annotateProvidesInjectionPoints"));
        }
        if (psiMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiMethod", "com/intellij/guice/model/GuiceInjectionsClassAnnotator", "annotateProvidesInjectionPoints"));
        }
        GuiceProvides provides = (GuiceProvides)JamService.getJamService((Project)module.getProject()).getJamElement((PsiElement)psiMethod, new JamMemberMeta[]{GuiceProvides.METHOD_META});
        if (provides != null && (injectionPoints = GuiceInjectionUtil.getInjectionPoints(provides, allInjectionPoints = GuiceInjectionUtil.getInjectionPoints(module.getProject(), GlobalSearchScope.moduleWithDependenciesScope((Module)module)))).size() > 0) {
            GuiceInjectionsClassAnnotator.addInjectionPointsGutterIcon(result, injectionPoints, (PsiElement)psiMethod.getNameIdentifier());
        }
    }

    private void addInjectedGutterIcon(@NotNull Collection<? super RelatedItemLineMarkerInfo> result, @NotNull Set<BindDescriptor> descriptors, @NotNull Set<GuiceProvides> provides, @NotNull PsiModifierListOwner owner) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/guice/model/GuiceInjectionsClassAnnotator", "addInjectedGutterIcon"));
        }
        if (descriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "com/intellij/guice/model/GuiceInjectionsClassAnnotator", "addInjectedGutterIcon"));
        }
        if (provides == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provides", "com/intellij/guice/model/GuiceInjectionsClassAnnotator", "addInjectedGutterIcon"));
        }
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/guice/model/GuiceInjectionsClassAnnotator", "addInjectedGutterIcon"));
        }
        ArrayList<Object> allTargets = new ArrayList<Object>();
        for (BindDescriptor descriptor : descriptors) {
            allTargets.add(descriptor.getBindExpression());
        }
        for (GuiceProvides provide : provides) {
            allTargets.add(provide.getPsiElement());
        }
        if (allTargets.size() > 0) {
            NavigationGutterIconBuilder builder = NavigationGutterIconBuilder.create((Icon)GuiceIcons.Inject).setPopupTitle(GuiceBundle.message("GuiceClassAnnotator.popup.title", new Object[0])).setTooltipText(GuiceBundle.message("GuiceClassAnnotator.popup.tooltip.text", new Object[0])).setCellRenderer(this.BINDING_CLASS_CELL_RENDERER).setTargets(allTargets);
            result.add((RelatedItemLineMarkerInfo)builder.createLineMarkerInfo((PsiElement)owner));
        }
    }

    private static void addInjectionPointsGutterIcon(@NotNull Collection<? super RelatedItemLineMarkerInfo> result, @NotNull Set<InjectionPointDescriptor> ips, @NotNull PsiElement owner) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/guice/model/GuiceInjectionsClassAnnotator", "addInjectionPointsGutterIcon"));
        }
        if (ips == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ips", "com/intellij/guice/model/GuiceInjectionsClassAnnotator", "addInjectionPointsGutterIcon"));
        }
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/guice/model/GuiceInjectionsClassAnnotator", "addInjectionPointsGutterIcon"));
        }
        if (ips.size() > 0) {
            List members = ContainerUtil.map(ips, descriptor -> descriptor.getOwner());
            NavigationGutterIconBuilder builder = NavigationGutterIconBuilder.create((Icon)GuiceIcons.Inject).setTargets((Collection)members).setPopupTitle(GuiceBundle.message("gutter.choose.injected.point", new Object[0])).setTooltipText(GuiceBundle.message("gutter.navigate.to.injection.point", new Object[0]));
            result.add((RelatedItemLineMarkerInfo)builder.createLineMarkerInfo(owner));
        }
    }
}

