/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.guice.model.jam;

import com.intellij.guice.model.GuiceInjectorManager;
import com.intellij.guice.model.InjectionPointDescriptor;
import com.intellij.jam.JamElement;
import com.intellij.jam.annotations.JamPsiConnector;
import com.intellij.jam.annotations.JamPsiValidity;
import com.intellij.jam.reflect.JamFieldMeta;
import com.intellij.jam.reflect.JamMethodMeta;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.semantic.SemKey;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public abstract class GuiceInject<T extends PsiMember>
implements JamElement {
    public static final SemKey<GuiceInject> SEM_KEY = SemKey.createKey((String)"GuiceInject", (SemKey[])new SemKey[0]);
    public static final JamMethodMeta<GuiceInject> METHOD_JSR_330_META = new JamMethodMeta(null, Method.class, SEM_KEY);
    public static final JamMethodMeta<GuiceInject> METHOD_META = new JamMethodMeta(null, Method.class, SEM_KEY);
    public static final JamFieldMeta<GuiceInject> FIELD_JSR_330_META = new JamFieldMeta(null, Field.class, SEM_KEY);
    public static final JamFieldMeta<GuiceInject> FIELD_META = new JamFieldMeta(null, Field.class, SEM_KEY);

    public abstract List<InjectionPointDescriptor> getInjectionPoints();

    @NotNull
    public Set<PsiAnnotation> getBindingAnnotations() {
        Set<PsiAnnotation> set = GuiceInjectorManager.getBindingAnnotations(this.getPsiElement());
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/guice/model/jam/GuiceInject", "getBindingAnnotations"));
        }
        return set;
    }

    @JamPsiConnector
    @NotNull
    public abstract T getPsiElement();

    @JamPsiValidity
    public abstract boolean isPsiValid();

    public static abstract class Method
    extends GuiceInject<PsiMethod> {
        @Override
        public List<InjectionPointDescriptor> getInjectionPoints() {
            ArrayList descriptors = ContainerUtil.newArrayList();
            for (PsiParameter parameter : ((PsiMethod)this.getPsiElement()).getParameterList().getParameters()) {
                descriptors.add(new InjectionPointDescriptor((PsiModifierListOwner)parameter));
            }
            return descriptors;
        }
    }

    public static abstract class Field
    extends GuiceInject<PsiField> {
        public PsiType getType() {
            return ((PsiField)this.getPsiElement()).getType();
        }

        @Override
        public List<InjectionPointDescriptor> getInjectionPoints() {
            return Collections.singletonList(new InjectionPointDescriptor((PsiModifierListOwner)this.getPsiElement()));
        }
    }
}

