/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coding;

import com.intellij.coding.CodeTextBuilder;
import com.intellij.dbm.common.DbmElement;
import com.intellij.dbm.common.DbmModel;
import com.intellij.dbm.common.DbmNode;
import com.intellij.dbm.common.DbmObject;
import com.intellij.dbm.common.DbmRoot;
import com.intellij.dbm.common.Family;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class DbmDescribing {
    public static String describe(@NotNull DbmObject element, boolean includeSurrogates) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/coding/DbmDescribing", "describe"));
        }
        CodeTextBuilder ctb = new CodeTextBuilder();
        ctb.setIndentation("    ");
        DbmDescribing.describeRecursively(ctb, element, includeSurrogates);
        return ctb.getText();
    }

    public static String describe(@NotNull DbmModel model, boolean includeSurrogates) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/coding/DbmDescribing", "describe"));
        }
        CodeTextBuilder ctb = new CodeTextBuilder();
        ctb.setIndentation("    ");
        DbmDescribing.describeRecursively(ctb, (DbmNode)((Object)((DbmRoot)model.getRoot()).getNamespaces()), includeSurrogates);
        return ctb.getText();
    }

    public static void describeRecursively(@NotNull CodeTextBuilder ctb, @NotNull DbmNode node, boolean includeSurrogates) {
        if (ctb == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ctb", "com/intellij/coding/DbmDescribing", "describeRecursively"));
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/coding/DbmDescribing", "describeRecursively"));
        }
        if (node instanceof DbmObject) {
            DbmObject object = (DbmObject)node;
            DbmDescribing.describeObjectRecursively(ctb, object, includeSurrogates);
        } else if (node instanceof Family) {
            Iterable<? extends DbmNode> innerNodes = node.getChildNodes();
            for (DbmNode dbmNode : innerNodes) {
                DbmDescribing.describeRecursively(ctb, dbmNode, includeSurrogates);
            }
        } else if (node instanceof DbmElement) {
            DbmDescribing.describeElement(ctb, (DbmElement)((Object)node), includeSurrogates);
        } else {
            ctb.addText(node.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void describeObjectRecursively(@NotNull CodeTextBuilder ctb, @NotNull DbmObject object, boolean includeSurrogates) {
        if (ctb == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ctb", "com/intellij/coding/DbmDescribing", "describeObjectRecursively"));
        }
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/coding/DbmDescribing", "describeObjectRecursively"));
        }
        DbmDescribing.describeElement(ctb, object, includeSurrogates);
        String comment = object.getComment();
        if (comment != null && comment.length() > 0) {
            ctb.indent();
            try {
                String[] commentLines;
                for (String commentLine : commentLines = comment.split("\n")) {
                    ctb.addText("--  " + commentLine);
                }
            }
            finally {
                ctb.unindent();
            }
        }
        ctb.indent();
        try {
            for (Family family : object.getFamilies()) {
                ArrayList children = new ArrayList(family);
                if (!includeSurrogates) {
                    for (int i2 = children.size() - 1; i2 >= 0; --i2) {
                        DbmObject child = (DbmObject)children.get(i2);
                        if (!child.isObjectSurrogate()) continue;
                        children.remove(i2);
                    }
                }
                if (children.isEmpty()) continue;
                String sectionLine = "+ " + StringUtil.pluralize((String)family.getChildKind().code());
                ctb.addText(sectionLine);
                ctb.indent();
                try {
                    for (DbmObject child : children) {
                        DbmDescribing.describeObjectRecursively(ctb, child, includeSurrogates);
                    }
                }
                finally {
                    ctb.unindent();
                }
            }
        }
        finally {
            ctb.unindent();
        }
    }

    private static void describeElement(@NotNull CodeTextBuilder ctb, @NotNull DbmElement element, boolean includeSurrogates) {
        if (ctb == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ctb", "com/intellij/coding/DbmDescribing", "describeElement"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/coding/DbmDescribing", "describeElement"));
        }
        String id = element.identity(includeSurrogates);
        String desc = element.description(includeSurrogates);
        String elementLine = id + ":  " + desc;
        ctb.addText(elementLine);
    }
}

