/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.url.JdbcUrlParser;
import com.intellij.database.dataSource.url.JdbcUrlParserUtil;
import com.intellij.database.dataSource.url.StatelessJdbcUrlParser;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.dump.dbdump.DbDumpUtil;
import com.intellij.database.dump.dbdump.DumpConfiguration;
import com.intellij.database.dump.dbdump.DumpConfigurationImpl;
import com.intellij.database.dump.dbdump.DumpDialog;
import com.intellij.database.dump.dbdump.DumpManager;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.RawConnectionConfig;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbNamespaceImpl;
import com.intellij.database.psi.DbTable;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.view.DatabaseStructure;
import com.intellij.database.view.DatabaseView;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NativeDumpAction
extends DumbAwareAction {
    private static final String TEXT_PATTERN = "Dump with \"%s\"";

    public void update(AnActionEvent e) {
        boolean enabled = NativeDumpAction.isEnabled(e);
        e.getPresentation().setEnabledAndVisible(enabled);
        if (!enabled) {
            return;
        }
        DbDataSource dataSource = (DbDataSource)ObjectUtils.assertNotNull((Object)NativeDumpAction.getDataSource(e));
        DatabaseDialectEx dialect = DbImplUtil.getDatabaseDialect((DbElement)ObjectUtils.assertNotNull((Object)dataSource));
        DumpConfigurationImpl configuration = DumpConfigurationImpl.of(dialect);
        if (configuration == null) {
            return;
        }
        e.getPresentation().setText(String.format(TEXT_PATTERN, StringUtil.escapeMnemonics((String)configuration.getName())));
    }

    public void actionPerformed(AnActionEvent e) {
        DumpManager manager;
        if (!NativeDumpAction.isEnabled(e)) {
            return;
        }
        DbDataSource dataSource = NativeDumpAction.getDataSource(e);
        if (dataSource == null) {
            return;
        }
        DatabaseDialectEx dialect = DbImplUtil.getDatabaseDialect((DbElement)dataSource);
        DumpConfigurationImpl configuration = DumpConfigurationImpl.of(dialect);
        if (configuration == null) {
            return;
        }
        List<DbElement> selected = configuration.filterElements(ContainerUtil.filter(NativeDumpAction.getSelectedElements(e), DbImplUtil::canConnectTo));
        Project project = (Project)ObjectUtils.assertNotNull((Object)e.getProject());
        DumpDialog dialog = new DumpDialog(dataSource, project, manager = new DumpManager(dataSource, NativeDumpAction.distinct(selected), project, configuration), configuration);
        if (dialog.showAndGet()) {
            manager.dump();
        }
        Disposer.dispose((Disposable)manager);
    }

    @Nullable
    private static String getDatabaseName(@Nullable DbDataSource dataSource) {
        if (dataSource == null) {
            return null;
        }
        DasNamespace namespace = dataSource.getDelegate().getModel().getCurrentRootNamespace();
        return namespace == null ? null : namespace.getName();
    }

    @NotNull
    private static List<DbElement> getSelectedElements(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/actions/NativeDumpAction", "getSelectedElements"));
        }
        List<DbTable> tables = NativeDumpAction.getGroupedTables(e.getProject());
        Set<DbElement> selected = DatabaseView.getSelectedElements(e.getDataContext(), DbElement.class);
        selected.addAll(tables);
        DbElement dataSource = (DbElement)ContainerUtil.find(selected, (Condition)DasUtil.byClass(DbDataSource.class));
        if (dataSource != null) {
            selected.addAll(dataSource.getDbChildren(DbNamespaceImpl.class, ObjectKind.SCHEMA).toList());
        }
        Condition condition = element -> element instanceof DbDataSource || element instanceof DbTable || element instanceof DbNamespaceImpl;
        List list = ContainerUtil.filter(selected, (Condition)condition);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/actions/NativeDumpAction", "getSelectedElements"));
        }
        return list;
    }

    @NotNull
    private static List<DbTable> getGroupedTables(@Nullable Project project) {
        if (project == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/actions/NativeDumpAction", "getGroupedTables"));
            }
            return list;
        }
        DatabaseView view2 = DatabaseView.getDatabaseView(project);
        if (view2 == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/actions/NativeDumpAction", "getGroupedTables"));
            }
            return list;
        }
        Set elements = view2.getTreeBuilder().getSelectedElements();
        List list = JBIterable.from((Iterable)elements).filter(DatabaseStructure.GroupElement.class).filter(element -> element.getKind() == ObjectKind.TABLE || element.getKind() == ObjectKind.VIEW).filter(element -> element.getParent() instanceof DbNamespaceImpl).flatMap(element -> ((DbElement)element.getParent()).getDbChildren(DbTable.class, element.getKind())).toList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/actions/NativeDumpAction", "getGroupedTables"));
        }
        return list;
    }

    @NotNull
    private static Collection<DbElement> distinct(@NotNull List<DbElement> elements) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/database/actions/NativeDumpAction", "distinct"));
        }
        HashSet result = ContainerUtil.newHashSet();
        elements.forEach(element -> {
            String name = DbDumpUtil.getNameOfElement(element);
            DbElement found = (DbElement)ContainerUtil.find((Iterable)result, resultElement -> StringUtil.equals((CharSequence)DbDumpUtil.getNameOfElement(resultElement), (CharSequence)name));
            if (found == null) {
                result.add(element);
            }
        });
        HashSet hashSet = result;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/actions/NativeDumpAction", "distinct"));
        }
        return hashSet;
    }

    private static boolean isEnabled(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/actions/NativeDumpAction", "isEnabled"));
        }
        DbDataSource dataSource = NativeDumpAction.getDataSource(e);
        if (dataSource == null || !(dataSource.getDelegate() instanceof LocalDataSource)) {
            return false;
        }
        LocalDataSource local = (LocalDataSource)dataSource.getDelegate();
        if (!NativeDumpAction.isHostAndPortExists(local)) {
            return false;
        }
        DumpConfigurationImpl configuration = DumpConfigurationImpl.of(DbImplUtil.getDatabaseDialect((DbElement)dataSource));
        return configuration != null && NativeDumpAction.hasSuitableSelectedElements(e, configuration) && NativeDumpAction.getDatabaseName(dataSource) != null && e.getProject() != null;
    }

    private static boolean hasSuitableSelectedElements(@NotNull AnActionEvent e, @NotNull DumpConfiguration configuration) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/actions/NativeDumpAction", "hasSuitableSelectedElements"));
        }
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/database/actions/NativeDumpAction", "hasSuitableSelectedElements"));
        }
        List selected = ContainerUtil.filter(NativeDumpAction.getSelectedElements(e), DbImplUtil::canConnectTo);
        List<DbElement> filtered = configuration.filterElements(selected);
        return !filtered.isEmpty();
    }

    private static boolean isHostAndPortExists(@NotNull LocalDataSource source) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/actions/NativeDumpAction", "isHostAndPortExists"));
        }
        DatabaseDriver driver = source.getDatabaseDriver();
        RawConnectionConfig config = source.getConnectionConfig();
        if (config == null || driver == null) {
            return false;
        }
        List<StatelessJdbcUrlParser> parsers = driver.getJDBCUrlParsers();
        Pair.NonNull<String, String> hostPort = JdbcUrlParserUtil.extractHostPort(parsers, config.getUrl(), (Ref<JdbcUrlParser>)Ref.create());
        return hostPort != null && hostPort.first != null && hostPort.second != null;
    }

    @Nullable
    private static DbDataSource getDataSource(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/actions/NativeDumpAction", "getDataSource"));
        }
        Set<DbElement> elements = DatabaseView.getSelectedElements(e.getDataContext(), DbElement.class);
        HashSet sources = ContainerUtil.newHashSet();
        elements.forEach(element -> sources.add(element.getDataSource()));
        return sources.size() == 1 ? (DbDataSource)ContainerUtil.getFirstItem((Collection)sources) : null;
    }
}

