/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.csv.ui.preview;

import com.intellij.database.csv.CsvFormat;
import com.intellij.database.csv.CsvFormatter;
import com.intellij.database.csv.ui.preview.CsvFormatPreview;
import com.intellij.database.csv.ui.preview.TextView;
import com.intellij.database.datagrid.CsvDocumentDataHookUp;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.containers.ContainerUtil;
import java.awt.GridLayout;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class TableAndTextCsvFormatPreview
implements CsvFormatPreview,
Disposable {
    private static final String[] DUMMY_HEADER = new String[]{"id", "first name", "last name", "gender", "birth date"};
    private static final String[][] DUMMY_DATA = new String[][]{{"10001", "Georgi", "Facello", "M", "1953-09-02"}, {"10002", "Bezalel", "Simmel", "F", "1964-06-02"}, {"10003", "Parto", "Bamford", "M", "1959-12-03"}, {"10004", "Chirstian", "Koblick", "M", "1954-05-01"}, {"10005", "Kyoichi", "Maliniak", "M", "1955-01-21"}, {"10006", "Anneke", "Preusig", "F", "1953-04-20"}, {"10007", "Tzvetan", "Zielinski", "F", "1957-05-23"}, {"10008", "Saniya", "Kalloufi", "M", "1958-02-19"}, {"10009", "Sumant", "Peac", "F", "1952-04-19"}, {"10010", "Duangkaew", "Piveteau", "F", "1963-06-01"}};
    private final JPanel myPanel;
    private final CsvDocumentDataHookUp myHookUp;
    private final TextView myTextView;

    public TableAndTextCsvFormatPreview(@NotNull Project project, @NotNull Disposable parent) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/csv/ui/preview/TableAndTextCsvFormatPreview", "<init>"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/database/csv/ui/preview/TableAndTextCsvFormatPreview", "<init>"));
        }
        Disposer.register((Disposable)parent, (Disposable)this);
        Document document = EditorFactory.getInstance().createDocument((CharSequence)"");
        this.myHookUp = new CsvDocumentDataHookUp(project, DatabaseSettings.TSV_FORMAT, document, null);
        Disposer.register((Disposable)this, (Disposable)this.myHookUp);
        DataGrid grid = DataGridUtil.createPreviewDataGrid(project, this.myHookUp);
        Disposer.register((Disposable)this, (Disposable)grid);
        this.myTextView = new TextView(document, this);
        this.myPanel = new JPanel(new GridLayout(2, 1, 0, 8));
        this.myPanel.add(this.myTextView.getComponent());
        this.myPanel.add(grid.getComponent());
    }

    @Override
    public void setFormat(@NotNull CsvFormat format) {
        if (format == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "format", "com/intellij/database/csv/ui/preview/TableAndTextCsvFormatPreview", "setFormat"));
        }
        this.myTextView.setText("");
        this.myHookUp.setFormat(format);
        CsvFormatter formatter = new CsvFormatter(this.myHookUp.getFormat());
        StringBuilder sb = new StringBuilder();
        sb.append(formatter.formatHeader((List<?>)ContainerUtil.immutableList((Object[])DUMMY_HEADER))).append(formatter.recordSeparator());
        for (Object[] objectArray : DUMMY_DATA) {
            sb.append(formatter.formatRecord((List<?>)ContainerUtil.immutableList((Object[])objectArray))).append(formatter.recordSeparator());
        }
        this.myTextView.setText(sb.toString());
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/csv/ui/preview/TableAndTextCsvFormatPreview", "getComponent"));
        }
        return jPanel;
    }

    public void dispose() {
    }
}

