/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.autoconfig.DataSourceConfigUtil;
import com.intellij.database.dataSource.DatabaseDriverImpl;
import com.intellij.facet.frameworks.LibrariesDownloadConnectionService;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.util.Consumer;
import com.intellij.util.EventDispatcher;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.download.DownloadableFileDescription;
import com.intellij.util.download.DownloadableFileService;
import com.intellij.util.download.DownloadableFileSetDescription;
import com.intellij.util.download.DownloadableFileSetVersions;
import com.intellij.util.download.FileDownloader;
import com.intellij.util.net.HttpConfigurable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseArtifactManager {
    private static final Logger LOG = Logger.getInstance(DatabaseArtifactManager.class);
    public static final String VERSION_LATEST = "latest";
    private static final DatabaseArtifactManager INSTANCE = new DatabaseArtifactManager();
    private static final int UPDATE_LIST_TIMEOUT_MSEC = 86400000;
    private volatile MultiMap<String, DownloadableFileSetDescription> myArtifacts = MultiMap.create();
    private final EventDispatcher<ArtifactListener> myDispatcher = EventDispatcher.create(ArtifactListener.class);
    private boolean myLoaded = false;
    private Long myLastUpdate = null;
    private final Object myFileLock = new Object();

    public static DatabaseArtifactManager getInstance() {
        INSTANCE.checkForUpdates();
        return INSTANCE;
    }

    public boolean existsVersion(@NotNull String name, @NotNull String version) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/dataSource/DatabaseArtifactManager", "existsVersion"));
        }
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "com/intellij/database/dataSource/DatabaseArtifactManager", "existsVersion"));
        }
        return this.getArtifact(name, version) != null;
    }

    @Nullable
    private DownloadableFileSetDescription getArtifactLatest(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/dataSource/DatabaseArtifactManager", "getArtifactLatest"));
        }
        this.checkForUpdates();
        return (DownloadableFileSetDescription)DatabaseArtifactManager.latest(this.myArtifacts.get((Object)name));
    }

    @Nullable
    private DownloadableFileSetDescription getArtifact(@NotNull String name, @NotNull String version) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/dataSource/DatabaseArtifactManager", "getArtifact"));
        }
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "com/intellij/database/dataSource/DatabaseArtifactManager", "getArtifact"));
        }
        if (VERSION_LATEST.equals(version)) {
            return this.getArtifactLatest(name);
        }
        this.checkForUpdates();
        for (DownloadableFileSetDescription description : this.myArtifacts.get((Object)name)) {
            if (!version.equals(description.getVersionString())) continue;
            return description;
        }
        return null;
    }

    @Nullable
    private static <T> T latest(@Nullable Collection<T> col) {
        return (T)ContainerUtil.getFirstItem((List)((List)col));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkForUpdates() {
        boolean outdated;
        if (ApplicationManager.getApplication() == null) {
            return;
        }
        DatabaseArtifactManager databaseArtifactManager = INSTANCE;
        synchronized (databaseArtifactManager) {
            outdated = this.isOutdated();
            if (outdated) {
                this.setLastUpdate(System.currentTimeMillis());
            }
        }
        if (outdated) {
            this.updateLists();
        } else if (!this.myLoaded) {
            this.initLocal();
            this.listLoaded();
        }
    }

    private void initLocal() {
        if (!this.myLoaded) {
            try {
                ApplicationManager.getApplication().executeOnPooledThread(() -> this.loadLocalArtifactsList()).get();
            }
            catch (InterruptedException interruptedException) {
            }
            catch (ExecutionException e) {
                LOG.error((Throwable)e);
            }
        }
    }

    @NotNull
    public List<DownloadableFileSetDescription> getArtifacts() {
        ArrayList arrayList = ContainerUtil.newArrayList((Iterable)this.myArtifacts.values());
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseArtifactManager", "getArtifacts"));
        }
        return arrayList;
    }

    @NotNull
    private static DownloadableFileSetVersions<DownloadableFileSetDescription> getDriverVersionsFetcher() throws IOException {
        DownloadableFileSetVersions downloadableFileSetVersions = DownloadableFileService.getInstance().createFileSetVersions(null, new URL[]{DatabaseArtifactManager.getLocalArtifactListPath().toURI().toURL()});
        if (downloadableFileSetVersions == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseArtifactManager", "getDriverVersionsFetcher"));
        }
        return downloadableFileSetVersions;
    }

    public void updateLists() {
        this.setLastUpdate(System.currentTimeMillis());
        new Task.Backgroundable(null, "Update Database Drivers List", false){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/database/dataSource/DatabaseArtifactManager$1", "run"));
                }
                indicator.setText("Loading database drivers list...");
                try {
                    DatabaseArtifactManager.this.loadRemoteArtifactList();
                }
                catch (IOException e) {
                    LOG.error((Throwable)e);
                }
                if (!DatabaseArtifactManager.this.myLoaded) {
                    DatabaseArtifactManager.this.initLocal();
                }
                DatabaseArtifactManager.this.listLoaded();
            }
        }.queue();
    }

    private void listLoaded() {
        ApplicationManager.getApplication().invokeLater(() -> {
            DatabaseArtifactManager.refreshRecursively(LocalFileSystem.getInstance().refreshAndFindFileByPath(DatabaseDriverImpl.getDriverDownloadDirectory()));
            this.fireChanged(null, null);
        });
    }

    private boolean isOutdated() {
        File path = DatabaseArtifactManager.getLocalArtifactListPath();
        return path.exists() ? System.currentTimeMillis() - path.lastModified() > 86400000L : this.myLastUpdate == null || System.currentTimeMillis() - this.myLastUpdate > 86400000L;
    }

    private void loadRemoteArtifactList() throws IOException {
        DatabaseArtifactManager.loadArtifactsList();
        this.loadLocalArtifactsList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadLocalArtifactsList() {
        if (!DatabaseArtifactManager.getLocalArtifactListPath().exists()) {
            return;
        }
        List versions = Collections.emptyList();
        Exception wentWrong = null;
        try {
            Object object = this.myFileLock;
            synchronized (object) {
                versions = DatabaseArtifactManager.getDriverVersionsFetcher().fetchVersions();
            }
        }
        catch (Exception e) {
            wentWrong = e;
        }
        if (versions.isEmpty()) {
            LOG.warn("Unable to load jdbc-drivers.xml. Will delete", (Throwable)wentWrong);
            FileUtil.delete((File)DatabaseArtifactManager.getLocalArtifactListPath());
            this.myLoaded = false;
            this.setLastUpdate(null);
            return;
        }
        this.setArtifacts(versions);
        this.myLoaded = true;
        this.setLastUpdate(System.currentTimeMillis());
        ApplicationManager.getApplication().invokeLater(() -> {
            DatabaseArtifactManager.refreshRecursively(LocalFileSystem.getInstance().refreshAndFindFileByPath(DatabaseDriverImpl.getDriverDownloadDirectory()));
            this.fireChanged(null, null);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setLastUpdate(Long lastUpdate) {
        DatabaseArtifactManager databaseArtifactManager = INSTANCE;
        synchronized (databaseArtifactManager) {
            this.myLastUpdate = lastUpdate;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean loadArtifactsList() {
        File file = DatabaseArtifactManager.getLocalArtifactListPath();
        boolean forced = !file.exists();
        List urls = ContainerUtil.newSmartList();
        ContainerUtil.addIfNotNull((Collection)urls, (Object)DatabaseArtifactManager.createVersionsUrl("jdbc-drivers"));
        if (!forced) {
            ContainerUtil.addIfNotNull((Collection)urls, (Object)DataSourceConfigUtil.class.getResource("/resources/jdbc-drivers.xml"));
        }
        if (urls.isEmpty()) {
            return false;
        }
        for (URL url : urls) {
            try (InputStream stream = url.openStream();){
                byte[] text = StreamUtil.loadFromStream((InputStream)stream);
                Object object = DatabaseArtifactManager.INSTANCE.myFileLock;
                synchronized (object) {
                    FileUtil.writeToFile((File)file, (byte[])text);
                    break;
                }
            }
            catch (IOException e) {
                LOG.warn((Throwable)e);
            }
        }
        return true;
    }

    @Nullable
    private static URL createVersionsUrl(@NotNull String id) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/database/dataSource/DatabaseArtifactManager", "createVersionsUrl"));
        }
        String serviceUrl = LibrariesDownloadConnectionService.getInstance().getServiceUrl();
        if (StringUtil.isNotEmpty((String)serviceUrl)) {
            try {
                String url = serviceUrl + "/" + id + "/";
                HttpConfigurable.getInstance().prepareURL(url);
                return new URL(url);
            }
            catch (MalformedURLException e) {
                LOG.error((Throwable)e);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    @NotNull
    private static File getLocalArtifactListPath() {
        File file = new File(DatabaseDriverImpl.getDriverDownloadDirectory(), "jdbc-drivers.xml");
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseArtifactManager", "getLocalArtifactListPath"));
        }
        return file;
    }

    private void setArtifacts(List<DownloadableFileSetDescription> versions) {
        MultiMap newArtifacts = MultiMap.create();
        for (DownloadableFileSetDescription version : versions) {
            if (!SystemInfo.isWindows) {
                version.getFiles().removeIf(d -> d.getPresentableFileName().contains("win"));
            }
            newArtifacts.putValue((Object)version.getName(), (Object)version);
        }
        this.myArtifacts = newArtifacts;
    }

    public void addListener(@NotNull ArtifactListener listener, @Nullable Disposable parent) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/database/dataSource/DatabaseArtifactManager", "addListener"));
        }
        if (parent != null) {
            this.myDispatcher.addListener((EventListener)listener, parent);
        } else {
            this.myDispatcher.addListener((EventListener)listener);
        }
    }

    private void fireChanged(@Nullable String name, @Nullable String version) {
        ((ArtifactListener)this.myDispatcher.getMulticaster()).artifactChanged(name, version);
    }

    @NotNull
    private static String getBasePath(@NotNull String name, @NotNull String version) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/dataSource/DatabaseArtifactManager", "getBasePath"));
        }
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "com/intellij/database/dataSource/DatabaseArtifactManager", "getBasePath"));
        }
        String string = DatabaseDriverImpl.getDriverDownloadDirectory() + "/" + name + "/" + version;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseArtifactManager", "getBasePath"));
        }
        return string;
    }

    @Nullable
    public String getActualVersion(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/dataSource/DatabaseArtifactManager", "getActualVersion"));
        }
        DownloadableFileSetDescription artifact = this.getArtifactLatest(name);
        return artifact == null ? null : artifact.getVersionString();
    }

    public boolean isValid(@NotNull String name, @NotNull String version) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/dataSource/DatabaseArtifactManager", "isValid"));
        }
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "com/intellij/database/dataSource/DatabaseArtifactManager", "isValid"));
        }
        DownloadableFileSetDescription desc = this.getArtifact(name, version);
        if (desc != null) {
            return DatabaseArtifactManager.isValidFileList(name, desc);
        }
        String path = DatabaseArtifactManager.getBasePath(name, version);
        VirtualFile folder = LocalFileSystem.getInstance().findFileByPath(path);
        return folder != null && folder.getChildren().length > 0;
    }

    public boolean isFreshFiles(@NotNull String name, @NotNull String version, @NotNull Set<String> fileNames) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/dataSource/DatabaseArtifactManager", "isFreshFiles"));
        }
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "com/intellij/database/dataSource/DatabaseArtifactManager", "isFreshFiles"));
        }
        if (fileNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileNames", "com/intellij/database/dataSource/DatabaseArtifactManager", "isFreshFiles"));
        }
        DownloadableFileSetDescription desc = this.getArtifact(name, version);
        return desc == null || DatabaseArtifactManager.isAllDownloaded(desc, fileNames);
    }

    public boolean isVersionValid(@NotNull String name, @NotNull String version) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/dataSource/DatabaseArtifactManager", "isVersionValid"));
        }
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "com/intellij/database/dataSource/DatabaseArtifactManager", "isVersionValid"));
        }
        DownloadableFileSetDescription desc = this.getArtifact(name, version);
        if (desc == null) {
            return true;
        }
        return DatabaseArtifactManager.isValidFileList(name, desc);
    }

    private static boolean isValidFileList(@NotNull String name, @NotNull DownloadableFileSetDescription desc) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/dataSource/DatabaseArtifactManager", "isValidFileList"));
        }
        if (desc == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "desc", "com/intellij/database/dataSource/DatabaseArtifactManager", "isValidFileList"));
        }
        String path = DatabaseArtifactManager.getBasePath(name, desc.getVersionString());
        VirtualFile folder = LocalFileSystem.getInstance().findFileByPath(path);
        HashSet existing = ContainerUtil.newHashSet();
        if (folder == null) {
            return false;
        }
        for (VirtualFile file : folder.getChildren()) {
            existing.add(file.getName());
        }
        return DatabaseArtifactManager.isAllDownloaded(desc, existing);
    }

    private static boolean isAllDownloaded(@NotNull DownloadableFileSetDescription desc, Set<String> existing) {
        if (desc == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "desc", "com/intellij/database/dataSource/DatabaseArtifactManager", "isAllDownloaded"));
        }
        for (DownloadableFileDescription file : desc.getFiles()) {
            if (file.getDefaultFileName().endsWith(".txt") || existing.contains(file.getDefaultFileName())) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public String downloadArtifact(@NotNull String name, @NotNull String version, @Nullable Consumer<String> onFinish) throws IOException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/dataSource/DatabaseArtifactManager", "downloadArtifact"));
        }
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "com/intellij/database/dataSource/DatabaseArtifactManager", "downloadArtifact"));
        }
        DownloadableFileSetDescription download = this.getArtifact(name, version);
        if (download == null) {
            return null;
        }
        String path = DatabaseArtifactManager.getBasePath(name, download.getVersionString());
        FileDownloader downloader = DownloadableFileService.getInstance().createDownloader(download);
        File dir = new File(path);
        downloader.download(dir);
        ApplicationManager.getApplication().invokeLater(() -> {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/dataSource/DatabaseArtifactManager", "lambda$downloadArtifact$4"));
            }
            DatabaseArtifactManager.refreshRecursively(LocalFileSystem.getInstance().refreshAndFindFileByIoFile(dir));
            if (onFinish != null) {
                onFinish.consume((Object)download.getVersionString());
            }
            this.fireChanged(name, download.getVersionString());
        });
        return download.getVersionString();
    }

    private static void refreshRecursively(@Nullable VirtualFile file) {
        if (file != null) {
            VfsUtil.markDirty((boolean)true, (boolean)true, (VirtualFile[])new VirtualFile[]{file});
            RefreshQueue.getInstance().refresh(false, true, null, ModalityState.defaultModalityState(), new VirtualFile[]{file});
        }
    }

    @NotNull
    public VirtualFile[] getFiles(@NotNull String name, @NotNull String version) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/dataSource/DatabaseArtifactManager", "getFiles"));
        }
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "com/intellij/database/dataSource/DatabaseArtifactManager", "getFiles"));
        }
        if (VERSION_LATEST.equals(version)) {
            throw new AssertionError((Object)"Should be concrete version");
        }
        String path = DatabaseArtifactManager.getBasePath(name, version);
        VirtualFile folder = LocalFileSystem.getInstance().findFileByPath(path);
        VirtualFile[] virtualFileArray = folder == null ? VirtualFile.EMPTY_ARRAY : folder.getChildren();
        if (virtualFileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseArtifactManager", "getFiles"));
        }
        return virtualFileArray;
    }

    public static interface ArtifactListener
    extends EventListener {
        public void artifactChanged(String var1, String var2);
    }
}

