/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.dataSource.DatabaseArtifactManager;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.DatabaseDriverImpl;
import com.intellij.database.dataSource.DatabaseDriverListener;
import com.intellij.database.dataSource.DatabaseDriverManager;
import com.intellij.database.dataSource.url.template.UrlTemplate;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.ExportableComponent;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.EventDispatcher;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="LocalDatabaseDriverManager", storages={@Storage(value="databaseDrivers.xml")})
public class DatabaseDriverManagerImpl
extends DatabaseDriverManager
implements PersistentStateComponent<Element>,
ExportableComponent {
    private static final Logger LOG = Logger.getInstance(DatabaseDriverManagerImpl.class);
    private static final String VERSION_PRE_141 = null;
    private static final String VERSION_141 = "141+";
    private static final String VERSION_LATEST = "163";
    public static final String URL_DRIVERS_LOCATION = "resources/database-drivers.xml";
    @NonNls
    static final String STATE_NAME = "databaseDrivers";
    @NonNls
    static final String STATE_FILE = "databaseDrivers.xml";
    private final Map<String, DatabaseDriverImpl> myDrivers = ContainerUtil.newHashMap();
    private final Map<String, DatabaseDriverImpl> myPredefinedDrivers = ContainerUtil.newHashMap();
    private final EventDispatcher<DatabaseDriverListener> myDispatcher = EventDispatcher.create(DatabaseDriverListener.class);
    private static final Map<String, String> MIGRATION_MAP = ContainerUtil.newHashMap((Pair)Pair.create((Object)"sqlite.zentus", (Object)"sqlite.xerial"), (Pair[])new Pair[]{Pair.create((Object)"h2.embedded", (Object)"h2.unified"), Pair.create((Object)"h2.in-memory", (Object)"h2.unified"), Pair.create((Object)"h2.remote", (Object)"h2.unified"), Pair.create((Object)"hsqldb.embedded", (Object)"hsqldb.local"), Pair.create((Object)"hsqldb.in-memory", (Object)"hsqldb.local")});

    public static DatabaseDriverManagerImpl getLocalInstance() {
        return (DatabaseDriverManagerImpl)DatabaseDriverManager.getInstance();
    }

    public void dump(@NotNull StringBuilder sb) {
        if (sb == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sb", "com/intellij/database/dataSource/DatabaseDriverManagerImpl", "dump"));
        }
        ArrayList drivers = ContainerUtil.newArrayList(this.getDrivers());
        Collections.sort(drivers, (o1, o2) -> Comparing.compare((Comparable)((Object)o1.getId()), (Comparable)((Object)o2.getId())));
        for (DatabaseDriverImpl driver : drivers) {
            driver.dump(sb);
            sb.append("\n----\n");
        }
    }

    public static DatabaseDriverManagerImpl create(@NotNull String file) throws MalformedURLException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/dataSource/DatabaseDriverManagerImpl", "create"));
        }
        return new DatabaseDriverManagerImpl(new File(file).toURI().toURL());
    }

    public DatabaseDriverManagerImpl() {
        this(DatabaseDriverManagerImpl.getPredefinedLocation());
    }

    @Nullable
    private static URL getPredefinedLocation() {
        return DatabaseDriverManagerImpl.class.getClassLoader().getResource(URL_DRIVERS_LOCATION);
    }

    private DatabaseDriverManagerImpl(@Nullable URL url) {
        try {
            if (url != null) {
                this.loadLatest(JDOMUtil.loadDocument((URL)url).getRootElement(), false, true, VERSION_LATEST);
            }
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
        }
        for (DatabaseDriverImpl driver : this.myDrivers.values()) {
            if (!driver.isPredefined()) continue;
            DatabaseDriverImpl backup = new DatabaseDriverImpl(driver.getId(), true);
            backup.loadState(driver.getState(true), false, true, Integer.MAX_VALUE);
            this.myPredefinedDrivers.put(backup.getId(), backup);
        }
        DatabaseArtifactManager.getInstance().addListener((artifactName, artifactVersion) -> {
            for (DatabaseDriverImpl driver : this.myDrivers.values()) {
                DatabaseDriver.ArtifactRef artifact = driver.getArtifact();
                if (artifact == null || artifactName != null && (!artifactName.equals(artifact.getName()) || !Comparing.equal((String)artifactVersion, (String)artifact.getVersion()))) continue;
                ((DatabaseDriverListener)this.myDispatcher.getMulticaster()).driverUpdated(driver);
            }
        }, null);
    }

    @NotNull
    private DatabaseDriverImpl addDriver(@NotNull DatabaseDriverImpl driver) {
        if (driver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "driver", "com/intellij/database/dataSource/DatabaseDriverManagerImpl", "addDriver"));
        }
        this.myDrivers.put(driver.getId(), driver);
        ((DatabaseDriverListener)this.getDispatcher().getMulticaster()).driverAdded(driver);
        DatabaseDriverImpl databaseDriverImpl = driver;
        if (databaseDriverImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseDriverManagerImpl", "addDriver"));
        }
        return databaseDriverImpl;
    }

    @Nullable
    private DatabaseDriverImpl removeDriver(@NotNull String id) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/database/dataSource/DatabaseDriverManagerImpl", "removeDriver"));
        }
        DatabaseDriverImpl driver = this.myDrivers.remove(id);
        if (driver != null) {
            ((DatabaseDriverListener)this.getDispatcher().getMulticaster()).driverRemoved(driver);
        }
        return driver;
    }

    @NotNull
    private static List<Element> getDrivers(@NotNull Element state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/database/dataSource/DatabaseDriverManagerImpl", "getDrivers"));
        }
        List list = state.getChildren("driver");
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseDriverManagerImpl", "getDrivers"));
        }
        return list;
    }

    @Nullable
    private static String getDriverId(@NotNull Element state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/database/dataSource/DatabaseDriverManagerImpl", "getDriverId"));
        }
        String id = state.getAttributeValue("id");
        if (StringUtil.isEmpty((String)id)) {
            return null;
        }
        if (id.equals("odbc.sun")) {
            if (!SystemInfo.isWindows) {
                return null;
            }
            if (SystemInfo.isJavaVersionAtLeast((String)"1.8.0")) {
                return null;
            }
        }
        return id;
    }

    @Nullable
    private DatabaseDriverImpl getOrCreateDriver(@NotNull String id, boolean predefined, boolean create) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/database/dataSource/DatabaseDriverManagerImpl", "getOrCreateDriver"));
        }
        DatabaseDriverImpl driver = this.myDrivers.get(id);
        if (driver == null && create) {
            driver = this.addDriver(new DatabaseDriverImpl(id, predefined));
        }
        return driver;
    }

    private void loadLatest(@NotNull Element state, boolean merge, boolean predefined, String version) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/database/dataSource/DatabaseDriverManagerImpl", "loadLatest"));
        }
        int ver = DatabaseDriverManagerImpl.parseVersion(version);
        for (Element driverState : DatabaseDriverManagerImpl.getDrivers(state)) {
            String id = DatabaseDriverManagerImpl.getDriverId(driverState);
            DatabaseDriverImpl driver = id == null ? null : this.getOrCreateDriver(id, predefined, true);
            if (driver == null) continue;
            driver.loadState(driverState, merge, true, ver);
        }
    }

    private static int parseVersion(String version) {
        Matcher matcher = Pattern.compile("\\d+").matcher(version);
        try {
            if (matcher.find()) {
                return Integer.parseInt(version);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return 0;
    }

    private void loadPre141(@NotNull Element state, boolean merge, boolean predefined) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/database/dataSource/DatabaseDriverManagerImpl", "loadPre141"));
        }
        this.loadPre141Impl(state, merge, new ArrayList<Element>(), predefined);
    }

    private void loadPre141Impl(@NotNull Element state, boolean merge, @NotNull List<Element> parents, boolean predefined) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/database/dataSource/DatabaseDriverManagerImpl", "loadPre141Impl"));
        }
        if (parents == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parents", "com/intellij/database/dataSource/DatabaseDriverManagerImpl", "loadPre141Impl"));
        }
        for (Element driverState : DatabaseDriverManagerImpl.getDrivers(state)) {
            boolean instantiable;
            String id = DatabaseDriverManagerImpl.getDriverId(driverState);
            DatabaseDriverImpl driver = null;
            boolean bl = instantiable = driverState.getChild("driver") == null && !MIGRATION_MAP.containsKey(id);
            if (id != null) {
                driver = this.getOrCreateDriver(id, predefined, instantiable);
            }
            parents.add(driverState);
            if (driver != null) {
                boolean submerge = merge;
                for (Element parent : parents) {
                    driver.loadState(parent, submerge, false, 0);
                    submerge = true;
                }
            }
            this.loadPre141Impl(driverState, merge, parents, predefined);
            parents.remove(parents.size() - 1);
        }
    }

    EventDispatcher<DatabaseDriverListener> getDispatcher() {
        return this.myDispatcher;
    }

    @Nullable
    public Element getState() {
        Element result = new Element("LocalDatabaseDriverManager");
        result.setAttribute("version", VERSION_LATEST);
        for (DatabaseDriverImpl driver : this.myDrivers.values()) {
            result.addContent(driver.getState(false));
        }
        return result;
    }

    public void loadState(Element state) {
        String version = state.getAttributeValue("version");
        if (Comparing.equal((String)version, (String)VERSION_PRE_141)) {
            this.loadPre141(state, true, false);
        } else if (Comparing.equal((String)version, (String)VERSION_141) || Comparing.equal((String)version, (String)VERSION_LATEST)) {
            this.loadLatest(state, true, false, version);
        } else {
            LOG.warn("Unknown drivers format version: " + version + "\nWon't load.");
        }
    }

    public Collection<DatabaseDriverImpl> getDrivers() {
        return Collections.unmodifiableCollection(this.myDrivers.values());
    }

    @Override
    public DatabaseDriverImpl getDriver(String id) {
        return this.myDrivers.get(StringUtil.notNullize((String)MIGRATION_MAP.get(id), (String)id));
    }

    @Override
    public DatabaseDriverImpl createDriver(String name, String driverClass, UrlTemplate urlTemplate) {
        String driverId = driverClass;
        if (this.getDriver(driverId) != null) {
            driverId = null;
        }
        return new DatabaseDriverImpl(driverId, name, driverClass, urlTemplate);
    }

    @Override
    public void resetToPredefined(@NotNull DatabaseDriver driver) {
        if (driver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "driver", "com/intellij/database/dataSource/DatabaseDriverManagerImpl", "resetToPredefined"));
        }
        DatabaseDriverImpl result = (DatabaseDriverImpl)driver;
        DatabaseDriverImpl backup = this.myPredefinedDrivers.get(driver.getId());
        ArrayList classPath = ContainerUtil.newArrayList(result.getAdditionalClasspathElements());
        result.loadState(backup.getState(true), false, true, Integer.MAX_VALUE);
        result.setAdditionalClasspathElements(classPath);
    }

    @Override
    public boolean isInPredefinedState(@NotNull DatabaseDriver driver) {
        if (driver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "driver", "com/intellij/database/dataSource/DatabaseDriverManagerImpl", "isInPredefinedState"));
        }
        DatabaseDriverImpl backup = this.myPredefinedDrivers.get(driver.getId());
        return backup == null || ((DatabaseDriverImpl)driver).equalConfiguration(backup, true);
    }

    @Override
    public void updateDriver(@NotNull DatabaseDriver driver) {
        if (driver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "driver", "com/intellij/database/dataSource/DatabaseDriverManagerImpl", "updateDriver"));
        }
        DatabaseDriverImpl driverImpl = (DatabaseDriverImpl)driver;
        if (!this.myDrivers.containsKey(driverImpl.getId())) {
            this.addDriver(driverImpl);
        }
    }

    @Override
    public void removeDriver(@NotNull DatabaseDriver driver) {
        if (driver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "driver", "com/intellij/database/dataSource/DatabaseDriverManagerImpl", "removeDriver"));
        }
        if (this.myDrivers.containsKey(driver.getId())) {
            this.removeDriver(driver.getId());
        }
    }

    @Override
    public void addDriverListener(@NotNull DatabaseDriverListener listener, @NotNull Disposable parent) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/database/dataSource/DatabaseDriverManagerImpl", "addDriverListener"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/database/dataSource/DatabaseDriverManagerImpl", "addDriverListener"));
        }
        this.myDispatcher.addListener((EventListener)listener, parent);
    }

    @NotNull
    public File[] getExportFiles() {
        File[] fileArray = new File[]{PathManager.getOptionsFile((String)STATE_NAME)};
        if (fileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseDriverManagerImpl", "getExportFiles"));
        }
        return fileArray;
    }

    @NotNull
    public String getPresentableName() {
        if ("Database: drivers" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseDriverManagerImpl", "getPresentableName"));
        }
        return "Database: drivers";
    }
}

