/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.srcStorage;

import com.intellij.database.dataSource.DataSourceListener;
import com.intellij.database.dataSource.DataSourceManagerEx;
import com.intellij.database.dataSource.DataSourceStorage;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.srcStorage.DbSrcFileStatus;
import com.intellij.database.dataSource.srcStorage.DbSrcFileSystem;
import com.intellij.database.dataSource.srcStorage.DbSrcPath;
import com.intellij.database.dataSource.srcStorage.DbSrcStorage;
import com.intellij.database.dataSource.srcStorage.DbSrcUtils;
import com.intellij.database.model.RawConnectionConfig;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbModeTask;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.roots.impl.FilePropertyPusher;
import com.intellij.openapi.roots.impl.PushedFilePropertiesUpdater;
import com.intellij.openapi.roots.impl.PushedFilePropertiesUpdaterImpl;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.ModificationTrackerListener;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vcs.actions.VcsContextFactory;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.CurrentContentRevision;
import com.intellij.openapi.vcs.changes.TextRevisionNumber;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlPsiFacade;
import com.intellij.util.Alarm;
import com.intellij.util.Consumer;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.indexing.UnindexedFilesUpdater;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DbSrcChangesTracker {
    private static final Logger LOG = Logger.getInstance(DbSrcChangesTracker.class);
    public static final VcsRevisionNumber LOCAL = VcsRevisionNumber.NULL;
    public static final VcsRevisionNumber REMOTE = new TextRevisionNumber("remote");
    protected final Map<String, DbSrcChangeList> myChangeLists = ContainerUtil.newHashMap();
    private final EventDispatcher<ModificationTrackerListener<DbSrcChangesTracker>> myDispatcher = EventDispatcher.create(ModificationTrackerListener.class);
    protected final Project myProject;

    @NotNull
    public static DbSrcChangesTracker getInstance(@Nullable Project project) {
        DbSrcChangesTracker dbSrcChangesTracker = project == null ? (DbSrcChangesTracker)ServiceManager.getService(App.class) : (DbSrcChangesTracker)ServiceManager.getService((Project)project, Proj.class);
        if (dbSrcChangesTracker == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcChangesTracker", "getInstance"));
        }
        return dbSrcChangesTracker;
    }

    public DbSrcChangesTracker(@Nullable Project project) {
        this.myProject = project;
    }

    public void addListener(@NotNull ModificationTrackerListener<DbSrcChangesTracker> listener, @NotNull Disposable parent) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/database/dataSource/srcStorage/DbSrcChangesTracker", "addListener"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/database/dataSource/srcStorage/DbSrcChangesTracker", "addListener"));
        }
        this.myDispatcher.addListener(listener, parent);
    }

    protected void invokeLater(@NotNull Runnable r) {
        if (r == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "r", "com/intellij/database/dataSource/srcStorage/DbSrcChangesTracker", "invokeLater"));
        }
        Application app = ApplicationManager.getApplication();
        app.invokeLater(r, this.myProject == null ? app.getDisposed() : this.myProject.getDisposed());
    }

    @NotNull
    public Set<VirtualFile> getDataSourceRoots() {
        DbSrcFileSystem dbFs = DbSrcFileSystem.getInstance();
        Set set = JBIterable.from(DbSrcUtils.getDataSources(this.myProject)).transform(ds -> dbFs.findFileByPath(DbSrcFileSystem.getPath(ds.isGlobal() ? null : this.myProject, ds.getUniqueId(), null, false))).filter(Conditions.notNull()).toSet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcChangesTracker", "getDataSourceRoots"));
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<DbSrcChangeList> getChangeLists() {
        ArrayList changeLists;
        Map<String, DbSrcChangeList> map = this.myChangeLists;
        synchronized (map) {
            changeLists = ContainerUtil.newArrayList(this.myChangeLists.values());
        }
        if (this.myProject != null) {
            changeLists.addAll(DbSrcChangesTracker.getInstance(null).getChangeLists());
        }
        ArrayList arrayList = changeLists;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcChangesTracker", "getChangeLists"));
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateFiles(@NotNull Collection<VirtualFile> files) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/database/dataSource/srcStorage/DbSrcChangesTracker", "updateFiles"));
        }
        if (!files.isEmpty()) {
            HashMap changeLists = ContainerUtil.newHashMap();
            MultiMap byDataSource = MultiMap.create();
            Iterator iterator = this.myChangeLists;
            synchronized (iterator) {
                this.myChangeLists.entrySet().forEach(e -> {
                    DbSrcChangeList cfr_ignored_0 = (DbSrcChangeList)changeLists.put(e.getKey(), e.getValue());
                });
            }
            for (VirtualFile file : files) {
                String ds = DbSrcUtils.getDataSource(file);
                if (ds == null) continue;
                byDataSource.putValue((Object)ds, (Object)file);
            }
            for (Map.Entry entry : byDataSource.entrySet()) {
                DbSrcChangeList list = (DbSrcChangeList)changeLists.get(entry.getKey());
                if (list == null) continue;
                list.updateChanges((Iterable)entry.getValue());
            }
        }
        if (this.myProject != null) {
            FileStatusManager.getInstance((Project)this.myProject).fileStatusesChanged();
        }
        ((ModificationTrackerListener)this.myDispatcher.getMulticaster()).modificationCountChanged((Object)this);
    }

    private static class MyDataSourceListener
    implements DataSourceListener {
        private final DbSrcChangesTracker myTracker;

        public MyDataSourceListener(@NotNull DbSrcChangesTracker tracker) {
            if (tracker == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tracker", "com/intellij/database/dataSource/srcStorage/DbSrcChangesTracker$MyDataSourceListener", "<init>"));
            }
            this.myTracker = tracker;
            for (LocalDataSource localDataSource : this.getDataSources()) {
                this.dataSourceAdded(localDataSource);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dataSourceAdded(@NotNull LocalDataSource dataSource) {
            if (dataSource == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/dataSource/srcStorage/DbSrcChangesTracker$MyDataSourceListener", "dataSourceAdded"));
            }
            if (!this.isGlobalAccepted() && dataSource.isGlobal()) {
                return;
            }
            Map<String, DbSrcChangeList> map = this.myTracker.myChangeLists;
            synchronized (map) {
                String id = dataSource.getUniqueId();
                if (!this.myTracker.myChangeLists.containsKey(id)) {
                    this.myTracker.myChangeLists.put(id, new DbSrcChangeList(this.myTracker.myProject, id));
                    DialectHandler.updateDialectLater(Collections.singleton(Pair.create((Object)this.myTracker.myProject, (Object)((Object)dataSource))), Collections.emptyList(), () -> this.dataSourceDirty(id));
                }
            }
        }

        private boolean isGlobalAccepted() {
            return this.myTracker.myProject == null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dataSourceRemoved(@NotNull LocalDataSource dataSource) {
            if (dataSource == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/dataSource/srcStorage/DbSrcChangesTracker$MyDataSourceListener", "dataSourceRemoved"));
            }
            if (!this.isGlobalAccepted() && dataSource.isGlobal()) {
                return;
            }
            Map<String, DbSrcChangeList> map = this.myTracker.myChangeLists;
            synchronized (map) {
                String id = dataSource.getUniqueId();
                this.myTracker.myChangeLists.remove(id);
                this.dataSourceDirty(id);
            }
        }

        @Override
        public void dataSourceChanged(@Nullable LocalDataSource dataSource) {
            JBIterable dataSources;
            JBIterable jBIterable = dataSources = dataSource != null ? JBIterable.of((Object)((Object)dataSource)) : JBIterable.from(this.getDataSources());
            if (!this.isGlobalAccepted()) {
                dataSources = dataSources.filter(ds -> !ds.isGlobal());
            }
            if (!dataSources.isEmpty()) {
                DialectHandler.updateDialectLater((Iterable<Pair<Project, LocalDataSource>>)dataSources.transform(ds -> Pair.create((Object)this.myTracker.myProject, (Object)ds)), Collections.emptyList(), null);
            }
        }

        @NotNull
        private List<? extends LocalDataSource> getDataSources() {
            if (this.myTracker.myProject != null) {
                List<? extends LocalDataSource> list = DataSourceManagerEx.getInstanceEx(this.myTracker.myProject).getDataSources();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcChangesTracker$MyDataSourceListener", "getDataSources"));
                }
                return list;
            }
            List<LocalDataSource> list = DataSourceStorage.getStorage().getDataSources();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcChangesTracker$MyDataSourceListener", "getDataSources"));
            }
            return list;
        }

        private void dataSourceDirty(@NotNull String dataSourceId) {
            if (dataSourceId == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSourceId", "com/intellij/database/dataSource/srcStorage/DbSrcChangesTracker$MyDataSourceListener", "dataSourceDirty"));
            }
            App tracker = (App)ObjectUtils.tryCast((Object)this.myTracker, App.class);
            if (tracker == null) {
                tracker = (App)ServiceManager.getService(App.class);
            }
            tracker.fileDirty(DbSrcFileSystem.getInstance().findFileByPath(DbSrcFileSystem.getPath(this.myTracker.myProject, dataSourceId, null, false)));
        }
    }

    public static class Proj
    extends DbSrcChangesTracker {
        private final Alarm myAlarm;

        public Proj(@NotNull Project project, @NotNull App ignored) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/dataSource/srcStorage/DbSrcChangesTracker$Proj", "<init>"));
            }
            if (ignored == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ignored", "com/intellij/database/dataSource/srcStorage/DbSrcChangesTracker$Proj", "<init>"));
            }
            super(project);
            this.myAlarm = new Alarm((Disposable)project);
            if (!DbSrcStorage.isEnabled()) {
                return;
            }
            this.invokeLater(() -> {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/dataSource/srcStorage/DbSrcChangesTracker$Proj", "lambda$new$0"));
                }
                DataSourceManagerEx.getInstanceEx(project).addDataSourceListener(new MyDataSourceListener(this), (Disposable)project);
            });
        }

        private void updateIndex() {
            this.myAlarm.cancelAllRequests();
            this.myAlarm.addRequest(() -> DumbService.getInstance((Project)this.myProject).queueTask((DumbModeTask)new UnindexedFilesUpdater(this.myProject, false)), 5000, ModalityState.NON_MODAL);
        }
    }

    public static class App
    extends DbSrcChangesTracker {
        private final Set<VirtualFile> myDirtyFiles = ContainerUtil.newHashSet();
        private final Alarm myAlarm = new Alarm();

        public App() {
            super(null);
            if (!DbSrcStorage.isEnabled()) {
                return;
            }
            Application app = ApplicationManager.getApplication();
            app.getMessageBus().connect((Disposable)app).subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){

                public void before(@NotNull List<? extends VFileEvent> events) {
                    if (events == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/database/dataSource/srcStorage/DbSrcChangesTracker$App$1", "before"));
                    }
                }

                public void after(@NotNull List<? extends VFileEvent> events) {
                    if (events == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/database/dataSource/srcStorage/DbSrcChangesTracker$App$1", "after"));
                    }
                    for (VFileEvent vFileEvent : events) {
                        if (!(vFileEvent.getFileSystem() instanceof DbSrcFileSystem)) continue;
                        this.fileDirty(vFileEvent.getFile());
                    }
                    DialectHandler.processEvents(events);
                }
            });
            EditorFactory.getInstance().getEventMulticaster().addDocumentListener(new DocumentListener(){
                private FileDocumentManager myDocumentManager = FileDocumentManager.getInstance();

                public void beforeDocumentChange(DocumentEvent event) {
                }

                public void documentChanged(DocumentEvent event) {
                    VirtualFile file = this.myDocumentManager.getFile(event.getDocument());
                    if (file == null || !(file.getFileSystem() instanceof DbSrcFileSystem)) {
                        return;
                    }
                    this.fileDirty(file);
                }
            }, (Disposable)app);
            this.invokeLater(() -> DataSourceStorage.getStorage().addDataSourceListener(new MyDataSourceListener(this)));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void fileDirty(@Nullable VirtualFile file) {
            if (file == null || !(file.getFileSystem() instanceof DbSrcFileSystem)) {
                return;
            }
            Set<VirtualFile> set = this.myDirtyFiles;
            synchronized (set) {
                this.myDirtyFiles.add(file);
            }
            this.myAlarm.cancelAllRequests();
            this.myAlarm.addRequest(this::update, 1000, ModalityState.defaultModalityState());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void update() {
            ArrayList files;
            Set<VirtualFile> set = this.myDirtyFiles;
            synchronized (set) {
                files = ContainerUtil.newArrayList(this.myDirtyFiles);
                this.myDirtyFiles.clear();
            }
            ApplicationManager.getApplication().executeOnPooledThread(() -> {
                MultiMap byProject = MultiMap.create();
                for (VirtualFile file : files) {
                    Ref<Project> p = DbSrcUtils.getProject(file);
                    if (p == null) continue;
                    byProject.putValue(p.get(), (Object)file);
                }
                if (byProject.containsKey(null)) {
                    this.updateFiles(byProject.get(null));
                    for (Project project : ProjectManager.getInstance().getOpenProjects()) {
                        DbSrcChangesTracker.getInstance(project).updateFiles(byProject.get((Object)project));
                    }
                } else {
                    for (Map.Entry entry : byProject.entrySet()) {
                        DbSrcChangesTracker.getInstance((Project)entry.getKey()).updateFiles((Collection)entry.getValue());
                    }
                }
            });
        }
    }

    private static class DialectHandler {
        private static final FilePropertyPusher myPusher = DialectHandler.findDialectPusher();

        private DialectHandler() {
        }

        private static FilePropertyPusher findDialectPusher() {
            for (FilePropertyPusher pusher : (FilePropertyPusher[])Extensions.getExtensions((ExtensionPointName)FilePropertyPusher.EP_NAME)) {
                if (pusher.getDefaultValue() != DbSqlUtil.getGenericDialect()) continue;
                return pusher;
            }
            Logger.getInstance(DialectHandler.class).warn("SqlDialectPusher not found");
            return null;
        }

        public static void processEvents(@NotNull List<? extends VFileEvent> events) {
            if (events == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/database/dataSource/srcStorage/DbSrcChangesTracker$DialectHandler", "processEvents"));
            }
            final HashSet dataSources = ContainerUtil.newHashSet();
            final HashSet files = ContainerUtil.newHashSet();
            for (final VFileEvent vFileEvent : events) {
                if (!(vFileEvent.getFileSystem() instanceof DbSrcFileSystem) || !(vFileEvent instanceof VFileCreateEvent) && !(vFileEvent instanceof VFileMoveEvent)) continue;
                DbSrcFileSystem.processPath(vFileEvent.getPath(), new DbSrcFileSystem.ItemProcessor<Void>(){

                    @Override
                    public Void processDataSource(@Nullable Project project, @NotNull String dataSourceId) {
                        if (dataSourceId == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSourceId", "com/intellij/database/dataSource/srcStorage/DbSrcChangesTracker$DialectHandler$1", "processDataSource"));
                        }
                        LocalDataSource dataSource = DbSrcUtils.findDataSource(project, dataSourceId);
                        if (dataSource != null) {
                            dataSources.add(Pair.create((Object)project, (Object)((Object)dataSource)));
                        }
                        return null;
                    }

                    @Override
                    public Void processFile(@Nullable Project project, @NotNull String dataSourceId, @NotNull DbSrcPath path) {
                        if (dataSourceId == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSourceId", "com/intellij/database/dataSource/srcStorage/DbSrcChangesTracker$DialectHandler$1", "processFile"));
                        }
                        if (path == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/database/dataSource/srcStorage/DbSrcChangesTracker$DialectHandler$1", "processFile"));
                        }
                        VirtualFile file = vFileEvent.getFile();
                        if (file != null) {
                            files.add(Pair.create((Object)project, (Object)file));
                        }
                        return null;
                    }
                });
            }
            if (!dataSources.isEmpty() || !files.isEmpty()) {
                DialectHandler.updateDialectLater(dataSources, files, null);
            }
        }

        public static void updateDialectLater(@NotNull Iterable<Pair<Project, LocalDataSource>> sources, @NotNull Iterable<Pair<Project, VirtualFile>> files, @Nullable Runnable extra) {
            if (sources == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sources", "com/intellij/database/dataSource/srcStorage/DbSrcChangesTracker$DialectHandler", "updateDialectLater"));
            }
            if (files == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/database/dataSource/srcStorage/DbSrcChangesTracker$DialectHandler", "updateDialectLater"));
            }
            Application app = ApplicationManager.getApplication();
            app.invokeLater(() -> {
                if (sources == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sources", "com/intellij/database/dataSource/srcStorage/DbSrcChangesTracker$DialectHandler", "lambda$updateDialectLater$0"));
                }
                if (files == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/database/dataSource/srcStorage/DbSrcChangesTracker$DialectHandler", "lambda$updateDialectLater$0"));
                }
                DialectHandler.updateDialect(sources, files);
                if (extra != null) {
                    extra.run();
                }
            }, app.getDisposed());
        }

        public static void updateDialect(@NotNull Iterable<Pair<Project, LocalDataSource>> sources, @NotNull Iterable<Pair<Project, VirtualFile>> files) {
            if (sources == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sources", "com/intellij/database/dataSource/srcStorage/DbSrcChangesTracker$DialectHandler", "updateDialect"));
            }
            if (files == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/database/dataSource/srcStorage/DbSrcChangesTracker$DialectHandler", "updateDialect"));
            }
            DbSrcFileSystem dbFs = DbSrcFileSystem.getInstance();
            class ProjectSet {
                boolean allProjects = false;
                Set<Project> projects = ContainerUtil.newHashSet();

                ProjectSet() {
                }

                void process(Project p, Consumer<Project> consumer) {
                    if (p == null && !this.allProjects) {
                        ContainerUtil.addAll(this.projects, (Object[])ProjectManager.getInstance().getOpenProjects());
                        this.allProjects = true;
                    }
                    if (p != null) {
                        consumer.consume((Object)p);
                        this.projects.add(p);
                    } else {
                        this.projects.forEach(arg_0 -> consumer.consume(arg_0));
                    }
                }
            }
            ProjectSet projectSet = new ProjectSet();
            for (Pair<Project, LocalDataSource> pair : sources) {
                VirtualFile file;
                if (pair.first != null && ((Project)pair.first).isDisposed() || (file = dbFs.findFileByPath(DbSrcFileSystem.getPath((Project)pair.first, ((LocalDataSource)((Object)pair.second)).getUniqueId(), null, false))) == null) continue;
                projectSet.process((Project)pair.first, (Consumer<Project>)((Consumer)project -> {
                    SqlPsiFacade facade;
                    SqlLanguageDialect have;
                    SqlLanguageDialect should = DbSqlUtil.getSqlDialect(project, (RawConnectionConfig)pair.second);
                    if (!Comparing.equal((Object)should, (Object)(have = (facade = SqlPsiFacade.getInstance((Project)project)).getDialectMapping(file)))) {
                        facade.setDialectMapping(file, should);
                    }
                    DialectHandler.pushDialect(project, file);
                }));
            }
            for (Pair<Project, LocalDataSource> pair : files) {
                if (pair.first != null && ((Project)pair.first).isDisposed()) continue;
                projectSet.process((Project)pair.first, (Consumer<Project>)((Consumer)project -> DialectHandler.pushDialect(project, (VirtualFile)pair.second)));
            }
            projectSet.projects.forEach(p -> ((Proj)ServiceManager.getService((Project)p, Proj.class)).updateIndex());
        }

        private static void pushDialect(final @NotNull Project project, final @NotNull VirtualFile root2) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/dataSource/srcStorage/DbSrcChangesTracker$DialectHandler", "pushDialect"));
            }
            if (root2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/database/dataSource/srcStorage/DbSrcChangesTracker$DialectHandler", "pushDialect"));
            }
            if (myPusher == null) {
                return;
            }
            Object prevValue = myPusher.getFileDataKey().get((UserDataHolder)root2);
            PushedFilePropertiesUpdater.getInstance((Project)project).findAndUpdateValue(root2, myPusher, null);
            final Object value = myPusher.getFileDataKey().get((UserDataHolder)root2);
            if (value == null || prevValue == value) {
                return;
            }
            try {
                VfsUtilCore.visitChildrenRecursively((VirtualFile)root2, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[0]){

                    public boolean visitFile(@NotNull VirtualFile vfile) {
                        if (vfile == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vfile", "com/intellij/database/dataSource/srcStorage/DbSrcChangesTracker$DialectHandler$2", "visitFile"));
                        }
                        Object cur = myPusher.getFileDataKey().get((UserDataHolder)vfile);
                        if (cur == value) {
                            return Comparing.equal((Object)vfile, (Object)root2);
                        }
                        PushedFilePropertiesUpdaterImpl.updateValue((Project)project, (VirtualFile)vfile, (Object)value, (FilePropertyPusher)myPusher);
                        return true;
                    }
                });
            }
            catch (StackOverflowError e) {
                LOG.warn("Ouch, stack overflow on: " + root2.getPath());
                throw e;
            }
        }
    }

    public static final class DbContentRevision
    extends CurrentContentRevision {
        private final VirtualFile myContent;
        private final VcsRevisionNumber myRevision;

        public DbContentRevision(@NotNull VirtualFile content, @NotNull FilePath file, @NotNull VcsRevisionNumber revision) {
            if (content == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/database/dataSource/srcStorage/DbSrcChangesTracker$DbContentRevision", "<init>"));
            }
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/dataSource/srcStorage/DbSrcChangesTracker$DbContentRevision", "<init>"));
            }
            if (revision == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "revision", "com/intellij/database/dataSource/srcStorage/DbSrcChangesTracker$DbContentRevision", "<init>"));
            }
            super(file);
            this.myContent = content;
            this.myFile = file;
            this.myRevision = revision;
        }

        @Nullable
        public VirtualFile getVirtualFile() {
            return this.myContent;
        }

        @NotNull
        public VcsRevisionNumber getRevisionNumber() {
            VcsRevisionNumber vcsRevisionNumber = this.myRevision;
            if (vcsRevisionNumber == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcChangesTracker$DbContentRevision", "getRevisionNumber"));
            }
            return vcsRevisionNumber;
        }
    }

    public static class DbSrcChangeList
    implements ChangeList {
        private final String myDataSourceId;
        private final Project myProject;
        private volatile Map<VirtualFile, Change> myChanges;
        private String myName;

        public DbSrcChangeList(@Nullable Project project, @NotNull String dataSourceId) {
            if (dataSourceId == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSourceId", "com/intellij/database/dataSource/srcStorage/DbSrcChangesTracker$DbSrcChangeList", "<init>"));
            }
            this.myChanges = Collections.emptyMap();
            this.myProject = project;
            this.myDataSourceId = dataSourceId;
            this.updateName();
        }

        public Collection<Change> getChanges() {
            return this.myChanges == null ? Collections.emptyList() : this.myChanges.values();
        }

        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcChangesTracker$DbSrcChangeList", "getName"));
            }
            return string;
        }

        public String getComment() {
            return null;
        }

        private void updateName() {
            LocalDataSource source = this.getDataSource();
            this.myName = source == null ? "invalid" : source.getName();
        }

        @Nullable
        public LocalDataSource getDataSource() {
            return DbSrcUtils.findDataSource(this.myProject, this.myDataSourceId);
        }

        public void updateChanges(@NotNull Iterable<VirtualFile> files) {
            if (files == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/database/dataSource/srcStorage/DbSrcChangesTracker$DbSrcChangeList", "updateChanges"));
            }
            final DbSrcFileStatus fileStatus = DbSrcFileStatus.getInstance();
            final VcsContextFactory contextFactory = VcsContextFactory.SERVICE.getInstance();
            Map<VirtualFile, Change> old = this.myChanges;
            final ContainerUtil.ImmutableMapBuilder newChanges = ContainerUtil.immutableMapBuilder();
            for (Map.Entry<VirtualFile, Change> entry : old.entrySet()) {
                if (fileStatus.getStatus(entry.getKey()).getStatus() == null) continue;
                newChanges.put((Object)entry.getKey(), (Object)entry.getValue());
            }
            for (VirtualFile file : files) {
                VfsUtilCore.visitChildrenRecursively((VirtualFile)file, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[0]){

                    public boolean visitFile(@NotNull VirtualFile file) {
                        if (file == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/dataSource/srcStorage/DbSrcChangesTracker$DbSrcChangeList$1", "visitFile"));
                        }
                        if (file.isDirectory()) {
                            return true;
                        }
                        DbSrcFileStatus.StatusEntry status = fileStatus.getStatus(file);
                        if (status.getStatus() != null) {
                            String baseUrl = status.getBaseFileUrl();
                            VirtualFile baseFile = baseUrl == null ? null : VirtualFileManager.getInstance().findFileByUrl(baseUrl);
                            FilePath path = contextFactory.createFilePath(file.getPath(), false);
                            newChanges.put((Object)file, (Object)new Change((ContentRevision)(baseFile == null ? null : new DbContentRevision(baseFile, path, REMOTE)), (ContentRevision)new DbContentRevision(file, path, LOCAL), status.getStatus()));
                        }
                        return true;
                    }
                });
            }
            this.updateName();
            this.myChanges = newChanges.build();
        }
    }
}

