/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.srcStorage;

import com.intellij.database.dataSource.DataSourceListener;
import com.intellij.database.dataSource.DataSourceManagerEx;
import com.intellij.database.dataSource.DataSourceStorage;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.srcStorage.DbDataSourceLayout;
import com.intellij.database.dataSource.srcStorage.DbSrcPath;
import com.intellij.database.dataSource.srcStorage.DbSrcStorage;
import com.intellij.database.dataSource.srcStorage.DbSrcStorageDsMetadata;
import com.intellij.database.dataSource.srcStorage.DbSrcStorageLayout;
import com.intellij.database.dataSource.srcStorage.DbSrcUtils;
import com.intellij.database.vfs.DatabaseElementVirtualFileImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerAdapter;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.BufferExposingByteArrayInputStream;
import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.FileSystemInterface;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.openapi.vfs.newvfs.VfsImplUtil;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.util.Alarm;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.BidirectionalMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbSrcFileSystem
extends NewVirtualFileSystem {
    private static final Logger LOG = Logger.getInstance(DbSrcFileSystem.class);
    public static final String PROTOCOL = "dbSrc";
    public static final FileAttributes DEFAULT_FOLDER_ATTRIBUTES = new FileAttributes(true, false, false, false, 0L, 0L, false);
    public static final String APP_PROJECT_ID = "app";
    private final List<ProjectRoot> myProjectRoots = new CopyOnWriteArrayList<ProjectRoot>();
    private final Alarm myRefreshAlarm = new Alarm((Disposable)ApplicationManager.getApplication());

    public static DbSrcFileSystem getInstance() {
        return (DbSrcFileSystem)VirtualFileManager.getInstance().getFileSystem(PROTOCOL);
    }

    public DbSrcFileSystem() {
        if (!DbSrcStorage.isEnabled()) {
            return;
        }
        final Application application = ApplicationManager.getApplication();
        application.getMessageBus().connect((Disposable)application).subscribe(ProjectManager.TOPIC, (Object)new ProjectManagerListener(){

            public void projectOpened(Project project) {
                if (DbSrcFileSystem.this.myProjectRoots.isEmpty() && project != null) {
                    this.projectOpened(null);
                    Disposer.register((Disposable)application, () -> this.projectClosed(null));
                }
                String root2 = DbSrcStorage.getStorageRoot(project);
                String id = DbSrcUtils.getProjectId(project);
                DbSrcFileSystem.this.myProjectRoots.add(new ProjectRoot(id, root2));
                VfsUtil.markDirty((boolean)false, (boolean)false, (VirtualFile[])new VirtualFile[]{DbSrcFileSystem.this.findFileByPath("/")});
                DbSrcFileSystem.this.scheduleRefresh();
                if (project == null) {
                    DataSourceStorage.getStorage().addDataSourceListener(new MyDataSourceUpdater(null), (Disposable)application);
                } else {
                    DataSourceManagerEx.getInstanceEx(project).addDataSourceListener(new MyDataSourceUpdater(project), (Disposable)project);
                }
            }

            public void projectClosed(Project project) {
                String id = DbSrcUtils.getProjectId(project);
                ProjectRoot root2 = (ProjectRoot)ContainerUtil.find((Iterable)DbSrcFileSystem.this.myProjectRoots, r -> r.projectId.equals(id));
                if (root2 == null) {
                    return;
                }
                DbSrcFileSystem.this.myProjectRoots.remove(root2);
                LocalFileSystem.getInstance().removeWatchedRoot(root2.watchRequest);
                VfsUtil.markDirty((boolean)true, (boolean)false, (VirtualFile[])new VirtualFile[]{DbSrcFileSystem.this.findFileByPath(DbSrcFileSystem.getPath(project, null, null, false))});
                DbSrcFileSystem.this.scheduleRefresh();
            }
        });
        application.getMessageBus().connect((Disposable)application).subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){

            public void before(@NotNull List<? extends VFileEvent> events) {
                if (events == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem$2", "before"));
                }
            }

            public void after(@NotNull List<? extends VFileEvent> events) {
                if (events == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem$2", "after"));
                }
                ArrayList files = ContainerUtil.newArrayList();
                for (VFileEvent vFileEvent : events) {
                    String projectId = DbSrcFileSystem.this.getProjectRoot(vFileEvent.getPath());
                    if (projectId == null) continue;
                    Project project = null;
                    if (!DbSrcFileSystem.APP_PROJECT_ID.equals(projectId) && (project = ProjectIdMap.INSTANCE.getProject(projectId)) == null) continue;
                    VirtualFile baseFile = vFileEvent.getFile();
                    String dataSourceId = DbSrcUtils.getDataSourceId(project, baseFile);
                    if (dataSourceId == null || baseFile == null) {
                        ContainerUtil.addIfNotNull((Collection)files, (Object)DbSrcFileSystem.this.findAnyFileByPathUpward(DbSrcFileSystem.getPath(project, null, null, false)));
                        continue;
                    }
                    DbDataSourceLayout layout = DbSrcStorage.getInstance(project).getLayout(dataSourceId);
                    Pair<DbSrcPath, Boolean> object = layout.getObject(baseFile);
                    if (object == null) {
                        ContainerUtil.addIfNotNull((Collection)files, (Object)DbSrcFileSystem.this.findAnyFileByPathUpward(DbSrcFileSystem.getPath(project, dataSourceId, null, false)));
                        continue;
                    }
                    if (object.second == Boolean.TRUE && (vFileEvent instanceof VFileCreateEvent || vFileEvent instanceof VFileContentChangeEvent)) continue;
                    for (int i2 = 0; i2 < 2; ++i2) {
                        ContainerUtil.addIfNotNull((Collection)files, (Object)DbSrcFileSystem.this.findAnyFileByPathUpward(DbSrcFileSystem.getPath(project, dataSourceId, (DbSrcPath)object.first, i2 == 0)));
                    }
                }
                if (!files.isEmpty()) {
                    VfsUtil.markDirty((boolean)true, (boolean)false, (VirtualFile[])VfsUtilCore.toVirtualFileArray((Collection)files));
                    DbSrcFileSystem.this.scheduleRefresh();
                }
            }
        });
    }

    @Nullable
    private String getProjectRoot(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem", "getProjectRoot"));
        }
        for (ProjectRoot root2 : this.myProjectRoots) {
            if (!FileUtil.isAncestor((String)root2.root, (String)path, (boolean)false)) continue;
            return root2.projectId;
        }
        return null;
    }

    @NotNull
    public static String getPath(@Nullable Project project, @Nullable String dsId, @Nullable DbSrcPath object, boolean src) {
        StringBuilder builder = new StringBuilder();
        builder.append("/").append(DbSrcUtils.getProjectId(project));
        if (dsId != null) {
            builder.append("/").append(dsId);
            if (object != null) {
                int end = object.size();
                for (int i2 = 0; i2 < end; ++i2) {
                    builder.append("/").append(DbSrcFileSystem.escape(object.kind(i2))).append("/").append(DbSrcFileSystem.escape(object.name(i2)));
                }
                if (src) {
                    String d = object.getDisambiguator();
                    if (d != null) {
                        builder.append(".").append(DbSrcFileSystem.escape(d));
                    }
                    builder.append(".sql");
                }
            }
        }
        String string = builder.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem", "getPath"));
        }
        return string;
    }

    @NotNull
    public String getProtocol() {
        if (PROTOCOL == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem", "getProtocol"));
        }
        return PROTOCOL;
    }

    @Nullable
    public VirtualFile findFileByPath(@NotNull @NonNls String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem", "findFileByPath"));
        }
        return VfsImplUtil.findFileByPath((NewVirtualFileSystem)this, (String)path);
    }

    @Nullable
    public VirtualFile findAnyFileByPathUpward(@NotNull @NonNls String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem", "findAnyFileByPathUpward"));
        }
        VirtualFile last = this.findFileByPath("/");
        if (last == null) {
            return null;
        }
        for (String item : DbSrcFileSystem.splitPath(path)) {
            VirtualFile child = last.findChild(item);
            if (child == null) {
                return last;
            }
            last = child;
        }
        return last;
    }

    @NotNull
    public String extractPresentableUrl(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem", "extractPresentableUrl"));
        }
        StringBuilder res = DbSrcFileSystem.processPath(path, new ItemProcessor<StringBuilder>(){

            @Override
            public StringBuilder processProject(@Nullable Project project) {
                return new StringBuilder(project == null ? "Application" : project.getName());
            }

            @Override
            public StringBuilder processDataSource(@Nullable Project project, @NotNull String dataSourceId) {
                if (dataSourceId == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSourceId", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem$3", "processDataSource"));
                }
                LocalDataSource source = DbSrcUtils.findDataSource(project, dataSourceId);
                return this.processProject(project).append(File.separator).append(source == null ? dataSourceId : source.getName());
            }

            @Override
            public StringBuilder processFolder(@Nullable Project project, @NotNull String dataSourceId, @Nullable DbSrcPath path, @Nullable String group) {
                if (dataSourceId == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSourceId", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem$3", "processFolder"));
                }
                StringBuilder res = this.processPath(project, dataSourceId, path);
                if (group != null) {
                    res.append(File.separator).append(group);
                }
                return res;
            }

            @Override
            public StringBuilder processFile(@Nullable Project project, @NotNull String dataSourceId, @NotNull DbSrcPath path) {
                if (dataSourceId == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSourceId", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem$3", "processFile"));
                }
                if (path == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem$3", "processFile"));
                }
                StringBuilder res = this.processPath(project, dataSourceId, path);
                if (path.getDisambiguator() != null) {
                    res.append(path.getDisambiguator());
                }
                return res;
            }

            public StringBuilder processPath(@Nullable Project project, @NotNull String dataSourceId, @Nullable DbSrcPath path) {
                if (dataSourceId == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSourceId", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem$3", "processPath"));
                }
                StringBuilder res = this.processDataSource(project, dataSourceId);
                if (path != null) {
                    for (int i2 = 0; i2 < path.size(); ++i2) {
                        res.append(File.separator).append(path.kind(i2)).append(File.separator).append(path.name(i2));
                    }
                }
                return res;
            }
        });
        String string = res == null || res.length() == 0 ? path : res.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem", "extractPresentableUrl"));
        }
        return string;
    }

    public void refresh(boolean asynchronous) {
        ArrayList roots = ContainerUtil.newArrayList();
        for (ProjectRoot root2 : this.myProjectRoots) {
            ContainerUtil.addIfNotNull((Collection)roots, (Object)LocalFileSystem.getInstance().findFileByPath(root2.root));
        }
        ContainerUtil.addAllNotNull((Collection)roots, (Object[])ManagingFS.getInstance().getRoots((NewVirtualFileSystem)this));
        if (roots.size() > 0) {
            RefreshQueue.getInstance().refresh(asynchronous, true, null, (Collection)roots);
        }
    }

    @Nullable
    public VirtualFile refreshAndFindFileByPath(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem", "refreshAndFindFileByPath"));
        }
        return VfsImplUtil.refreshAndFindFileByPath((NewVirtualFileSystem)this, (String)path);
    }

    @Nullable
    public VirtualFile findFileByPathIfCached(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem", "findFileByPathIfCached"));
        }
        return VfsImplUtil.findFileByPathIfCached((NewVirtualFileSystem)this, (String)path);
    }

    @NotNull
    protected String extractRootPath(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem", "extractRootPath"));
        }
        String string = path.startsWith("/") ? "/" : "";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem", "extractRootPath"));
        }
        return string;
    }

    @Nullable
    protected String normalize(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem", "normalize"));
        }
        return path.startsWith("/") ? path : "/" + path;
    }

    public int getRank() {
        return 1;
    }

    @NotNull
    public VirtualFile copyFile(Object requestor, @NotNull VirtualFile file, @NotNull VirtualFile newParent, @NotNull String copyName) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem", "copyFile"));
        }
        if (newParent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newParent", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem", "copyFile"));
        }
        if (copyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "copyName", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem", "copyFile"));
        }
        throw DbSrcFileSystem.unsupported("copy", file);
    }

    @NotNull
    public VirtualFile createChildDirectory(Object requestor, @NotNull VirtualFile parent, @NotNull String dir) throws IOException {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem", "createChildDirectory"));
        }
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem", "createChildDirectory"));
        }
        throw DbSrcFileSystem.unsupported("create directory", parent);
    }

    @NotNull
    public VirtualFile createChildFile(Object requestor, @NotNull VirtualFile parent, @NotNull String file) throws IOException {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem", "createChildFile"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem", "createChildFile"));
        }
        throw DbSrcFileSystem.unsupported("create file", parent);
    }

    public void deleteFile(Object requestor, @NotNull VirtualFile file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem", "deleteFile"));
        }
        throw DbSrcFileSystem.unsupported("delete", file);
    }

    public void moveFile(Object requestor, @NotNull VirtualFile file, @NotNull VirtualFile newParent) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem", "moveFile"));
        }
        if (newParent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newParent", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem", "moveFile"));
        }
        throw DbSrcFileSystem.unsupported("move", file);
    }

    public void renameFile(Object requestor, @NotNull VirtualFile file, @NotNull String newName) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem", "renameFile"));
        }
        if (newName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newName", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem", "renameFile"));
        }
        throw DbSrcFileSystem.unsupported("rename", file);
    }

    @NotNull
    private static IOException unsupported(@NotNull String op, @NotNull VirtualFile file) {
        if (op == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "op", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem", "unsupported"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem", "unsupported"));
        }
        IOException iOException = new IOException(StringUtil.capitalize((String)op) + " is unsupported for DbSrcFS: " + file.getUrl());
        if (iOException == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem", "unsupported"));
        }
        return iOException;
    }

    @Nullable
    public FileAttributes getAttributes(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem", "getAttributes"));
        }
        if (!DbSrcStorage.isEnabled()) {
            return null;
        }
        return DbSrcFileSystem.processPath(file, new ItemProcessor<FileAttributes>(){

            @Override
            public FileAttributes processRoot() {
                return DEFAULT_FOLDER_ATTRIBUTES;
            }

            @Override
            public FileAttributes processProject(@Nullable Project project) {
                return DEFAULT_FOLDER_ATTRIBUTES;
            }

            @Override
            public FileAttributes processDataSource(@Nullable Project project, @NotNull String dataSourceId) {
                if (dataSourceId == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSourceId", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem$4", "processDataSource"));
                }
                DbSrcStorage storage = DbSrcStorage.getInstance(project);
                return storage.exists(dataSourceId) ? DEFAULT_FOLDER_ATTRIBUTES : null;
            }

            @Override
            public FileAttributes processFolder(@Nullable Project project, @NotNull String dataSourceId, @Nullable DbSrcPath path, @Nullable String group) {
                if (dataSourceId == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSourceId", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem$4", "processFolder"));
                }
                DbSrcStorage storage = DbSrcStorage.getInstance(project);
                DbDataSourceLayout layout = storage.getLayout(dataSourceId);
                if (group != null) {
                    return DEFAULT_FOLDER_ATTRIBUTES;
                }
                DbSrcStorageLayout.Item item = layout.getPath(path, false);
                return item != null && item.hasChildren() ? DEFAULT_FOLDER_ATTRIBUTES : null;
            }

            @Override
            public FileAttributes processFile(@Nullable Project project, @NotNull String dataSourceId, @NotNull DbSrcPath path) {
                VirtualFile baseFile;
                if (dataSourceId == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSourceId", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem$4", "processFile"));
                }
                if (path == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem$4", "processFile"));
                }
                DbSrcStorage storage = DbSrcStorage.getInstance(project);
                DbDataSourceLayout layout = storage.getLayout(dataSourceId);
                DbSrcStorageLayout.Item item = layout.getPath(path, true);
                VirtualFile virtualFile = baseFile = item == null ? null : item.getSrcFile();
                if (baseFile == null) {
                    item = layout.getPath(path, false);
                    VirtualFile virtualFile2 = baseFile = item == null ? null : item.getSrcFile();
                }
                if (baseFile == null) {
                    return null;
                }
                NewVirtualFileSystem baseFs = (NewVirtualFileSystem)ObjectUtils.tryCast((Object)baseFile.getFileSystem(), NewVirtualFileSystem.class);
                if (baseFs != null) {
                    FileAttributes attr = baseFs.getAttributes(baseFile);
                    return attr == null ? null : new FileAttributes(attr.isDirectory(), attr.isSpecial(), attr.isSymLink(), attr.isHidden(), attr.length, attr.lastModified, DbSrcStorage.isWritable());
                }
                return new FileAttributes(false, false, false, false, baseFile.getLength(), baseFile.getModificationStamp(), DbSrcStorage.isWritable());
            }
        });
    }

    public boolean exists(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem", "exists"));
        }
        return this.getAttributes(file) != null;
    }

    @NotNull
    public String[] list(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem", "list"));
        }
        if (!DbSrcStorage.isEnabled()) {
            if (ArrayUtil.EMPTY_STRING_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem", "list"));
            }
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        String[] stringArray = ArrayUtil.toStringArray(DbSrcFileSystem.processPath(file, new ItemProcessor<Collection<String>>(){

            @Override
            public Collection<String> processRoot() {
                ArrayList res = ContainerUtil.newArrayList((Object[])new String[]{DbSrcFileSystem.APP_PROJECT_ID});
                for (Project p : ProjectManager.getInstance().getOpenProjects()) {
                    res.add(p.getLocationHash());
                }
                return res;
            }

            @Override
            public Collection<String> processOutOfDate() {
                return Collections.emptyList();
            }

            @Override
            public Collection<String> processProject(@Nullable Project project) {
                return DbSrcStorage.getInstance(project).getDataSources();
            }

            @Override
            public Collection<String> processDataSource(@Nullable Project project, @NotNull String dataSourceId) {
                if (dataSourceId == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSourceId", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem$5", "processDataSource"));
                }
                DbDataSourceLayout layout = DbSrcStorage.getInstance(project).getLayout(dataSourceId);
                return JBIterable.from(layout.getExistingGroups(null)).transform(k -> DbSrcFileSystem.escape(k)).toList();
            }

            @Override
            public Collection<String> processFolder(@Nullable Project project, @NotNull String dataSourceId, @Nullable DbSrcPath path, @Nullable String group) {
                if (dataSourceId == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSourceId", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem$5", "processFolder"));
                }
                DbDataSourceLayout layout = DbSrcStorage.getInstance(project).getLayout(dataSourceId);
                if (group != null) {
                    ArrayList res = ContainerUtil.newArrayList();
                    for (DbSrcPath child : JBIterable.from(layout.getExistingChildren(path, group))) {
                        DbSrcStorageLayout.Item item = layout.getPath(child, false);
                        if (item == null) continue;
                        if (item.getSrcFile() != null) {
                            String d = child.getDisambiguator();
                            res.add(DbSrcFileSystem.escape(child.getName()) + (d == null ? "" : "." + DbSrcFileSystem.escape(d)) + ".sql");
                        }
                        if (!item.hasChildren()) continue;
                        res.add(DbSrcFileSystem.escape(child.getName()));
                    }
                    return res;
                }
                return JBIterable.from(layout.getExistingGroups(path)).transform(k -> DbSrcFileSystem.escape(k)).toList();
            }

            @Override
            public Collection<String> processFile(@Nullable Project project, @NotNull String dataSourceId, @NotNull DbSrcPath path) {
                if (dataSourceId == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSourceId", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem$5", "processFile"));
                }
                if (path == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem$5", "processFile"));
                }
                return Collections.emptyList();
            }
        }));
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem", "list"));
        }
        return stringArray;
    }

    public boolean isDirectory(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem", "isDirectory"));
        }
        FileAttributes attributes = this.getAttributes(file);
        return attributes != null && attributes.isDirectory();
    }

    public boolean isWritable(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem", "isWritable"));
        }
        FileAttributes attributes = this.getAttributes(file);
        return attributes != null && attributes.isWritable();
    }

    public boolean isSymLink(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem", "isSymLink"));
        }
        FileAttributes attributes = this.getAttributes(file);
        return attributes != null && attributes.isSymLink();
    }

    public long getTimeStamp(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem", "getTimeStamp"));
        }
        FileAttributes attributes = this.getAttributes(file);
        return attributes != null ? attributes.lastModified : 0L;
    }

    public long getLength(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem", "getLength"));
        }
        FileAttributes attributes = this.getAttributes(file);
        return attributes != null ? attributes.length : 0L;
    }

    public void setTimeStamp(@NotNull VirtualFile file, long timeStamp) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem", "setTimeStamp"));
        }
        throw DbSrcFileSystem.unsupported("set timestamp", file);
    }

    public void setWritable(@NotNull VirtualFile file, boolean writableFlag) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem", "setWritable"));
        }
        throw DbSrcFileSystem.unsupported("set writable", file);
    }

    @NotNull
    public byte[] contentsToByteArray(@NotNull VirtualFile file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem", "contentsToByteArray"));
        }
        VirtualFile baseFile = this.getBaseFile(file, true);
        if (baseFile == null) {
            baseFile = this.getBaseFile(file, false);
        }
        if (baseFile == null) {
            if (ArrayUtil.EMPTY_BYTE_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem", "contentsToByteArray"));
            }
            return ArrayUtil.EMPTY_BYTE_ARRAY;
        }
        FileSystemInterface fs = (FileSystemInterface)ObjectUtils.tryCast((Object)baseFile.getFileSystem(), FileSystemInterface.class);
        byte[] byArray = fs == null ? baseFile.contentsToByteArray() : fs.contentsToByteArray(baseFile);
        if (byArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem", "contentsToByteArray"));
        }
        return byArray;
    }

    @NotNull
    public InputStream getInputStream(@NotNull VirtualFile file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem", "getInputStream"));
        }
        BufferExposingByteArrayInputStream bufferExposingByteArrayInputStream = new BufferExposingByteArrayInputStream(this.contentsToByteArray(file));
        if (bufferExposingByteArrayInputStream == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem", "getInputStream"));
        }
        return bufferExposingByteArrayInputStream;
    }

    @NotNull
    public OutputStream getOutputStream(@NotNull VirtualFile file, Object requestor, long modStamp, long l) throws IOException {
        Integer hash;
        VirtualFile baseFile;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem", "getOutputStream"));
        }
        if (!DbSrcStorage.isWritable()) {
            throw new UnsupportedOperationException("Storage is not writable");
        }
        final DbSrcStorageDsMetadata.MetaData[] metaData = new DbSrcStorageDsMetadata.MetaData[]{null};
        Couple<DbSrcStorageLayout.Item> items = DbSrcFileSystem.processPath(file, new ItemProcessor<Couple<DbSrcStorageLayout.Item>>(){

            @Override
            public Couple<DbSrcStorageLayout.Item> processFile(@Nullable Project project, @NotNull String dataSourceId, @NotNull DbSrcPath path) {
                if (dataSourceId == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSourceId", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem$6", "processFile"));
                }
                if (path == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem$6", "processFile"));
                }
                DbSrcStorage instance = DbSrcStorage.getInstance(project);
                DbDataSourceLayout layout = instance.getLayout(dataSourceId);
                DbSrcStorageLayout.Item baseItem = layout.getPath(path, false);
                DbSrcStorageLayout.Item stagingItem = layout.getPath(path, true);
                metaData[0] = layout.getMetaData(path);
                return baseItem == null && stagingItem == null ? null : Couple.of((Object)baseItem, (Object)stagingItem);
            }
        });
        if (items == null) {
            throw new UnsupportedOperationException("No items in storage");
        }
        VirtualFile virtualFile = baseFile = items.first == null ? null : ((DbSrcStorageLayout.Item)items.first).getSrcFile();
        if (baseFile == null) {
            throw new UnsupportedOperationException("File not in storage");
        }
        VirtualFile stagingFile = this.getBaseFile(file, true);
        Integer n = hash = metaData[0] == null ? null : Integer.valueOf(metaData[0].contentHash);
        if (stagingFile != null) {
            StagingOutputStream stagingOutputStream = new StagingOutputStream(stagingFile, baseFile, hash);
            if (stagingOutputStream == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem", "getOutputStream"));
            }
            return stagingOutputStream;
        }
        TmpOutputStream tmpOutputStream = new TmpOutputStream((DbSrcStorageLayout.Item)items.second, baseFile, hash);
        if (tmpOutputStream == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem", "getOutputStream"));
        }
        return tmpOutputStream;
    }

    @Nullable
    public VirtualFile getBaseFile(@NotNull VirtualFile file, final boolean staging) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem", "getBaseFile"));
        }
        return DbSrcFileSystem.processPath(file, new ItemProcessor<VirtualFile>(){

            @Override
            public VirtualFile processFile(@Nullable Project project, @NotNull String dataSourceId, @NotNull DbSrcPath path) {
                if (dataSourceId == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSourceId", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem$7", "processFile"));
                }
                if (path == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem$7", "processFile"));
                }
                DbSrcStorage instance = DbSrcStorage.getInstance(project);
                DbDataSourceLayout layout = instance.getLayout(dataSourceId);
                DbSrcStorageLayout.Item item = layout.getPath(path, staging);
                return item == null ? null : item.getSrcFile();
            }
        });
    }

    public static <R> R processPath(@NotNull VirtualFile file, @NotNull ItemProcessor<R> processor) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem", "processPath"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem", "processPath"));
        }
        return DbSrcFileSystem.processPath(file.getPath(), processor);
    }

    public static Iterable<String> splitPath(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem", "splitPath"));
        }
        return StringUtil.tokenize((String)path, (String)String.valueOf('/'));
    }

    public static <R> R processPath(@NotNull String path, @NotNull ItemProcessor<R> processor) {
        Project project;
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem", "processPath"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem", "processPath"));
        }
        ArrayList items = ContainerUtil.newArrayList(DbSrcFileSystem.splitPath(path));
        if (items.isEmpty()) {
            return processor.processRoot();
        }
        boolean app = ((String)items.get(0)).equals(APP_PROJECT_ID);
        Project project2 = project = app ? null : ProjectIdMap.INSTANCE.getProject((String)items.get(0));
        if (project == null && !app) {
            return processor.processOutOfDate();
        }
        if (items.size() <= 1) {
            return processor.processProject(project);
        }
        if (items.size() <= 2) {
            return processor.processDataSource(project, (String)items.get(1));
        }
        boolean group = (items.size() - 2) % 2 == 1;
        String last = (String)items.get(items.size() - 1);
        if (!group) {
            if (last.endsWith(".sql")) {
                last = StringUtil.trimEnd((String)last, (String)".sql");
                items.set(items.size() - 1, last);
                String disambiguator = null;
                int pt = last.indexOf(46);
                if (pt != -1) {
                    disambiguator = last.substring(pt + 1);
                    items.set(items.size() - 1, last.substring(0, pt));
                }
                return processor.processFile(project, (String)items.get(1), DbSrcFileSystem.buildObject(DbSrcFileSystem.unescape(items.subList(2, items.size())), DbSrcFileSystem.unescape(disambiguator)));
            }
            return processor.processFolder(project, (String)items.get(1), DbSrcFileSystem.buildObject(DbSrcFileSystem.unescape(items.subList(2, items.size())), null), null);
        }
        return processor.processFolder(project, (String)items.get(1), DbSrcFileSystem.buildObject(DbSrcFileSystem.unescape(items.subList(2, items.size() - 1)), null), DbSrcFileSystem.unescape(last));
    }

    @NotNull
    private static DbSrcPath buildObject(final @NotNull List<String> path, @Nullable String disambiguator) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem", "buildObject"));
        }
        assert (path.size() % 2 == 0);
        final int size = path.size() / 2;
        DbSrcPath dbSrcPath = new DbSrcPath((List<String>)new AbstractList<String>(){

            @Override
            public String get(int index) {
                return (String)path.get(index * 2 + 1);
            }

            @Override
            public int size() {
                return size;
            }
        }, (List<String>)new AbstractList<String>(){

            @Override
            public String get(int index) {
                return (String)path.get(index * 2);
            }

            @Override
            public int size() {
                return size;
            }
        }, size, disambiguator);
        if (dbSrcPath == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem", "buildObject"));
        }
        return dbSrcPath;
    }

    private void scheduleRefresh() {
        this.myRefreshAlarm.cancelAllRequests();
        this.myRefreshAlarm.addRequest(() -> DbSrcUtils.refresh(), 500, ModalityState.defaultModalityState());
    }

    private static String escape(String s) {
        if (s == null) {
            return null;
        }
        return DatabaseElementVirtualFileImpl.escape(s);
    }

    private static String unescape(String s) {
        if (s == null) {
            return null;
        }
        return DatabaseElementVirtualFileImpl.unescape(s);
    }

    private static List<String> unescape(List<String> list) {
        for (int i2 = 0; i2 < list.size(); ++i2) {
            list.set(i2, DbSrcFileSystem.unescape(list.get(i2)));
        }
        return list;
    }

    private class MyDataSourceUpdater
    implements DataSourceListener {
        private final Project myProject;

        public MyDataSourceUpdater(Project project) {
            this.myProject = project;
        }

        @Override
        public void dataSourceAdded(@NotNull LocalDataSource dataSource) {
            if (dataSource == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem$MyDataSourceUpdater", "dataSourceAdded"));
            }
            this.markDirty();
        }

        @Override
        public void dataSourceRemoved(@NotNull LocalDataSource dataSource) {
            if (dataSource == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem$MyDataSourceUpdater", "dataSourceRemoved"));
            }
            this.markDirty();
        }

        @Override
        public void dataSourceChanged(@Nullable LocalDataSource dataSource) {
        }

        public void markDirty() {
            VfsUtil.markDirty((boolean)false, (boolean)false, (VirtualFile[])new VirtualFile[]{DbSrcFileSystem.this.findFileByPath(DbSrcFileSystem.getPath(this.myProject, null, null, false))});
            DbSrcFileSystem.this.scheduleRefresh();
        }
    }

    private static class ProjectIdMap {
        public static final ProjectIdMap INSTANCE = new ProjectIdMap();
        private final BidirectionalMap<Project, String> myProject2Id = new BidirectionalMap();

        public ProjectIdMap() {
            Application application = ApplicationManager.getApplication();
            application.getMessageBus().connect((Disposable)application).subscribe(ProjectManager.TOPIC, (Object)new ProjectManagerAdapter(){

                public void projectOpened(Project project) {
                    this.onProjectOpened(project);
                }
            });
            this.initProjectMap();
        }

        @Nullable
        public Project getProject(String projectId) {
            List list = this.myProject2Id.getKeysByValue((Object)projectId);
            return list == null || list.size() > 1 ? null : (Project)list.get(0);
        }

        public void onProjectClosed(Project project) {
            this.myProject2Id.remove((Object)project);
        }

        public void onProjectOpened(final Project project) {
            Disposer.register((Disposable)project, (Disposable)new Disposable(){

                public void dispose() {
                    this.onProjectClosed(project);
                }
            });
            String projectId = project.getLocationHash();
            this.myProject2Id.put((Object)project, (Object)projectId);
            List projects = this.myProject2Id.getKeysByValue((Object)projectId);
            if (projects != null && projects.size() > 1) {
                LOG.error("project " + projectId + " already registered: " + projects);
            }
        }

        private void initProjectMap() {
            for (Project project : ProjectManager.getInstance().getOpenProjects()) {
                if (!project.isOpen()) continue;
                this.onProjectOpened(project);
            }
        }
    }

    public static abstract class ItemProcessor<R> {
        public R processRoot() {
            return null;
        }

        public R processOutOfDate() {
            return null;
        }

        public R processProject(@Nullable Project project) {
            return null;
        }

        public R processDataSource(@Nullable Project project, @NotNull String dataSourceId) {
            if (dataSourceId == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSourceId", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem$ItemProcessor", "processDataSource"));
            }
            return null;
        }

        public R processFolder(@Nullable Project project, @NotNull String dataSourceId, @Nullable DbSrcPath path, @Nullable String group) {
            if (dataSourceId == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSourceId", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem$ItemProcessor", "processFolder"));
            }
            return null;
        }

        public R processFile(@Nullable Project project, @NotNull String dataSourceId, @NotNull DbSrcPath path) {
            if (dataSourceId == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSourceId", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem$ItemProcessor", "processFile"));
            }
            if (path == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem$ItemProcessor", "processFile"));
            }
            return null;
        }
    }

    private static abstract class DelegateOutputStream
    extends OutputStream {
        private final OutputStream myDelegate;
        private final DbSrcUtils.StringHashBuilder myHashBuilder;
        private final VirtualFile myBaseFile;
        private final Integer myBaseHash;

        public DelegateOutputStream(@NotNull OutputStream delegate, @NotNull VirtualFile baseFile, Integer baseHash) {
            if (delegate == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem$DelegateOutputStream", "<init>"));
            }
            if (baseFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseFile", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem$DelegateOutputStream", "<init>"));
            }
            this.myHashBuilder = new DbSrcUtils.StringHashBuilder();
            this.myBaseFile = baseFile;
            this.myBaseHash = baseHash;
            this.myDelegate = delegate;
        }

        @Override
        public void write(int b) throws IOException {
            this.myDelegate.write(b);
            this.myHashBuilder.consume(b);
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.write(b, 0, b.length);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.myDelegate.write(b, off, len);
            for (int i2 = off; i2 < len; ++i2) {
                this.myHashBuilder.consume(b[i2]);
            }
        }

        @Override
        public void flush() throws IOException {
            this.myDelegate.flush();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void close() throws IOException {
            boolean differs;
            this.myDelegate.close();
            boolean bl = differs = this.myBaseHash != null && this.myBaseHash.intValue() != this.myHashBuilder.get();
            if (!differs) {
                try (InputStream is1 = this.myBaseFile.getInputStream();
                     InputStream is2 = this.getInputStream();){
                    int r1;
                    byte[] buffer1 = new byte[0x100000];
                    byte[] buffer2 = new byte[0x100000];
                    do {
                        int r2;
                        differs = (r1 = DelegateOutputStream.readMaximum(is1, buffer1)) != (r2 = DelegateOutputStream.readMaximum(is2, buffer2));
                        for (int i2 = 0; i2 < r1 && !differs; ++i2) {
                            differs = buffer1[i2] != buffer2[i2];
                        }
                    } while (!differs && r1 != -1);
                }
            }
            if (differs) {
                this.closeDiffersFromBase();
                return;
            }
            this.closeEqualsToBase();
        }

        private static int readMaximum(InputStream is, byte[] buffer) throws IOException {
            int offs = 0;
            int read;
            while ((read = is.read(buffer, offs, buffer.length - offs)) != -1) {
                offs += read;
            }
            return offs == 0 ? -1 : offs;
        }

        @NotNull
        public abstract InputStream getInputStream() throws IOException;

        public abstract void closeEqualsToBase() throws IOException;

        public abstract void closeDiffersFromBase() throws IOException;
    }

    private static class StagingOutputStream
    extends DelegateOutputStream {
        private final VirtualFile myStagingFile;

        private StagingOutputStream(@NotNull VirtualFile stagingFile, @NotNull VirtualFile baseFile, Integer baseHash) throws IOException {
            if (stagingFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stagingFile", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem$StagingOutputStream", "<init>"));
            }
            if (baseFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseFile", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem$StagingOutputStream", "<init>"));
            }
            super(stagingFile.getOutputStream((Object)DbSrcFileSystem.getInstance()), baseFile, baseHash);
            this.myStagingFile = stagingFile;
        }

        @Override
        @NotNull
        public InputStream getInputStream() throws IOException {
            InputStream inputStream = this.myStagingFile.getInputStream();
            if (inputStream == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem$StagingOutputStream", "getInputStream"));
            }
            return inputStream;
        }

        @Override
        public void closeEqualsToBase() throws IOException {
            this.myStagingFile.delete((Object)DbSrcFileSystem.getInstance());
        }

        @Override
        public void closeDiffersFromBase() throws IOException {
        }
    }

    private static class TmpOutputStream
    extends DelegateOutputStream {
        private final DbSrcStorageLayout.Item myStagingItem;
        private final Path myTempFile;

        private TmpOutputStream(@NotNull Path tempFile, @NotNull DbSrcStorageLayout.Item stagingItem, @NotNull VirtualFile baseFile, Integer baseHash) throws IOException {
            if (tempFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tempFile", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem$TmpOutputStream", "<init>"));
            }
            if (stagingItem == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stagingItem", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem$TmpOutputStream", "<init>"));
            }
            if (baseFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseFile", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem$TmpOutputStream", "<init>"));
            }
            super(Files.newOutputStream(tempFile, new OpenOption[0]), baseFile, baseHash);
            this.myTempFile = tempFile;
            this.myStagingItem = stagingItem;
        }

        public TmpOutputStream(@NotNull DbSrcStorageLayout.Item stagingItem, @NotNull VirtualFile baseFile, Integer baseHash) throws IOException {
            if (stagingItem == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stagingItem", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem$TmpOutputStream", "<init>"));
            }
            if (baseFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseFile", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem$TmpOutputStream", "<init>"));
            }
            this(Files.createTempFile("storage", ".tmp", new FileAttribute[0]), stagingItem, baseFile, baseHash);
        }

        @Override
        @NotNull
        public InputStream getInputStream() throws IOException {
            InputStream inputStream = Files.newInputStream(this.myTempFile, new OpenOption[0]);
            if (inputStream == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem$TmpOutputStream", "getInputStream"));
            }
            return inputStream;
        }

        @Override
        public void closeEqualsToBase() throws IOException {
            Files.deleteIfExists(this.myTempFile);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void closeDiffersFromBase() throws IOException {
            try (InputStream is = this.getInputStream();
                 OutputStream os = this.myStagingItem.getOutputStream((Object)DbSrcFileSystem.getInstance(), null);){
                StreamUtil.copyStreamContent((InputStream)is, (OutputStream)os);
            }
            finally {
                Files.deleteIfExists(this.myTempFile);
            }
        }
    }

    private static class ProjectRoot {
        public final String projectId;
        public final String root;
        public final LocalFileSystem.WatchRequest watchRequest;

        private ProjectRoot(String projectId, String root2) {
            this.projectId = projectId;
            this.root = root2;
            this.watchRequest = LocalFileSystem.getInstance().addRootToWatch(root2, true);
        }
    }
}

