/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid;

import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGridListModel;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.GridDataHookUpBase;
import com.intellij.database.datagrid.GridLoader;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.GridMutator;
import com.intellij.database.datagrid.GridPagingModel;
import com.intellij.database.datagrid.GridPagingModelImpl;
import com.intellij.database.datagrid.GridRequestSource;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.ModelIndexSet;
import com.intellij.database.datagrid.mutating.CellMutation;
import com.intellij.database.datagrid.mutating.RowMutation;
import com.intellij.database.util.DbUIUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DocumentDataHookUp
extends GridDataHookUpBase<DataConsumer.Row, DataConsumer.Column>
implements Disposable {
    private static final String UPDATE_COMMAND_NAME = "Update Values";
    private final Document myDocument;
    private TextRange myRange;
    private DataMarkup myCurrentMarkup;
    private final DataGridListModel myModel;
    private final GridPagingModelImpl.SinglePage<DataConsumer.Row, DataConsumer.Column> myPageModel;
    private final DocumentDataLoader myLoader;
    private final DocumentDataMutator myMutator;
    private final MyDocumentListener myDocumentListener;

    protected DocumentDataHookUp(@NotNull Project project, @NotNull Document document, @Nullable TextRange range) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/datagrid/DocumentDataHookUp", "<init>"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/database/datagrid/DocumentDataHookUp", "<init>"));
        }
        super(project);
        this.myDocument = document;
        this.myRange = range;
        this.myModel = new DataGridListModel();
        this.myPageModel = new GridPagingModelImpl.SinglePage<DataConsumer.Row, DataConsumer.Column>(this.myModel);
        this.myLoader = new DocumentDataLoader();
        this.myMutator = new DocumentDataMutator();
        this.myDocumentListener = new MyDocumentListener();
        this.myDocument.addDocumentListener((DocumentListener)this.myDocumentListener, (Disposable)this);
    }

    @Override
    @NotNull
    public GridModel<DataConsumer.Row, DataConsumer.Column> getModel() {
        DataGridListModel dataGridListModel = this.myModel;
        if (dataGridListModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/DocumentDataHookUp", "getModel"));
        }
        return dataGridListModel;
    }

    @Override
    @NotNull
    public GridPagingModel<DataConsumer.Row, DataConsumer.Column> getPageModel() {
        GridPagingModelImpl.SinglePage<DataConsumer.Row, DataConsumer.Column> singlePage = this.myPageModel;
        if (singlePage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/DocumentDataHookUp", "getPageModel"));
        }
        return singlePage;
    }

    @Override
    @NotNull
    public GridLoader<DataConsumer.Row, DataConsumer.Column> getLoader() {
        DocumentDataLoader documentDataLoader = this.myLoader;
        if (documentDataLoader == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/DocumentDataHookUp", "getLoader"));
        }
        return documentDataLoader;
    }

    @Nullable
    public DocumentDataMutator getMutator() {
        return this.myMutator;
    }

    @Override
    public boolean isReadOnly() {
        return !this.myDocument.isWritable();
    }

    public void dispose() {
    }

    @Nullable
    public TextRange getRange() {
        return this.myRange;
    }

    @Nullable
    protected abstract DataMarkup buildMarkup(@NotNull CharSequence var1, @NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> var2);

    Document getDocument() {
        return this.myDocument;
    }

    private static interface UpdateAction {
        public boolean perform(@NotNull UpdateSession var1) throws Exception;
    }

    private class DocumentDataLoader
    implements GridLoader<DataConsumer.Row, DataConsumer.Column> {
        private DocumentDataLoader() {
        }

        @Override
        public void reloadCurrentPage(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> source) {
            if (source == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/datagrid/DocumentDataHookUp$DocumentDataLoader", "reloadCurrentPage"));
            }
            this.load(source, 1);
        }

        @Override
        public void loadNextPage(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> source) {
            if (source == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/datagrid/DocumentDataHookUp$DocumentDataLoader", "loadNextPage"));
            }
            this.load(source, 1);
        }

        @Override
        public void loadPreviousPage(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> source) {
            if (source == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/datagrid/DocumentDataHookUp$DocumentDataLoader", "loadPreviousPage"));
            }
            this.load(source, 1);
        }

        @Override
        public void loadLastPage(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> source) {
            if (source == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/datagrid/DocumentDataHookUp$DocumentDataLoader", "loadLastPage"));
            }
            this.load(source, 1);
        }

        @Override
        public void loadFirstPage(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> source) {
            if (source == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/datagrid/DocumentDataHookUp$DocumentDataLoader", "loadFirstPage"));
            }
            this.load(source, 1);
        }

        @Override
        public void load(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> source, int rowDataIdx) {
            if (source == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/datagrid/DocumentDataHookUp$DocumentDataLoader", "load"));
            }
            boolean dataLoaded = false;
            try {
                this.doLoadData(source);
                dataLoaded = true;
            }
            catch (Exception e) {
                DocumentDataHookUp.this.notifyRequestError(source, null, e);
            }
            DocumentDataHookUp.this.notifyRequestFinished(source, dataLoaded);
        }

        @Override
        public void updateTotalRowCount(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> source) {
            if (source == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/datagrid/DocumentDataHookUp$DocumentDataLoader", "updateTotalRowCount"));
            }
            DocumentDataHookUp.this.notifyRequestFinished(source, false);
        }

        @Override
        public void applyFilter(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> source) {
            if (source == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/datagrid/DocumentDataHookUp$DocumentDataLoader", "applyFilter"));
            }
            DocumentDataHookUp.this.notifyRequestFinished(source, false);
        }

        private void doLoadData(GridRequestSource<DataConsumer.Row, DataConsumer.Column> source) {
            CharSequence sequence = DocumentDataHookUp.this.myRange != null ? DocumentDataHookUp.this.myRange.subSequence(DocumentDataHookUp.this.myDocument.getCharsSequence()) : DocumentDataHookUp.this.myDocument.getCharsSequence();
            DataMarkup markup = DocumentDataHookUp.this.buildMarkup(sequence, source);
            if (markup == null) {
                DocumentDataHookUp.this.myModel.removeRows(0, DocumentDataHookUp.this.myModel.getRowCount());
                DocumentDataHookUp.this.myModel.setColumns(ContainerUtil.emptyList());
                DocumentDataHookUp.this.myCurrentMarkup = null;
                return;
            }
            List<DataConsumer.Column> columns = markup.columns;
            List<DataConsumer.Row> rows = markup.rows;
            if (!this.sameColumns(columns, DocumentDataHookUp.this.myModel.getColumns())) {
                DocumentDataHookUp.this.myModel.removeRows(0, DocumentDataHookUp.this.myModel.getRowCount());
                DocumentDataHookUp.this.myModel.setColumns(columns);
                DocumentDataHookUp.this.myModel.addRows(rows);
            } else {
                int oldRowCount = DocumentDataHookUp.this.myModel.getRowCount();
                int newRowCount = rows.size();
                DocumentDataHookUp.this.myModel.setRows(0, rows);
                if (oldRowCount > newRowCount) {
                    DocumentDataHookUp.this.myModel.removeRows(newRowCount, oldRowCount - newRowCount);
                }
            }
            DocumentDataHookUp.this.myCurrentMarkup = markup;
        }

        private boolean sameColumns(List<DataConsumer.Column> columns1, List<DataConsumer.Column> columns2) {
            if (columns1.size() != columns2.size()) {
                return false;
            }
            for (int i2 = 0; i2 < columns1.size(); ++i2) {
                if (Comparing.equal((Object)columns1.get(i2), (Object)columns2.get(i2))) continue;
                return false;
            }
            return true;
        }
    }

    private class MyDocumentListener
    implements DocumentListener {
        private boolean myMuteChangeEvents;
        private boolean myChangesOccurredWhileMuted;

        private MyDocumentListener() {
        }

        public void beforeDocumentChange(DocumentEvent event) {
            this.adjustRange(event);
        }

        public void documentChanged(DocumentEvent event) {
            if (this.myMuteChangeEvents) {
                this.myChangesOccurredWhileMuted = true;
            } else {
                this.reload();
            }
        }

        public void muteChangeEvents() {
            this.myMuteChangeEvents = true;
            this.myChangesOccurredWhileMuted = false;
        }

        public void unmuteChangeEvents() {
            this.myMuteChangeEvents = false;
            if (this.myChangesOccurredWhileMuted) {
                this.reload();
            }
        }

        private void reload() {
            DbUIUtil.invokeLaterIfNeeded(() -> DocumentDataHookUp.this.myLoader.doLoadData(new GridRequestSource(null, null)));
        }

        private void adjustRange(DocumentEvent e) {
            if (DocumentDataHookUp.this.myRange == null) {
                return;
            }
            int lengthDelta = e.getNewLength() - e.getOldLength();
            if (DocumentDataHookUp.this.myRange.containsRange(e.getOffset(), e.getOffset() + e.getOldLength())) {
                DocumentDataHookUp.this.myRange = new TextRange(DocumentDataHookUp.this.myRange.getStartOffset(), DocumentDataHookUp.this.myRange.getEndOffset() + lengthDelta);
            } else if (DocumentDataHookUp.this.myRange.getStartOffset() > e.getOffset() + e.getOldLength()) {
                DocumentDataHookUp.this.myRange = DocumentDataHookUp.this.myRange.shiftRight(lengthDelta);
            } else if (DocumentDataHookUp.this.myRange.intersects(e.getOffset(), e.getOffset() + e.getOldLength())) {
                int startOffset = Math.min(e.getOffset(), DocumentDataHookUp.this.myRange.getStartOffset());
                int endOffset = Math.max(e.getOffset() + e.getNewLength(), DocumentDataHookUp.this.myRange.getEndOffset() + lengthDelta);
                DocumentDataHookUp.this.myRange = new TextRange(startOffset, endOffset);
            }
        }
    }

    class DocumentDataMutator
    implements GridMutator.RowsMutator<DataConsumer.Row, DataConsumer.Column>,
    GridMutator.ColumnsMutator<DataConsumer.Row, DataConsumer.Column> {
        DocumentDataMutator() {
        }

        @Override
        public void deleteRows(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> source, @NotNull ModelIndexSet<DataConsumer.Row> rows) {
            if (source == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/datagrid/DocumentDataHookUp$DocumentDataMutator", "deleteRows"));
            }
            if (rows == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rows", "com/intellij/database/datagrid/DocumentDataHookUp$DocumentDataMutator", "deleteRows"));
            }
            final List<DataConsumer.Row> rowsToDelete = this.sortedRows(DocumentDataHookUp.this.myModel.getRows(rows));
            if (DocumentDataHookUp.this.isReadOnly() || rowsToDelete.isEmpty()) {
                DocumentDataHookUp.this.notifyRequestFinished(source, !DocumentDataHookUp.this.isReadOnly());
                return;
            }
            this.updateDocument(source, new UpdateAction(){

                @Override
                public boolean perform(@NotNull UpdateSession session) throws Exception {
                    if (session == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/database/datagrid/DocumentDataHookUp$DocumentDataMutator$1", "perform"));
                    }
                    return DocumentDataHookUp.this.myCurrentMarkup.deleteRows(session, rowsToDelete);
                }
            });
        }

        @Override
        public void insertRow(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> source) {
            if (source == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/datagrid/DocumentDataHookUp$DocumentDataMutator", "insertRow"));
            }
            if (DocumentDataHookUp.this.isReadOnly()) {
                DocumentDataHookUp.this.notifyRequestFinished(source, false);
                return;
            }
            this.updateDocument(source, new UpdateAction(){

                @Override
                public boolean perform(@NotNull UpdateSession session) throws Exception {
                    if (session == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/database/datagrid/DocumentDataHookUp$DocumentDataMutator$2", "perform"));
                    }
                    return DocumentDataHookUp.this.myCurrentMarkup.insertRow(session);
                }
            });
        }

        @Override
        public void cloneRow(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> source, @NotNull ModelIndex<DataConsumer.Row> toClone) {
            if (source == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/datagrid/DocumentDataHookUp$DocumentDataMutator", "cloneRow"));
            }
            if (toClone == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toClone", "com/intellij/database/datagrid/DocumentDataHookUp$DocumentDataMutator", "cloneRow"));
            }
            final DataConsumer.Row row = DocumentDataHookUp.this.myModel.getRow(toClone);
            if (DocumentDataHookUp.this.isReadOnly() || row == null) {
                DocumentDataHookUp.this.notifyRequestFinished(source, false);
                return;
            }
            this.updateDocument(source, new UpdateAction(){

                @Override
                public boolean perform(@NotNull UpdateSession session) throws Exception {
                    if (session == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/database/datagrid/DocumentDataHookUp$DocumentDataMutator$3", "perform"));
                    }
                    return DocumentDataHookUp.this.myCurrentMarkup.cloneRow(session, row);
                }
            });
        }

        @Override
        public boolean isDeletedRow(@NotNull ModelIndex<DataConsumer.Row> row) {
            if (row == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "row", "com/intellij/database/datagrid/DocumentDataHookUp$DocumentDataMutator", "isDeletedRow"));
            }
            return false;
        }

        @Override
        public boolean isDeletedRows(@NotNull ModelIndexSet<DataConsumer.Row> rows) {
            if (rows == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rows", "com/intellij/database/datagrid/DocumentDataHookUp$DocumentDataMutator", "isDeletedRows"));
            }
            return false;
        }

        @Override
        public boolean isInsertedRow(@NotNull ModelIndex<DataConsumer.Row> row) {
            if (row == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "row", "com/intellij/database/datagrid/DocumentDataHookUp$DocumentDataMutator", "isInsertedRow"));
            }
            return false;
        }

        @Override
        public void deleteColumns(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> source, @NotNull ModelIndexSet<DataConsumer.Column> columns) {
            if (source == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/datagrid/DocumentDataHookUp$DocumentDataMutator", "deleteColumns"));
            }
            if (columns == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columns", "com/intellij/database/datagrid/DocumentDataHookUp$DocumentDataMutator", "deleteColumns"));
            }
            final List<DataConsumer.Column> columnsToDelete = this.sortedColumns(DocumentDataHookUp.this.myModel.getColumns(columns));
            if (DocumentDataHookUp.this.isReadOnly() || columnsToDelete.isEmpty()) {
                DocumentDataHookUp.this.notifyRequestFinished(source, !DocumentDataHookUp.this.isReadOnly());
                return;
            }
            this.updateDocument(source, new UpdateAction(){

                @Override
                public boolean perform(@NotNull UpdateSession session) throws Exception {
                    if (session == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/database/datagrid/DocumentDataHookUp$DocumentDataMutator$4", "perform"));
                    }
                    return DocumentDataHookUp.this.myCurrentMarkup.deleteColumns(session, columnsToDelete);
                }
            });
        }

        @Override
        public void insertColumn(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> source) {
            if (source == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/datagrid/DocumentDataHookUp$DocumentDataMutator", "insertColumn"));
            }
            if (DocumentDataHookUp.this.isReadOnly()) {
                DocumentDataHookUp.this.notifyRequestFinished(source, false);
                return;
            }
            this.updateDocument(source, new UpdateAction(){

                @Override
                public boolean perform(@NotNull UpdateSession session) throws Exception {
                    if (session == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/database/datagrid/DocumentDataHookUp$DocumentDataMutator$5", "perform"));
                    }
                    return DocumentDataHookUp.this.myCurrentMarkup.insertColumn(session);
                }
            });
        }

        @Override
        public void cloneColumn(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> source, @NotNull ModelIndex<DataConsumer.Column> toClone) {
            if (source == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/datagrid/DocumentDataHookUp$DocumentDataMutator", "cloneColumn"));
            }
            if (toClone == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toClone", "com/intellij/database/datagrid/DocumentDataHookUp$DocumentDataMutator", "cloneColumn"));
            }
            final DataConsumer.Column column = DocumentDataHookUp.this.myModel.getColumn(toClone);
            if (DocumentDataHookUp.this.isReadOnly() || column == null) {
                DocumentDataHookUp.this.notifyRequestFinished(source, false);
                return;
            }
            this.updateDocument(source, new UpdateAction(){

                @Override
                public boolean perform(@NotNull UpdateSession session) throws Exception {
                    if (session == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/database/datagrid/DocumentDataHookUp$DocumentDataMutator$6", "perform"));
                    }
                    return DocumentDataHookUp.this.myCurrentMarkup.cloneColumn(session, column);
                }
            });
        }

        @Override
        @NotNull
        public ModelIndex<DataConsumer.Row> getLastInsertedRow() {
            ModelIndex<DataConsumer.Row> modelIndex = ModelIndex.forRow(DocumentDataHookUp.this.myModel, -1);
            if (modelIndex == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/DocumentDataHookUp$DocumentDataMutator", "getLastInsertedRow"));
            }
            return modelIndex;
        }

        @Override
        @NotNull
        public ModelIndexSet<DataConsumer.Row> getAffectedRows() {
            ModelIndexSet<DataConsumer.Row> modelIndexSet = ModelIndexSet.forRows(DocumentDataHookUp.this.myModel, -1);
            if (modelIndexSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/DocumentDataHookUp$DocumentDataMutator", "getAffectedRows"));
            }
            return modelIndexSet;
        }

        @Override
        public void mutate(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> source, @NotNull ModelIndexSet<DataConsumer.Row> rows, @NotNull ModelIndexSet<DataConsumer.Column> columns, Object newValue) {
            if (source == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/datagrid/DocumentDataHookUp$DocumentDataMutator", "mutate"));
            }
            if (rows == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rows", "com/intellij/database/datagrid/DocumentDataHookUp$DocumentDataMutator", "mutate"));
            }
            if (columns == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columns", "com/intellij/database/datagrid/DocumentDataHookUp$DocumentDataMutator", "mutate"));
            }
            this.mutate(source, DataGridUtil.createMutations(rows, columns, newValue));
        }

        @Override
        public void mutate(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> source, @NotNull List<CellMutation> mutations) {
            if (source == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/datagrid/DocumentDataHookUp$DocumentDataMutator", "mutate"));
            }
            if (mutations == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mutations", "com/intellij/database/datagrid/DocumentDataHookUp$DocumentDataMutator", "mutate"));
            }
            final List<RowMutation> rowMutations = DataGridUtil.mergeAll(mutations, DocumentDataHookUp.this.myModel);
            if (DocumentDataHookUp.this.isReadOnly() || mutations.isEmpty() || rowMutations.isEmpty() || DocumentDataHookUp.this.myModel.allValuesEqualTo(mutations)) {
                DocumentDataHookUp.this.notifyRequestFinished(source, !DocumentDataHookUp.this.isReadOnly());
                return;
            }
            this.updateDocument(source, new UpdateAction(){

                @Override
                public boolean perform(@NotNull UpdateSession session) throws Exception {
                    if (session == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/database/datagrid/DocumentDataHookUp$DocumentDataMutator$7", "perform"));
                    }
                    return DocumentDataHookUp.this.myCurrentMarkup.update(session, rowMutations);
                }
            });
        }

        @Override
        public boolean isUpdateSafe(@NotNull ModelIndexSet<DataConsumer.Row> rowIndices, @NotNull ModelIndexSet<DataConsumer.Column> columnIndices, @Nullable Object newValue) {
            if (rowIndices == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rowIndices", "com/intellij/database/datagrid/DocumentDataHookUp$DocumentDataMutator", "isUpdateSafe"));
            }
            if (columnIndices == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columnIndices", "com/intellij/database/datagrid/DocumentDataHookUp$DocumentDataMutator", "isUpdateSafe"));
            }
            return true;
        }

        @Override
        public boolean hasPendingChanges() {
            return false;
        }

        @Override
        public boolean isUpdateImmediately() {
            return true;
        }

        private void updateDocument(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> source, @NotNull UpdateAction action) {
            if (source == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/datagrid/DocumentDataHookUp$DocumentDataMutator", "updateDocument"));
            }
            if (action == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/database/datagrid/DocumentDataHookUp$DocumentDataMutator", "updateDocument"));
            }
            DbUIUtil.invokeLaterIfNeeded(() -> {
                if (source == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/datagrid/DocumentDataHookUp$DocumentDataMutator", "lambda$updateDocument$2"));
                }
                if (action == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/database/datagrid/DocumentDataHookUp$DocumentDataMutator", "lambda$updateDocument$2"));
                }
                if (!ReadonlyStatusHandler.ensureDocumentWritable((Project)DocumentDataHookUp.this.getProject(), (Document)DocumentDataHookUp.this.myDocument)) {
                    DocumentDataHookUp.this.notifyRequestError(source, "Cannot update document", null);
                    DocumentDataHookUp.this.notifyRequestFinished(source, false);
                    return;
                }
                UpdateSession session = new UpdateSession(DocumentDataHookUp.this.myDocument, DocumentDataHookUp.this.myRange != null ? DocumentDataHookUp.this.myRange.getStartOffset() : 0);
                ThrowableComputable wrappedAction = () -> {
                    if (action == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/database/datagrid/DocumentDataHookUp$DocumentDataMutator", "lambda$null$0"));
                    }
                    DocumentDataHookUp.this.myDocumentListener.muteChangeEvents();
                    try {
                        Boolean bl = action.perform(session);
                        return bl;
                    }
                    finally {
                        DocumentDataHookUp.this.myDocumentListener.unmuteChangeEvents();
                    }
                };
                CommandProcessor.getInstance().executeCommand(DocumentDataHookUp.this.getProject(), () -> {
                    if (source == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/datagrid/DocumentDataHookUp$DocumentDataMutator", "lambda$null$1"));
                    }
                    boolean success = false;
                    try {
                        success = (Boolean)ApplicationManager.getApplication().runWriteAction(wrappedAction);
                    }
                    catch (Exception e) {
                        DocumentDataHookUp.this.notifyRequestError(source, null, e);
                    }
                    DocumentDataHookUp.this.notifyRequestFinished(source, success);
                }, DocumentDataHookUp.UPDATE_COMMAND_NAME, null);
            });
        }

        private List<DataConsumer.Column> sortedColumns(@NotNull List<DataConsumer.Column> columns) {
            if (columns == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columns", "com/intellij/database/datagrid/DocumentDataHookUp$DocumentDataMutator", "sortedColumns"));
            }
            return ContainerUtil.sorted(columns, (column1, column2) -> column1.columnNum - column2.columnNum);
        }

        private List<DataConsumer.Row> sortedRows(@NotNull List<DataConsumer.Row> rows) {
            if (rows == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rows", "com/intellij/database/datagrid/DocumentDataHookUp$DocumentDataMutator", "sortedRows"));
            }
            return ContainerUtil.sorted(rows, (row1, row2) -> row1.rowNum - row2.rowNum);
        }
    }

    public static abstract class DataMarkup {
        public final List<DataConsumer.Column> columns;
        public final List<DataConsumer.Row> rows;

        public DataMarkup(@NotNull List<DataConsumer.Column> columns, @NotNull List<DataConsumer.Row> rows) {
            if (columns == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columns", "com/intellij/database/datagrid/DocumentDataHookUp$DataMarkup", "<init>"));
            }
            if (rows == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rows", "com/intellij/database/datagrid/DocumentDataHookUp$DataMarkup", "<init>"));
            }
            this.columns = columns;
            this.rows = rows;
        }

        protected abstract boolean deleteRows(@NotNull UpdateSession var1, @NotNull List<DataConsumer.Row> var2);

        protected abstract boolean insertRow(@NotNull UpdateSession var1);

        protected abstract boolean cloneRow(@NotNull UpdateSession var1, @NotNull DataConsumer.Row var2);

        protected abstract boolean deleteColumns(@NotNull UpdateSession var1, @NotNull List<DataConsumer.Column> var2);

        protected abstract boolean insertColumn(@NotNull UpdateSession var1);

        protected abstract boolean cloneColumn(@NotNull UpdateSession var1, @NotNull DataConsumer.Column var2);

        protected abstract boolean update(@NotNull UpdateSession var1, @NotNull List<RowMutation> var2);
    }

    protected static final class UpdateSession {
        private final Document myDocument;
        private int myRightShift;

        private UpdateSession(@NotNull Document document, int rightShift) {
            if (document == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/database/datagrid/DocumentDataHookUp$UpdateSession", "<init>"));
            }
            this.myDocument = document;
            this.myRightShift = rightShift;
        }

        public void insert(@NotNull CharSequence sequence, int atOffset) {
            if (sequence == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sequence", "com/intellij/database/datagrid/DocumentDataHookUp$UpdateSession", "insert"));
            }
            this.myDocument.insertString(atOffset + this.myRightShift, sequence);
            this.myRightShift += sequence.length();
        }

        public void replace(@NotNull TextRange range, @NotNull CharSequence sequence) {
            if (range == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/database/datagrid/DocumentDataHookUp$UpdateSession", "replace"));
            }
            if (sequence == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sequence", "com/intellij/database/datagrid/DocumentDataHookUp$UpdateSession", "replace"));
            }
            TextRange shifted = range.shiftRight(this.myRightShift);
            this.myDocument.replaceString(shifted.getStartOffset(), shifted.getEndOffset(), sequence);
            this.myRightShift += sequence.length() - shifted.getLength();
        }

        public void delete(@NotNull TextRange range) {
            if (range == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/database/datagrid/DocumentDataHookUp$UpdateSession", "delete"));
            }
            TextRange shifted = range.shiftRight(this.myRightShift);
            this.myDocument.deleteString(shifted.getStartOffset(), shifted.getEndOffset());
            this.myRightShift -= range.getLength();
        }

        public char charAt(int offset) {
            return this.myDocument.getCharsSequence().charAt(offset + this.myRightShift);
        }

        public boolean isValidOffset(int offset) {
            int shifted = offset + this.myRightShift;
            return shifted >= 0 && shifted < this.myDocument.getTextLength();
        }
    }
}

