/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport;

import com.intellij.database.csv.CsvFormat;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.dbimport.ImportDeTable;
import com.intellij.database.schemaEditor.model.DeColumn;
import com.intellij.database.schemaEditor.model.DeTable;
import com.intellij.util.containers.ContainerUtil;
import java.io.Writer;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImportInfo {
    @NotNull
    private final CsvFormat myFormat;
    @NotNull
    private final DeTable myTable;
    @NotNull
    private final String myFileName;
    @Nullable
    private final String myErrorFilePath;
    @Nullable
    private final Writer myErrorWriter;
    private final boolean myInExistingTable;
    private final boolean myLockTable;
    @NotNull
    private List<DataConsumer.Column> myConsumerColumns;

    public ImportInfo(@NotNull CsvFormat format, @NotNull DeTable table, @NotNull List<DataConsumer.Column> columns, @NotNull String fileName, @Nullable String errorFilePath, @Nullable Writer errorWriter, boolean lockTable, boolean inExistingTable) {
        if (format == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "format", "com/intellij/database/dbimport/ImportInfo", "<init>"));
        }
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/dbimport/ImportInfo", "<init>"));
        }
        if (columns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columns", "com/intellij/database/dbimport/ImportInfo", "<init>"));
        }
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/database/dbimport/ImportInfo", "<init>"));
        }
        this.myFormat = format;
        this.myTable = table;
        this.myFileName = fileName;
        this.myInExistingTable = inExistingTable;
        this.myConsumerColumns = columns;
        this.myLockTable = lockTable;
        this.myErrorFilePath = errorFilePath;
        this.myErrorWriter = errorWriter;
    }

    public List<DeColumn> getColumns() {
        return ContainerUtil.filter(this.myTable.columns, ImportDeTable::isEnabled);
    }

    @NotNull
    public CsvFormat getFormat() {
        CsvFormat csvFormat = this.myFormat;
        if (csvFormat == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportInfo", "getFormat"));
        }
        return csvFormat;
    }

    @NotNull
    public String getTableName() {
        String string = this.myTable.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportInfo", "getTableName"));
        }
        return string;
    }

    @NotNull
    public DeTable getTable() {
        DeTable deTable = this.myTable;
        if (deTable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportInfo", "getTable"));
        }
        return deTable;
    }

    public boolean isInExistingTable() {
        return this.myInExistingTable;
    }

    @NotNull
    public List<DataConsumer.Column> getConsumerColumns() {
        List<DataConsumer.Column> list = this.myConsumerColumns;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportInfo", "getConsumerColumns"));
        }
        return list;
    }

    @Nullable
    public String getErrorFilePath() {
        return this.myErrorFilePath;
    }

    public boolean shouldLockTable() {
        return this.myLockTable;
    }

    @NotNull
    public String getFileName() {
        String string = this.myFileName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportInfo", "getFileName"));
        }
        return string;
    }

    public boolean hasErrorPath() {
        return this.myErrorWriter != null;
    }

    @Nullable
    public Writer getErrorWriter() {
        return this.myErrorWriter;
    }

    public void setConsumerColumns(@NotNull List<DataConsumer.Column> consumerColumns) {
        if (consumerColumns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumerColumns", "com/intellij/database/dbimport/ImportInfo", "setConsumerColumns"));
        }
        this.myConsumerColumns = consumerColumns;
    }
}

