/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport.ui;

import com.intellij.database.dbimport.ImportManager;
import com.intellij.database.dbimport.ImportSettings;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.roots.ui.componentsList.layout.VerticalStackLayout;
import com.intellij.openapi.ui.TextBrowseFolderListener;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SystemProperties;
import java.awt.Component;
import java.awt.LayoutManager;
import java.io.File;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImportSettingsPanel
extends JPanel {
    private static final DateTimeFormatter DATE_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd_HH_mm_ss");
    private static final String HANDLE_ERROR_TEXT = "Write error records to file";
    private static final String DISABLE_STATE_TEXT = "Disable indexes and triggers, lock table (may be faster)";
    private static final int STRUT_HEIGHT = 10;
    @NotNull
    private final JCheckBox myHandleErrorCheckBox;
    @NotNull
    private final JCheckBox myModalityStateCheckBox;
    @NotNull
    private final TextFieldWithBrowseButton myErrorOutput;
    @NotNull
    private final String myTableName;

    public ImportSettingsPanel(@NotNull String tableName, @NotNull DatabaseDialect dialect, @NotNull DatabaseSystem system, boolean tableExists) {
        if (tableName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tableName", "com/intellij/database/dbimport/ui/ImportSettingsPanel", "<init>"));
        }
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/dbimport/ui/ImportSettingsPanel", "<init>"));
        }
        if (system == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "system", "com/intellij/database/dbimport/ui/ImportSettingsPanel", "<init>"));
        }
        super((LayoutManager)new VerticalStackLayout());
        this.myHandleErrorCheckBox = new JBCheckBox(HANDLE_ERROR_TEXT);
        this.myModalityStateCheckBox = new JBCheckBox(DISABLE_STATE_TEXT);
        this.myErrorOutput = new TextFieldWithBrowseButton();
        this.myTableName = tableName;
        this.myModalityStateCheckBox.setVisible(tableExists && ImportManager.of(dialect, system.getDatabaseProductVersion()).isSupportFastMode());
        this.configureComponents();
        this.addComponents();
    }

    @Nullable
    public String getErrorOutputFilePath() {
        return this.myErrorOutput.isEnabled() ? this.myErrorOutput.getText() : null;
    }

    public boolean getModalityState() {
        return this.myModalityStateCheckBox.isSelected();
    }

    private void addComponents() {
        this.add(Box.createVerticalStrut(10));
        this.add(this.myHandleErrorCheckBox);
        this.add((Component)this.myErrorOutput);
        this.add(Box.createVerticalStrut(10));
        this.add(this.myModalityStateCheckBox);
    }

    private void configureComponents() {
        boolean errors = ImportSettings.getWriteErrors();
        String directory = ImportSettings.getErrorDirectory();
        this.myErrorOutput.setEnabled(errors);
        this.myErrorOutput.setText(this.getDefaultText((String)ObjectUtils.chooseNotNull((Object)directory, (Object)SystemProperties.getUserHome())));
        this.myErrorOutput.addBrowseFolderListener(new TextBrowseFolderListener(new FileChooserDescriptor(true, false, false, false, false, false)){

            protected void onFileChosen(@NotNull VirtualFile chosenFile) {
                if (chosenFile == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chosenFile", "com/intellij/database/dbimport/ui/ImportSettingsPanel$1", "onFileChosen"));
                }
                ImportSettingsPanel.this.myErrorOutput.setText(chosenFile.getPath());
            }
        });
        this.myHandleErrorCheckBox.setSelected(errors);
        this.myModalityStateCheckBox.setSelected(this.myModalityStateCheckBox.isVisible() && ImportSettings.getImportModality());
        this.myHandleErrorCheckBox.addItemListener(e -> this.myErrorOutput.setEnabled(this.myHandleErrorCheckBox.isSelected()));
    }

    @NotNull
    private String getDefaultText(@NotNull String directory) {
        if (directory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directory", "com/intellij/database/dbimport/ui/ImportSettingsPanel", "getDefaultText"));
        }
        String string = directory + File.separator + this.myTableName + "_" + DATE_FORMAT.format(LocalDateTime.now()) + ".txt";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ui/ImportSettingsPanel", "getDefaultText"));
        }
        return string;
    }
}

