/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects;

import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.dialects.OracleDialect;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasConstraint;
import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.DasIndex;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasTableChild;
import com.intellij.database.model.DasTableKey;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.MultiRef;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicKey;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModRoot;
import com.intellij.database.model.impl.MemoryTextStorage;
import com.intellij.database.model.impl.ModelFactory;
import com.intellij.database.psi.DbIndex;
import com.intellij.database.psi.DbTableImpl;
import com.intellij.database.util.CharOut;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.QNameUtil;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.Rdbms;

public class DialectUtils {
    public static <T, M extends BasicModModel, R extends BasicModRoot> T withNewModel(Rdbms rdbms, Class<M> modelClass, Class<R> rootClass, Function<R, T> function) {
        BasicModModel model = (BasicModModel)new ModelFactory(new MemoryTextStorage()).createModel(rdbms, modelClass);
        Ref resultRef = Ref.create();
        model.modify(rootClass, root2 -> resultRef.set(function.fun(root2)));
        return (T)resultRef.get();
    }

    public static DdlBuilder getObjectCommentAlterSQL(@NotNull DdlBuilder builder, @NotNull String type, @NotNull DasObject object, boolean dropIsNull) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/DialectUtils", "getObjectCommentAlterSQL"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/database/dialects/DialectUtils", "getObjectCommentAlterSQL"));
        }
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/dialects/DialectUtils", "getObjectCommentAlterSQL"));
        }
        builder.keywords("COMMENT", "ON", type).space();
        DasColumn column = (DasColumn)ObjectUtils.tryCast((Object)object, DasColumn.class);
        if (column != null) {
            builder.qualifiedRef((DasObject)column.getTable()).symbol(".").columnRef((DasObject)column).space();
        } else {
            builder.qualifiedRef(object).space();
        }
        builder.keyword("IS").space();
        if (object.getComment() == null || !dropIsNull) {
            builder.literal("'" + StringUtil.notNullize((String)object.getComment()) + "'");
        } else {
            builder.literal("NULL");
        }
        return builder;
    }

    public static DdlBuilder getColumnCommentAlterSQL(@NotNull DdlBuilder builder, @NotNull DasColumn column, boolean dropIsNull) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/DialectUtils", "getColumnCommentAlterSQL"));
        }
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/dialects/DialectUtils", "getColumnCommentAlterSQL"));
        }
        return DialectUtils.getObjectCommentAlterSQL(builder, "COLUMN", (DasObject)column, dropIsNull);
    }

    public static DdlBuilder getColumnDropSQL(@NotNull DdlBuilder builder, @NotNull DasColumn column) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/DialectUtils", "getColumnDropSQL"));
        }
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/dialects/DialectUtils", "getColumnDropSQL"));
        }
        return DialectUtils.getColumnDropSQL(builder, column, "DROP", false, "");
    }

    public static DdlBuilder getColumnDropSQL(@NotNull DdlBuilder builder, @NotNull DasColumn column, String dropClause, boolean addConstraintClause, @NotNull String constraintClause) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/DialectUtils", "getColumnDropSQL"));
        }
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/dialects/DialectUtils", "getColumnDropSQL"));
        }
        if (constraintClause == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constraintClause", "com/intellij/database/dialects/DialectUtils", "getColumnDropSQL"));
        }
        builder.keywords("ALTER", "TABLE").space().qualifiedRef((DasObject)column.getTable()).space();
        builder.keyword(dropClause).space();
        builder.columnRef((DasObject)column);
        if (addConstraintClause) {
            builder.space();
            builder.keyword(constraintClause);
        }
        return builder;
    }

    @NotNull
    public static DdlBuilder getTableDropSQL(@NotNull DdlBuilder builder, @NotNull DasTable tableInfo, boolean supportsCascade, boolean cascadeValue, boolean supportsMatViews, String cascadeClause, boolean isMatView) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/DialectUtils", "getTableDropSQL"));
        }
        if (tableInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tableInfo", "com/intellij/database/dialects/DialectUtils", "getTableDropSQL"));
        }
        if (supportsMatViews && isMatView) {
            builder.keyword("DROP").space().keyword("MATERIALIZED").space().keyword("VIEW").space();
        } else {
            builder.keyword("DROP").space().keyword("TABLE").space();
        }
        builder.qualifiedRef((DasObject)tableInfo);
        if (supportsCascade && cascadeValue && !cascadeClause.isEmpty()) {
            builder.space().keyword(cascadeClause);
        }
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/DialectUtils", "getTableDropSQL"));
        }
        return ddlBuilder;
    }

    public static DdlBuilder getColumnNullableAlterSQL(@NotNull DdlBuilder builder, @NotNull DasColumn info, @NotNull String alterClause, boolean specifyType) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/DialectUtils", "getColumnNullableAlterSQL"));
        }
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/database/dialects/DialectUtils", "getColumnNullableAlterSQL"));
        }
        if (alterClause == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "alterClause", "com/intellij/database/dialects/DialectUtils", "getColumnNullableAlterSQL"));
        }
        return DialectUtils.getColumnNullableAlterSQL(builder, (DasTypedObject)info, !info.isNotNull(), alterClause, specifyType);
    }

    public static DdlBuilder getColumnNullableAlterSQL(@NotNull DdlBuilder builder, @NotNull DasTypedObject column, boolean nullable, @NotNull String alterClause, boolean specifyType) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/DialectUtils", "getColumnNullableAlterSQL"));
        }
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/dialects/DialectUtils", "getColumnNullableAlterSQL"));
        }
        if (alterClause == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "alterClause", "com/intellij/database/dialects/DialectUtils", "getColumnNullableAlterSQL"));
        }
        builder.keyword("ALTER").space().keyword("TABLE").space().qualifiedRef(column.getDbParent()).space().keyword(alterClause).space();
        builder.columnRef((DasObject)column);
        if (specifyType) {
            builder.space().type(column);
        }
        DialectUtils.addNullabilityClause(builder, !nullable, true);
        return builder;
    }

    public static DdlBuilder getAddPrimaryKeySQL(@NotNull DdlBuilder builder, @NotNull DasTableKey pk, boolean appendConstraintName) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/DialectUtils", "getAddPrimaryKeySQL"));
        }
        if (pk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pk", "com/intellij/database/dialects/DialectUtils", "getAddPrimaryKeySQL"));
        }
        builder.keyword("ALTER").space().keyword("TABLE").space();
        builder.qualifiedRef((DasObject)pk.getTable());
        builder.space().keyword("ADD").space();
        if (StringUtil.isNotEmpty((String)pk.getName()) && !appendConstraintName) {
            builder.keyword("CONSTRAINT").space().constraintRef((DasObject)pk).space();
        }
        builder.keywords("PRIMARY", "KEY").space();
        DialectUtils.columnList(builder, (DasConstraint)pk);
        if (appendConstraintName) {
            builder.space().keyword("CONSTRAINT").space();
            builder.constraintRef((DasObject)pk);
        }
        return builder;
    }

    @NotNull
    public static DdlBuilder getAddForeignKeyConstraintSQL(@NotNull DdlBuilder builder, @NotNull DasForeignKey keyInfo, boolean matchFull, boolean autoFKIndex, @NotNull DatabaseDialectEx dialect) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/DialectUtils", "getAddForeignKeyConstraintSQL"));
        }
        if (keyInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keyInfo", "com/intellij/database/dialects/DialectUtils", "getAddForeignKeyConstraintSQL"));
        }
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/dialects/DialectUtils", "getAddForeignKeyConstraintSQL"));
        }
        builder.keywords("ALTER", "TABLE").space().qualifiedRef((DasObject)keyInfo.getTable());
        builder.newLine().keyword("ADD").space();
        String keyName = keyInfo.getName();
        if (StringUtil.isNotEmpty((String)keyName)) {
            builder.keyword("CONSTRAINT").space();
            builder.constraintRef((DasObject)keyInfo).newLine();
        }
        dialect.sqlDefineForeignKey(builder, keyInfo, matchFull);
        builder.newStatement();
        if (autoFKIndex && StringUtil.isNotEmpty((String)keyName)) {
            DialectUtils.getAddIndexSQL(builder, (DasTableChild)keyInfo, "", "", "");
            builder.newStatement();
        }
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/DialectUtils", "getAddForeignKeyConstraintSQL"));
        }
        return ddlBuilder;
    }

    static DdlBuilder foreignKeyTail(DdlBuilder builder, DasForeignKey keyInfo, @Nullable DasForeignKey.Deferrability deferrabilityOverride, boolean matchFull, @Nullable DasForeignKey.RuleAction deleteOverride, @Nullable DasForeignKey.RuleAction updateOverride) {
        DasForeignKey.Deferrability deferrability;
        builder.keywords("FOREIGN", "KEY").space();
        DialectUtils.columnList(builder, (DasConstraint)keyInfo);
        DasTable table = keyInfo.getTable();
        if (table != null) {
            builder.pushDefaultSchema(DasUtil.getNamespace((DasObject)table));
        }
        builder.space();
        DialectUtils.refColumnList(builder, keyInfo);
        if (table != null) {
            builder.popDefaultSchema();
        }
        if (matchFull) {
            builder.space().keyword("MATCH").space().keyword("FULL");
        }
        DialectUtils.constructFKConstraintActionClause(builder, true, deleteOverride != null ? deleteOverride : keyInfo.getDeleteRule());
        DialectUtils.constructFKConstraintActionClause(builder, false, updateOverride != null ? updateOverride : keyInfo.getUpdateRule());
        DasForeignKey.Deferrability deferrability2 = deferrability = deferrabilityOverride != null ? deferrabilityOverride : keyInfo.getDeferrability();
        if (deferrability != null) {
            if (deferrability != DasForeignKey.Deferrability.NOT_DEFERRABLE) {
                builder.space().keyword("DEFERRABLE");
            }
            if (deferrability == DasForeignKey.Deferrability.INITIALLY_DEFERRED) {
                builder.space().keyword("INITIALLY").space().keyword("DEFERRED");
            }
        }
        return builder;
    }

    public static DdlBuilder getAddUniqueConstraintSQL(@NotNull DdlBuilder builder, @NotNull DasTable table, @Nullable DasObject constraint, @NotNull String constraintName, @NotNull List<DasColumn> columns) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/DialectUtils", "getAddUniqueConstraintSQL"));
        }
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/dialects/DialectUtils", "getAddUniqueConstraintSQL"));
        }
        if (constraintName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constraintName", "com/intellij/database/dialects/DialectUtils", "getAddUniqueConstraintSQL"));
        }
        if (columns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columns", "com/intellij/database/dialects/DialectUtils", "getAddUniqueConstraintSQL"));
        }
        builder.keyword("ALTER").space().keyword("TABLE");
        builder.space();
        builder.qualifiedRef((DasObject)table);
        builder.newLine();
        builder.space();
        builder.keyword("ADD").space().keyword("CONSTRAINT");
        builder.space();
        builder.constraintRef(constraint, constraintName);
        builder.space();
        builder.keyword("UNIQUE");
        builder.space().symbol("(");
        DialectUtils.appendColumnList(builder, columns);
        builder.symbol(")");
        return builder;
    }

    public static DdlBuilder getColumnNameAlterSQL(@NotNull DdlBuilder builder, @NotNull DasColumn from, @NotNull String toName, @NotNull String alterClause, @NotNull String renameToClause) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/DialectUtils", "getColumnNameAlterSQL"));
        }
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/intellij/database/dialects/DialectUtils", "getColumnNameAlterSQL"));
        }
        if (toName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toName", "com/intellij/database/dialects/DialectUtils", "getColumnNameAlterSQL"));
        }
        if (alterClause == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "alterClause", "com/intellij/database/dialects/DialectUtils", "getColumnNameAlterSQL"));
        }
        if (renameToClause == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renameToClause", "com/intellij/database/dialects/DialectUtils", "getColumnNameAlterSQL"));
        }
        builder.keyword("ALTER").space().keyword("TABLE").space();
        builder.qualifiedRef((DasObject)from.getTable());
        builder.space();
        builder.keyword(alterClause);
        builder.space();
        builder.columnRef((DasObject)from);
        builder.space();
        builder.keyword(renameToClause);
        builder.space();
        builder.newName(toName);
        return builder;
    }

    public static DdlBuilder getColumnDefaultAlterSQL(@NotNull DdlBuilder builder, @NotNull DasColumn column, String alterClause, boolean specifyType, String defaultClause) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/DialectUtils", "getColumnDefaultAlterSQL"));
        }
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/dialects/DialectUtils", "getColumnDefaultAlterSQL"));
        }
        builder.keyword("ALTER").space().keyword("TABLE").space();
        builder.qualifiedRef((DasObject)column.getTable());
        builder.space();
        builder.keyword(alterClause);
        builder.space();
        builder.columnRef((DasObject)column);
        if (specifyType) {
            builder.space().type((DasTypedObject)column);
        }
        builder.space().keyword(defaultClause).space();
        builder.literal(StringUtil.notNullize((String)column.getDefault(), (String)"NULL"));
        return builder;
    }

    public static DdlBuilder getColumnDefaultAlterOrDropSQL(@NotNull DdlBuilder builder, @NotNull DasColumn column) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/DialectUtils", "getColumnDefaultAlterOrDropSQL"));
        }
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/dialects/DialectUtils", "getColumnDefaultAlterOrDropSQL"));
        }
        String defVal = column.getDefault();
        boolean drop = defVal == null || defVal.isEmpty();
        builder.keywords("ALTER", "TABLE").space();
        builder.qualifiedRef((DasObject)column.getTable()).space();
        builder.keywords("ALTER", "COLUMN").space();
        builder.columnRef((DasObject)column);
        if (drop) {
            builder.space().keyword("DROP").space().keyword("DEFAULT");
        } else {
            DialectUtils.addDefaultClauseIfNeeded(builder, column, "SET DEFAULT");
        }
        return builder;
    }

    public static void addDefaultClauseIfNeeded(@NotNull DdlBuilder builder, @NotNull DasColumn column, @NotNull String defaultClause) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/DialectUtils", "addDefaultClauseIfNeeded"));
        }
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/dialects/DialectUtils", "addDefaultClauseIfNeeded"));
        }
        if (defaultClause == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultClause", "com/intellij/database/dialects/DialectUtils", "addDefaultClauseIfNeeded"));
        }
        DialectUtils.addDefaultClauseIfNeeded(builder, defaultClause, column.getDefault());
    }

    public static void addDefaultClauseIfNeeded(@NotNull DdlBuilder builder, @NotNull String defaultClause, @Nullable String defVal) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/DialectUtils", "addDefaultClauseIfNeeded"));
        }
        if (defaultClause == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultClause", "com/intellij/database/dialects/DialectUtils", "addDefaultClauseIfNeeded"));
        }
        if (StringUtil.isNotEmpty((String)defVal)) {
            builder.space().keyword(defaultClause).space();
            builder.literal(defVal);
        }
    }

    public static void addCommentClauseIfNeeded(@NotNull DdlBuilder builder, @NotNull DasColumn column) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/DialectUtils", "addCommentClauseIfNeeded"));
        }
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/dialects/DialectUtils", "addCommentClauseIfNeeded"));
        }
        if (!StringUtil.isEmpty((String)column.getComment())) {
            builder.space().keyword("COMMENT").space().literal("'" + column.getComment() + "'");
        }
    }

    public static void addNullabilityClause(@NotNull DdlBuilder builder, @NotNull DasColumn column, boolean supportsNullQualifier) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/DialectUtils", "addNullabilityClause"));
        }
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/dialects/DialectUtils", "addNullabilityClause"));
        }
        DialectUtils.addNullabilityClause(builder, column.isNotNull(), supportsNullQualifier);
    }

    public static void addNullabilityClause(@NotNull DdlBuilder builder, boolean notNull, boolean supportsNullQualifier) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/DialectUtils", "addNullabilityClause"));
        }
        if (notNull) {
            builder.space().keyword("NOT");
        }
        if (supportsNullQualifier || notNull) {
            builder.space().keyword("NULL");
        }
    }

    @NotNull
    public static DdlBuilder getColumnTypeAlterSQL(@NotNull DdlBuilder builder, @NotNull String alterClause, @NotNull String setClause, boolean repeatColumn, @NotNull DasColumn to) throws UnsupportedOperationException {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/DialectUtils", "getColumnTypeAlterSQL"));
        }
        if (alterClause == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "alterClause", "com/intellij/database/dialects/DialectUtils", "getColumnTypeAlterSQL"));
        }
        if (setClause == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "setClause", "com/intellij/database/dialects/DialectUtils", "getColumnTypeAlterSQL"));
        }
        if (to == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "com/intellij/database/dialects/DialectUtils", "getColumnTypeAlterSQL"));
        }
        builder.keywords("ALTER", "TABLE").space();
        builder.qualifiedRef((DasObject)to.getTable());
        builder.space();
        builder.keyword(alterClause);
        builder.space();
        if (repeatColumn) {
            builder.columnRef((DasObject)to);
            builder.space();
        }
        builder.columnRef((DasObject)to);
        builder.space();
        if (!setClause.isEmpty()) {
            builder.keyword(setClause);
            builder.space();
        }
        builder.type((DasTypedObject)to);
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/DialectUtils", "getColumnTypeAlterSQL"));
        }
        return ddlBuilder;
    }

    public static DdlBuilder getDropPrimaryKeySQL(@NotNull DdlBuilder builder, @NotNull DasTableKey pk, boolean useConstraintName, boolean cascadeConstraints) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/DialectUtils", "getDropPrimaryKeySQL"));
        }
        if (pk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pk", "com/intellij/database/dialects/DialectUtils", "getDropPrimaryKeySQL"));
        }
        builder.keyword("ALTER").space().keyword("TABLE").space();
        builder.qualifiedRef((DasObject)pk.getTable());
        if (useConstraintName) {
            builder.space().keyword("DROP").space().keyword("CONSTRAINT").space();
            builder.constraintRef((DasObject)pk);
        } else {
            builder.space().keywords("DROP", "PRIMARY", "KEY");
        }
        if (cascadeConstraints) {
            builder.space().keyword("CASCADE");
        }
        return builder;
    }

    public static DdlBuilder getDropIndexSQL(@NotNull DdlBuilder builder, @NotNull DasTable table, @Nullable DasIndex index, @NotNull String indexName, @Nullable Boolean cascade, boolean onTable) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/DialectUtils", "getDropIndexSQL"));
        }
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/dialects/DialectUtils", "getDropIndexSQL"));
        }
        if (indexName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indexName", "com/intellij/database/dialects/DialectUtils", "getDropIndexSQL"));
        }
        builder.keyword("DROP").space().keyword("INDEX");
        builder.space();
        builder.qualifiedRefOpt((DasObject)index, (DasObject)table, indexName);
        if (cascade != null) {
            builder.space().keyword(cascade != false ? "CASCADE" : "RESTRICT");
        }
        if (onTable) {
            builder.space().keyword("ON").space().qualifiedRef((DasObject)table);
        }
        return builder;
    }

    public static DdlBuilder getDropSequenceSQL(@NotNull DdlBuilder builder, @NotNull DasTable sequence, @Nullable Boolean cascade) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/DialectUtils", "getDropSequenceSQL"));
        }
        if (sequence == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sequence", "com/intellij/database/dialects/DialectUtils", "getDropSequenceSQL"));
        }
        builder.keywords("DROP", "SEQUENCE").space().qualifiedRef((DasObject)sequence);
        if (cascade != null) {
            builder.space().keyword(cascade != false ? "CASCADE" : "RESTRICT");
        }
        return builder;
    }

    public static DdlBuilder getDropConstraintSQL(@NotNull DdlBuilder builder, @NotNull DasTable table, @Nullable DasObject constraint, @NotNull String constraintName) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/DialectUtils", "getDropConstraintSQL"));
        }
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/dialects/DialectUtils", "getDropConstraintSQL"));
        }
        if (constraintName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constraintName", "com/intellij/database/dialects/DialectUtils", "getDropConstraintSQL"));
        }
        return builder.keyword("ALTER").space().keyword("TABLE").space().qualifiedRef((DasObject)table).space().keyword("DROP").space().keyword("CONSTRAINT").space().constraintRef(constraint, constraintName);
    }

    public static DdlBuilder getDropViewSQL(@NotNull DdlBuilder builder, @NotNull DasTable view2, @Nullable Boolean cascade) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/DialectUtils", "getDropViewSQL"));
        }
        if (view2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/intellij/database/dialects/DialectUtils", "getDropViewSQL"));
        }
        builder.keyword("DROP").space().keyword("VIEW").space().qualifiedRef((DasObject)view2);
        if (cascade != null) {
            builder.space();
            builder.keyword(cascade != false ? "CASCADE" : "RESTRICT");
        }
        return builder;
    }

    public static DdlBuilder getAddIndexSQL(@NotNull DdlBuilder builder, @NotNull DasTableChild keyOrIndex, @NotNull String accessMethod, @NotNull String tablespace, @NotNull String constraints) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/DialectUtils", "getAddIndexSQL"));
        }
        if (keyOrIndex == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keyOrIndex", "com/intellij/database/dialects/DialectUtils", "getAddIndexSQL"));
        }
        if (accessMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "accessMethod", "com/intellij/database/dialects/DialectUtils", "getAddIndexSQL"));
        }
        if (tablespace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tablespace", "com/intellij/database/dialects/DialectUtils", "getAddIndexSQL"));
        }
        if (constraints == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constraints", "com/intellij/database/dialects/DialectUtils", "getAddIndexSQL"));
        }
        builder.keyword("CREATE").space();
        if (!(keyOrIndex instanceof DasIndex) || ((DasIndex)keyOrIndex).isUnique()) {
            builder.keyword("UNIQUE").space();
        }
        builder.keyword("INDEX").space();
        builder.identifier(keyOrIndex.getName());
        builder.space().keyword("ON").space().qualifiedRef((DasObject)keyOrIndex.getTable()).space();
        if (!accessMethod.isEmpty()) {
            builder.keyword("USING").space();
            builder.plain(accessMethod).space();
        }
        MultiRef ref = keyOrIndex instanceof DasConstraint ? ((DasConstraint)keyOrIndex).getColumnsRef() : ((DasIndex)keyOrIndex).getColumnsRef();
        DialectUtils.columnList(builder, (MultiRef<? extends DasTypedObject>)ref);
        if (!tablespace.isEmpty()) {
            builder.newLine().space().keyword("TABLESPACE").space().ref(null, tablespace);
        }
        if (!constraints.isEmpty()) {
            builder.newLine().space().keyword("WHERE").space().plain(constraints);
        }
        return builder;
    }

    public static DdlBuilder getRenameTableSQL(@NotNull DdlBuilder builder, @NotNull DasTable table, @NotNull String newTableName) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/DialectUtils", "getRenameTableSQL"));
        }
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/dialects/DialectUtils", "getRenameTableSQL"));
        }
        if (newTableName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newTableName", "com/intellij/database/dialects/DialectUtils", "getRenameTableSQL"));
        }
        builder.keyword("ALTER").space().keyword("TABLE").space();
        builder.qualifiedRef((DasObject)table);
        builder.space().keyword("RENAME").space().keyword("TO").space();
        builder.newName(newTableName, (DasObject)table);
        return builder;
    }

    public static DdlBuilder getDropForeignKeySQL(@NotNull DdlBuilder builder, @Nullable DasForeignKey fk, @NotNull String fkName, @NotNull DasTable table) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/DialectUtils", "getDropForeignKeySQL"));
        }
        if (fkName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fkName", "com/intellij/database/dialects/DialectUtils", "getDropForeignKeySQL"));
        }
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/dialects/DialectUtils", "getDropForeignKeySQL"));
        }
        builder.keyword("ALTER").space().keyword("TABLE").space().qualifiedRef((DasObject)table).space().keyword("DROP").space().keyword("CONSTRAINT").space().constraintRef((DasObject)fk, fkName);
        return builder;
    }

    @NotNull
    public static DdlBuilder getCreateTableSQL(@NotNull DdlBuilder builder, @NotNull List<? extends DasTable> tables, boolean constraintsAtEnd, @NotNull DatabaseDialectEx dialect, @Nullable Set<? extends DasForeignKey> ignoreFks) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/DialectUtils", "getCreateTableSQL"));
        }
        if (tables == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tables", "com/intellij/database/dialects/DialectUtils", "getCreateTableSQL"));
        }
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/dialects/DialectUtils", "getCreateTableSQL"));
        }
        DdlBuilder ddlBuilder = DialectUtils.getCreateTableSQL(builder, tables, constraintsAtEnd, false, dialect, ignoreFks);
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/DialectUtils", "getCreateTableSQL"));
        }
        return ddlBuilder;
    }

    public static <T> boolean contains(@Nullable Collection<? extends T> col, T item) {
        return col != null && col.contains(item);
    }

    @NotNull
    public static DdlBuilder getCreateTableSQL(@NotNull DdlBuilder builder, @NotNull List<? extends DasTable> tables, boolean constraintsAtEnd, boolean suppressKeysCreation, @NotNull DatabaseDialectEx dialect, @Nullable Set<? extends DasForeignKey> ignoreFks) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/DialectUtils", "getCreateTableSQL"));
        }
        if (tables == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tables", "com/intellij/database/dialects/DialectUtils", "getCreateTableSQL"));
        }
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/dialects/DialectUtils", "getCreateTableSQL"));
        }
        boolean fkInside = tables.size() == 1 && !DasUtil.getForeignKeys((DasTable)tables.get(0)).isEmpty() || !dialect.supportsAddForeignKey() || ignoreFks != null;
        boolean first0 = true;
        Iterator<? extends DasTable> iterator = tables.iterator();
        while (iterator.hasNext()) {
            DasTable dasTable;
            DasTable table = dasTable = iterator.next();
            DasTable tableDelegate = null;
            if (table instanceof DbTableImpl) {
                tableDelegate = (DasTable)((DbTableImpl)table).getDelegate();
            }
            if (tableDelegate != null) {
                table = tableDelegate;
            }
            if (first0) {
                first0 = false;
            } else {
                builder.newStatement();
            }
            builder.keyword("CREATE").space().keyword("TABLE").space();
            builder.qualifiedRef((DasObject)dasTable);
            builder.newLine().symbol("(");
            DasTableKey pkInfo = builder.isJdbcOdbc() ? null : DasUtil.getPrimaryKey((DasTable)table);
            MultiRef pkColumnsRef = pkInfo == null ? DasUtil.emptyMultiRef() : pkInfo.getColumnsRef();
            boolean oneColumnPk = pkColumnsRef.size() == 1;
            JBIterable infos = DasUtil.getColumns((DasObject)table);
            boolean first = true;
            for (DasColumn column : builder.sortKeysIfNeeded(infos)) {
                if (first) {
                    first = false;
                } else {
                    builder.symbol(",");
                }
                builder.newLine().tab();
                boolean isSinglePk = oneColumnPk && DasUtil.containsName((String)column.getName(), (MultiRef)pkColumnsRef);
                dialect.sqlDefineColumn(builder, column, isSinglePk);
            }
            if (pkColumnsRef.size() > 1) {
                String name;
                builder.symbol(",").newLine().tab();
                String string = name = pkInfo != null ? pkInfo.getName() : null;
                if (StringUtil.isNotEmpty((String)name) && !QNameUtil.isFakeName(name)) {
                    builder.keyword("CONSTRAINT").space();
                    builder.identifier((DasObject)pkInfo, name).space();
                }
                builder.keywords("PRIMARY", "KEY").space();
                DialectUtils.columnList(builder, (DasConstraint)pkInfo);
            }
            if (fkInside && !suppressKeysCreation) {
                for (DasForeignKey foreignKeyInfo : DasUtil.getForeignKeys((DasTable)table)) {
                    if (DialectUtils.contains(ignoreFks, foreignKeyInfo)) continue;
                    builder.symbol(",").newLine();
                    builder.tab();
                    String name = foreignKeyInfo.getName();
                    if (StringUtil.isNotEmpty((String)name) && !QNameUtil.isFakeName(name)) {
                        builder.keyword("CONSTRAINT").space();
                        builder.identifier((DasObject)foreignKeyInfo, name).space();
                    }
                    dialect.sqlDefineForeignKey(builder, foreignKeyInfo, false);
                }
            }
            if (table.getKind() != ObjectKind.VIEW) {
                for (DasIndex index : DasUtil.getIndices((DasTable)table)) {
                    String indexName;
                    if (pkInfo instanceof BasicKey && Comparing.equal((String)((BasicKey)pkInfo).getUnderlyingIndexName(), (String)index.getName()) || StringUtil.isNotEmpty((String)(indexName = index.getName()))) continue;
                    builder.symbol(",").newLine();
                    builder.tab();
                    if (index.isUnique()) {
                        builder.keyword("UNIQUE").space();
                    }
                    builder.keyword("INDEX").space();
                    DialectUtils.columnList(builder, index);
                }
            }
            builder.newLine().symbol(")");
            if (builder.isJdbcOdbc()) continue;
            if (!constraintsAtEnd && !suppressKeysCreation) {
                DialectUtils.createConstraintsAndIndices(builder, table, tables, fkInside, dialect);
            }
            if (!dialect.supportsColumnComment() || dialect.supportsColumnCommentsInTableDefinition()) continue;
            for (DasColumn info : infos) {
                if (!StringUtil.isNotEmpty((String)info.getComment())) continue;
                DialectUtils.getColumnCommentAlterSQL(builder.newStatement(), info, false);
            }
        }
        if (constraintsAtEnd && !suppressKeysCreation) {
            for (DasTable dasTable : tables) {
                DialectUtils.createConstraintsAndIndices(builder, dasTable, tables, fkInside, dialect);
            }
        }
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/DialectUtils", "getCreateTableSQL"));
        }
        return ddlBuilder;
    }

    private static void createConstraintsAndIndices(@NotNull DdlBuilder builder, @NotNull DasTable tableInfo, @NotNull List<? extends DasTable> tables, boolean fkInside, @NotNull DatabaseDialectEx dialect) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/DialectUtils", "createConstraintsAndIndices"));
        }
        if (tableInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tableInfo", "com/intellij/database/dialects/DialectUtils", "createConstraintsAndIndices"));
        }
        if (tables == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tables", "com/intellij/database/dialects/DialectUtils", "createConstraintsAndIndices"));
        }
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/dialects/DialectUtils", "createConstraintsAndIndices"));
        }
        if (!fkInside) {
            DialectUtils.createConstraints(builder, tableInfo, tables, !builder.skipExternalReferences(), dialect);
        }
        DialectUtils.createIndices(builder, tableInfo);
    }

    public static <E> Iterable<E> resolve(final @NotNull MultiRef<E> ref) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/database/dialects/DialectUtils", "resolve"));
        }
        return new Iterable<E>(){

            @Override
            @NotNull
            public Iterator<E> iterator() {
                Iterator iterator = new Iterator<E>(){
                    MultiRef.It<E> it;
                    {
                        this.it = ref.iterate();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.it.hasNext();
                    }

                    @Override
                    public E next() {
                        this.it.next();
                        return this.it.resolve();
                    }

                    @Override
                    public void remove() {
                        this.it.remove();
                    }
                };
                if (iterator == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/DialectUtils$1", "iterator"));
                }
                return iterator;
            }
        };
    }

    public static void columnList(DdlBuilder builder, DasConstraint o) {
        DialectUtils.columnList(builder, (MultiRef<? extends DasTypedObject>)o.getColumnsRef());
    }

    public static void columnList(DdlBuilder builder, DasIndex o) {
        builder.symbol("(");
        boolean first = true;
        MultiRef.It it = o.getColumnsRef().iterate();
        while (it.hasNext()) {
            String name = (String)it.next();
            if (first) {
                first = false;
            } else {
                builder.symbol(",").space();
            }
            DasTypedObject column = (DasTypedObject)it.resolve();
            if (column != null) {
                builder.columnRef((DasObject)column);
                DasIndex.Sorting sorting = o.getColumnSorting(column);
                if (sorting != DasIndex.Sorting.DESCENDING) continue;
                builder.space().keyword("DESC");
                continue;
            }
            builder.columnRef(name);
        }
        builder.symbol(")");
    }

    public static void columnList(DdlBuilder builder, MultiRef<? extends DasTypedObject> o) {
        DialectUtils.columnList(builder, o, false);
    }

    public static boolean columnList(DdlBuilder builder, MultiRef<? extends DasTypedObject> o, boolean noParensForEmpty) {
        boolean first = true;
        MultiRef.It it = o.iterate();
        while (it.hasNext()) {
            String name = (String)it.next();
            if (first) {
                builder.symbol("(");
                first = false;
            } else {
                builder.symbol(",").space();
            }
            DasTypedObject column = (DasTypedObject)it.resolve();
            if (column != null) {
                builder.columnRef((DasObject)column);
                continue;
            }
            builder.columnRef(name);
        }
        if (!first) {
            builder.symbol(")");
        } else if (!noParensForEmpty) {
            builder.symbol("(").symbol(")");
        } else {
            return false;
        }
        return true;
    }

    public static void refColumnList(DdlBuilder builder, DasForeignKey keyInfo) {
        String refTableName = StringUtil.notNullize((String)keyInfo.getRefTableName());
        builder.keyword("REFERENCES").space().qualifiedRefOpt((DasObject)keyInfo.getRefTable(), refTableName);
        DdlBuilder.Marker mark = builder.mark();
        builder.space();
        if (!DialectUtils.columnList(builder, (MultiRef<? extends DasTypedObject>)keyInfo.getRefColumns(), true)) {
            mark.replace("");
        }
        mark.finish();
    }

    public static DdlBuilder getColumnDefinitionSQL(@NotNull DdlBuilder builder, @NotNull DasColumn column, boolean isSinglePkColumn) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/DialectUtils", "getColumnDefinitionSQL"));
        }
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/dialects/DialectUtils", "getColumnDefinitionSQL"));
        }
        return DialectUtils.getColumnDefinitionSQL(builder, column, isSinglePkColumn, null);
    }

    public static DdlBuilder getColumnDefinitionSQL(@NotNull DdlBuilder builder, @NotNull DasColumn column, boolean isSinglePkColumn, @Nullable String type) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/DialectUtils", "getColumnDefinitionSQL"));
        }
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/dialects/DialectUtils", "getColumnDefinitionSQL"));
        }
        builder.columnRef((DasObject)column);
        builder.space();
        if (type != null) {
            builder.type(type);
        } else {
            builder.type((DasTypedObject)column);
        }
        if (isSinglePkColumn) {
            builder.space().keywords("PRIMARY", "KEY");
        } else {
            DialectUtils.addDefaultClauseIfNeeded(builder, column, "DEFAULT");
        }
        DialectUtils.addNullabilityClause(builder, column, false);
        return builder;
    }

    public static DdlBuilder getCreateIndexSQL(@NotNull DdlBuilder builder, @NotNull DasIndex index) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/DialectUtils", "getCreateIndexSQL"));
        }
        if (index == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "index", "com/intellij/database/dialects/DialectUtils", "getCreateIndexSQL"));
        }
        builder.keyword("CREATE").space();
        if (index.isUnique()) {
            builder.keyword("UNIQUE").space();
        }
        builder.keyword("INDEX").space();
        builder.qualifiedRefOpt((DasObject)index, (DasObject)index.getTable(), index.getName());
        builder.space().keyword("ON").space();
        builder.qualifiedRef((DasObject)index.getTable());
        builder.symbol("(");
        boolean first = true;
        for (String column : index.getColumnsRef().names()) {
            if (first) {
                first = false;
            } else {
                builder.symbol(",");
            }
            builder.columnRef(column);
        }
        builder.symbol(")");
        return builder;
    }

    public static DdlBuilder getCreateViewSQL(@NotNull DdlBuilder builder, @NotNull DasTable view2, @NotNull String definition, @NotNull String checkOption, @NotNull DatabaseDialectEx dialect) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/DialectUtils", "getCreateViewSQL"));
        }
        if (view2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/intellij/database/dialects/DialectUtils", "getCreateViewSQL"));
        }
        if (definition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "definition", "com/intellij/database/dialects/DialectUtils", "getCreateViewSQL"));
        }
        if (checkOption == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "checkOption", "com/intellij/database/dialects/DialectUtils", "getCreateViewSQL"));
        }
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/dialects/DialectUtils", "getCreateViewSQL"));
        }
        builder.keyword("CREATE").space().keyword("VIEW").space().qualifiedRef((DasObject)view2).space().keyword("AS").space().plain(definition);
        if (dialect.supportsCheckOptionsForViews() && !checkOption.isEmpty()) {
            builder.newLine().keyword("WITH").space().keyword(checkOption).space().keyword("CHECK").space().keyword("OPTION");
        }
        return builder;
    }

    public static DdlBuilder getCreateSequenceSQL(@NotNull DdlBuilder builder, @NotNull DasTable sequence, @NotNull String increment, @NotNull String minimumClause, @NotNull String minimum, @NotNull String maximumClause, @NotNull String maximum, @NotNull String start, @NotNull String cache, @NotNull String cycleClause) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/DialectUtils", "getCreateSequenceSQL"));
        }
        if (sequence == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sequence", "com/intellij/database/dialects/DialectUtils", "getCreateSequenceSQL"));
        }
        if (increment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "increment", "com/intellij/database/dialects/DialectUtils", "getCreateSequenceSQL"));
        }
        if (minimumClause == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "minimumClause", "com/intellij/database/dialects/DialectUtils", "getCreateSequenceSQL"));
        }
        if (minimum == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "minimum", "com/intellij/database/dialects/DialectUtils", "getCreateSequenceSQL"));
        }
        if (maximumClause == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "maximumClause", "com/intellij/database/dialects/DialectUtils", "getCreateSequenceSQL"));
        }
        if (maximum == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "maximum", "com/intellij/database/dialects/DialectUtils", "getCreateSequenceSQL"));
        }
        if (start == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "start", "com/intellij/database/dialects/DialectUtils", "getCreateSequenceSQL"));
        }
        if (cache == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cache", "com/intellij/database/dialects/DialectUtils", "getCreateSequenceSQL"));
        }
        if (cycleClause == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cycleClause", "com/intellij/database/dialects/DialectUtils", "getCreateSequenceSQL"));
        }
        builder.keyword("CREATE").space().keyword("SEQUENCE").space();
        builder.qualifiedRef((DasObject)sequence);
        if (!increment.isEmpty()) {
            builder.space().keyword("INCREMENT").space().keyword("BY").space().literal(increment);
        }
        if (!minimumClause.isEmpty()) {
            builder.space().keyword(minimumClause);
        }
        if (!minimum.isEmpty()) {
            builder.space().literal(minimum);
        }
        if (!maximumClause.isEmpty()) {
            builder.space().keyword(maximumClause);
        }
        if (!maximum.isEmpty()) {
            builder.space().literal(maximum);
        }
        if (!start.isEmpty()) {
            builder.space().keywords("START", "WITH");
            builder.space().literal(start);
        }
        if (!cache.isEmpty()) {
            builder.space().keyword("CACHE");
            builder.space().literal(cache);
        }
        if (!cycleClause.isEmpty()) {
            builder.space().keyword(cycleClause);
        }
        return builder;
    }

    public static DdlBuilder getCreateSequenceSQL(@NotNull DdlBuilder builder, @NotNull DasTable sequenceName, @NotNull String increment, @NotNull String minimum, @NotNull String maximum, @NotNull String start, @NotNull String cache, @NotNull String cycleClause) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/DialectUtils", "getCreateSequenceSQL"));
        }
        if (sequenceName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sequenceName", "com/intellij/database/dialects/DialectUtils", "getCreateSequenceSQL"));
        }
        if (increment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "increment", "com/intellij/database/dialects/DialectUtils", "getCreateSequenceSQL"));
        }
        if (minimum == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "minimum", "com/intellij/database/dialects/DialectUtils", "getCreateSequenceSQL"));
        }
        if (maximum == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "maximum", "com/intellij/database/dialects/DialectUtils", "getCreateSequenceSQL"));
        }
        if (start == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "start", "com/intellij/database/dialects/DialectUtils", "getCreateSequenceSQL"));
        }
        if (cache == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cache", "com/intellij/database/dialects/DialectUtils", "getCreateSequenceSQL"));
        }
        if (cycleClause == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cycleClause", "com/intellij/database/dialects/DialectUtils", "getCreateSequenceSQL"));
        }
        return DialectUtils.getCreateSequenceSQL(builder, sequenceName, increment, !minimum.isEmpty() ? "MINVALUE" : "NO MINVALUE", minimum, !maximum.isEmpty() ? "MAXVALUE" : "NO MAXVALUE", maximum, start, cache, cycleClause);
    }

    public static DdlBuilder getAlterSequenceSQL(@NotNull DdlBuilder builder, @NotNull DasTable sequence, @NotNull String increment, @NotNull String minimum, @NotNull String maximum, @NotNull String restart, @NotNull String cache, @NotNull String cycleClause) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/DialectUtils", "getAlterSequenceSQL"));
        }
        if (sequence == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sequence", "com/intellij/database/dialects/DialectUtils", "getAlterSequenceSQL"));
        }
        if (increment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "increment", "com/intellij/database/dialects/DialectUtils", "getAlterSequenceSQL"));
        }
        if (minimum == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "minimum", "com/intellij/database/dialects/DialectUtils", "getAlterSequenceSQL"));
        }
        if (maximum == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "maximum", "com/intellij/database/dialects/DialectUtils", "getAlterSequenceSQL"));
        }
        if (restart == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "restart", "com/intellij/database/dialects/DialectUtils", "getAlterSequenceSQL"));
        }
        if (cache == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cache", "com/intellij/database/dialects/DialectUtils", "getAlterSequenceSQL"));
        }
        if (cycleClause == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cycleClause", "com/intellij/database/dialects/DialectUtils", "getAlterSequenceSQL"));
        }
        builder.keywords("ALTER", "SEQUENCE").space();
        builder.qualifiedRef((DasObject)sequence).newLine();
        if (!increment.isEmpty()) {
            builder.keywords("INCREMENT", "BY").space();
            builder.literal(increment).space();
        }
        if (!minimum.isEmpty()) {
            builder.keyword("MINVALUE").space();
            builder.literal(minimum).space();
        } else {
            builder.keywords("NO", "MINVALUE");
        }
        if (!maximum.isEmpty()) {
            builder.keyword("MAXVALUE").space();
            builder.literal(maximum).newLine();
        } else {
            builder.keyword("NO").keyword("MAXVALUE").newLine();
        }
        if (!restart.isEmpty()) {
            builder.keywords("RESTART", "WITH").space();
            builder.plain(restart).space();
        }
        if (!cache.isEmpty()) {
            builder.keyword("CACHE").space();
            builder.plain(cache).space();
        }
        if (!cycleClause.isEmpty()) {
            builder.keyword(cycleClause);
        }
        return builder;
    }

    public static void createIndices(@NotNull DdlBuilder builder, @NotNull DasTable table) {
        DasTableKey pk;
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/DialectUtils", "createIndices"));
        }
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/dialects/DialectUtils", "createIndices"));
        }
        if (table.getKind() == ObjectKind.VIEW) {
            return;
        }
        if (table instanceof DbTableImpl) {
            table = (DasTable)((DbTableImpl)table).getDelegate();
        }
        String pkName = (pk = DasUtil.getPrimaryKey((DasTable)table)) != null ? pk.getName() : null;
        boolean isOracle = builder.getDialect() instanceof OracleDialect;
        for (DasIndex ind : DasUtil.getIndices((DasTable)table)) {
            DasIndex index = ind instanceof DbIndex ? (DasIndex)((DbIndex)ind).getDelegate() : ind;
            String indexName = index.getName();
            if (StringUtil.isEmpty((String)indexName) || pk instanceof BasicKey && indexName.equals(((BasicKey)pk).getUnderlyingIndexName()) || index.isUnique() && isOracle && pkName != null && pkName.equals(indexName)) continue;
            builder.newStatement();
            builder.keyword("CREATE").space();
            if (index.isUnique()) {
                builder.keyword("UNIQUE").space();
            }
            builder.keyword("INDEX").space();
            builder.identifier(indexName);
            builder.space().keyword("ON").space();
            builder.qualifiedRef((DasObject)table).space();
            DialectUtils.columnList(builder, index);
        }
    }

    public static void createConstraints(@NotNull DdlBuilder builder, @NotNull DasTable tableInfo, @NotNull List<? extends DasTable> tables, boolean includeExternalReferences, @NotNull DatabaseDialectEx dialect) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/DialectUtils", "createConstraints"));
        }
        if (tableInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tableInfo", "com/intellij/database/dialects/DialectUtils", "createConstraints"));
        }
        if (tables == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tables", "com/intellij/database/dialects/DialectUtils", "createConstraints"));
        }
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/dialects/DialectUtils", "createConstraints"));
        }
        for (DasForeignKey keyInfo : DasUtil.getForeignKeys((DasTable)tableInfo)) {
            if (!includeExternalReferences) {
                boolean found = false;
                for (DasTable dasTable : tables) {
                    if (!dasTable.getName().equalsIgnoreCase(keyInfo.getRefTableName())) continue;
                    found = true;
                    break;
                }
                if (!found) continue;
            }
            builder.newStatement();
            builder.keyword("ALTER").space().keyword("TABLE").space().qualifiedRef((DasObject)keyInfo.getTable()).space();
            builder.keyword("ADD").space();
            dialect.sqlDefineForeignKey(builder, keyInfo, false);
        }
    }

    private static void constructFKConstraintActionClause(@NotNull DdlBuilder builder, boolean onDelete, DasForeignKey.RuleAction rule) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/DialectUtils", "constructFKConstraintActionClause"));
        }
        if (rule == null) {
            return;
        }
        String updateDelete = onDelete ? "DELETE" : "UPDATE";
        switch (rule) {
            case CASCADE: {
                builder.space().keyword("ON").space().keyword(updateDelete);
                builder.space().keyword("CASCADE");
                break;
            }
            case SET_NULL: {
                builder.space().keyword("ON").space().keyword(updateDelete);
                builder.space().keyword("SET").space().keyword("NULL");
                break;
            }
            case SET_DEFAULT: {
                builder.space().keyword("ON").space().keyword(updateDelete);
                builder.space().keyword("SET").space().keyword("DEFAULT");
                break;
            }
        }
    }

    public static DdlBuilder getAddColumnSQL(@NotNull DdlBuilder builder, @NotNull DasColumn column, boolean addDefaultClause, boolean supportsNullQualifier, boolean addNullClause) throws UnsupportedOperationException {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/DialectUtils", "getAddColumnSQL"));
        }
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/dialects/DialectUtils", "getAddColumnSQL"));
        }
        return DialectUtils.getAddColumnSQL(builder, column, addDefaultClause, supportsNullQualifier, addNullClause, null);
    }

    public static DdlBuilder getAddColumnSQL(@NotNull DdlBuilder builder, @NotNull DasColumn column, boolean addDefaultClause, boolean supportsNullQualifier, boolean addNullClause, @Nullable String type) throws UnsupportedOperationException {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/DialectUtils", "getAddColumnSQL"));
        }
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/dialects/DialectUtils", "getAddColumnSQL"));
        }
        builder.keyword("ALTER").space().keyword("TABLE").space();
        builder.qualifiedRef((DasObject)column.getTable());
        builder.space();
        builder.keyword("ADD");
        builder.space();
        builder.newName(column.getName());
        builder.space();
        if (type != null) {
            builder.type(type);
        } else {
            builder.type((DasTypedObject)column);
        }
        if (addDefaultClause) {
            DialectUtils.addDefaultClauseIfNeeded(builder, column, "DEFAULT");
        }
        if (addNullClause && (column.getDataType().getLength() != -1 || column.getDataType().getScale() != -1)) {
            DialectUtils.addNullabilityClause(builder, column, supportsNullQualifier);
        }
        return builder;
    }

    @NotNull
    public static String stripQuotesFromIdentifier(@NotNull DatabaseDialectEx dialect, @NotNull String identifier, @NotNull String strWithQuotes) {
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/dialects/DialectUtils", "stripQuotesFromIdentifier"));
        }
        if (identifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "identifier", "com/intellij/database/dialects/DialectUtils", "stripQuotesFromIdentifier"));
        }
        if (strWithQuotes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "strWithQuotes", "com/intellij/database/dialects/DialectUtils", "stripQuotesFromIdentifier"));
        }
        String string = strWithQuotes.replaceAll(dialect.quoteIdentifier(identifier, true, false), identifier);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/DialectUtils", "stripQuotesFromIdentifier"));
        }
        return string;
    }

    @NotNull
    public static String toHexString(@NotNull byte[] bytes) {
        if (bytes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bytes", "com/intellij/database/dialects/DialectUtils", "toHexString"));
        }
        CharOut out = CharOut.Util.newSink(new StringBuilder(bytes.length * 2));
        for (byte b : bytes) {
            DialectUtils.appendHex(out, (long)b & 0xFFL, 2);
        }
        String string = out.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/DialectUtils", "toHexString"));
        }
        return string;
    }

    @NotNull
    public static String toPresentableHexString(@NotNull byte[] bytes) {
        String string;
        if (bytes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bytes", "com/intellij/database/dialects/DialectUtils", "toPresentableHexString"));
        }
        try {
            int expectedLength = (bytes.length / 16 + 1) * 78;
            CharOut out = CharOut.Util.newSink(new StringBuilder(expectedLength));
            DialectUtils.toPresentableHexString(new ByteArrayInputStream(bytes), out);
            string = out.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/DialectUtils", "toPresentableHexString"));
        }
        return string;
    }

    public static void toPresentableHexString(@NotNull InputStream input, @NotNull CharOut output) throws IOException {
        if (input == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "input", "com/intellij/database/dialects/DialectUtils", "toPresentableHexString"));
        }
        if (output == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "output", "com/intellij/database/dialects/DialectUtils", "toPresentableHexString"));
        }
        long i2 = 0L;
        StringBuilder sb2 = new StringBuilder();
        while (input.available() > 0) {
            sb2.setLength(0);
            DialectUtils.appendHex(output, i2 * 16L, 8).append("  ");
            for (int j = 0; j < 16; ++j) {
                if (input.available() > 0) {
                    int value = input.read();
                    DialectUtils.appendHex(output, value, 2).append(" ");
                    sb2.append((char)(!Character.isISOControl(value) ? (int)value : 46));
                    continue;
                }
                while (j < 16) {
                    output.append("   ");
                    ++j;
                }
            }
            output.append("   ").append(sb2).append("\n");
            ++i2;
        }
        input.close();
    }

    private static CharOut appendHex(CharOut out, long value, int padTo) {
        String hex = Long.toHexString(value);
        for (int i2 = hex.length(); i2 < padTo; ++i2) {
            out.append("0");
        }
        return out.append(hex.toUpperCase(Locale.ENGLISH));
    }

    @NotNull
    public static DdlBuilder getCreateViewWithCheckOptionSQL(@NotNull DdlBuilder builder, @NotNull DasTable view2, @NotNull String definition, @NotNull String checkOption) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/DialectUtils", "getCreateViewWithCheckOptionSQL"));
        }
        if (view2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/intellij/database/dialects/DialectUtils", "getCreateViewWithCheckOptionSQL"));
        }
        if (definition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "definition", "com/intellij/database/dialects/DialectUtils", "getCreateViewWithCheckOptionSQL"));
        }
        if (checkOption == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "checkOption", "com/intellij/database/dialects/DialectUtils", "getCreateViewWithCheckOptionSQL"));
        }
        builder.keywords("CREATE", "VIEW").space();
        builder.qualifiedRef((DasObject)view2).space();
        builder.keyword("AS").space();
        builder.plain(definition).space();
        if (!checkOption.isEmpty()) {
            builder.keyword("WITH").space();
            builder.keyword("CHECK OPTION");
        }
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/DialectUtils", "getCreateViewWithCheckOptionSQL"));
        }
        return ddlBuilder;
    }

    static DdlBuilder createIndex(@NotNull DdlBuilder builder, @NotNull DasIndex index, @NotNull String accessMethod) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/DialectUtils", "createIndex"));
        }
        if (index == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "index", "com/intellij/database/dialects/DialectUtils", "createIndex"));
        }
        if (accessMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "accessMethod", "com/intellij/database/dialects/DialectUtils", "createIndex"));
        }
        builder.keyword("CREATE").space();
        if (index.isUnique()) {
            builder.keyword("UNIQUE").space();
            if ("HASH".equalsIgnoreCase(accessMethod)) {
                builder.keyword("HASH").space();
            }
        }
        builder.keyword("INDEX").space();
        builder.identifier(index.getName()).space();
        builder.keyword("ON").space();
        builder.qualifiedRef((DasObject)index.getTable()).space();
        DialectUtils.columnList(builder, index);
        return builder;
    }

    static DdlBuilder alterSequenceSQL(DdlBuilder builder, DasTable sequence, String increment, String restart) {
        builder.keywords("ALTER", "SEQUENCE").space();
        builder.qualifiedRef((DasObject)sequence).space();
        if (StringUtil.isNotEmpty((String)restart)) {
            builder.keywords("RESTART", "WITH").space();
            builder.literal(restart);
        }
        if (StringUtil.isNotEmpty((String)increment)) {
            builder.space().keywords("INCREMENT", "BY").space();
            builder.literal(increment);
        }
        return builder;
    }

    @NotNull
    public static String sqlConcat(@NotNull List<String> statements) {
        if (statements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statements", "com/intellij/database/dialects/DialectUtils", "sqlConcat"));
        }
        String string = StringUtil.join(statements, (String)";\n") + (statements.isEmpty() ? "" : ";");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/DialectUtils", "sqlConcat"));
        }
        return string;
    }

    public static void appendColumnList(DdlBuilder builder, Iterable<DasColumn> columns) {
        boolean first = true;
        for (DasColumn column : columns) {
            if (first) {
                first = false;
            } else {
                builder.symbol(",").space();
            }
            builder.columnRef((DasObject)column);
        }
    }

    public static void appendStringList(DdlBuilder builder, Iterable<String> columns) {
        boolean first = true;
        for (String column : columns) {
            if (first) {
                first = false;
            } else {
                builder.symbol(",").space();
            }
            builder.columnRef(column);
        }
    }

    public static void appendPlainList(DdlBuilder builder, Iterable<String> values) {
        boolean first = true;
        for (String value : values) {
            if (first) {
                first = false;
            } else {
                builder.symbol(",").space();
            }
            builder.plain(value);
        }
    }

    static DdlBuilder sqlDropProcedure(DdlBuilder builder, DasRoutine procedure, boolean ifExists) {
        String type = procedure.getRoutineKind().name();
        builder.keyword("DROP").space().keyword(type).space();
        if (ifExists) {
            builder.keywords("IF", "EXISTS").space();
        }
        return builder.qualifiedRef((DasObject)procedure);
    }
}

