/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dump.dbdump;

import com.intellij.database.dump.dbdump.lexer.HelpTokenType;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;

public class DumpCommandLineLexeme
implements Comparable<DumpCommandLineLexeme> {
    private final IElementType myType;
    private final int myStart;
    private final int myEnd;
    private final String myText;

    public DumpCommandLineLexeme(@NotNull String text, @NotNull IElementType type, int start, int end) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/dump/dbdump/DumpCommandLineLexeme", "<init>"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/database/dump/dbdump/DumpCommandLineLexeme", "<init>"));
        }
        this.myType = type;
        this.myStart = start;
        this.myEnd = end;
        this.myText = text;
    }

    public int getStart() {
        return this.myStart;
    }

    public int getEnd() {
        return this.myEnd;
    }

    @NotNull
    public String getText() {
        String string = this.myText;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/DumpCommandLineLexeme", "getText"));
        }
        return string;
    }

    @NotNull
    public IElementType getType() {
        IElementType iElementType = this.myType;
        if (iElementType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/DumpCommandLineLexeme", "getType"));
        }
        return iElementType;
    }

    @NotNull
    public DumpCommandLineLexeme convertLineWrapToWhitespace() {
        DumpCommandLineLexeme dumpCommandLineLexeme = this.isLineWrap() ? new DumpCommandLineLexeme(" ", HelpTokenType.BAD, this.myStart, this.myEnd) : this;
        if (dumpCommandLineLexeme == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/DumpCommandLineLexeme", "convertLineWrapToWhitespace"));
        }
        return dumpCommandLineLexeme;
    }

    public boolean isArgument() {
        return this.myType == HelpTokenType.LONG_PARAMETER || this.myType == HelpTokenType.SHORT_PARAMETER;
    }

    public boolean isBad() {
        return this.myType == HelpTokenType.BAD;
    }

    public boolean isParameter() {
        return this.myType == HelpTokenType.VALUE;
    }

    public boolean isWhitespace() {
        return this.isBad() && StringUtil.equals((CharSequence)this.myText, (CharSequence)" ");
    }

    private boolean isLineWrap() {
        return this.isBad() && StringUtil.equals((CharSequence)this.myText, (CharSequence)"\n");
    }

    @Override
    public int compareTo(DumpCommandLineLexeme o) {
        return Integer.compare(this.myStart, o.myStart);
    }

    public int hashCode() {
        return this.myStart + this.myEnd * 31 + this.myText.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DumpCommandLineLexeme)) {
            return false;
        }
        DumpCommandLineLexeme lexeme = (DumpCommandLineLexeme)obj;
        return lexeme.myStart == this.myStart && lexeme.myEnd == this.myEnd && StringUtil.equals((CharSequence)lexeme.myText, (CharSequence)this.myText);
    }

    public String toString() {
        return this.myText + " [" + this.myType + "]";
    }
}

